/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.os;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import org.apache.calcite.adapter.os.OsQueryType;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.util.trace.CalciteTrace;
import org.slf4j.Logger;

public class OsQuery
implements Enumerator<Object[]> {
    private static final Logger LOGGER = CalciteTrace.getParserTracer();
    private final Enumerator<Object[]> enumerator;

    public OsQuery(String type) {
        this.enumerator = Linq4j.enumerator(this.eval(type));
    }

    public Enumerator<Object[]> getEnumerator() {
        return this.enumerator;
    }

    public Object[] current() {
        return (Object[])this.enumerator.current();
    }

    public boolean moveNext() {
        return this.enumerator.moveNext();
    }

    public void reset() {
        this.enumerator.reset();
    }

    public void close() {
        this.enumerator.close();
    }

    public List<Object[]> eval(String type) {
        OsQueryType queryType = OsQueryType.valueOf(type.toUpperCase(Locale.ROOT));
        try {
            return queryType.getInfo();
        }
        catch (Exception e) {
            LOGGER.error("Failed to get result's info", (Throwable)e);
            return new ArrayList<Object[]>();
        }
    }
}

