/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.tpcds;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.teradata.tpcds.Results;
import com.teradata.tpcds.Session;
import com.teradata.tpcds.column.Column;
import com.teradata.tpcds.column.ColumnType;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Bug;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class TpcdsSchema
extends AbstractSchema {
    private final double scaleFactor;
    private final ImmutableMap<String, Table> tableMap;
    private static final ImmutableMap<String, Integer> TABLE_ROW_COUNTS = ImmutableMap.builder().put((Object)"CALL_CENTER", (Object)8).put((Object)"CATALOG_PAGE", (Object)11718).put((Object)"CATALOG_RETURNS", (Object)144067).put((Object)"CATALOG_SALES", (Object)1441548).put((Object)"CUSTOMER", (Object)100000).put((Object)"CUSTOMER_ADDRESS", (Object)50000).put((Object)"CUSTOMER_DEMOGRAPHICS", (Object)1920800).put((Object)"DATE_DIM", (Object)73049).put((Object)"DBGEN_VERSION", (Object)1).put((Object)"HOUSEHOLD_DEMOGRAPHICS", (Object)7200).put((Object)"INCOME_BAND", (Object)20).put((Object)"INVENTORY", (Object)11745000).put((Object)"ITEM", (Object)18000).put((Object)"PROMOTION", (Object)300).put((Object)"REASON", (Object)35).put((Object)"SHIP_MODE", (Object)20).put((Object)"STORE", (Object)12).put((Object)"STORE_RETURNS", (Object)287514).put((Object)"STORE_SALES", (Object)2880404).put((Object)"TIME_DIM", (Object)86400).put((Object)"WAREHOUSE", (Object)5).put((Object)"WEB_PAGE", (Object)60).put((Object)"WEB_RETURNS", (Object)71763).put((Object)"WEB_SALES", (Object)719384).put((Object)"WEB_SITE", (Object)1).build();

    @Deprecated
    public TpcdsSchema(double scaleFactor, int part, int partCount) {
        this(scaleFactor);
        Util.discard((int)part);
        Util.discard((int)partCount);
    }

    public TpcdsSchema(double scaleFactor) {
        this.scaleFactor = scaleFactor;
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (com.teradata.tpcds.Table tpcdsTable : com.teradata.tpcds.Table.getBaseTables()) {
            builder.put((Object)tpcdsTable.name().toUpperCase(Locale.ROOT), new TpcdsQueryableTable(tpcdsTable));
        }
        this.tableMap = builder.build();
    }

    protected Map<String, Table> getTableMap() {
        return this.tableMap;
    }

    private static @Nullable Object convert(@Nullable String string, Column column) {
        if (string == null) {
            return null;
        }
        switch (column.getType().getBase()) {
            case IDENTIFIER: {
                return Long.valueOf(string);
            }
            case INTEGER: {
                return Integer.valueOf(string);
            }
            case CHAR: 
            case VARCHAR: {
                return string;
            }
            case DATE: {
                return DateTimeUtils.dateStringToUnixDate((String)string);
            }
            case TIME: {
                return DateTimeUtils.timeStringToUnixDate((String)string);
            }
            case DECIMAL: {
                return new BigDecimal(string);
            }
        }
        throw new AssertionError(column);
    }

    private class TpcdsQueryableTable<E extends com.teradata.tpcds.Table>
    extends AbstractQueryableTable {
        private final com.teradata.tpcds.Table tpcdsTable;

        TpcdsQueryableTable(com.teradata.tpcds.Table tpcdsTable) {
            super(Object[].class);
            this.tpcdsTable = tpcdsTable;
        }

        public Statistic getStatistic() {
            Bug.upgrade((String)"add row count estimate to TpcdsTable, and use it");
            Integer rowCount = (Integer)TABLE_ROW_COUNTS.get((Object)this.tpcdsTable.name());
            Objects.requireNonNull(rowCount, "table has null row count: " + this.tpcdsTable);
            return Statistics.of((double)rowCount.intValue(), (List)ImmutableList.of());
        }

        public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
            return new AbstractTableQueryable<Object[]>(queryProvider, schema, (QueryableTable)this, tableName){

                public Enumerator<@Nullable Object[]> enumerator() {
                    Session session = Session.getDefaultSession().withTable(TpcdsQueryableTable.this.tpcdsTable).withScale(TpcdsSchema.this.scaleFactor);
                    Results results = Results.constructResults((com.teradata.tpcds.Table)TpcdsQueryableTable.this.tpcdsTable, (Session)session);
                    return Linq4j.asEnumerable((Iterable)results).selectMany((Function1)new Function1<List<List<String>>, Enumerable<Object[]>>(){
                        final Column[] columns;
                        {
                            this.columns = TpcdsQueryableTable.this.tpcdsTable.getColumns();
                        }

                        public Enumerable<@Nullable Object[]> apply(List<List<@Nullable String>> inRows) {
                            ArrayList<@Nullable Object[]> rows = new ArrayList<Object[]>();
                            for (List<String> strings : inRows) {
                                @Nullable Object[] values = new Object[this.columns.length];
                                for (int i = 0; i < strings.size(); ++i) {
                                    values[i] = TpcdsSchema.convert(strings.get(i), this.columns[i]);
                                }
                                rows.add(values);
                            }
                            return Linq4j.asEnumerable(rows);
                        }
                    }).enumerator();
                }
            };
        }

        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            RelDataTypeFactory.FieldInfoBuilder builder = typeFactory.builder();
            for (Column column : this.tpcdsTable.getColumns()) {
                builder.add(column.getName().toUpperCase(Locale.ROOT), this.type(typeFactory, column));
            }
            return builder.build();
        }

        private RelDataType type(RelDataTypeFactory typeFactory, Column column) {
            ColumnType type = column.getType();
            switch (type.getBase()) {
                case DATE: {
                    return typeFactory.createSqlType(SqlTypeName.DATE);
                }
                case TIME: {
                    return typeFactory.createSqlType(SqlTypeName.TIME);
                }
                case INTEGER: {
                    return typeFactory.createSqlType(SqlTypeName.INTEGER);
                }
                case IDENTIFIER: {
                    return typeFactory.createSqlType(SqlTypeName.BIGINT);
                }
                case DECIMAL: {
                    return typeFactory.createSqlType(SqlTypeName.DECIMAL, ((Integer)type.getPrecision().get()).intValue(), ((Integer)type.getScale().get()).intValue());
                }
                case VARCHAR: {
                    return typeFactory.createSqlType(SqlTypeName.VARCHAR, ((Integer)type.getPrecision().get()).intValue());
                }
                case CHAR: {
                    return typeFactory.createSqlType(SqlTypeName.CHAR, ((Integer)type.getPrecision().get()).intValue());
                }
            }
            throw new AssertionError((Object)(type.getBase() + ": " + column));
        }
    }
}

