/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.piglet.parser;

import com.google.common.collect.ImmutableList;
import java.io.InputStream;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Vector;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.piglet.Ast;
import org.apache.calcite.piglet.parser.ParseException;
import org.apache.calcite.piglet.parser.PigletParserConstants;
import org.apache.calcite.piglet.parser.PigletParserTokenManager;
import org.apache.calcite.piglet.parser.SimpleCharStream;
import org.apache.calcite.piglet.parser.Token;
import org.apache.calcite.piglet.parser.TokenMgrError;
import org.apache.calcite.runtime.CalciteContextException;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.parser.SqlParserUtil;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.trace.CalciteTrace;
import org.slf4j.Logger;

public class PigletParser
implements PigletParserConstants {
    private static final Logger LOGGER = CalciteTrace.getParserTracer();
    public PigletParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private Token jj_scanpos;
    private Token jj_lastpos;
    private int jj_la;
    public boolean lookingAhead = false;
    private boolean jj_semLA;
    private int jj_gen;
    private final int[] jj_la1 = new int[32];
    private static int[] jj_la1_0;
    private static int[] jj_la1_1;
    private static int[] jj_la1_2;
    private final JJCalls[] jj_2_rtns = new JJCalls[5];
    private boolean jj_rescan = false;
    private int jj_gc = 0;
    private final LookaheadSuccess jj_ls = new LookaheadSuccess();
    private Vector jj_expentries = new Vector();
    private int[] jj_expentry;
    private int jj_kind = -1;
    private int[] jj_lasttokens = new int[100];
    private int jj_endpos;

    public void setTabSize(int tabSize) {
        this.jj_input_stream.setTabSize(tabSize);
    }

    void debug_message1() throws ParseException {
        LOGGER.info("{} , {}", (Object)this.getToken((int)0).image, (Object)this.getToken((int)1).image);
    }

    String unquotedIdentifier() throws ParseException {
        return SqlParserUtil.toCase((String)this.getToken((int)0).image, (Casing)Casing.UNCHANGED);
    }

    public final String nonReservedKeyWord() throws ParseException {
        String kw = this.commonNonReservedKeyWord();
        return kw;
    }

    void e() throws ParseException {
    }

    SqlParserPos pos() throws ParseException {
        return new SqlParserPos(this.token.beginLine, this.token.beginColumn, this.token.endLine, this.token.endColumn);
    }

    SqlParserPos pos2(SqlParserPos p) throws ParseException {
        return p.plus(this.pos());
    }

    SqlParserPos pos3(Ast.Node n) throws ParseException {
        return n.pos.plus(this.pos());
    }

    SqlParseException convertException(Throwable ex) throws ParseException {
        if (ex instanceof SqlParseException) {
            return (SqlParseException)ex;
        }
        SqlParserPos pos = null;
        int[][] expectedTokenSequences = null;
        String[] tokenImage = null;
        if (ex instanceof ParseException) {
            ParseException pex = (ParseException)ex;
            expectedTokenSequences = pex.expectedTokenSequences;
            tokenImage = pex.tokenImage;
            if (pex.currentToken != null) {
                Token token = pex.currentToken.next;
                pos = new SqlParserPos(token.beginLine, token.beginColumn, token.endLine, token.endColumn);
            }
        } else if (ex instanceof TokenMgrError) {
            TokenMgrError tme = (TokenMgrError)ex;
            expectedTokenSequences = null;
            tokenImage = null;
            Pattern pattern = Pattern.compile("(?s)Lexical error at line ([0-9]+), column ([0-9]+).*");
            Matcher matcher = pattern.matcher(ex.getMessage());
            if (matcher.matches()) {
                int line = Integer.parseInt(matcher.group(1));
                int column = Integer.parseInt(matcher.group(2));
                pos = new SqlParserPos(line, column, line, column);
            }
        } else if (ex instanceof CalciteContextException) {
            CalciteContextException ece = (CalciteContextException)ex;
            pos = new SqlParserPos(ece.getPosLine(), ece.getPosColumn(), ece.getEndPosLine(), ece.getEndPosColumn());
            ex = ece.getCause();
        }
        return new SqlParseException(ex.getMessage(), pos, expectedTokenSequences, tokenImage, ex);
    }

    public final Ast.Program stmtListEof() throws ParseException {
        ArrayList<Ast.Stmt> list = new ArrayList<Ast.Stmt>();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 1: 
                case 2: 
                case 3: 
                case 6: 
                case 7: 
                case 8: 
                case 9: 
                case 10: 
                case 13: 
                case 14: 
                case 15: 
                case 16: 
                case 17: 
                case 19: 
                case 20: 
                case 21: 
                case 24: 
                case 81: {
                    break;
                }
                default: {
                    this.jj_la1[0] = this.jj_gen;
                    break block3;
                }
            }
            Ast.Stmt s = this.stmt();
            list.add(s);
        }
        this.jj_consume_token(0);
        SqlParserPos p = SqlParserPos.ZERO;
        for (Ast.Stmt s2 : list) {
            p = p.plus(s2.pos);
        }
        return new Ast.Program(p, list);
    }

    public final Ast.Stmt stmt() throws ParseException {
        Ast.Stmt s;
        block16: {
            block15: {
                if (!this.jj_2_1(2)) break block15;
                Ast.Identifier target = this.simpleIdentifier();
                this.jj_consume_token(47);
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 16: {
                        s = this.loadStmt(target);
                        break block16;
                    }
                    case 24: {
                        s = this.valuesStmt(target);
                        break block16;
                    }
                    case 9: {
                        s = this.distinctStmt(target);
                        break block16;
                    }
                    case 17: {
                        s = this.limitStmt(target);
                        break block16;
                    }
                    case 20: {
                        s = this.orderStmt(target);
                        break block16;
                    }
                    case 13: {
                        s = this.foreachStmt(target);
                        break block16;
                    }
                    case 12: {
                        s = this.filterStmt(target);
                        break block16;
                    }
                    case 15: {
                        s = this.groupStmt(target);
                        break block16;
                    }
                    default: {
                        this.jj_la1[1] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
            if (this.jj_2_2(2)) {
                s = this.describeStmt();
            } else {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 10: {
                        s = this.dumpStmt();
                        break;
                    }
                    default: {
                        this.jj_la1[2] = this.jj_gen;
                        this.jj_consume_token(-1);
                        throw new ParseException();
                    }
                }
            }
        }
        return s;
    }

    public final Ast.Assignment1 nestedStmt() throws ParseException {
        Ast.Assignment1 s;
        Ast.Identifier target = this.simpleIdentifier();
        this.jj_consume_token(47);
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 9: {
                s = this.distinctStmt(target);
                break;
            }
            case 17: {
                s = this.limitStmt(target);
                break;
            }
            case 20: {
                s = this.orderStmt(target);
                break;
            }
            case 12: {
                s = this.filterStmt(target);
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return s;
    }

    public final Ast.LoadStmt loadStmt(Ast.Identifier target) throws ParseException {
        this.jj_consume_token(16);
        Ast.Literal name = this.stringLiteral();
        this.jj_consume_token(44);
        return new Ast.LoadStmt(this.pos3(target), target, name);
    }

    public final Ast.ValuesStmt valuesStmt(Ast.Identifier target) throws ParseException {
        this.jj_consume_token(24);
        List<List<Ast.Node>> tupleList = this.tupleListMaybeEmpty();
        this.jj_consume_token(4);
        Ast.Schema schema = this.schema();
        this.jj_consume_token(44);
        return new Ast.ValuesStmt(this.pos3(target), target, schema, tupleList);
    }

    public final List<List<Ast.Node>> tupleListMaybeEmpty() throws ParseException {
        ImmutableList.Builder tupleList = ImmutableList.builder();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 38: {
                List<Ast.Node> tuple = this.tuple();
                tupleList.add(tuple);
                while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 46: {
                            break;
                        }
                        default: {
                            this.jj_la1[4] = this.jj_gen;
                            break block0;
                        }
                    }
                    this.jj_consume_token(46);
                    tuple = this.tuple();
                    tupleList.add(tuple);
                }
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
            }
        }
        return tupleList.build();
    }

    public final Ast.DescribeStmt describeStmt() throws ParseException {
        this.jj_consume_token(8);
        SqlParserPos p = this.pos();
        Ast.Identifier id = this.simpleIdentifier();
        this.jj_consume_token(44);
        return new Ast.DescribeStmt(this.pos2(p), id);
    }

    public final Ast.DumpStmt dumpStmt() throws ParseException {
        this.jj_consume_token(10);
        SqlParserPos p = this.pos();
        Ast.Identifier id = this.simpleIdentifier();
        this.jj_consume_token(44);
        return new Ast.DumpStmt(this.pos2(p), id);
    }

    public final Ast.Assignment foreachStmt(Ast.Identifier target) throws ParseException {
        Ast.Schema schema = null;
        this.jj_consume_token(13);
        Ast.Identifier id = this.simpleIdentifier();
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 14: {
                this.jj_consume_token(14);
                List<Ast.Node> expList = this.expCommaList();
                this.jj_consume_token(44);
                return new Ast.ForeachStmt(this.pos3(target), target, id, expList, schema);
            }
            case 40: {
                this.jj_consume_token(40);
                List<Ast.Stmt> nestedStmtList = this.nestedStmtList();
                this.jj_consume_token(14);
                List<Ast.Node> expList = this.expCommaList();
                this.jj_consume_token(44);
                this.jj_consume_token(41);
                return new Ast.ForeachNestedStmt(this.pos3(target), target, id, nestedStmtList, expList, schema);
            }
        }
        this.jj_la1[6] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final List<Ast.Stmt> nestedStmtList() throws ParseException {
        ArrayList<Ast.Stmt> list = new ArrayList<Ast.Stmt>();
        Ast.Assignment1 s = this.nestedStmt();
        list.add(s);
        while (this.jj_2_3(2)) {
            s = this.nestedStmt();
            list.add(s);
        }
        return list;
    }

    public final Ast.FilterStmt filterStmt(Ast.Identifier target) throws ParseException {
        this.jj_consume_token(12);
        Ast.Identifier id = this.simpleIdentifier();
        this.jj_consume_token(6);
        Ast.Node condition = this.exp();
        this.jj_consume_token(44);
        return new Ast.FilterStmt(this.pos3(target), target, id, condition);
    }

    public final Ast.DistinctStmt distinctStmt(Ast.Identifier target) throws ParseException {
        this.jj_consume_token(9);
        Ast.Identifier id = this.simpleIdentifier();
        this.jj_consume_token(44);
        return new Ast.DistinctStmt(this.pos3(target), target, id);
    }

    public final Ast.LimitStmt limitStmt(Ast.Identifier target) throws ParseException {
        this.jj_consume_token(17);
        Ast.Identifier id = this.simpleIdentifier();
        Ast.NumericLiteral count = this.numericLiteral();
        this.jj_consume_token(44);
        return new Ast.LimitStmt(this.pos3(target), target, id, count);
    }

    public final Ast.OrderStmt orderStmt(Ast.Identifier target) throws ParseException {
        this.jj_consume_token(20);
        Ast.Identifier id = this.simpleIdentifier();
        this.jj_consume_token(6);
        List<Pair<Ast.Identifier, Ast.Direction>> fields = this.orderFieldCommaList();
        this.jj_consume_token(44);
        return new Ast.OrderStmt(this.pos3(target), target, id, fields);
    }

    public final List<Pair<Ast.Identifier, Ast.Direction>> orderFieldCommaList() throws ParseException {
        ArrayList<Pair<Ast.Identifier, Ast.Direction>> list = new ArrayList<Pair<Ast.Identifier, Ast.Direction>>();
        Pair<Ast.Identifier, Ast.Direction> field = this.orderField();
        list.add(field);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 46: {
                    break;
                }
                default: {
                    this.jj_la1[7] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(46);
            field = this.orderField();
            list.add(field);
        }
        return list;
    }

    public final Pair<Ast.Identifier, Ast.Direction> orderField() throws ParseException {
        Ast.Direction direction;
        Ast.Identifier id;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 58: {
                this.jj_consume_token(58);
                id = new Ast.SpecialIdentifier(this.pos());
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 81: {
                id = this.simpleIdentifier();
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: {
                this.jj_consume_token(3);
                direction = Ast.Direction.ASC;
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                direction = Ast.Direction.DESC;
                break;
            }
            default: {
                this.jj_la1[9] = this.jj_gen;
                direction = Ast.Direction.NOT_SPECIFIED;
            }
        }
        return Pair.of((Object)id, (Object)((Object)direction));
    }

    public final Ast.GroupStmt groupStmt(Ast.Identifier target) throws ParseException {
        ImmutableList keys;
        this.jj_consume_token(15);
        Ast.Identifier id = this.simpleIdentifier();
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                this.jj_consume_token(1);
                keys = null;
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                if (this.jj_2_4(3)) {
                    keys = this.tuple();
                    break;
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 1: 
                    case 2: 
                    case 3: 
                    case 6: 
                    case 7: 
                    case 8: 
                    case 9: 
                    case 10: 
                    case 11: 
                    case 13: 
                    case 14: 
                    case 15: 
                    case 16: 
                    case 17: 
                    case 19: 
                    case 20: 
                    case 21: 
                    case 22: 
                    case 24: 
                    case 25: 
                    case 26: 
                    case 33: 
                    case 38: 
                    case 40: 
                    case 56: 
                    case 57: 
                    case 81: {
                        Ast.Node exp = this.exp();
                        keys = ImmutableList.of((Object)exp);
                        break block0;
                    }
                }
                this.jj_la1[10] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[11] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        this.jj_consume_token(44);
        return new Ast.GroupStmt(this.pos3(target), target, id, (List<Ast.Node>)keys);
    }

    public final Ast.Schema schema() throws ParseException {
        this.jj_consume_token(38);
        SqlParserPos p = this.pos();
        List<Ast.FieldSchema> fieldSchemaList = this.fieldSchemaList();
        this.jj_consume_token(39);
        return new Ast.Schema(this.pos2(p), fieldSchemaList);
    }

    public final List<Ast.FieldSchema> fieldSchemaList() throws ParseException {
        ImmutableList.Builder list = ImmutableList.builder();
        Ast.FieldSchema fieldSchema = this.fieldSchema();
        list.add((Object)fieldSchema);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 46: {
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(46);
            fieldSchema = this.fieldSchema();
            list.add((Object)fieldSchema);
        }
        return list.build();
    }

    public final Ast.FieldSchema fieldSchema() throws ParseException {
        Ast.Identifier identifier = this.simpleIdentifier();
        this.jj_consume_token(52);
        Ast.Type type = this.type();
        return new Ast.FieldSchema(this.pos3(identifier), identifier, type);
    }

    public final Ast.Type type() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 81: {
                String s = this.identifier();
                return new Ast.ScalarType(this.pos(), s);
            }
            case 5: {
                this.jj_consume_token(5);
                SqlParserPos p = this.pos();
                this.jj_consume_token(40);
                Ast.Type t = this.type();
                this.jj_consume_token(41);
                return new Ast.BagType(this.pos2(p), t);
            }
            case 23: {
                this.jj_consume_token(23);
                SqlParserPos p = this.pos();
                this.jj_consume_token(38);
                List<Ast.FieldSchema> fieldSchemaList = this.fieldSchemaList();
                this.jj_consume_token(39);
                return new Ast.TupleType(this.pos2(p), fieldSchemaList);
            }
            case 18: {
                this.jj_consume_token(18);
                SqlParserPos p = this.pos();
                this.jj_consume_token(42);
                this.jj_consume_token(43);
                return new Ast.MapType(this.pos2(p));
            }
        }
        this.jj_la1[13] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Ast.Node exp() throws ParseException {
        Ast.Node e = this.exp1();
        return e;
    }

    public final Ast.Node exp1() throws ParseException {
        Ast.Node e = this.exp2();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 21: {
                    break;
                }
                default: {
                    this.jj_la1[14] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(21);
            Ast.Node f = this.exp2();
            e = new Ast.Call(this.pos3(e), Ast.Op.OR, e, f);
        }
        return e;
    }

    public final Ast.Node exp2() throws ParseException {
        Ast.Node e = this.exp3();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 2: {
                    break;
                }
                default: {
                    this.jj_la1[15] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(2);
            Ast.Node f = this.exp3();
            e = new Ast.Call(this.pos3(e), Ast.Op.AND, e, f);
        }
        return e;
    }

    public final Ast.Node exp3() throws ParseException {
        if (this.jj_2_5(3)) {
            this.jj_consume_token(19);
            SqlParserPos p = this.pos();
            Ast.Node e = this.exp3();
            return new Ast.Call(this.pos2(p), Ast.Op.NOT, e);
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 33: 
            case 38: 
            case 40: 
            case 56: 
            case 57: 
            case 81: {
                Ast.Node e = this.exp4();
                return e;
            }
        }
        this.jj_la1[16] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Ast.Node exp4() throws ParseException {
        Ast.Node e;
        block11: {
            e = this.exp5();
            block10: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 48: 
                    case 49: 
                    case 50: 
                    case 53: 
                    case 54: {
                        break;
                    }
                    default: {
                        this.jj_la1[17] = this.jj_gen;
                        break block11;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 48: {
                        this.jj_consume_token(48);
                        Ast.Node f = this.exp5();
                        e = new Ast.Call(this.pos3(e), Ast.Op.EQ, e, f);
                        continue block10;
                    }
                    case 49: {
                        this.jj_consume_token(49);
                        Ast.Node f = this.exp5();
                        e = new Ast.Call(this.pos3(e), Ast.Op.GT, e, f);
                        continue block10;
                    }
                    case 50: {
                        this.jj_consume_token(50);
                        Ast.Node f = this.exp5();
                        e = new Ast.Call(this.pos3(e), Ast.Op.LT, e, f);
                        continue block10;
                    }
                    case 54: {
                        this.jj_consume_token(54);
                        Ast.Node f = this.exp5();
                        e = new Ast.Call(this.pos3(e), Ast.Op.GTE, e, f);
                        continue block10;
                    }
                    case 53: {
                        this.jj_consume_token(53);
                        Ast.Node f = this.exp5();
                        e = new Ast.Call(this.pos3(e), Ast.Op.LTE, e, f);
                        continue block10;
                    }
                }
                break;
            }
            this.jj_la1[18] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return e;
    }

    public final Ast.Node exp5() throws ParseException {
        Ast.Node e;
        block8: {
            e = this.exp10();
            block7: while (true) {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 56: 
                    case 57: {
                        break;
                    }
                    default: {
                        this.jj_la1[19] = this.jj_gen;
                        break block8;
                    }
                }
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 56: {
                        this.jj_consume_token(56);
                        Ast.Node f = this.exp10();
                        e = new Ast.Call(this.pos3(e), Ast.Op.PLUS, e, f);
                        continue block7;
                    }
                    case 57: {
                        this.jj_consume_token(57);
                        Ast.Node f = this.exp10();
                        e = new Ast.Call(this.pos3(e), Ast.Op.PLUS, e, f);
                        continue block7;
                    }
                }
                break;
            }
            this.jj_la1[20] = this.jj_gen;
            this.jj_consume_token(-1);
            throw new ParseException();
        }
        return e;
    }

    public final Ast.Node exp10() throws ParseException {
        Ast.Node e = this.atom();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 45: {
                    break;
                }
                default: {
                    this.jj_la1[21] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(45);
            Ast.Node f = this.atom();
            e = new Ast.Call(this.pos3(e), Ast.Op.DOT, e, f);
        }
        return e;
    }

    public final Ast.Node atom() throws ParseException {
        Ast.Node e;
        ImmutableList.Builder builder = null;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: 
            case 22: 
            case 25: 
            case 26: 
            case 33: 
            case 56: 
            case 57: {
                e = this.literal();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: 
            case 81: {
                e = this.simpleIdentifier();
                break;
            }
            case 38: {
                this.jj_consume_token(38);
                SqlParserPos p = this.pos();
                Ast.Node e2 = this.exp();
                block9: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 46: {
                            break;
                        }
                        default: {
                            this.jj_la1[22] = this.jj_gen;
                            break block9;
                        }
                    }
                    this.jj_consume_token(46);
                    Ast.Node f = this.exp();
                    if (builder == null) {
                        builder = ImmutableList.builder();
                        builder.add((Object)e2);
                    }
                    builder.add((Object)f);
                }
                this.jj_consume_token(39);
                if (builder == null) {
                    return e2;
                }
                return new Ast.Call(this.pos2(p), Ast.Op.TUPLE, (Iterable<? extends Ast.Node>)builder.build());
            }
            case 40: {
                this.jj_consume_token(40);
                SqlParserPos p = this.pos();
                List<Ast.Node> list = this.expCommaListOrEmpty();
                this.jj_consume_token(41);
                return new Ast.Call(this.pos2(p), Ast.Op.BAG, list);
            }
            default: {
                this.jj_la1[23] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return e;
    }

    public final List<Ast.Node> expCommaList() throws ParseException {
        ArrayList<Ast.Node> list = new ArrayList<Ast.Node>();
        Ast.Node e = this.exp();
        list.add(e);
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 46: {
                    break;
                }
                default: {
                    this.jj_la1[24] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(46);
            e = this.exp();
            list.add(e);
        }
        return list;
    }

    public final List<Ast.Node> expCommaListOrEmpty() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 11: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 22: 
            case 24: 
            case 25: 
            case 26: 
            case 33: 
            case 38: 
            case 40: 
            case 56: 
            case 57: 
            case 81: {
                List<Ast.Node> list = this.expCommaList();
                return list;
            }
        }
        this.jj_la1[25] = this.jj_gen;
        return ImmutableList.of();
    }

    public final List<Ast.Node> tuple() throws ParseException {
        this.jj_consume_token(38);
        List<Ast.Node> expList = this.expCommaList();
        this.jj_consume_token(39);
        return expList;
    }

    public final Ast.Literal literal() throws ParseException {
        Ast.Literal e;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 11: 
            case 22: {
                e = this.booleanLiteral();
                break;
            }
            case 25: 
            case 26: 
            case 56: 
            case 57: {
                e = this.numericLiteral();
                break;
            }
            case 33: {
                e = this.stringLiteral();
                break;
            }
            default: {
                this.jj_la1[26] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return e;
    }

    public final Ast.Literal booleanLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 22: {
                this.jj_consume_token(22);
                return new Ast.Literal(this.pos(), true);
            }
            case 11: {
                this.jj_consume_token(11);
                return new Ast.Literal(this.pos(), false);
            }
        }
        this.jj_la1[27] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Ast.NumericLiteral unsignedNumericLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 25: {
                this.jj_consume_token(25);
                return Ast.Literal.createExactNumeric(this.token.image, this.pos());
            }
            case 26: {
                this.jj_consume_token(26);
                assert (this.token.image.endsWith("F"));
                String x = this.token.image.substring(0, this.token.image.length() - 1);
                return Ast.Literal.createExactNumeric(x, this.pos());
            }
        }
        this.jj_la1[28] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Ast.NumericLiteral numericLiteral() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 56: {
                this.jj_consume_token(56);
                Ast.NumericLiteral num = this.unsignedNumericLiteral();
                return num;
            }
            case 57: {
                this.jj_consume_token(57);
                SqlParserPos p = this.pos();
                Ast.NumericLiteral num = this.unsignedNumericLiteral();
                return num.negate(this.pos2(p));
            }
            case 25: 
            case 26: {
                Ast.NumericLiteral num = this.unsignedNumericLiteral();
                return num;
            }
        }
        this.jj_la1[29] = this.jj_gen;
        this.jj_consume_token(-1);
        throw new ParseException();
    }

    public final Ast.Literal stringLiteral() throws ParseException {
        this.jj_consume_token(33);
        String s = SqlParserUtil.parseString((String)this.token.image);
        return new Ast.Literal(this.pos(), s);
    }

    public final String identifier() throws ParseException {
        String id;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 81: {
                this.jj_consume_token(81);
                id = this.unquotedIdentifier();
                break;
            }
            case 1: 
            case 2: 
            case 3: 
            case 6: 
            case 7: 
            case 8: 
            case 9: 
            case 10: 
            case 13: 
            case 14: 
            case 15: 
            case 16: 
            case 17: 
            case 19: 
            case 20: 
            case 21: 
            case 24: {
                id = this.nonReservedKeyWord();
                break;
            }
            default: {
                this.jj_la1[30] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return id;
    }

    public final Ast.Identifier simpleIdentifier() throws ParseException {
        String s = this.identifier();
        return new Ast.Identifier(this.pos(), s);
    }

    public final String commonNonReservedKeyWord() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                this.jj_consume_token(1);
                break;
            }
            case 2: {
                this.jj_consume_token(2);
                break;
            }
            case 3: {
                this.jj_consume_token(3);
                break;
            }
            case 6: {
                this.jj_consume_token(6);
                break;
            }
            case 7: {
                this.jj_consume_token(7);
                break;
            }
            case 8: {
                this.jj_consume_token(8);
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                break;
            }
            case 10: {
                this.jj_consume_token(10);
                break;
            }
            case 13: {
                this.jj_consume_token(13);
                break;
            }
            case 14: {
                this.jj_consume_token(14);
                break;
            }
            case 15: {
                this.jj_consume_token(15);
                break;
            }
            case 17: {
                this.jj_consume_token(17);
                break;
            }
            case 16: {
                this.jj_consume_token(16);
                break;
            }
            case 19: {
                this.jj_consume_token(19);
                break;
            }
            case 21: {
                this.jj_consume_token(21);
                break;
            }
            case 20: {
                this.jj_consume_token(20);
                break;
            }
            case 24: {
                this.jj_consume_token(24);
                break;
            }
            default: {
                this.jj_la1[31] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        return this.unquotedIdentifier();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_1(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_1();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(0, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_2(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_2();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(1, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_3(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_3();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(2, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_4(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_4();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(3, xla);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private final boolean jj_2_5(int xla) {
        this.jj_la = xla;
        this.jj_lastpos = this.jj_scanpos = this.token;
        try {
            boolean bl = !this.jj_3_5();
            return bl;
        }
        catch (LookaheadSuccess ls) {
            boolean bl = true;
            return bl;
        }
        finally {
            this.jj_save(4, xla);
        }
    }

    private final boolean jj_3R_63() {
        return this.jj_3R_64();
    }

    private final boolean jj_3R_44() {
        return this.jj_scan_token(57);
    }

    private final boolean jj_3R_27() {
        Token xsp;
        if (this.jj_3R_31()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_32());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_43() {
        return this.jj_scan_token(56);
    }

    private final boolean jj_3R_34() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_43()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_44()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_62() {
        if (this.jj_scan_token(57)) {
            return true;
        }
        return this.jj_3R_64();
    }

    private final boolean jj_3R_28() {
        Token xsp;
        if (this.jj_3R_33()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_34());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_24() {
        return this.jj_scan_token(46);
    }

    private final boolean jj_3R_30() {
        Token xsp = this.jj_scanpos;
        if (this.jj_scan_token(1)) {
            this.jj_scanpos = xsp;
            if (this.jj_scan_token(2)) {
                this.jj_scanpos = xsp;
                if (this.jj_scan_token(3)) {
                    this.jj_scanpos = xsp;
                    if (this.jj_scan_token(6)) {
                        this.jj_scanpos = xsp;
                        if (this.jj_scan_token(7)) {
                            this.jj_scanpos = xsp;
                            if (this.jj_scan_token(8)) {
                                this.jj_scanpos = xsp;
                                if (this.jj_scan_token(9)) {
                                    this.jj_scanpos = xsp;
                                    if (this.jj_scan_token(10)) {
                                        this.jj_scanpos = xsp;
                                        if (this.jj_scan_token(13)) {
                                            this.jj_scanpos = xsp;
                                            if (this.jj_scan_token(14)) {
                                                this.jj_scanpos = xsp;
                                                if (this.jj_scan_token(15)) {
                                                    this.jj_scanpos = xsp;
                                                    if (this.jj_scan_token(17)) {
                                                        this.jj_scanpos = xsp;
                                                        if (this.jj_scan_token(16)) {
                                                            this.jj_scanpos = xsp;
                                                            if (this.jj_scan_token(19)) {
                                                                this.jj_scanpos = xsp;
                                                                if (this.jj_scan_token(21)) {
                                                                    this.jj_scanpos = xsp;
                                                                    if (this.jj_scan_token(20)) {
                                                                        this.jj_scanpos = xsp;
                                                                        if (this.jj_scan_token(24)) {
                                                                            return true;
                                                                        }
                                                                    }
                                                                }
                                                            }
                                                        }
                                                    }
                                                }
                                            }
                                        }
                                    }
                                }
                            }
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_61() {
        if (this.jj_scan_token(56)) {
            return true;
        }
        return this.jj_3R_64();
    }

    private final boolean jj_3R_57() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_61()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_62()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_63()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3_4() {
        return this.jj_3R_16();
    }

    private final boolean jj_3R_26() {
        return this.jj_3R_30();
    }

    private final boolean jj_3R_23() {
        return this.jj_3R_27();
    }

    private final boolean jj_3R_19() {
        Token xsp;
        if (this.jj_3R_23()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_24());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_39() {
        return this.jj_scan_token(53);
    }

    private final boolean jj_3R_66() {
        return this.jj_scan_token(26);
    }

    private final boolean jj_3R_38() {
        return this.jj_scan_token(54);
    }

    private final boolean jj_3R_65() {
        return this.jj_scan_token(25);
    }

    private final boolean jj_3R_37() {
        return this.jj_scan_token(50);
    }

    private final boolean jj_3R_64() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_65()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_66()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_48() {
        if (this.jj_scan_token(40)) {
            return true;
        }
        return this.jj_3R_50();
    }

    private final boolean jj_3R_36() {
        return this.jj_scan_token(49);
    }

    private final boolean jj_3R_29() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_35()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_36()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_37()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_38()) {
                        this.jj_scanpos = xsp;
                        if (this.jj_3R_39()) {
                            return true;
                        }
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_35() {
        return this.jj_scan_token(48);
    }

    private final boolean jj_3_3() {
        return this.jj_3R_15();
    }

    private final boolean jj_3R_60() {
        return this.jj_scan_token(11);
    }

    private final boolean jj_3R_25() {
        Token xsp;
        if (this.jj_3R_28()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_29());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_59() {
        return this.jj_scan_token(22);
    }

    private final boolean jj_3R_56() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_59()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_60()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_47() {
        if (this.jj_scan_token(38)) {
            return true;
        }
        return this.jj_3R_23();
    }

    private final boolean jj_3R_20() {
        return this.jj_3R_25();
    }

    private final boolean jj_3R_13() {
        return this.jj_3R_18();
    }

    private final boolean jj_3R_46() {
        return this.jj_3R_13();
    }

    private final boolean jj_3R_53() {
        return this.jj_3R_58();
    }

    private final boolean jj_3R_45() {
        return this.jj_3R_49();
    }

    private final boolean jj_3R_52() {
        return this.jj_3R_57();
    }

    private final boolean jj_3R_15() {
        if (this.jj_3R_13()) {
            return true;
        }
        return this.jj_scan_token(47);
    }

    private final boolean jj_3R_51() {
        return this.jj_3R_56();
    }

    private final boolean jj_3R_41() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_45()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_46()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_47()) {
                    this.jj_scanpos = xsp;
                    if (this.jj_3R_48()) {
                        return true;
                    }
                }
            }
        }
        return false;
    }

    private final boolean jj_3_5() {
        if (this.jj_scan_token(19)) {
            return true;
        }
        return this.jj_3R_17();
    }

    private final boolean jj_3R_49() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_51()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_52()) {
                this.jj_scanpos = xsp;
                if (this.jj_3R_53()) {
                    return true;
                }
            }
        }
        return false;
    }

    private final boolean jj_3R_17() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3_5()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_20()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_22() {
        return this.jj_3R_26();
    }

    private final boolean jj_3R_21() {
        return this.jj_scan_token(81);
    }

    private final boolean jj_3_2() {
        return this.jj_3R_14();
    }

    private final boolean jj_3R_18() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_21()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_22()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_16() {
        if (this.jj_scan_token(38)) {
            return true;
        }
        if (this.jj_3R_19()) {
            return true;
        }
        return this.jj_scan_token(39);
    }

    private final boolean jj_3R_40() {
        return this.jj_scan_token(2);
    }

    private final boolean jj_3R_42() {
        return this.jj_scan_token(45);
    }

    private final boolean jj_3R_31() {
        Token xsp;
        if (this.jj_3R_17()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_40());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_33() {
        Token xsp;
        if (this.jj_3R_41()) {
            return true;
        }
        do {
            xsp = this.jj_scanpos;
        } while (!this.jj_3R_42());
        this.jj_scanpos = xsp;
        return false;
    }

    private final boolean jj_3R_58() {
        return this.jj_scan_token(33);
    }

    private final boolean jj_3R_55() {
        return false;
    }

    private final boolean jj_3R_14() {
        if (this.jj_scan_token(8)) {
            return true;
        }
        return this.jj_3R_13();
    }

    private final boolean jj_3R_54() {
        return this.jj_3R_19();
    }

    private final boolean jj_3_1() {
        if (this.jj_3R_13()) {
            return true;
        }
        return this.jj_scan_token(47);
    }

    private final boolean jj_3R_50() {
        Token xsp = this.jj_scanpos;
        if (this.jj_3R_54()) {
            this.jj_scanpos = xsp;
            if (this.jj_3R_55()) {
                return true;
            }
        }
        return false;
    }

    private final boolean jj_3R_32() {
        return this.jj_scan_token(21);
    }

    private static void jj_la1_0() {
        jj_la1_0 = new int[]{20703182, 18067968, 1024, 0x121200, 0, 0, 16384, 0, 20703182, 136, 125562830, 66, 0, 29353966, 0x200000, 4, 125562830, 0, 0, 0, 0, 0, 0, 125562830, 0, 125562830, 104859648, 0x400800, 0x6000000, 0x6000000, 20703182, 20703182};
    }

    private static void jj_la1_1() {
        jj_la1_1 = new int[]{0, 0, 0, 0, 16384, 64, 256, 16384, 0x4000000, 0, 50331970, 0, 16384, 0, 0, 0, 50331970, 0x670000, 0x670000, 0x3000000, 0x3000000, 8192, 16384, 50331970, 16384, 50331970, 0x3000002, 0, 0, 0x3000000, 0, 0};
    }

    private static void jj_la1_2() {
        jj_la1_2 = new int[]{131072, 0, 0, 0, 0, 0, 0, 0, 131072, 0, 131072, 0, 0, 131072, 0, 0, 131072, 0, 0, 0, 0, 0, 0, 131072, 0, 131072, 0, 0, 0, 0, 131072, 0};
    }

    public PigletParser(InputStream stream) {
        this(stream, null);
    }

    public PigletParser(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new PigletParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 32; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        int i;
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 32; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public PigletParser(Reader stream) {
        int i;
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new PigletParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 32; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(Reader stream) {
        int i;
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 32; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public PigletParser(PigletParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 32; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    public void ReInit(PigletParserTokenManager tm) {
        int i;
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        for (i = 0; i < 32; ++i) {
            this.jj_la1[i] = -1;
        }
        for (i = 0; i < this.jj_2_rtns.length; ++i) {
            this.jj_2_rtns[i] = new JJCalls();
        }
    }

    private final Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            if (++this.jj_gc > 100) {
                this.jj_gc = 0;
                for (int i = 0; i < this.jj_2_rtns.length; ++i) {
                    JJCalls c = this.jj_2_rtns[i];
                    while (c != null) {
                        if (c.gen < this.jj_gen) {
                            c.first = null;
                        }
                        c = c.next;
                    }
                }
            }
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    private final boolean jj_scan_token(int kind) {
        if (this.jj_scanpos == this.jj_lastpos) {
            --this.jj_la;
            if (this.jj_scanpos.next == null) {
                this.jj_scanpos = this.jj_scanpos.next = this.token_source.getNextToken();
                this.jj_lastpos = this.jj_scanpos.next;
            } else {
                this.jj_lastpos = this.jj_scanpos = this.jj_scanpos.next;
            }
        } else {
            this.jj_scanpos = this.jj_scanpos.next;
        }
        if (this.jj_rescan) {
            int i = 0;
            Token tok = this.token;
            while (tok != null && tok != this.jj_scanpos) {
                ++i;
                tok = tok.next;
            }
            if (tok != null) {
                this.jj_add_error_token(kind, i);
            }
        }
        if (this.jj_scanpos.kind != kind) {
            return true;
        }
        if (this.jj_la == 0 && this.jj_scanpos == this.jj_lastpos) {
            throw this.jj_ls;
        }
        return false;
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.lookingAhead ? this.jj_scanpos : this.token;
        for (int i = 0; i < index; ++i) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
        }
        return t;
    }

    private final int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    private void jj_add_error_token(int kind, int pos) {
        if (pos >= 100) {
            return;
        }
        if (pos == this.jj_endpos + 1) {
            this.jj_lasttokens[this.jj_endpos++] = kind;
        } else if (this.jj_endpos != 0) {
            this.jj_expentry = new int[this.jj_endpos];
            for (int i = 0; i < this.jj_endpos; ++i) {
                this.jj_expentry[i] = this.jj_lasttokens[i];
            }
            boolean exists = false;
            Enumeration e = this.jj_expentries.elements();
            while (e.hasMoreElements()) {
                int[] oldentry = (int[])e.nextElement();
                if (oldentry.length != this.jj_expentry.length) continue;
                exists = true;
                for (int i = 0; i < this.jj_expentry.length; ++i) {
                    if (oldentry[i] == this.jj_expentry[i]) continue;
                    exists = false;
                    break;
                }
                if (!exists) continue;
                break;
            }
            if (!exists) {
                this.jj_expentries.addElement(this.jj_expentry);
            }
            if (pos != 0) {
                this.jj_endpos = pos;
                this.jj_lasttokens[this.jj_endpos - 1] = kind;
            }
        }
    }

    public ParseException generateParseException() {
        int i;
        this.jj_expentries.removeAllElements();
        boolean[] la1tokens = new boolean[85];
        for (i = 0; i < 85; ++i) {
            la1tokens[i] = false;
        }
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        for (i = 0; i < 32; ++i) {
            if (this.jj_la1[i] != this.jj_gen) continue;
            for (int j = 0; j < 32; ++j) {
                if ((jj_la1_0[i] & 1 << j) != 0) {
                    la1tokens[j] = true;
                }
                if ((jj_la1_1[i] & 1 << j) != 0) {
                    la1tokens[32 + j] = true;
                }
                if ((jj_la1_2[i] & 1 << j) == 0) continue;
                la1tokens[64 + j] = true;
            }
        }
        for (i = 0; i < 85; ++i) {
            if (!la1tokens[i]) continue;
            this.jj_expentry = new int[1];
            this.jj_expentry[0] = i;
            this.jj_expentries.addElement(this.jj_expentry);
        }
        this.jj_endpos = 0;
        this.jj_rescan_token();
        this.jj_add_error_token(0, 0);
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        for (int i2 = 0; i2 < this.jj_expentries.size(); ++i2) {
            exptokseq[i2] = (int[])this.jj_expentries.elementAt(i2);
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }

    private final void jj_rescan_token() {
        this.jj_rescan = true;
        for (int i = 0; i < 5; ++i) {
            try {
                JJCalls p = this.jj_2_rtns[i];
                do {
                    if (p.gen <= this.jj_gen) continue;
                    this.jj_la = p.arg;
                    this.jj_lastpos = this.jj_scanpos = p.first;
                    switch (i) {
                        case 0: {
                            this.jj_3_1();
                            break;
                        }
                        case 1: {
                            this.jj_3_2();
                            break;
                        }
                        case 2: {
                            this.jj_3_3();
                            break;
                        }
                        case 3: {
                            this.jj_3_4();
                            break;
                        }
                        case 4: {
                            this.jj_3_5();
                        }
                    }
                } while ((p = p.next) != null);
                continue;
            }
            catch (LookaheadSuccess lookaheadSuccess) {
                // empty catch block
            }
        }
        this.jj_rescan = false;
    }

    private final void jj_save(int index, int xla) {
        JJCalls p = this.jj_2_rtns[index];
        while (p.gen > this.jj_gen) {
            if (p.next == null) {
                p = p.next = new JJCalls();
                break;
            }
            p = p.next;
        }
        p.gen = this.jj_gen + xla - this.jj_la;
        p.first = this.token;
        p.arg = xla;
    }

    static {
        PigletParser.jj_la1_0();
        PigletParser.jj_la1_1();
        PigletParser.jj_la1_2();
    }

    static final class JJCalls {
        int gen;
        Token first;
        int arg;
        JJCalls next;

        JJCalls() {
        }
    }

    private static final class LookaheadSuccess
    extends Error {
        private LookaheadSuccess() {
        }
    }
}

