/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.piglet;

import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Locale;
import org.apache.calcite.piglet.PigUdfs;
import org.apache.calcite.util.ReflectUtil;

class PigUdfFinder {
    private final ImmutableMap<String, Method> udfWrapper;

    PigUdfFinder() {
        HashMap<String, Method> map = new HashMap<String, Method>();
        for (Method method : PigUdfs.class.getMethods()) {
            if (!ReflectUtil.isPublic((Member)method) || method.getReturnType() == Method.class) continue;
            map.put(method.getName(), method);
        }
        this.udfWrapper = ImmutableMap.copyOf(map);
    }

    Method findPigUdfImplementationMethod(Class clazz) {
        Method returnedMethod = (Method)this.udfWrapper.get((Object)clazz.getSimpleName().toLowerCase(Locale.US));
        if (returnedMethod != null) {
            return returnedMethod;
        }
        returnedMethod = PigUdfFinder.findExecMethod(clazz.getDeclaredMethods());
        if (returnedMethod != null) {
            return returnedMethod;
        }
        returnedMethod = PigUdfFinder.findExecMethod(clazz.getMethods());
        if (returnedMethod != null) {
            return returnedMethod;
        }
        throw new IllegalArgumentException("Could not find 'exec' method for PigUDF class of " + clazz.getName());
    }

    private static Method findExecMethod(Method[] methods) {
        if (methods == null) {
            return null;
        }
        Method returnedMethod = null;
        for (Method method : methods) {
            if (!method.getName().equals("exec")) continue;
            if (method.getReturnType() != Object.class) {
                return method;
            }
            returnedMethod = method;
        }
        return returnedMethod;
    }
}

