/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.piglet;

import com.google.common.collect.ImmutableList;
import java.lang.reflect.Method;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.calcite.linq4j.function.Functions;
import org.apache.calcite.piglet.PigTypes;
import org.apache.calcite.piglet.PigUserDefinedFunction;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeFactoryImpl;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.ScalarFunction;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.calcite.sql.SqlCallBinding;
import org.apache.calcite.sql.SqlOperandCountRange;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.type.MultisetSqlType;
import org.apache.calcite.sql.type.OperandTypes;
import org.apache.calcite.sql.type.SqlOperandCountRanges;
import org.apache.calcite.sql.type.SqlOperandMetadata;
import org.apache.calcite.sql.type.SqlReturnTypeInference;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.pig.FuncSpec;
import org.apache.pig.data.BagFactory;
import org.apache.pig.data.DataBag;
import org.apache.pig.data.Tuple;
import org.apache.pig.data.TupleFactory;

public class PigRelSqlUdfs {
    private static final ScalarFunction PIG_TUPLE_FUNC = ScalarFunctionImpl.create(PigRelSqlUdfs.class, (String)"buildTuple");
    private static final ScalarFunction PIG_BAG_FUNC = ScalarFunctionImpl.create(PigRelSqlUdfs.class, (String)"buildBag");
    private static final ScalarFunction MULTISET_PROJECTION_FUNC = ScalarFunctionImpl.create(PigRelSqlUdfs.class, (String)"projectMultiset");
    static final SqlUserDefinedFunction MULTISET_PROJECTION = new PigUserDefinedFunction("MULTISET_PROJECTION", PigRelSqlUdfs.multisetProjectionInfer(), PigRelSqlUdfs.multisetProjectionCheck(), (Function)MULTISET_PROJECTION_FUNC);

    private PigRelSqlUdfs() {
    }

    static SqlUserDefinedFunction createPigTupleUDF(ImmutableList<RexNode> operands) {
        return new PigUserDefinedFunction("PIG_TUPLE", PigRelSqlUdfs.infer(PIG_TUPLE_FUNC), OperandTypes.operandMetadata(PigRelSqlUdfs.getTypeFamilies(operands), typeFactory -> PigRelSqlUdfs.getRelDataTypes(operands), i -> "arg" + i, i -> false), (Function)PIG_TUPLE_FUNC);
    }

    static SqlUserDefinedFunction createPigBagUDF(ImmutableList<RexNode> operands) {
        SqlOperandMetadata operandMetadata = OperandTypes.operandMetadata(PigRelSqlUdfs.getTypeFamilies(operands), typeFactory -> PigRelSqlUdfs.getRelDataTypes(operands), i -> "arg" + i, i -> false);
        return new PigUserDefinedFunction("PIG_BAG", PigRelSqlUdfs.infer(PIG_BAG_FUNC), operandMetadata, (Function)PIG_BAG_FUNC);
    }

    static SqlUserDefinedFunction createGeneralPigUdf(String udfName, Method method, FuncSpec funcSpec, RelDataType inputType, RelDataType returnType) {
        SqlOperandMetadata operandMetadata = OperandTypes.operandMetadata((List)ImmutableList.of((Object)SqlTypeFamily.ANY), typeFactory -> ImmutableList.of((Object)inputType), i -> "arg" + i, i -> false);
        return new PigUserDefinedFunction(udfName, opBinding -> returnType, operandMetadata, (Function)ScalarFunctionImpl.createUnsafe((Method)method), funcSpec);
    }

    private static SqlReturnTypeInference multisetProjectionInfer() {
        return opBinding -> {
            MultisetSqlType source = (MultisetSqlType)opBinding.getOperandType(0);
            List fields = source.getComponentType().getFieldList();
            if (opBinding.getOperandCount() == 2) {
                int fieldNo = (Integer)opBinding.getOperandLiteralValue(1, Integer.class);
                if (fields.size() == 1) {
                    assert (fieldNo == 0);
                    return source;
                }
                return PigTypes.TYPE_FACTORY.createMultisetType(((RelDataTypeField)fields.get(fieldNo)).getType(), -1L);
            }
            ArrayList<String> destNames = new ArrayList<String>();
            ArrayList<RelDataType> destTypes = new ArrayList<RelDataType>();
            for (int i = 1; i < opBinding.getOperandCount(); ++i) {
                int fieldNo = (Integer)opBinding.getOperandLiteralValue(i, Integer.class);
                destNames.add(((RelDataTypeField)fields.get(fieldNo)).getName());
                destTypes.add(((RelDataTypeField)fields.get(fieldNo)).getType());
            }
            return PigTypes.TYPE_FACTORY.createMultisetType(PigTypes.TYPE_FACTORY.createStructType(destTypes, destNames), -1L);
        };
    }

    private static SqlOperandMetadata multisetProjectionCheck() {
        int paramCount = 2;
        return new SqlOperandMetadata(){

            public boolean checkOperandTypes(SqlCallBinding callBinding, boolean throwOnFailure) {
                if (callBinding.getOperandCount() < 2) {
                    return false;
                }
                if (!(callBinding.getOperandType(0) instanceof MultisetSqlType)) {
                    return false;
                }
                MultisetSqlType source = (MultisetSqlType)callBinding.getOperandType(0);
                int maxFieldNo = source.getComponentType().getFieldCount() - 1;
                for (int i = 1; i < callBinding.getOperandCount(); ++i) {
                    if (!(callBinding.getOperandLiteralValue(i, Comparable.class) instanceof BigDecimal)) {
                        return false;
                    }
                    int fieldNo = (Integer)callBinding.getOperandLiteralValue(i, Integer.class);
                    if (fieldNo >= 0 && fieldNo <= maxFieldNo) continue;
                    return false;
                }
                return true;
            }

            public SqlOperandCountRange getOperandCountRange() {
                return SqlOperandCountRanges.from((int)2);
            }

            public String getAllowedSignatures(SqlOperator op, String opName) {
                return opName + "(...)";
            }

            public List<RelDataType> paramTypes(RelDataTypeFactory typeFactory) {
                return Functions.generate((int)2, i -> typeFactory.createSqlType(SqlTypeName.ANY));
            }

            public List<String> paramNames() {
                return Functions.generate((int)2, i -> "arg" + i);
            }

            public boolean isFixedParameters() {
                return true;
            }
        };
    }

    private static List<SqlTypeFamily> getTypeFamilies(ImmutableList<RexNode> operands) {
        ArrayList<SqlTypeFamily> ret = new ArrayList<SqlTypeFamily>();
        for (RexNode operand : operands) {
            SqlTypeFamily family = operand.getType().getSqlTypeName().getFamily();
            ret.add(family != null ? family : SqlTypeFamily.ANY);
        }
        return ret;
    }

    private static List<RelDataType> getRelDataTypes(ImmutableList<RexNode> operands) {
        ArrayList<RelDataType> ret = new ArrayList<RelDataType>();
        for (RexNode operand : operands) {
            ret.add(operand.getType());
        }
        return ret;
    }

    private static SqlReturnTypeInference infer(ScalarFunction function) {
        return opBinding -> PigRelSqlUdfs.getRelDataType(function);
    }

    private static RelDataType getRelDataType(ScalarFunction function) {
        PigTypes.PigRelDataTypeFactory typeFactory = PigTypes.TYPE_FACTORY;
        RelDataType type = function.getReturnType((RelDataTypeFactory)typeFactory);
        if (type instanceof RelDataTypeFactoryImpl.JavaType && ((RelDataTypeFactoryImpl.JavaType)type).getJavaClass() == Object.class) {
            return typeFactory.createTypeWithNullability(typeFactory.createSqlType(SqlTypeName.ANY), true);
        }
        return typeFactory.toSql(type);
    }

    public static Tuple buildTuple(Object ... elements) {
        return TupleFactory.getInstance().newTuple(Arrays.asList(elements));
    }

    public static Tuple buildBag(Object ... elements) {
        TupleFactory tupleFactory = TupleFactory.getInstance();
        BagFactory bagFactory = BagFactory.getInstance();
        ArrayList<Tuple> tupleList = new ArrayList<Tuple>();
        if (elements != null) {
            List<Object> bag = elements[0] instanceof List ? (List<Object>)elements[0] : Collections.singletonList(elements[0]);
            for (Object row : bag) {
                tupleList.add(tupleFactory.newTuple(Arrays.asList(row)));
            }
        }
        DataBag resultBag = bagFactory.newDefaultBag(tupleList);
        ArrayList<Object> finalTuple = new ArrayList<Object>();
        finalTuple.add(resultBag);
        if (elements != null) {
            for (int i = 1; i < elements.length; ++i) {
                finalTuple.add(elements[i]);
            }
        }
        return tupleFactory.newTuple(finalTuple);
    }

    public static List projectMultiset(Object ... objects) {
        List inputMultiset = (List)objects[0];
        ArrayList<Object> projectedMultiset = new ArrayList<Object>();
        for (Object[] row : inputMultiset) {
            if (objects.length > 2) {
                Object[] newRow = new Object[objects.length - 1];
                for (int j = 1; j < objects.length; ++j) {
                    newRow[j - 1] = row[(Integer)objects[j]];
                }
                projectedMultiset.add(newRow);
                continue;
            }
            projectedMultiset.add(row[(Integer)objects[1]]);
        }
        return projectedMultiset;
    }
}

