/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.piglet;

import com.google.common.collect.ImmutableSet;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Set;
import org.apache.calcite.piglet.DynamicTupleRecordType;
import org.apache.calcite.piglet.PigRelBuilder;
import org.apache.calcite.piglet.PigRelExVisitor;
import org.apache.calcite.piglet.PigRelOpVisitor;
import org.apache.calcite.piglet.PigTypes;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.CorrelationId;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rel.logical.LogicalValues;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.MultisetSqlType;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.type.SqlTypeUtil;
import org.apache.calcite.util.Litmus;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanWalker;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.relational.LOGenerate;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;
import org.apache.pig.newplan.logical.relational.LogicalSchema;

class PigRelOpInnerVisitor
extends PigRelOpVisitor {
    private final RelNode inputRel;
    private final Deque<CorrelationId> corStack = new ArrayDeque<CorrelationId>();

    PigRelOpInnerVisitor(OperatorPlan plan, PlanWalker walker, PigRelBuilder builder) throws FrontendException {
        super(plan, walker, builder);
        this.inputRel = builder.peek();
    }

    @Override
    public void visit(LOGenerate gen) throws FrontendException {
        this.makeCorrelates();
        ArrayList<Integer> multisetFlattens = new ArrayList<Integer>();
        ArrayList<String> flattenOutputAliases = new ArrayList<String>();
        this.doGenerateWithoutMultisetFlatten(gen, multisetFlattens, flattenOutputAliases);
        if (!multisetFlattens.isEmpty()) {
            this.builder.multiSetFlatten(multisetFlattens, flattenOutputAliases);
        }
    }

    private void makeCorrelates() {
        ArrayList<CorrelationId> corIds = new ArrayList<CorrelationId>();
        ArrayList<RelNode> rightRels = new ArrayList<RelNode>();
        while (!this.corStack.isEmpty()) {
            CorrelationId corId = this.corStack.pop();
            corIds.add(0, corId);
            ArrayList<RelNode> corRels = new ArrayList<RelNode>();
            while (!RelOptUtil.notContainsCorrelation((RelNode)this.builder.peek(), (CorrelationId)corId, (Litmus)Litmus.IGNORE)) {
                corRels.add(0, this.builder.build());
            }
            assert (!corRels.isEmpty());
            this.builder.push((RelNode)corRels.get(0));
            this.builder.collect();
            for (int i = 1; i < corRels.size(); ++i) {
                this.builder.push((RelNode)corRels.get(i));
                this.builder.collect();
                this.builder.join(JoinRelType.INNER, (RexNode)this.builder.literal(true));
            }
            rightRels.add(0, this.builder.build());
        }
        for (int i = 0; i < corIds.size(); ++i) {
            this.builder.push((RelNode)rightRels.get(i));
            this.builder.join(JoinRelType.INNER, (RexNode)this.builder.literal(true), (Set)ImmutableSet.of(corIds.get(i)));
        }
    }

    private void doGenerateWithoutMultisetFlatten(LOGenerate gen, List<Integer> multisetFlattens, List<String> flattenOutputAliases) throws FrontendException {
        List pigProjections = gen.getOutputPlans();
        ArrayList<RexNode> innerCols = new ArrayList<RexNode>();
        ArrayList<String> fieldAlias = new ArrayList<String>();
        if (gen.getOutputPlanSchemas() == null) {
            throw new IllegalArgumentException("Generate statement at line " + gen.getLocation().line() + " produces empty schema");
        }
        for (int i = 0; i < pigProjections.size(); ++i) {
            LogicalSchema outputFieldSchema = (LogicalSchema)gen.getOutputPlanSchemas().get(i);
            RexNode rexNode = PigRelExVisitor.translatePigEx(this.builder, (LogicalExpressionPlan)pigProjections.get(i));
            RelDataType dataType = rexNode.getType();
            if (dataType.getSqlTypeName() == SqlTypeName.NULL) {
                dataType = PigTypes.convertSchema(outputFieldSchema, true);
            }
            if (outputFieldSchema.size() == 1 && !gen.getFlattenFlags()[i]) {
                RelDataType scriptType = PigTypes.convertSchemaField(outputFieldSchema.getField(0));
                if (dataType.getSqlTypeName() == SqlTypeName.ANY || !SqlTypeUtil.isComparable((RelDataType)dataType, (RelDataType)scriptType)) {
                    rexNode = this.builder.getRexBuilder().makeCast(scriptType, rexNode);
                }
            }
            if (gen.getFlattenFlags()[i] && dataType.isStruct() && (dataType.getFieldCount() > 0 || dataType instanceof DynamicTupleRecordType)) {
                if (dataType instanceof DynamicTupleRecordType) {
                    ((DynamicTupleRecordType)dataType).resize(outputFieldSchema.size());
                    for (int j = 0; j < outputFieldSchema.size(); ++j) {
                        RelDataType scriptType = PigTypes.convertSchemaField(outputFieldSchema.getField(j));
                        RexNode exp = this.builder.call(SqlStdOperatorTable.ITEM, new RexNode[]{rexNode, this.builder.literal(j + 1)});
                        innerCols.add(this.builder.getRexBuilder().makeCast(scriptType, exp));
                        fieldAlias.add(outputFieldSchema.getField((int)j).alias);
                    }
                    continue;
                }
                for (int j = 0; j < dataType.getFieldCount(); ++j) {
                    innerCols.add(this.builder.dot(rexNode, j));
                    fieldAlias.add(outputFieldSchema.getField((int)j).alias);
                }
                continue;
            }
            innerCols.add(rexNode);
            String alias = null;
            if (outputFieldSchema.size() == 1) {
                alias = outputFieldSchema.getField((int)0).alias;
            }
            fieldAlias.add(alias);
            if (!gen.getFlattenFlags()[i] || !(dataType.getFamily() instanceof MultisetSqlType)) continue;
            multisetFlattens.add(innerCols.size() - 1);
            for (LogicalSchema.LogicalFieldSchema field : outputFieldSchema.getFields()) {
                String colAlias = field.alias;
                if (colAlias.contains("::")) {
                    String[] tokens = colAlias.split("::");
                    colAlias = tokens[tokens.length - 1];
                }
                flattenOutputAliases.add(colAlias);
            }
        }
        this.builder.project(innerCols, fieldAlias, true);
    }

    @Override
    public void visit(LOInnerLoad load) {
        int index;
        List succesors = load.getPlan().getSuccessors((Operator)load);
        if (succesors.size() == 1 && succesors.get(0) instanceof LOGenerate) {
            return;
        }
        RelDataType inputType = this.inputRel.getRowType();
        String colAlias = load.getProjection().getColAlias();
        int n = index = colAlias != null ? inputType.getFieldNames().indexOf(colAlias) : load.getProjection().getColNum();
        assert (index >= 0);
        assert (((RelDataTypeField)inputType.getFieldList().get(index)).getType().getFamily() instanceof MultisetSqlType);
        CorrelationId correlId = this.builder.nextCorrelId();
        RexNode cor = this.builder.correl(inputType.getFieldList(), correlId);
        RexNode fieldAccess = this.builder.getRexBuilder().makeFieldAccess(cor, index);
        this.builder.push((RelNode)LogicalValues.createOneRow((RelOptCluster)this.builder.getCluster()));
        this.builder.project(new RexNode[]{fieldAccess});
        this.builder.multiSetFlatten();
        this.corStack.push(correlId);
    }

    @Override
    public boolean preVisit(LogicalRelationalOperator root) {
        return false;
    }
}

