/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.piglet;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import java.math.BigDecimal;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Deque;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.piglet.PigRelBuilder;
import org.apache.calcite.piglet.PigRelExWalker;
import org.apache.calcite.piglet.PigRelSqlUdfs;
import org.apache.calcite.piglet.PigRelUdfConverter;
import org.apache.calcite.piglet.PigTypes;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexSubQuery;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.schema.impl.ScalarFunctionImpl;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.MultisetSqlType;
import org.apache.calcite.sql.validate.SqlUserDefinedFunction;
import org.apache.calcite.util.NlsString;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.newplan.Operator;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.PlanVisitor;
import org.apache.pig.newplan.PlanWalker;
import org.apache.pig.newplan.logical.expression.AddExpression;
import org.apache.pig.newplan.logical.expression.AndExpression;
import org.apache.pig.newplan.logical.expression.BinCondExpression;
import org.apache.pig.newplan.logical.expression.CastExpression;
import org.apache.pig.newplan.logical.expression.ConstantExpression;
import org.apache.pig.newplan.logical.expression.DereferenceExpression;
import org.apache.pig.newplan.logical.expression.DivideExpression;
import org.apache.pig.newplan.logical.expression.EqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanEqualExpression;
import org.apache.pig.newplan.logical.expression.GreaterThanExpression;
import org.apache.pig.newplan.logical.expression.IsNullExpression;
import org.apache.pig.newplan.logical.expression.LessThanEqualExpression;
import org.apache.pig.newplan.logical.expression.LessThanExpression;
import org.apache.pig.newplan.logical.expression.LogicalExpressionPlan;
import org.apache.pig.newplan.logical.expression.LogicalExpressionVisitor;
import org.apache.pig.newplan.logical.expression.MapLookupExpression;
import org.apache.pig.newplan.logical.expression.ModExpression;
import org.apache.pig.newplan.logical.expression.MultiplyExpression;
import org.apache.pig.newplan.logical.expression.NegativeExpression;
import org.apache.pig.newplan.logical.expression.NotEqualExpression;
import org.apache.pig.newplan.logical.expression.NotExpression;
import org.apache.pig.newplan.logical.expression.OrExpression;
import org.apache.pig.newplan.logical.expression.ProjectExpression;
import org.apache.pig.newplan.logical.expression.RegexExpression;
import org.apache.pig.newplan.logical.expression.ScalarExpression;
import org.apache.pig.newplan.logical.expression.SubtractExpression;
import org.apache.pig.newplan.logical.expression.UserFuncExpression;
import org.apache.pig.newplan.logical.relational.LOInnerLoad;
import org.apache.pig.newplan.logical.relational.LogicalRelationalOperator;

class PigRelExVisitor
extends LogicalExpressionVisitor {
    private final Deque<RexNode> stack = new ArrayDeque<RexNode>();
    private final PigRelBuilder builder;
    private final int inputCount;
    private final int inputOrdinal;

    private PigRelExVisitor(OperatorPlan expressionPlan, PlanWalker walker, PigRelBuilder builder, int inputCount, int inputOrdinal) throws FrontendException {
        super(expressionPlan, walker);
        this.builder = builder;
        this.inputCount = inputCount;
        this.inputOrdinal = inputOrdinal;
    }

    private List<RexNode> translate() throws FrontendException {
        this.currentWalker.walk((PlanVisitor)this);
        return new ArrayList<RexNode>(this.stack);
    }

    static RexNode translatePigEx(PigRelBuilder builder, LogicalExpressionPlan pigEx, int inputCount, int inputOrdinal) throws FrontendException {
        PigRelExWalker walker = new PigRelExWalker((OperatorPlan)pigEx);
        PigRelExVisitor exVisitor = new PigRelExVisitor((OperatorPlan)pigEx, walker, builder, inputCount, inputOrdinal);
        List<RexNode> result = exVisitor.translate();
        assert (result.size() == 1);
        return result.get(0);
    }

    static RexNode translatePigEx(PigRelBuilder builder, LogicalExpressionPlan pigEx) throws FrontendException {
        return PigRelExVisitor.translatePigEx(builder, pigEx, 1, 0);
    }

    private ImmutableList<RexNode> buildOperands(int numOps) {
        ArrayList<RexNode> opList = new ArrayList<RexNode>();
        for (int i = 0; i < numOps; ++i) {
            opList.add(0, this.stack.pop());
        }
        return ImmutableList.copyOf(opList);
    }

    private ImmutableList<RexNode> buildBinaryOperands() {
        return this.buildOperands(2);
    }

    public void visit(ConstantExpression op) throws FrontendException {
        RelDataType constType = PigTypes.convertSchemaField(op.getFieldSchema(), false);
        this.stack.push((RexNode)this.builder.literal(op.getValue(), constType));
    }

    public void visit(ProjectExpression op) throws FrontendException {
        String fullAlias = op.getFieldSchema().alias;
        if (fullAlias != null) {
            RexInputRef inputRef;
            try {
                inputRef = this.builder.field(this.inputCount, this.inputOrdinal, fullAlias);
            }
            catch (IllegalArgumentException e) {
                List fieldNames = this.builder.peek(this.inputCount, this.inputOrdinal).getRowType().getFieldNames();
                int index = -1;
                for (int i = 0; i < fieldNames.size(); ++i) {
                    if (!fullAlias.endsWith((String)fieldNames.get(i))) continue;
                    index = i;
                    break;
                }
                if (index < 0) {
                    String shortAlias = fullAlias;
                    if (fullAlias.contains("::")) {
                        String[] tokens = fullAlias.split("::");
                        shortAlias = tokens[tokens.length - 1];
                    }
                    for (int i = 0; i < fieldNames.size(); ++i) {
                        if (!((String)fieldNames.get(i)).equals(shortAlias)) continue;
                        index = i;
                        break;
                    }
                    if (index < 0) {
                        throw new IllegalArgumentException("field [" + fullAlias + "] not found; input fields are: " + fieldNames);
                    }
                }
                inputRef = this.builder.field(this.inputCount, this.inputOrdinal, index);
            }
            this.stack.push((RexNode)inputRef);
        } else {
            assert (op.getInputNum() >= 0);
            LogicalRelationalOperator pigRelOp = op.getAttachedRelationalOp();
            LogicalRelationalOperator childOp = (LogicalRelationalOperator)pigRelOp.getPlan().getPredecessors((Operator)pigRelOp).get(op.getInputNum());
            if (this.builder.checkMap(childOp)) {
                this.builder.push(this.builder.getRel((Operator)childOp));
                ImmutableList<RexNode> fields = this.builder.getFields(this.inputCount, this.inputOrdinal, op.getColNum());
                for (int i = fields.size() - 1; i >= 0; --i) {
                    this.stack.push((RexNode)fields.get(i));
                }
                this.builder.build();
            } else {
                assert (childOp instanceof LOInnerLoad);
                this.visit(((LOInnerLoad)childOp).getProjection());
            }
        }
    }

    public void visit(NegativeExpression op) {
        RexNode operand = this.stack.pop();
        if (operand instanceof RexLiteral) {
            Comparable value = ((RexLiteral)operand).getValue();
            if (value instanceof BigDecimal) {
                this.stack.push((RexNode)this.builder.literal(((BigDecimal)value).negate()));
            } else {
                assert (value instanceof Double);
                this.stack.push((RexNode)this.builder.literal(-((Double)value).doubleValue()));
            }
        } else {
            this.stack.push(this.builder.call((SqlOperator)SqlStdOperatorTable.UNARY_MINUS, new RexNode[]{operand}));
        }
    }

    public void visit(EqualExpression op) {
        this.stack.push(this.builder.call((SqlOperator)SqlStdOperatorTable.EQUALS, (Iterable)this.buildBinaryOperands()));
    }

    public void visit(NotEqualExpression op) {
        this.stack.push(this.builder.call((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, (Iterable)this.buildBinaryOperands()));
    }

    public void visit(LessThanExpression op) {
        this.stack.push(this.builder.call((SqlOperator)SqlStdOperatorTable.LESS_THAN, (Iterable)this.buildBinaryOperands()));
    }

    public void visit(LessThanEqualExpression op) {
        this.stack.push(this.builder.call((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, (Iterable)this.buildBinaryOperands()));
    }

    public void visit(GreaterThanExpression op) {
        this.stack.push(this.builder.call((SqlOperator)SqlStdOperatorTable.GREATER_THAN, (Iterable)this.buildBinaryOperands()));
    }

    public void visit(GreaterThanEqualExpression op) {
        this.stack.push(this.builder.call((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, (Iterable)this.buildBinaryOperands()));
    }

    public void visit(RegexExpression op) {
        RexNode operand1 = PigRelExVisitor.replacePatternIfPossible(this.stack.pop());
        RexNode operand2 = PigRelExVisitor.replacePatternIfPossible(this.stack.pop());
        this.stack.push(this.builder.call((SqlOperator)SqlStdOperatorTable.LIKE, (Iterable)ImmutableList.of((Object)operand2, (Object)operand1)));
    }

    private static RexNode replacePatternIfPossible(RexNode rexNode) {
        return rexNode;
    }

    public void visit(IsNullExpression op) {
        this.stack.push(this.builder.call((SqlOperator)SqlStdOperatorTable.IS_NULL, new RexNode[]{this.stack.pop()}));
    }

    public void visit(NotExpression op) {
        this.stack.push(this.builder.call((SqlOperator)SqlStdOperatorTable.NOT, new RexNode[]{this.stack.pop()}));
    }

    public void visit(AndExpression op) {
        this.stack.push(this.builder.call((SqlOperator)SqlStdOperatorTable.AND, (Iterable)this.buildBinaryOperands()));
    }

    public void visit(OrExpression op) {
        this.stack.push(this.builder.call((SqlOperator)SqlStdOperatorTable.OR, (Iterable)this.buildBinaryOperands()));
    }

    public void visit(AddExpression op) {
        this.stack.push(this.builder.call((SqlOperator)SqlStdOperatorTable.PLUS, (Iterable)this.buildBinaryOperands()));
    }

    public void visit(SubtractExpression op) {
        this.stack.push(this.builder.call((SqlOperator)SqlStdOperatorTable.MINUS, (Iterable)this.buildBinaryOperands()));
    }

    public void visit(MultiplyExpression op) {
        this.stack.push(this.builder.call((SqlOperator)SqlStdOperatorTable.MULTIPLY, (Iterable)this.buildBinaryOperands()));
    }

    public void visit(ModExpression op) {
        this.stack.push(this.builder.call((SqlOperator)SqlStdOperatorTable.MOD, (Iterable)this.buildBinaryOperands()));
    }

    public void visit(DivideExpression op) {
        this.stack.push(this.builder.call((SqlOperator)SqlStdOperatorTable.DIVIDE, (Iterable)this.buildBinaryOperands()));
    }

    public void visit(BinCondExpression op) {
        this.stack.push(this.builder.call((SqlOperator)SqlStdOperatorTable.CASE, (Iterable)this.buildOperands(3)));
    }

    public void visit(UserFuncExpression op) throws FrontendException {
        if (op.getFuncSpec().getClassName().equals("org.apache.pig.impl.builtin.IdentityColumn")) {
            return;
        }
        int numAgrs = PigRelExVisitor.optSize(op.getPlan().getSuccessors((Operator)op)) + PigRelExVisitor.optSize(op.getPlan().getSoftLinkSuccessors((Operator)op));
        RelDataType returnType = PigTypes.convertSchemaField(op.getFieldSchema());
        this.stack.push(PigRelUdfConverter.convertPigFunction(this.builder, op.getFuncSpec(), this.buildOperands(numAgrs), returnType));
        String className = op.getFuncSpec().getClassName();
        SqlOperator sqlOp = ((RexCall)this.stack.peek()).getOperator();
        if (sqlOp instanceof SqlUserDefinedFunction) {
            ScalarFunctionImpl sqlFunc = (ScalarFunctionImpl)((SqlUserDefinedFunction)sqlOp).getFunction();
            className = sqlFunc.method.getDeclaringClass().getName();
        }
        this.builder.registerPigUDF(className, op.getFuncSpec());
    }

    private static int optSize(List<Operator> list) {
        return list != null ? list.size() : 0;
    }

    public void visit(DereferenceExpression op) {
        RexNode parentField = this.stack.pop();
        List cols = op.getBagColumns();
        Objects.requireNonNull(cols, "cols");
        Preconditions.checkArgument((!cols.isEmpty() ? 1 : 0) != 0);
        if (parentField.getType() instanceof MultisetSqlType) {
            RexNode[] rexCols = new RexNode[cols.size() + 1];
            rexCols[0] = parentField;
            for (int i = 0; i < cols.size(); ++i) {
                rexCols[i + 1] = this.builder.literal(cols.get(i));
            }
            this.stack.push(this.builder.call((SqlOperator)PigRelSqlUdfs.MULTISET_PROJECTION, rexCols));
        } else if (cols.size() == 1) {
            this.stack.push(this.builder.dot(parentField, cols.get(0)));
        } else {
            ArrayList<RexNode> relFields = new ArrayList<RexNode>();
            for (Object col : cols) {
                relFields.add(this.builder.dot(parentField, col));
            }
            RelDataType newRelType = RexUtil.createStructType((RelDataTypeFactory)PigTypes.TYPE_FACTORY, relFields);
            this.stack.push(this.builder.getRexBuilder().makeCall(newRelType, (SqlOperator)SqlStdOperatorTable.ROW, relFields));
        }
    }

    public void visit(CastExpression op) throws FrontendException {
        RelDataType relType = PigTypes.convertSchemaField(op.getFieldSchema());
        RexNode castOperand = this.stack.pop();
        if (castOperand instanceof RexLiteral && ((RexLiteral)castOperand).getValue() == null) {
            if (!relType.isStruct() && relType.getComponentType() == null) {
                this.stack.push((RexNode)this.builder.getRexBuilder().makeNullLiteral(relType));
            } else {
                this.stack.push(castOperand);
            }
        } else {
            this.stack.push(this.builder.getRexBuilder().makeCast(relType, castOperand));
        }
    }

    public void visit(MapLookupExpression op) {
        RexLiteral relKey = this.builder.literal(op.getLookupKey());
        RexNode relMap = this.stack.pop();
        this.stack.push(this.builder.call(SqlStdOperatorTable.ITEM, new RexNode[]{relMap, relKey}));
    }

    public void visit(ScalarExpression op) {
        RexNode operand1 = this.stack.pop();
        assert (operand1 instanceof RexLiteral && ((RexLiteral)operand1).getValue() instanceof NlsString);
        RexNode operand2 = this.stack.pop();
        assert (operand2 instanceof RexLiteral && ((RexLiteral)operand2).getValue() instanceof BigDecimal);
        int index = ((BigDecimal)((RexLiteral)operand2).getValue()).intValue();
        RelNode referencedRel = this.builder.getRel(((LogicalRelationalOperator)op.getImplicitReferencedOperator()).getAlias());
        this.builder.push(referencedRel);
        ArrayList projectCol = Lists.newArrayList((Object[])new RexNode[]{this.builder.field(index)});
        this.builder.project(projectCol);
        this.stack.push((RexNode)RexSubQuery.scalar((RelNode)this.builder.build()));
    }
}

