/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.piglet;

import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.apache.calcite.adapter.enumerable.EnumerableConvention;
import org.apache.calcite.adapter.enumerable.EnumerableRules;
import org.apache.calcite.piglet.PigRelBuilder;
import org.apache.calcite.piglet.PigRelOpVisitor;
import org.apache.calcite.piglet.PigRelOpWalker;
import org.apache.calcite.piglet.PigRelToSqlConverter;
import org.apache.calcite.piglet.PigToSqlAggregateRule;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.ToLogicalConverter;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.sql.SqlDialect;
import org.apache.calcite.sql.SqlNode;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.SqlWriterConfig;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.tools.FrameworkConfig;
import org.apache.calcite.tools.Program;
import org.apache.calcite.tools.Programs;
import org.apache.calcite.tools.RelBuilder;
import org.apache.calcite.tools.RuleSet;
import org.apache.calcite.tools.RuleSets;
import org.apache.pig.ExecType;
import org.apache.pig.PigServer;
import org.apache.pig.impl.logicalLayer.FrontendException;
import org.apache.pig.impl.util.PropertiesUtil;
import org.apache.pig.newplan.OperatorPlan;
import org.apache.pig.newplan.logical.relational.LogicalPlan;

public class PigConverter
extends PigServer {
    private static final List<RelOptRule> PIG_RULES = ImmutableList.of((Object)CoreRules.PROJECT_TO_LOGICAL_PROJECT_AND_WINDOW, (Object)((Object)PigToSqlAggregateRule.INSTANCE), (Object)EnumerableRules.ENUMERABLE_VALUES_RULE, (Object)EnumerableRules.ENUMERABLE_JOIN_RULE, (Object)EnumerableRules.ENUMERABLE_CORRELATE_RULE, (Object)EnumerableRules.ENUMERABLE_PROJECT_RULE, (Object)EnumerableRules.ENUMERABLE_FILTER_RULE, (Object)EnumerableRules.ENUMERABLE_AGGREGATE_RULE, (Object)EnumerableRules.ENUMERABLE_SORT_RULE, (Object)EnumerableRules.ENUMERABLE_LIMIT_RULE, (Object)EnumerableRules.ENUMERABLE_COLLECT_RULE, (Object)EnumerableRules.ENUMERABLE_UNCOLLECT_RULE, (Object[])new RelOptRule[]{EnumerableRules.ENUMERABLE_UNION_RULE, EnumerableRules.ENUMERABLE_WINDOW_RULE, EnumerableRules.ENUMERABLE_TABLE_SCAN_RULE, EnumerableRules.TO_INTERPRETER});
    private static final List<RelOptRule> TRANSFORM_RULES = ImmutableList.of((Object)CoreRules.PROJECT_WINDOW_TRANSPOSE, (Object)CoreRules.FILTER_MERGE, (Object)CoreRules.PROJECT_MERGE, (Object)CoreRules.FILTER_PROJECT_TRANSPOSE, (Object)EnumerableRules.ENUMERABLE_VALUES_RULE, (Object)EnumerableRules.ENUMERABLE_JOIN_RULE, (Object)EnumerableRules.ENUMERABLE_CORRELATE_RULE, (Object)EnumerableRules.ENUMERABLE_PROJECT_RULE, (Object)EnumerableRules.ENUMERABLE_FILTER_RULE, (Object)EnumerableRules.ENUMERABLE_AGGREGATE_RULE, (Object)EnumerableRules.ENUMERABLE_SORT_RULE, (Object)EnumerableRules.ENUMERABLE_LIMIT_RULE, (Object[])new RelOptRule[]{EnumerableRules.ENUMERABLE_COLLECT_RULE, EnumerableRules.ENUMERABLE_UNCOLLECT_RULE, EnumerableRules.ENUMERABLE_UNION_RULE, EnumerableRules.ENUMERABLE_WINDOW_RULE, EnumerableRules.ENUMERABLE_TABLE_SCAN_RULE, EnumerableRules.TO_INTERPRETER});
    private final PigRelBuilder builder;

    private PigConverter(FrameworkConfig config, ExecType execType, Properties properties) throws Exception {
        super(execType, properties);
        this.builder = PigRelBuilder.create(config);
    }

    public static PigConverter create(FrameworkConfig config, Properties properties) throws Exception {
        return new PigConverter(config, ExecType.LOCAL, properties);
    }

    public static PigConverter create(FrameworkConfig config) throws Exception {
        return PigConverter.create(config, PropertiesUtil.loadDefaultProperties());
    }

    public PigRelBuilder getBuilder() {
        return this.builder;
    }

    public List<RelNode> pigQuery2Rel(String pigQuery) throws IOException {
        return this.pigQuery2Rel(pigQuery, true, true, true);
    }

    public List<RelNode> pigQuery2Rel(String pigQuery, boolean planRewrite, boolean validate, boolean usePigRules) throws IOException {
        this.setBatchOn();
        this.registerQuery(pigQuery);
        LogicalPlan pigPlan = this.getCurrentDAG().getLogicalPlan();
        if (validate) {
            pigPlan.validate(this.getPigContext(), this.scope, false);
        }
        return this.pigPlan2Rel(pigPlan, planRewrite, usePigRules);
    }

    public String getPigScript(InputStream in, Map<String, String> params) throws IOException {
        return this.getPigContext().doParamSubstitution(in, this.paramMapToList(params), null);
    }

    public List<RelNode> pigScript2Rel(String fileName, Map<String, String> params, boolean planRewrite) throws IOException {
        this.setBatchOn();
        this.registerScript(fileName, params);
        LogicalPlan pigPlan = this.getCurrentDAG().getLogicalPlan();
        pigPlan.validate(this.getPigContext(), this.scope, false);
        return this.pigPlan2Rel(pigPlan, planRewrite, true);
    }

    private List<RelNode> pigPlan2Rel(LogicalPlan pigPlan, boolean planRewrite, boolean usePigRules) throws FrontendException {
        PigRelOpWalker walker = new PigRelOpWalker((OperatorPlan)pigPlan);
        List<RelNode> relNodes = new PigRelOpVisitor((OperatorPlan)pigPlan, walker, this.builder).translate();
        List<RelNode> storeRels = this.builder.getRelsForStores();
        List<RelNode> list = relNodes = storeRels != null ? storeRels : relNodes;
        if (usePigRules) {
            relNodes = this.optimizePlans(relNodes, PIG_RULES);
        }
        if (planRewrite) {
            relNodes = this.optimizePlans(relNodes, TRANSFORM_RULES);
        }
        return relNodes;
    }

    public List<String> pigToSql(String pigQuery, SqlDialect sqlDialect) throws IOException {
        SqlWriterConfig config = SqlPrettyWriter.config().withQuoteAllIdentifiers(false).withAlwaysUseParentheses(false).withSelectListItemsOnSeparateLines(false).withIndentation(2).withDialect(sqlDialect);
        SqlPrettyWriter writer = new SqlPrettyWriter(config);
        return this.pigToSql(pigQuery, (SqlWriter)writer);
    }

    private List<String> pigToSql(String pigQuery, SqlWriter writer) throws IOException {
        PigRelToSqlConverter sqlConverter = new PigRelToSqlConverter(writer.getDialect());
        List<RelNode> finalRels = this.pigQuery2Rel(pigQuery);
        ArrayList<String> sqlStatements = new ArrayList<String>();
        for (RelNode rel : finalRels) {
            SqlNode sqlNode = sqlConverter.visitRoot(rel).asStatement();
            sqlNode.unparse(writer, 0, 0);
            sqlStatements.add(writer.toString());
            writer.reset();
        }
        return sqlStatements;
    }

    private List<RelNode> optimizePlans(List<RelNode> originalRels, List<RelOptRule> rules) {
        RelOptPlanner planner = originalRels.get(0).getCluster().getPlanner();
        List oldRules = planner.getRules();
        PigConverter.resetPlannerRules(planner, rules);
        Program program = Programs.of((RuleSet)RuleSets.ofList((Iterable)planner.getRules()));
        ArrayList<RelNode> optimizedPlans = new ArrayList<RelNode>();
        for (RelNode rel : originalRels) {
            RelCollation collation = rel instanceof Sort ? ((Sort)rel).collation : RelCollations.EMPTY;
            RelNode physicalPlan = program.run(planner, rel, rel.getTraitSet().replace((RelTrait)EnumerableConvention.INSTANCE).replace((RelTrait)collation).simplify(), (List)ImmutableList.of(), (List)ImmutableList.of());
            RelNode logicalPlan = new ToLogicalConverter((RelBuilder)this.builder).visit(physicalPlan);
            optimizedPlans.add(logicalPlan);
        }
        PigConverter.resetPlannerRules(planner, oldRules);
        return optimizedPlans;
    }

    private static void resetPlannerRules(RelOptPlanner planner, List<RelOptRule> rulesToSet) {
        planner.clear();
        for (RelOptRule rule : rulesToSet) {
            planner.addRule(rule);
        }
    }
}

