/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.pig;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.enumerable.EnumerableRules;
import org.apache.calcite.adapter.pig.PigDataType;
import org.apache.calcite.adapter.pig.PigRel;
import org.apache.calcite.adapter.pig.PigRules;
import org.apache.calcite.adapter.pig.PigTable;
import org.apache.calcite.adapter.pig.PigToEnumerableConverterRule;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.rules.CoreRules;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.pig.data.DataType;

public class PigTableScan
extends TableScan
implements PigRel {
    public PigTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table) {
        super(cluster, traitSet, (List)ImmutableList.of(), table);
        assert (this.getConvention() == PigRel.CONVENTION);
    }

    @Override
    public void implement(PigRel.Implementor implementor) {
        PigTable pigTable = this.getPigTable(implementor.getTableName(this));
        String alias = implementor.getPigRelationAlias(this);
        String schema = '(' + this.getSchemaForPigStatement(implementor) + ')';
        String statement = alias + " = LOAD '" + pigTable.getFilePath() + "' USING PigStorage() AS " + schema + ';';
        implementor.addStatement(statement);
    }

    private PigTable getPigTable(String name) {
        CalciteSchema schema = (CalciteSchema)this.getTable().unwrapOrThrow(CalciteSchema.class);
        return (PigTable)Objects.requireNonNull(schema.getTable(name, false)).getTable();
    }

    private String getSchemaForPigStatement(PigRel.Implementor implementor) {
        ArrayList<String> fieldNamesAndTypes = new ArrayList<String>(this.getTable().getRowType().getFieldList().size());
        for (RelDataTypeField f : this.getTable().getRowType().getFieldList()) {
            fieldNamesAndTypes.add(this.getConcatenatedFieldNameAndTypeForPigSchema(implementor, f));
        }
        return String.join((CharSequence)", ", fieldNamesAndTypes);
    }

    private String getConcatenatedFieldNameAndTypeForPigSchema(PigRel.Implementor implementor, RelDataTypeField field) {
        PigDataType pigDataType = PigDataType.valueOf(field.getType().getSqlTypeName());
        String fieldName = implementor.getFieldName(this, field.getIndex());
        return fieldName + ':' + DataType.findTypeName((byte)pigDataType.getPigType());
    }

    public void register(RelOptPlanner planner) {
        planner.addRule((RelOptRule)PigToEnumerableConverterRule.INSTANCE);
        for (RelOptRule relOptRule : PigRules.ALL_PIG_OPT_RULES) {
            planner.addRule(relOptRule);
        }
        planner.removeRule((RelOptRule)CoreRules.AGGREGATE_EXPAND_DISTINCT_AGGREGATES);
        planner.removeRule(EnumerableRules.ENUMERABLE_JOIN_RULE);
    }
}

