/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.pig;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.calcite.adapter.pig.PigRel;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Join;
import org.apache.calcite.rel.core.JoinRelType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlKind;

public class PigJoin
extends Join
implements PigRel {
    public PigJoin(RelOptCluster cluster, RelTraitSet traitSet, RelNode left, RelNode right, RexNode condition, JoinRelType joinType) {
        super(cluster, traitSet, (List)ImmutableList.of(), left, right, condition, (Set)ImmutableSet.of(), joinType);
        assert (this.getConvention() == PigRel.CONVENTION);
    }

    public Join copy(RelTraitSet traitSet, RexNode conditionExpr, RelNode left, RelNode right, JoinRelType joinType, boolean semiJoinDone) {
        return new PigJoin(this.getCluster(), traitSet, left, right, conditionExpr, joinType);
    }

    @Override
    public void implement(PigRel.Implementor implementor) {
        implementor.visitChild(0, this.getLeft());
        implementor.visitChild(0, this.getRight());
        implementor.addStatement(this.getPigJoinStatement(implementor));
    }

    public RelOptTable getTable() {
        return this.getLeft().getTable();
    }

    private String getPigJoinStatement(PigRel.Implementor implementor) {
        if (!this.getCondition().isA(SqlKind.EQUALS)) {
            throw new IllegalArgumentException("Only equi-join are supported");
        }
        List operands = ((RexCall)this.getCondition()).getOperands();
        if (operands.size() != 2) {
            throw new IllegalArgumentException("Only equi-join are supported");
        }
        ArrayList leftKeys = new ArrayList(1);
        ArrayList rightKeys = new ArrayList(1);
        ArrayList filterNulls = new ArrayList(1);
        RelOptUtil.splitJoinCondition((RelNode)this.getLeft(), (RelNode)this.getRight(), (RexNode)this.getCondition(), leftKeys, rightKeys, filterNulls);
        String leftRelAlias = implementor.getPigRelationAlias((PigRel)this.getLeft());
        String rightRelAlias = implementor.getPigRelationAlias((PigRel)this.getRight());
        String leftJoinFieldName = implementor.getFieldName((PigRel)this.getLeft(), (Integer)leftKeys.get(0));
        String rightJoinFieldName = implementor.getFieldName((PigRel)this.getRight(), (Integer)rightKeys.get(0));
        return implementor.getPigRelationAlias((PigRel)this.getLeft()) + " = JOIN " + leftRelAlias + " BY " + leftJoinFieldName + ' ' + this.getPigJoinType() + ", " + rightRelAlias + " BY " + rightJoinFieldName + ';';
    }

    private String getPigJoinType() {
        switch (this.getJoinType()) {
            case INNER: {
                return "";
            }
        }
        return this.getJoinType().name();
    }
}

