/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.pig;

import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.pig.data.DataType;

public enum PigDataType {
    CHARARRAY(55, SqlTypeName.VARCHAR);

    private final byte pigType;
    private final SqlTypeName sqlType;

    private PigDataType(byte pigType, SqlTypeName sqlType) {
        this.pigType = pigType;
        this.sqlType = sqlType;
    }

    public byte getPigType() {
        return this.pigType;
    }

    public SqlTypeName getSqlType() {
        return this.sqlType;
    }

    public static PigDataType valueOf(byte pigType) {
        for (PigDataType pigDataType : PigDataType.values()) {
            if (pigDataType.pigType != pigType) continue;
            return pigDataType;
        }
        throw new IllegalArgumentException("Pig data type " + DataType.findTypeName((byte)pigType) + " is not supported");
    }

    public static PigDataType valueOf(SqlTypeName sqlType) {
        for (PigDataType pigDataType : PigDataType.values()) {
            if (pigDataType.sqlType != sqlType) continue;
            return pigDataType;
        }
        throw new IllegalArgumentException("SQL data type " + sqlType + " is not supported");
    }
}

