/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.pig;

import com.google.common.collect.ImmutableList;
import java.util.List;
import org.apache.calcite.adapter.pig.PigAggregate;
import org.apache.calcite.adapter.pig.PigFilter;
import org.apache.calcite.adapter.pig.PigJoin;
import org.apache.calcite.adapter.pig.PigProject;
import org.apache.calcite.adapter.pig.PigRel;
import org.apache.calcite.adapter.pig.PigTableScan;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalJoin;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.logical.LogicalTableScan;
import org.apache.calcite.util.ImmutableBitSet;

public class PigRules {
    public static final List<ConverterRule> ALL_PIG_OPT_RULES = ImmutableList.of((Object)((Object)PigFilterRule.access$000()), (Object)((Object)PigTableScanRule.access$100()), (Object)((Object)PigProjectRule.access$200()), (Object)((Object)PigAggregateRule.access$300()), (Object)((Object)PigJoinRule.access$400()));

    private PigRules() {
    }

    private static class PigJoinRule
    extends ConverterRule {
        private static final PigJoinRule INSTANCE = (PigJoinRule)ConverterRule.Config.INSTANCE.withConversion(LogicalJoin.class, (RelTrait)Convention.NONE, (RelTrait)PigRel.CONVENTION, "PigJoinRule").withRuleFactory(PigJoinRule::new).toRule(PigJoinRule.class);

        protected PigJoinRule(ConverterRule.Config config) {
            super(config);
        }

        public RelNode convert(RelNode rel) {
            LogicalJoin join = (LogicalJoin)rel;
            RelTraitSet traitSet = join.getTraitSet().replace((RelTrait)PigRel.CONVENTION);
            return new PigJoin(join.getCluster(), traitSet, join.getLeft(), join.getRight(), join.getCondition(), join.getJoinType());
        }

        static /* synthetic */ PigJoinRule access$400() {
            return INSTANCE;
        }
    }

    private static class PigAggregateRule
    extends ConverterRule {
        private static final PigAggregateRule INSTANCE = (PigAggregateRule)ConverterRule.Config.INSTANCE.withConversion(LogicalAggregate.class, (RelTrait)Convention.NONE, (RelTrait)PigRel.CONVENTION, "PigAggregateRule").withRuleFactory(PigAggregateRule::new).toRule(PigAggregateRule.class);

        protected PigAggregateRule(ConverterRule.Config config) {
            super(config);
        }

        public RelNode convert(RelNode rel) {
            LogicalAggregate agg = (LogicalAggregate)rel;
            RelTraitSet traitSet = agg.getTraitSet().replace((RelTrait)PigRel.CONVENTION);
            return new PigAggregate(agg.getCluster(), traitSet, agg.getInput(), agg.getGroupSet(), (List<ImmutableBitSet>)agg.getGroupSets(), agg.getAggCallList());
        }

        static /* synthetic */ PigAggregateRule access$300() {
            return INSTANCE;
        }
    }

    private static class PigProjectRule
    extends ConverterRule {
        private static final PigProjectRule INSTANCE = (PigProjectRule)ConverterRule.Config.INSTANCE.withConversion(LogicalProject.class, (RelTrait)Convention.NONE, (RelTrait)PigRel.CONVENTION, "PigProjectRule").withRuleFactory(PigProjectRule::new).toRule(PigProjectRule.class);

        protected PigProjectRule(ConverterRule.Config config) {
            super(config);
        }

        public boolean matches(RelOptRuleCall call) {
            LogicalProject project = (LogicalProject)call.rel(0);
            return project.getVariablesSet().isEmpty();
        }

        public RelNode convert(RelNode rel) {
            LogicalProject project = (LogicalProject)rel;
            RelTraitSet traitSet = project.getTraitSet().replace((RelTrait)PigRel.CONVENTION);
            return new PigProject(project.getCluster(), traitSet, project.getInput(), project.getProjects(), project.getRowType());
        }

        static /* synthetic */ PigProjectRule access$200() {
            return INSTANCE;
        }
    }

    private static class PigTableScanRule
    extends ConverterRule {
        private static final PigTableScanRule INSTANCE = (PigTableScanRule)((ConverterRule.Config)ConverterRule.Config.INSTANCE.withConversion(LogicalTableScan.class, (RelTrait)Convention.NONE, (RelTrait)PigRel.CONVENTION, "PigTableScanRule").withRuleFactory(PigTableScanRule::new).as(ConverterRule.Config.class)).toRule(PigTableScanRule.class);

        protected PigTableScanRule(ConverterRule.Config config) {
            super(config);
        }

        public RelNode convert(RelNode rel) {
            LogicalTableScan scan = (LogicalTableScan)rel;
            RelTraitSet traitSet = scan.getTraitSet().replace((RelTrait)PigRel.CONVENTION);
            return new PigTableScan(rel.getCluster(), traitSet, scan.getTable());
        }

        static /* synthetic */ PigTableScanRule access$100() {
            return INSTANCE;
        }
    }

    private static class PigFilterRule
    extends ConverterRule {
        private static final PigFilterRule INSTANCE = (PigFilterRule)ConverterRule.Config.INSTANCE.withConversion(LogicalFilter.class, (RelTrait)Convention.NONE, (RelTrait)PigRel.CONVENTION, "PigFilterRule").withRuleFactory(PigFilterRule::new).toRule(PigFilterRule.class);

        protected PigFilterRule(ConverterRule.Config config) {
            super(config);
        }

        public RelNode convert(RelNode rel) {
            LogicalFilter filter = (LogicalFilter)rel;
            RelTraitSet traitSet = filter.getTraitSet().replace((RelTrait)PigRel.CONVENTION);
            return new PigFilter(rel.getCluster(), traitSet, PigFilterRule.convert((RelNode)filter.getInput(), (RelTrait)PigRel.CONVENTION), filter.getCondition());
        }

        static /* synthetic */ PigFilterRule access$000() {
            return INSTANCE;
        }
    }
}

