/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.mongodb;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.mongodb.MongoRel;
import org.apache.calcite.adapter.mongodb.MongoRules;
import org.apache.calcite.adapter.mongodb.MongoTable;
import org.apache.calcite.adapter.mongodb.MongoToEnumerableConverterRule;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.checkerframework.checker.nullness.qual.Nullable;

public class MongoTableScan
extends TableScan
implements MongoRel {
    final MongoTable mongoTable;
    final @Nullable RelDataType projectRowType;

    protected MongoTableScan(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, MongoTable mongoTable, @Nullable RelDataType projectRowType) {
        super(cluster, traitSet, (List)ImmutableList.of(), table);
        this.mongoTable = Objects.requireNonNull(mongoTable, "mongoTable");
        this.projectRowType = projectRowType;
        Preconditions.checkArgument((this.getConvention() == MongoRel.CONVENTION ? 1 : 0) != 0);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return this;
    }

    public RelDataType deriveRowType() {
        return this.projectRowType != null ? this.projectRowType : super.deriveRowType();
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        float f = this.projectRowType == null ? 1.0f : (float)this.projectRowType.getFieldCount() / 100.0f;
        RelOptCost cost = Objects.requireNonNull(super.computeSelfCost(planner, mq));
        return cost.multiplyBy(0.1 * (double)f);
    }

    public void register(RelOptPlanner planner) {
        planner.addRule((RelOptRule)MongoToEnumerableConverterRule.INSTANCE);
        for (RelOptRule rule : MongoRules.RULES) {
            planner.addRule(rule);
        }
    }

    @Override
    public void implement(MongoRel.Implementor implementor) {
        implementor.mongoTable = this.mongoTable;
        implementor.table = this.table;
    }
}

