/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.mongodb;

import com.mongodb.client.MongoCursor;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.Primitive;
import org.bson.BsonTimestamp;
import org.bson.Document;
import org.bson.types.Binary;
import org.bson.types.Decimal128;
import org.checkerframework.checker.nullness.qual.Nullable;

class MongoEnumerator
implements Enumerator<Object> {
    private final Iterator<Document> cursor;
    private final Function1<Document, Object> getter;
    private @Nullable Object current;

    MongoEnumerator(Iterator<Document> cursor, Function1<Document, Object> getter) {
        this.cursor = cursor;
        this.getter = getter;
    }

    public Object current() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        return this.current;
    }

    public boolean moveNext() {
        try {
            if (this.cursor.hasNext()) {
                Document map = this.cursor.next();
                this.current = this.getter.apply((Object)map);
                return true;
            }
            this.current = null;
            return false;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void close() {
        if (this.cursor instanceof MongoCursor) {
            ((MongoCursor)this.cursor).close();
        }
    }

    static Function1<Document, Map> mapGetter() {
        return a0 -> a0;
    }

    static Function1<Document, Object> singletonGetter(String fieldName, Class fieldClass) {
        return a0 -> MongoEnumerator.convert(fieldName, a0.get((Object)fieldName), fieldClass);
    }

    static Function1<Document, Object[]> listGetter(List<Map.Entry<String, Class>> fields) {
        return a0 -> {
            Object[] objects = new Object[fields.size()];
            for (int i = 0; i < fields.size(); ++i) {
                Map.Entry field = (Map.Entry)fields.get(i);
                String name = (String)field.getKey();
                objects[i] = MongoEnumerator.convert(name, a0.get((Object)name), (Class)field.getValue());
            }
            return objects;
        };
    }

    static Function1<Document, Object> getter(List<Map.Entry<String, Class>> fields) {
        return fields == null ? MongoEnumerator.mapGetter() : (fields.size() == 1 ? MongoEnumerator.singletonGetter(fields.get(0).getKey(), fields.get(0).getValue()) : MongoEnumerator.listGetter(fields));
    }

    private static Object convert(String fieldName, Object o, Class clazz) {
        if (o == null) {
            return null;
        }
        Primitive primitive = Primitive.of((Type)clazz);
        if (primitive != null) {
            clazz = primitive.boxClass;
        } else {
            primitive = Primitive.ofBox((Type)clazz);
        }
        if (clazz.isInstance(o)) {
            return o;
        }
        if (clazz == Long.class) {
            if (o instanceof Date) {
                return ((Date)o).getTime();
            }
            if (o instanceof BsonTimestamp) {
                return (long)((BsonTimestamp)o).getTime() * 1000L;
            }
        } else if (clazz == BigDecimal.class) {
            if (o instanceof Decimal128) {
                return new BigDecimal(((Decimal128)o).toString());
            }
        } else {
            if (clazz == String.class) {
                if (o.getClass().isArray()) {
                    return Primitive.OTHER.arrayToString(o);
                }
                return String.valueOf(o);
            }
            if (clazz == ByteString.class && o instanceof Binary) {
                return new ByteString(((Binary)o).getData());
            }
        }
        if (primitive != null) {
            if (o instanceof String) {
                return primitive.parse((String)o);
            }
            if (o instanceof Number) {
                return primitive.number((Number)o);
            }
            if (o instanceof Date) {
                return primitive.number((Number)(((Date)o).getTime() / 86400000L));
            }
        }
        throw new IllegalArgumentException(String.format(Locale.ROOT, "Invalid field: '%s'. The dataType '%s' is invalid for '%s'.", fieldName, clazz.getSimpleName(), o));
    }
}

