/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.kafka;

import com.google.common.collect.ImmutableList;
import java.util.Collections;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.kafka.KafkaMessageEnumerator;
import org.apache.calcite.adapter.kafka.KafkaTableOptions;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.StreamableTable;
import org.apache.calcite.schema.Table;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlNode;
import org.apache.kafka.clients.consumer.Consumer;
import org.apache.kafka.clients.consumer.KafkaConsumer;
import org.checkerframework.checker.nullness.qual.Nullable;

public class KafkaStreamTable
implements ScannableTable,
StreamableTable {
    final KafkaTableOptions tableOptions;

    KafkaStreamTable(KafkaTableOptions tableOptions) {
        this.tableOptions = tableOptions;
    }

    public Enumerable<@Nullable Object[]> scan(DataContext root) {
        final AtomicBoolean cancelFlag = (AtomicBoolean)DataContext.Variable.CANCEL_FLAG.get(root);
        return new AbstractEnumerable<Object[]>(){

            public Enumerator<@Nullable Object[]> enumerator() {
                if (KafkaStreamTable.this.tableOptions.getConsumer() != null) {
                    return new KafkaMessageEnumerator(KafkaStreamTable.this.tableOptions.getConsumer(), KafkaStreamTable.this.tableOptions.getRowConverter(), cancelFlag);
                }
                Properties consumerConfig = new Properties();
                consumerConfig.put("bootstrap.servers", KafkaStreamTable.this.tableOptions.getBootstrapServers());
                consumerConfig.put("value.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
                consumerConfig.put("key.deserializer", "org.apache.kafka.common.serialization.ByteArrayDeserializer");
                if (KafkaStreamTable.this.tableOptions.getConsumerParams() != null) {
                    consumerConfig.putAll(KafkaStreamTable.this.tableOptions.getConsumerParams());
                }
                KafkaConsumer consumer = new KafkaConsumer(consumerConfig);
                consumer.subscribe(Collections.singletonList(KafkaStreamTable.this.tableOptions.getTopicName()));
                return new KafkaMessageEnumerator((Consumer)consumer, KafkaStreamTable.this.tableOptions.getRowConverter(), cancelFlag);
            }
        };
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return this.tableOptions.getRowConverter().rowDataType(this.tableOptions.getTopicName());
    }

    public Statistic getStatistic() {
        return Statistics.of((double)100.0, (List)ImmutableList.of(), (List)RelCollations.createSingleton((int)0));
    }

    public boolean isRolledUp(String column) {
        return false;
    }

    public boolean rolledUpColumnValidInsideAgg(String column, SqlCall call, @Nullable SqlNode parent, @Nullable CalciteConnectionConfig config) {
        return false;
    }

    public Table stream() {
        return this;
    }

    public Schema.TableType getJdbcTableType() {
        return Schema.TableType.STREAM;
    }
}

