/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.innodb;

import com.alibaba.innodb.java.reader.TableReaderFactory;
import com.alibaba.innodb.java.reader.schema.Column;
import com.alibaba.innodb.java.reader.schema.TableDef;
import com.alibaba.innodb.java.reader.schema.provider.impl.SqlFileTableDefProvider;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.innodb.ColumnTypeToSqlTypeConversionRules;
import org.apache.calcite.adapter.innodb.InnodbTable;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.commons.lang3.StringUtils;

public class InnodbSchema
extends AbstractSchema {
    final List<String> sqlFilePathList;
    final String ibdDataFileBasePath;
    final TableReaderFactory tableReaderFactory;
    static final ColumnTypeToSqlTypeConversionRules COLUMN_TYPE_TO_SQL_TYPE = ColumnTypeToSqlTypeConversionRules.instance();

    public InnodbSchema(List<String> sqlFilePathList, String ibdDataFileBasePath) {
        Preconditions.checkArgument((sqlFilePathList != null && !sqlFilePathList.isEmpty() ? 1 : 0) != 0, (Object)"SQL file path list cannot be empty");
        Preconditions.checkArgument((boolean)StringUtils.isNotEmpty((CharSequence)ibdDataFileBasePath), (Object)"InnoDB data file with ibd suffix cannot be empty");
        this.sqlFilePathList = sqlFilePathList;
        this.ibdDataFileBasePath = ibdDataFileBasePath;
        List tableDefProviderList = sqlFilePathList.stream().map(SqlFileTableDefProvider::new).collect(Collectors.toList());
        this.tableReaderFactory = TableReaderFactory.builder().withProviders(tableDefProviderList).withDataFileBasePath(ibdDataFileBasePath).build();
    }

    RelProtoDataType getRelDataType(String tableName) {
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataTypeFactory.FieldInfoBuilder fieldInfo = typeFactory.builder();
        if (!this.tableReaderFactory.existTableDef(tableName)) {
            throw new RuntimeException("Table definition " + tableName + " not found");
        }
        TableDef tableDef = this.tableReaderFactory.getTableDef(tableName);
        for (Column column : tableDef.getColumnList()) {
            int scale;
            int precision;
            SqlTypeName sqlTypeName = COLUMN_TYPE_TO_SQL_TYPE.lookup(column.getType());
            switch (column.getType()) {
                case "TIMESTAMP": 
                case "TIME": 
                case "DATETIME": {
                    precision = column.getPrecision();
                    scale = 0;
                    break;
                }
                default: {
                    precision = column.getPrecision();
                    scale = column.getScale();
                }
            }
            if (sqlTypeName.allowsPrecScale(true, true) && column.getPrecision() >= 0 && column.getScale() >= 0) {
                fieldInfo.add(column.getName(), sqlTypeName, precision, scale);
            } else if (sqlTypeName.allowsPrecNoScale() && precision >= 0) {
                fieldInfo.add(column.getName(), sqlTypeName, precision);
            } else {
                assert (sqlTypeName.allowsNoPrecNoScale());
                fieldInfo.add(column.getName(), sqlTypeName);
            }
            fieldInfo.nullable(column.isNullable());
        }
        return RelDataTypeImpl.proto((RelDataType)fieldInfo.build());
    }

    public TableDef getTableDef(String tableName) {
        if (!this.tableReaderFactory.existTableDef(tableName)) {
            throw new RuntimeException("cannot find table definition for " + tableName);
        }
        return this.tableReaderFactory.getTableDef(tableName);
    }

    protected Map<String, Table> getTableMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        Map map = this.tableReaderFactory.getTableNameToDefMap();
        for (Map.Entry entry : map.entrySet()) {
            String tableName = (String)entry.getKey();
            builder.put((Object)tableName, (Object)new InnodbTable(this, tableName));
        }
        return builder.build();
    }
}

