/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.innodb;

import java.util.LinkedHashMap;
import java.util.Map;
import org.apache.calcite.adapter.innodb.IndexCondition;
import org.apache.calcite.adapter.innodb.InnodbTable;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.rel.RelNode;

public interface InnodbRel
extends RelNode {
    public static final Convention CONVENTION = new Convention.Impl("INNODB", InnodbRel.class);

    public void implement(Implementor var1);

    public static class Implementor {
        final Map<String, String> selectFields = new LinkedHashMap<String, String>();
        IndexCondition indexCondition = IndexCondition.EMPTY_CONDITION;
        boolean ascOrder = true;
        RelOptTable table;
        InnodbTable innodbTable;

        public void addSelectFields(Map<String, String> fields) {
            if (fields != null) {
                this.selectFields.putAll(fields);
            }
        }

        public void setIndexCondition(IndexCondition indexCondition) {
            this.indexCondition = indexCondition;
        }

        public void setAscOrder(boolean ascOrder) {
            this.ascOrder = ascOrder;
        }

        public void visitChild(int ordinal, RelNode input) {
            assert (ordinal == 0);
            ((InnodbRel)input).implement(this);
        }
    }
}

