/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.innodb;

import com.alibaba.innodb.java.reader.comparator.ComparisonOperator;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.AbstractList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.innodb.IndexCondition;
import org.apache.calcite.adapter.innodb.InnodbMethod;
import org.apache.calcite.adapter.innodb.InnodbRel;
import org.apache.calcite.adapter.innodb.InnodbTable;
import org.apache.calcite.adapter.innodb.QueryType;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.ConstantExpression;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Node;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.PairList;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class InnodbToEnumerableConverter
extends ConverterImpl
implements EnumerableRel {
    protected InnodbToEnumerableConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, traits, input);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new InnodbToEnumerableConverter(this.getCluster(), traitSet, (RelNode)InnodbToEnumerableConverter.sole(inputs));
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        return Objects.requireNonNull(super.computeSelfCost(planner, mq));
    }

    static List<String> innodbFieldNames(RelDataType rowType) {
        return SqlValidatorUtil.uniquify((List)rowType.getFieldNames(), (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER, (boolean)true);
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder list = new BlockBuilder();
        InnodbRel.Implementor innodbImplementor = new InnodbRel.Implementor();
        innodbImplementor.visitChild(0, this.getInput());
        final RelDataType rowType = this.getRowType();
        final PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)rowType, (JavaRowFormat)pref.prefer(JavaRowFormat.ARRAY));
        Expression fields = list.append("fields", InnodbToEnumerableConverter.constantArrayList(Pair.zip(InnodbToEnumerableConverter.innodbFieldNames(rowType), (List)new AbstractList<Class>(){

            @Override
            public Class get(int index) {
                return physType.fieldClass(index);
            }

            @Override
            public int size() {
                return rowType.getFieldCount();
            }
        }), Pair.class));
        PairList selectList = PairList.of(innodbImplementor.selectFields);
        Expression selectFields = list.append("selectFields", InnodbToEnumerableConverter.constantArrayList(selectList, Pair.class));
        Expression table = list.append("table", Objects.requireNonNull(innodbImplementor.table.getExpression(InnodbTable.InnodbQueryable.class)));
        IndexCondition condition = innodbImplementor.indexCondition;
        Expression indexName = list.append("indexName", (Expression)Expressions.constant((Object)condition.getIndexName(), String.class));
        Expression queryType = list.append("queryType", (Expression)Expressions.constant((Object)((Object)condition.getQueryType()), QueryType.class));
        Expression pointQueryKey = list.append("pointQueryKey", InnodbToEnumerableConverter.constantArrayList(condition.getPointQueryKey(), Object.class));
        Expression rangeQueryLowerOp = list.append("rangeQueryLowerOp", (Expression)Expressions.constant((Object)condition.getRangeQueryLowerOp(), ComparisonOperator.class));
        Expression rangeQueryLowerKey = list.append("rangeQueryLowerKey", InnodbToEnumerableConverter.constantArrayList(condition.getRangeQueryLowerKey(), Object.class));
        Expression rangeQueryUpperOp = list.append("rangeQueryUpperOp", (Expression)Expressions.constant((Object)condition.getRangeQueryUpperOp(), ComparisonOperator.class));
        Expression rangeQueryUpperKey = list.append("rangeQueryUpperKey", InnodbToEnumerableConverter.constantArrayList(condition.getRangeQueryUpperKey(), Object.class));
        Expression cond = list.append("condition", (Expression)Expressions.call(IndexCondition.class, (String)"create", (Expression[])new Expression[]{indexName, queryType, pointQueryKey, rangeQueryLowerOp, rangeQueryUpperOp, rangeQueryLowerKey, rangeQueryUpperKey}));
        ConstantExpression ascOrder = Expressions.constant((Object)innodbImplementor.ascOrder);
        Expression enumerable = list.append("enumerable", (Expression)Expressions.call((Expression)table, (Method)InnodbMethod.INNODB_QUERYABLE_QUERY.method, (Expression[])new Expression[]{fields, selectFields, cond, ascOrder}));
        if (((Boolean)CalciteSystemProperty.DEBUG.value()).booleanValue()) {
            System.out.println("Innodb: " + Expressions.toString((Node)enumerable));
        }
        list.add((Statement)Expressions.return_(null, (Expression)enumerable));
        return implementor.result(physType, list.toBlock());
    }

    private static <T> Expression constantArrayList(List<T> values, Class clazz) {
        if (values instanceof PairList && !values.isEmpty() && Map.Entry.class.isAssignableFrom(clazz)) {
            List keyValues = ((PairList)values).stream().flatMap(p -> Stream.of(p.getKey(), p.getValue())).collect(Collectors.toList());
            return Expressions.call(null, (Method)BuiltInMethod.PAIR_LIST_COPY_OF.method, InnodbToEnumerableConverter.constantList(keyValues));
        }
        return Expressions.call((Method)BuiltInMethod.ARRAYS_AS_LIST.method, (Expression[])new Expression[]{Expressions.newArrayInit((Type)clazz, InnodbToEnumerableConverter.constantList(values))});
    }

    private static <T> List<Expression> constantList(List<T> values) {
        if (values.isEmpty()) {
            return Collections.emptyList();
        }
        return Util.transform(values, Expressions::constant);
    }
}

