/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.geode.util;

import java.lang.reflect.Field;
import java.lang.reflect.Type;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.calcite.adapter.geode.util.JavaTypeFactoryExtImpl;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.util.Util;
import org.apache.commons.lang3.Strings;
import org.apache.geode.cache.CacheClosedException;
import org.apache.geode.cache.GemFireCache;
import org.apache.geode.cache.Region;
import org.apache.geode.cache.RegionExistsException;
import org.apache.geode.cache.client.ClientCache;
import org.apache.geode.cache.client.ClientCacheFactory;
import org.apache.geode.cache.client.ClientRegionShortcut;
import org.apache.geode.cache.query.Struct;
import org.apache.geode.pdx.PdxInstance;
import org.apache.geode.pdx.PdxSerializer;
import org.apache.geode.pdx.ReflectionBasedAutoSerializer;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeodeUtils {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)GeodeUtils.class.getName());
    private static final Map<String, Region> REGION_MAP = new ConcurrentHashMap<String, Region>();
    private static String currentLocatorHost = "";
    private static int currentLocatorPort = -1;
    private static final JavaTypeFactoryExtImpl JAVA_TYPE_FACTORY = new JavaTypeFactoryExtImpl();

    private GeodeUtils() {
    }

    public static synchronized ClientCache createClientCache(String locatorHost, int locatorPort, String autoSerializerPackagePath, boolean readSerialized) {
        if (locatorPort != currentLocatorPort || !Strings.CI.equals(currentLocatorHost, locatorHost)) {
            LOGGER.info("Close existing ClientCache [" + currentLocatorHost + ":" + currentLocatorPort + "] for new Locator connection at: [" + locatorHost + ":" + locatorPort + "]");
            currentLocatorHost = locatorHost;
            currentLocatorPort = locatorPort;
            GeodeUtils.closeClientCache();
        }
        try {
            return ClientCacheFactory.getAnyInstance();
        }
        catch (CacheClosedException cacheClosedException) {
            return new ClientCacheFactory().addPoolLocator(locatorHost, locatorPort).setPdxSerializer((PdxSerializer)new ReflectionBasedAutoSerializer(new String[]{autoSerializerPackagePath})).setPdxReadSerialized(readSerialized).create();
        }
    }

    public static synchronized void closeClientCache() {
        try {
            ClientCacheFactory.getAnyInstance().close();
        }
        catch (CacheClosedException cacheClosedException) {
            // empty catch block
        }
        REGION_MAP.clear();
    }

    public static synchronized Region createRegion(GemFireCache cache, String regionName) {
        Objects.requireNonNull(cache, "cache");
        Objects.requireNonNull(regionName, "regionName");
        Region region = REGION_MAP.get(regionName);
        if (region == null) {
            try {
                region = ((ClientCache)cache).createClientRegionFactory(ClientRegionShortcut.PROXY).create(regionName);
            }
            catch (IllegalStateException | RegionExistsException e) {
                region = cache.getRegion(regionName);
            }
            REGION_MAP.put(regionName, region);
        }
        return region;
    }

    public static @Nullable Object convertToRowValues(List<RelDataTypeField> relDataTypeFields, Object geodeResultObject) {
        Object values = geodeResultObject instanceof Struct ? GeodeUtils.handleStructEntry(relDataTypeFields, geodeResultObject) : (geodeResultObject instanceof PdxInstance ? GeodeUtils.handlePdxInstanceEntry(relDataTypeFields, geodeResultObject) : GeodeUtils.handleJavaObjectEntry(relDataTypeFields, geodeResultObject));
        return values;
    }

    private static Object handleStructEntry(List<RelDataTypeField> relDataTypeFields, Object obj) {
        Struct struct = (Struct)obj;
        Object[] values = new Object[relDataTypeFields.size()];
        int index = 0;
        for (RelDataTypeField relDataTypeField : relDataTypeFields) {
            Object rawValue;
            Type javaType = JAVA_TYPE_FACTORY.getJavaClass(relDataTypeField.getType());
            try {
                rawValue = struct.get(relDataTypeField.getName());
            }
            catch (IllegalArgumentException e) {
                rawValue = "<error>";
                System.err.println("Could find field : " + relDataTypeField.getName());
                e.printStackTrace();
            }
            values[index++] = GeodeUtils.convert(rawValue, (Class)javaType);
        }
        if (values.length == 1) {
            return values[0];
        }
        return values;
    }

    private static Object handlePdxInstanceEntry(List<RelDataTypeField> relDataTypeFields, Object obj) {
        PdxInstance pdxEntry = (PdxInstance)obj;
        Object[] values = new Object[relDataTypeFields.size()];
        int index = 0;
        for (RelDataTypeField relDataTypeField : relDataTypeFields) {
            Type javaType = JAVA_TYPE_FACTORY.getJavaClass(relDataTypeField.getType());
            Object rawValue = pdxEntry.getField(relDataTypeField.getName());
            values[index++] = GeodeUtils.convert(rawValue, (Class)javaType);
        }
        if (values.length == 1) {
            return values[0];
        }
        return values;
    }

    private static @Nullable Object handleJavaObjectEntry(List<RelDataTypeField> relDataTypeFields, Object obj) {
        Class<?> clazz = obj.getClass();
        if (relDataTypeFields.size() == 1) {
            try {
                Field javaField = clazz.getDeclaredField(relDataTypeFields.get(0).getName());
                javaField.setAccessible(true);
                return javaField.get(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
        }
        Object[] values = new Object[relDataTypeFields.size()];
        int index = 0;
        for (RelDataTypeField relDataTypeField : relDataTypeFields) {
            try {
                Field javaField = clazz.getDeclaredField(relDataTypeField.getName());
                javaField.setAccessible(true);
                values[index++] = javaField.get(obj);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        return values;
    }

    private static Object convert(Object o, Class clazz) {
        if (o == null) {
            return null;
        }
        Primitive primitive = Primitive.of((Type)clazz);
        if (primitive != null) {
            clazz = primitive.boxClass;
        } else {
            primitive = Primitive.ofBox((Type)clazz);
        }
        if (clazz == null) {
            return o.toString();
        }
        if (Map.class.isAssignableFrom(clazz) && o instanceof PdxInstance) {
            return Util.toString((Iterable)((PdxInstance)o).getFieldNames(), (String)"PDX[", (String)",", (String)"]");
        }
        if (clazz.isInstance(o)) {
            return o;
        }
        if (o instanceof Date && primitive != null) {
            o = ((Date)o).getTime() / 86400000L;
        }
        if (o instanceof Number && primitive != null) {
            return primitive.number((Number)o);
        }
        return o;
    }

    public static RelDataType autodetectRelTypeFromRegion(Region<?, ?> region) {
        Objects.requireNonNull(region, "region");
        Class constraint = region.getAttributes().getValueConstraint();
        if (constraint != null && !PdxInstance.class.isAssignableFrom(constraint)) {
            return new JavaTypeFactoryExtImpl().createStructType(constraint);
        }
        Iterator iter = region.getAttributes().getPoolName() == null ? region.keySet().iterator() : region.keySetOnServer().iterator();
        if (!iter.hasNext()) {
            String message = String.format(Locale.ROOT, "Region %s is empty, can't autodetect type(s)", region.getName());
            throw new IllegalStateException(message);
        }
        Object entry = region.get(iter.next());
        return GeodeUtils.createRelDataType(entry);
    }

    private static RelDataType createRelDataType(Object regionEntry) {
        JavaTypeFactoryExtImpl typeFactory = new JavaTypeFactoryExtImpl();
        if (regionEntry instanceof PdxInstance) {
            return typeFactory.createPdxType((PdxInstance)regionEntry);
        }
        return typeFactory.createStructType(regionEntry.getClass());
    }
}

