/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.geode.rel;

import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.calcite.adapter.geode.util.GeodeUtils;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.geode.cache.query.SelectResults;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class GeodeEnumerator
implements Enumerator<Object> {
    protected static final Logger LOGGER = LoggerFactory.getLogger((String)GeodeEnumerator.class.getName());
    private final Iterator iterator;
    private @Nullable Object current;
    private final List<RelDataTypeField> fieldTypes;

    GeodeEnumerator(SelectResults results, RelProtoDataType protoRowType) {
        if (results == null) {
            LOGGER.warn("Null OQL results!");
        }
        this.iterator = results == null ? Collections.emptyIterator() : results.iterator();
        this.current = null;
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        this.fieldTypes = ((RelDataType)protoRowType.apply((Object)typeFactory)).getFieldList();
    }

    public @Nullable Object current() {
        if (this.current == null) {
            throw new IllegalStateException();
        }
        return GeodeUtils.convertToRowValues(this.fieldTypes, this.current);
    }

    public boolean moveNext() {
        if (this.iterator.hasNext()) {
            this.current = this.iterator.next();
            return true;
        }
        return false;
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }
}

