/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.geode.rel;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.calcite.adapter.geode.rel.GeodeAggregate;
import org.apache.calcite.adapter.geode.rel.GeodeFilter;
import org.apache.calcite.adapter.geode.rel.GeodeProject;
import org.apache.calcite.adapter.geode.rel.GeodeRel;
import org.apache.calcite.adapter.geode.rel.GeodeSort;
import org.apache.calcite.adapter.geode.rel.GeodeTableScan;
import org.apache.calcite.adapter.geode.rel.ImmutableGeodeFilterRuleConfig;
import org.apache.calcite.adapter.geode.rel.ImmutableGeodeSortLimitRuleConfig;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalAggregate;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Value;

public class GeodeRules {
    static final RelOptRule[] RULES = new RelOptRule[]{GeodeSortLimitRule.access$000(), GeodeFilterRule.access$100(), GeodeProjectRule.access$200(), GeodeAggregateRule.access$300()};

    private GeodeRules() {
    }

    static @Nullable String isItem(RexCall call) {
        if (call.getOperator() != SqlStdOperatorTable.ITEM) {
            return null;
        }
        RexNode op0 = (RexNode)call.getOperands().get(0);
        RexNode op1 = (RexNode)call.getOperands().get(1);
        if (op0 instanceof RexInputRef && ((RexInputRef)op0).getIndex() == 0 && op1 instanceof RexLiteral && ((RexLiteral)op1).getValue2() instanceof String) {
            return (String)((RexLiteral)op1).getValue2();
        }
        return null;
    }

    static List<String> geodeFieldNames(RelDataType rowType) {
        return SqlValidatorUtil.uniquify((List)rowType.getFieldNames(), (boolean)true);
    }

    static abstract class GeodeConverterRule
    extends ConverterRule {
        protected GeodeConverterRule(ConverterRule.Config config) {
            super(config);
        }
    }

    public static class GeodeFilterRule
    extends RelRule<GeodeFilterRuleConfig> {
        private static final GeodeFilterRule INSTANCE = ImmutableGeodeFilterRuleConfig.builder().withOperandSupplier(b0 -> b0.operand(LogicalFilter.class).oneInput(b1 -> b1.operand(GeodeTableScan.class).noInputs())).build().toRule();

        protected GeodeFilterRule(GeodeFilterRuleConfig config) {
            super((RelRule.Config)config);
        }

        public boolean matches(RelOptRuleCall call) {
            LogicalFilter filter = (LogicalFilter)call.rel(0);
            RexNode condition = filter.getCondition();
            List<String> fieldNames = GeodeRules.geodeFieldNames(filter.getInput().getRowType());
            List disjunctions = RelOptUtil.disjunctions((RexNode)condition);
            if (disjunctions.size() != 1) {
                return true;
            }
            condition = (RexNode)disjunctions.get(0);
            for (RexNode predicate : RelOptUtil.conjunctions((RexNode)condition)) {
                if (GeodeFilterRule.isEqualityOnKey(predicate, fieldNames)) continue;
                return false;
            }
            return true;
        }

        private static boolean isEqualityOnKey(RexNode node, List<String> fieldNames) {
            RexNode right;
            if (GeodeFilterRule.isBooleanColumnReference(node, fieldNames)) {
                return true;
            }
            if (!SqlKind.COMPARISON.contains(node.getKind()) && node.getKind() != SqlKind.SEARCH) {
                return false;
            }
            RexCall call = (RexCall)node;
            RexNode left = (RexNode)call.operands.get(0);
            if (GeodeFilterRule.checkConditionContainsInputRefOrLiterals(left, right = (RexNode)call.operands.get(1), fieldNames)) {
                return true;
            }
            return GeodeFilterRule.checkConditionContainsInputRefOrLiterals(right, left, fieldNames);
        }

        private static boolean isBooleanColumnReference(RexNode node, List<String> fieldNames) {
            while (node.isA((Collection)ImmutableList.of((Object)SqlKind.NOT, (Object)SqlKind.CAST, (Object)SqlKind.IS_NOT_NULL))) {
                node = (RexNode)((RexCall)node).getOperands().get(0);
            }
            if (node.isA(SqlKind.INPUT_REF) && node.getType().getSqlTypeName() == SqlTypeName.BOOLEAN) {
                RexInputRef left1 = (RexInputRef)node;
                String name = fieldNames.get(left1.getIndex());
                return name != null;
            }
            return false;
        }

        private static boolean checkConditionContainsInputRefOrLiterals(RexNode left, RexNode right, List<String> fieldNames) {
            if (left.isA(SqlKind.CAST)) {
                left = (RexNode)((RexCall)left).getOperands().get(0);
            }
            if (right.isA(SqlKind.CAST)) {
                right = (RexNode)((RexCall)right).getOperands().get(0);
            }
            if (left.isA(SqlKind.INPUT_REF) && right.isA(SqlKind.LITERAL)) {
                RexInputRef left1 = (RexInputRef)left;
                String name = fieldNames.get(left1.getIndex());
                return name != null;
            }
            if (left.isA(SqlKind.INPUT_REF) && right.isA(SqlKind.INPUT_REF)) {
                RexInputRef left1 = (RexInputRef)left;
                String leftName = fieldNames.get(left1.getIndex());
                RexInputRef right1 = (RexInputRef)right;
                String rightName = fieldNames.get(right1.getIndex());
                return leftName != null && rightName != null;
            }
            return left.isA(SqlKind.ITEM) && right.isA(SqlKind.LITERAL);
        }

        public void onMatch(RelOptRuleCall call) {
            LogicalFilter filter = (LogicalFilter)call.rel(0);
            if (filter.getTraitSet().contains((RelTrait)Convention.NONE)) {
                RelNode converted = GeodeFilterRule.convert(filter);
                call.transformTo(converted);
            }
        }

        private static RelNode convert(LogicalFilter filter) {
            RelTraitSet traitSet = filter.getTraitSet().replace((RelTrait)GeodeRel.CONVENTION);
            return new GeodeFilter(filter.getCluster(), traitSet, GeodeFilterRule.convert((RelNode)filter.getInput(), (RelTrait)GeodeRel.CONVENTION), filter.getCondition());
        }

        static /* synthetic */ GeodeFilterRule access$100() {
            return INSTANCE;
        }

        @Value.Immutable(singleton=false)
        public static interface GeodeFilterRuleConfig
        extends RelRule.Config {
            default public GeodeFilterRule toRule() {
                return new GeodeFilterRule(this);
            }
        }
    }

    public static class GeodeSortLimitRule
    extends RelRule<GeodeSortLimitRuleConfig> {
        private static final GeodeSortLimitRule INSTANCE = ImmutableGeodeSortLimitRuleConfig.builder().withOperandSupplier(b -> b.operand(Sort.class).predicate(sort -> sort.offset == null).anyInputs()).build().toRule();

        protected GeodeSortLimitRule(GeodeSortLimitRuleConfig config) {
            super((RelRule.Config)config);
        }

        public void onMatch(RelOptRuleCall call) {
            Sort sort = (Sort)call.rel(0);
            RelTraitSet traitSet = sort.getTraitSet().replace((RelTrait)GeodeRel.CONVENTION).replace((RelTrait)sort.getCollation());
            GeodeSort geodeSort = new GeodeSort(sort.getCluster(), traitSet, GeodeSortLimitRule.convert((RelOptPlanner)call.getPlanner(), (RelNode)sort.getInput(), (RelTraitSet)traitSet.replace((RelTrait)RelCollations.EMPTY)), sort.getCollation(), sort.fetch);
            call.transformTo((RelNode)geodeSort);
        }

        static /* synthetic */ GeodeSortLimitRule access$000() {
            return INSTANCE;
        }

        @Value.Immutable(singleton=false)
        public static interface GeodeSortLimitRuleConfig
        extends RelRule.Config {
            default public GeodeSortLimitRule toRule() {
                return new GeodeSortLimitRule(this);
            }
        }
    }

    private static class GeodeAggregateRule
    extends GeodeConverterRule {
        private static final GeodeAggregateRule INSTANCE = (GeodeAggregateRule)ConverterRule.Config.INSTANCE.withConversion(LogicalAggregate.class, (RelTrait)Convention.NONE, (RelTrait)GeodeRel.CONVENTION, "GeodeAggregateRule").withRuleFactory(GeodeAggregateRule::new).toRule(GeodeAggregateRule.class);

        protected GeodeAggregateRule(ConverterRule.Config config) {
            super(config);
        }

        public RelNode convert(RelNode rel) {
            LogicalAggregate aggregate = (LogicalAggregate)rel;
            RelTraitSet traitSet = aggregate.getTraitSet().replace((RelTrait)this.getOutConvention());
            return new GeodeAggregate(aggregate.getCluster(), traitSet, GeodeAggregateRule.convert((RelNode)aggregate.getInput(), (RelTraitSet)traitSet.simplify()), aggregate.getGroupSet(), (List<ImmutableBitSet>)aggregate.getGroupSets(), aggregate.getAggCallList());
        }

        static /* synthetic */ GeodeAggregateRule access$300() {
            return INSTANCE;
        }
    }

    private static class GeodeProjectRule
    extends GeodeConverterRule {
        private static final GeodeProjectRule INSTANCE = (GeodeProjectRule)ConverterRule.Config.INSTANCE.withConversion(LogicalProject.class, (RelTrait)Convention.NONE, (RelTrait)GeodeRel.CONVENTION, "GeodeProjectRule").withRuleFactory(GeodeProjectRule::new).toRule(GeodeProjectRule.class);

        protected GeodeProjectRule(ConverterRule.Config config) {
            super(config);
        }

        public boolean matches(RelOptRuleCall call) {
            LogicalProject project = (LogicalProject)call.rel(0);
            for (RexNode e : project.getProjects()) {
                if (e.getType().getSqlTypeName() != SqlTypeName.GEOMETRY) continue;
                return false;
            }
            return project.getVariablesSet().isEmpty();
        }

        public RelNode convert(RelNode rel) {
            LogicalProject project = (LogicalProject)rel;
            Preconditions.checkArgument((boolean)project.getVariablesSet().isEmpty(), (Object)"GeodeProject does now allow variables");
            RelTraitSet traitSet = project.getTraitSet().replace((RelTrait)this.getOutConvention());
            return new GeodeProject(project.getCluster(), traitSet, GeodeProjectRule.convert((RelNode)project.getInput(), (RelTrait)this.getOutConvention()), project.getProjects(), project.getRowType());
        }

        static /* synthetic */ GeodeProjectRule access$200() {
            return INSTANCE;
        }
    }

    static class RexToGeodeTranslator
    extends RexVisitorImpl<String> {
        private final List<String> inFields;

        protected RexToGeodeTranslator(List<String> inFields) {
            super(true);
            this.inFields = inFields;
        }

        public String visitInputRef(RexInputRef inputRef) {
            return this.inFields.get(inputRef.getIndex());
        }

        public String visitCall(RexCall call) {
            RexNode op1;
            ArrayList strings = new ArrayList();
            this.visitList((Iterable)call.operands, strings);
            if (call.getOperator() == SqlStdOperatorTable.ITEM && (op1 = (RexNode)call.getOperands().get(1)) instanceof RexLiteral) {
                if (op1.getType().getSqlTypeName() == SqlTypeName.INTEGER) {
                    return RexToGeodeTranslator.stripQuotes((String)strings.get(0)) + "[" + ((RexLiteral)op1).getValue2() + "]";
                }
                if (op1.getType().getSqlTypeName() == SqlTypeName.CHAR) {
                    return RexToGeodeTranslator.stripQuotes((String)strings.get(0)) + "." + ((RexLiteral)op1).getValue2();
                }
            }
            return (String)super.visitCall(call);
        }

        private static String stripQuotes(String s) {
            return s.startsWith("'") && s.endsWith("'") ? s.substring(1, s.length() - 1) : s;
        }
    }
}

