/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.geode.rel;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.calcite.adapter.geode.rel.GeodeRel;
import org.apache.calcite.adapter.geode.rel.GeodeRules;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexBuilder;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexUtil;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.DateString;
import org.apache.calcite.util.TimeString;
import org.apache.calcite.util.TimestampString;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class GeodeFilter
extends Filter
implements GeodeRel {
    private final String match;

    GeodeFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexNode condition) {
        super(cluster, traitSet, input, condition);
        Translator translator = new Translator(this.getRowType(), this.getCluster().getRexBuilder());
        this.match = translator.translateMatch(condition);
        assert (this.getConvention() == GeodeRel.CONVENTION);
        assert (this.getConvention() == input.getConvention());
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost cost = Objects.requireNonNull(super.computeSelfCost(planner, mq));
        return cost.multiplyBy(0.1);
    }

    public GeodeFilter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        return new GeodeFilter(this.getCluster(), traitSet, input, condition);
    }

    @Override
    public void implement(GeodeRel.GeodeImplementContext geodeImplementContext) {
        geodeImplementContext.visitChild(this.getInput());
        geodeImplementContext.addPredicates(Collections.singletonList(this.match));
    }

    static class Translator {
        private final List<String> fieldNames;
        private final RexBuilder rexBuilder;

        Translator(RelDataType rowType, RexBuilder rexBuilder) {
            Objects.requireNonNull(rowType, "rowType");
            this.rexBuilder = Objects.requireNonNull(rexBuilder, "rexBuilder");
            this.fieldNames = GeodeRules.geodeFieldNames(rowType);
        }

        private static String literalValue(RexLiteral literal) {
            Comparable valueComparable = (Comparable)literal.getValueAs(Comparable.class);
            switch (literal.getTypeName()) {
                case TIMESTAMP: 
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: {
                    assert (valueComparable instanceof TimestampString);
                    return "TIMESTAMP '" + valueComparable + "'";
                }
                case DATE: {
                    assert (valueComparable instanceof DateString);
                    return "DATE '" + valueComparable + "'";
                }
                case TIME: 
                case TIME_WITH_LOCAL_TIME_ZONE: {
                    assert (valueComparable instanceof TimeString);
                    return "TIME '" + valueComparable + "'";
                }
            }
            return String.valueOf(literal.getValue3());
        }

        private String translateMatch(RexNode condition) {
            RexNode condition2 = RexUtil.expandSearch((RexBuilder)this.rexBuilder, null, (RexNode)condition);
            List disjunctions = RelOptUtil.disjunctions((RexNode)condition2);
            if (disjunctions.size() == 1) {
                return this.translateAnd((RexNode)disjunctions.get(0));
            }
            return this.translateOr(disjunctions);
        }

        private String translateAnd(RexNode condition) {
            ArrayList<String> predicates = new ArrayList<String>();
            for (RexNode node : RelOptUtil.conjunctions((RexNode)condition)) {
                predicates.add(this.translateMatch2(node));
            }
            return Util.toString(predicates, (String)"", (String)" AND ", (String)"");
        }

        private @Nullable String getLeftNodeFieldName(RexNode left) {
            switch (left.getKind()) {
                case INPUT_REF: {
                    RexInputRef left1 = (RexInputRef)left;
                    return this.fieldNames.get(left1.getIndex());
                }
                case CAST: {
                    return this.getLeftNodeFieldName((RexNode)((RexCall)left).operands.get(0));
                }
                case ITEM: 
                case OTHER_FUNCTION: {
                    return (String)left.accept((RexVisitor)new GeodeRules.RexToGeodeTranslator(this.fieldNames));
                }
            }
            return null;
        }

        private boolean useInSetQueryClause(List<RexNode> disjunctions) {
            if (disjunctions.size() <= 1) {
                return false;
            }
            return disjunctions.stream().allMatch(node -> {
                if (node.getKind() != SqlKind.EQUALS) {
                    return false;
                }
                RexCall call = (RexCall)node;
                RexNode left = (RexNode)call.operands.get(0);
                RexNode right = (RexNode)call.operands.get(1);
                if (right.getKind() != SqlKind.LITERAL) {
                    return false;
                }
                String name = this.getLeftNodeFieldName(left);
                return name != null;
            });
        }

        private String translateInSet(List<RexNode> disjunctions) {
            Preconditions.checkArgument((!disjunctions.isEmpty() ? 1 : 0) != 0, (Object)"empty disjunctions");
            RexNode firstNode = disjunctions.get(0);
            RexCall firstCall = (RexCall)firstNode;
            RexNode left = (RexNode)firstCall.operands.get(0);
            String name = this.getLeftNodeFieldName(left);
            LinkedHashSet rightLiteralValueList = new LinkedHashSet();
            disjunctions.forEach(node -> {
                RexCall call = (RexCall)node;
                RexLiteral rightLiteral = (RexLiteral)call.operands.get(1);
                rightLiteralValueList.add(Translator.quoteCharLiteral(rightLiteral));
            });
            return String.format(Locale.ROOT, "%s IN SET(%s)", name, String.join((CharSequence)", ", rightLiteralValueList));
        }

        private @Nullable String getLeftNodeFieldNameForNode(RexNode node) {
            RexCall call = (RexCall)node;
            RexNode left = (RexNode)call.operands.get(0);
            return this.getLeftNodeFieldName(left);
        }

        private List<RexNode> getLeftNodeDisjunctions(RexNode node, List<RexNode> disjunctions) {
            List<Object> leftNodeDisjunctions = new ArrayList<RexNode>();
            String leftNodeFieldName = this.getLeftNodeFieldNameForNode(node);
            if (leftNodeFieldName != null) {
                leftNodeDisjunctions = disjunctions.stream().filter(rexNode -> {
                    RexCall rexCall = (RexCall)rexNode;
                    RexNode rexCallLeft = (RexNode)rexCall.operands.get(0);
                    return leftNodeFieldName.equals(this.getLeftNodeFieldName(rexCallLeft));
                }).collect(Collectors.toList());
            }
            return leftNodeDisjunctions;
        }

        private String translateOr(List<RexNode> disjunctions) {
            ArrayList<String> predicates = new ArrayList<String>();
            ArrayList<String> leftFieldNameList = new ArrayList<String>();
            ArrayList<String> inSetLeftFieldNameList = new ArrayList<String>();
            for (RexNode node : disjunctions) {
                String leftNodeFieldName = this.getLeftNodeFieldNameForNode(node);
                if (inSetLeftFieldNameList.contains(leftNodeFieldName)) continue;
                ArrayList<RexNode> leftNodeDisjunctions = new ArrayList();
                boolean useInSetQueryClause = false;
                if (!leftFieldNameList.contains(leftNodeFieldName)) {
                    leftNodeDisjunctions = this.getLeftNodeDisjunctions(node, disjunctions);
                    useInSetQueryClause = this.useInSetQueryClause(leftNodeDisjunctions);
                }
                if (useInSetQueryClause) {
                    predicates.add(this.translateInSet(leftNodeDisjunctions));
                    inSetLeftFieldNameList.add(leftNodeFieldName);
                } else if (RelOptUtil.conjunctions((RexNode)node).size() > 1) {
                    predicates.add("(" + this.translateMatch(node) + ")");
                } else {
                    predicates.add(this.translateMatch2(node));
                }
                leftFieldNameList.add(leftNodeFieldName);
            }
            return Util.toString(predicates, (String)"", (String)" OR ", (String)"");
        }

        private String translateMatch2(RexNode node) {
            switch (node.getKind()) {
                case EQUALS: {
                    return this.translateBinary("=", "=", (RexCall)node);
                }
                case LESS_THAN: {
                    return this.translateBinary("<", ">", (RexCall)node);
                }
                case LESS_THAN_OR_EQUAL: {
                    return this.translateBinary("<=", ">=", (RexCall)node);
                }
                case GREATER_THAN: {
                    return this.translateBinary(">", "<", (RexCall)node);
                }
                case GREATER_THAN_OR_EQUAL: {
                    return this.translateBinary(">=", "<=", (RexCall)node);
                }
                case INPUT_REF: {
                    return this.translateBinary2("=", node, (RexNode)this.rexBuilder.makeLiteral(true));
                }
                case IS_NOT_NULL: {
                    RexNode child = (RexNode)((RexCall)node).getOperands().get(0);
                    return this.translateBinary2("<>", child, (RexNode)this.rexBuilder.makeNullLiteral(node.getType()));
                }
                case NOT: {
                    RexNode child = (RexNode)((RexCall)node).getOperands().get(0);
                    if (child.getKind() == SqlKind.CAST) {
                        child = (RexNode)((RexCall)child).getOperands().get(0);
                    }
                    if (child.getKind() != SqlKind.INPUT_REF) break;
                    return this.translateBinary2("=", child, (RexNode)this.rexBuilder.makeLiteral(false));
                }
                case CAST: {
                    return this.translateMatch2((RexNode)((RexCall)node).getOperands().get(0));
                }
            }
            throw new AssertionError((Object)("Cannot translate " + node + ", kind=" + node.getKind()));
        }

        private String translateBinary(String op, String rop, RexCall call) {
            RexNode right;
            RexNode left = (RexNode)call.operands.get(0);
            String expression = this.translateBinary2Opt(op, left, right = (RexNode)call.operands.get(1));
            if (expression != null) {
                return expression;
            }
            expression = this.translateBinary2Opt(rop, right, left);
            if (expression != null) {
                return expression;
            }
            throw new AssertionError((Object)("cannot translate op " + op + " call " + call));
        }

        private String translateBinary2(String op, RexNode left, RexNode right) {
            String s = this.translateBinary2Opt(op, left, right);
            return Objects.requireNonNull(s, "s");
        }

        private @Nullable String translateBinary2Opt(String op, RexNode left, RexNode right) {
            switch (right.getKind()) {
                case LITERAL: {
                    break;
                }
                default: {
                    return null;
                }
            }
            RexLiteral rightLiteral = (RexLiteral)right;
            switch (left.getKind()) {
                case INPUT_REF: {
                    RexInputRef left1 = (RexInputRef)left;
                    String name = this.fieldNames.get(left1.getIndex());
                    return Translator.translateOp2(op, name, rightLiteral);
                }
                case CAST: {
                    return this.translateBinary2(op, (RexNode)((RexCall)left).operands.get(0), right);
                }
                case ITEM: {
                    String item = (String)left.accept((RexVisitor)new GeodeRules.RexToGeodeTranslator(this.fieldNames));
                    return item == null ? null : item + " " + op + " " + Translator.quoteCharLiteral(rightLiteral);
                }
            }
            return null;
        }

        private static String quoteCharLiteral(RexLiteral literal) {
            String value = Translator.literalValue(literal);
            if (literal.getTypeName() == SqlTypeName.CHAR) {
                value = "'" + value + "'";
            }
            return value;
        }

        private static String translateOp2(String op, String name, RexLiteral right) {
            String valueString = Translator.quoteCharLiteral(right);
            return name + " " + op + " " + valueString;
        }
    }
}

