/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import java.util.Objects;
import org.apache.calcite.sql.type.SqlTypeName;

public enum DruidType {
    LONG(SqlTypeName.BIGINT),
    FLOAT(SqlTypeName.REAL),
    DOUBLE(SqlTypeName.DOUBLE),
    STRING(SqlTypeName.VARCHAR),
    COMPLEX(SqlTypeName.OTHER),
    HYPER_UNIQUE(SqlTypeName.VARBINARY),
    THETA_SKETCH(SqlTypeName.VARBINARY);

    public final SqlTypeName sqlType;

    private DruidType(SqlTypeName sqlType) {
        this.sqlType = sqlType;
    }

    public boolean isComplex() {
        return this == THETA_SKETCH || this == HYPER_UNIQUE || this == COMPLEX;
    }

    static DruidType getTypeFromMetric(String type) {
        Objects.requireNonNull(type, "type");
        if (type.equals("hyperUnique")) {
            return HYPER_UNIQUE;
        }
        if (type.equals("thetaSketch")) {
            return THETA_SKETCH;
        }
        if (type.startsWith("long") || type.equals("count")) {
            return LONG;
        }
        if (type.startsWith("double")) {
            return DOUBLE;
        }
        if (type.startsWith("float")) {
            return FLOAT;
        }
        throw new AssertionError((Object)("Unknown type: " + type));
    }

    static DruidType getTypeFromMetaData(String type) {
        Objects.requireNonNull(type, "type");
        switch (type) {
            case "LONG": {
                return LONG;
            }
            case "FLOAT": {
                return FLOAT;
            }
            case "DOUBLE": {
                return DOUBLE;
            }
            case "STRING": {
                return STRING;
            }
        }
        return DruidType.getTypeFromMetric(type);
    }
}

