/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.TimeZone;
import java.util.regex.Pattern;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.druid.BinaryOperatorConversion;
import org.apache.calcite.adapter.druid.CeilOperatorConversion;
import org.apache.calcite.adapter.druid.ComplexMetric;
import org.apache.calcite.adapter.druid.DefaultDimensionSpec;
import org.apache.calcite.adapter.druid.DimensionSpec;
import org.apache.calcite.adapter.druid.DirectOperatorConversion;
import org.apache.calcite.adapter.druid.DruidConnectionImpl;
import org.apache.calcite.adapter.druid.DruidDateTimeUtils;
import org.apache.calcite.adapter.druid.DruidExpressions;
import org.apache.calcite.adapter.druid.DruidJson;
import org.apache.calcite.adapter.druid.DruidJsonFilter;
import org.apache.calcite.adapter.druid.DruidRules;
import org.apache.calcite.adapter.druid.DruidSqlCastConverter;
import org.apache.calcite.adapter.druid.DruidSqlOperatorConverter;
import org.apache.calcite.adapter.druid.DruidTable;
import org.apache.calcite.adapter.druid.ExtractOperatorConversion;
import org.apache.calcite.adapter.druid.ExtractionDimensionSpec;
import org.apache.calcite.adapter.druid.ExtractionFunction;
import org.apache.calcite.adapter.druid.FloorOperatorConversion;
import org.apache.calcite.adapter.druid.Granularities;
import org.apache.calcite.adapter.druid.Granularity;
import org.apache.calcite.adapter.druid.NaryOperatorConverter;
import org.apache.calcite.adapter.druid.QueryType;
import org.apache.calcite.adapter.druid.SubstringOperatorConversion;
import org.apache.calcite.adapter.druid.TimeExtractionFunction;
import org.apache.calcite.adapter.druid.UnaryPrefixOperatorConversion;
import org.apache.calcite.adapter.druid.UnarySuffixOperatorConversion;
import org.apache.calcite.adapter.druid.VirtualColumn;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.config.CalciteConnectionConfig;
import org.apache.calcite.interpreter.BindableRel;
import org.apache.calcite.interpreter.Bindables;
import org.apache.calcite.interpreter.Compiler;
import org.apache.calcite.interpreter.InterpretableRel;
import org.apache.calcite.interpreter.Node;
import org.apache.calcite.interpreter.Sink;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.AbstractRelNode;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.RelWriter;
import org.apache.calcite.rel.core.Aggregate;
import org.apache.calcite.rel.core.AggregateCall;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.core.TableScan;
import org.apache.calcite.rel.metadata.RelMdUtil;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeFamily;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.apache.calcite.util.ImmutableBitSet;
import org.apache.calcite.util.Litmus;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.joda.time.Interval;

public class DruidQuery
extends AbstractRelNode
implements BindableRel {
    public static final List<DruidSqlOperatorConverter> DEFAULT_OPERATORS_LIST = ImmutableList.builder().add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.EXP, "exp")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.CONCAT, "concat")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.DIVIDE_INTEGER, "div")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.LIKE, "like")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.LN, "log")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.SQRT, "sqrt")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.LOWER, "lower")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.LOG10, "log10")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.REPLACE, "replace")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.UPPER, "upper")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.POWER, "pow")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.ABS, "abs")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.SIN, "sin")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.COS, "cos")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.TAN, "tan")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.COT, "cot")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.ASIN, "asin")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.ACOS, "acos")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.ATAN, "atan")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.ATAN2, "atan2")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.CASE, "case_searched")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.CHAR_LENGTH, "strlen")).add((Object)new DirectOperatorConversion((SqlOperator)SqlStdOperatorTable.CHARACTER_LENGTH, "strlen")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.EQUALS, "==")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.NOT_EQUALS, "!=")).add((Object)new NaryOperatorConverter((SqlOperator)SqlStdOperatorTable.OR, "||")).add((Object)new NaryOperatorConverter((SqlOperator)SqlStdOperatorTable.AND, "&&")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.LESS_THAN, "<")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.LESS_THAN_OR_EQUAL, "<=")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.GREATER_THAN, ">")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.GREATER_THAN_OR_EQUAL, ">=")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.PLUS, "+")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.MINUS, "-")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.MULTIPLY, "*")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.DIVIDE, "/")).add((Object)new BinaryOperatorConversion((SqlOperator)SqlStdOperatorTable.MOD, "%")).add((Object)new DruidSqlCastConverter()).add((Object)new ExtractOperatorConversion()).add((Object)new UnaryPrefixOperatorConversion((SqlOperator)SqlStdOperatorTable.NOT, "!")).add((Object)new UnaryPrefixOperatorConversion((SqlOperator)SqlStdOperatorTable.UNARY_MINUS, "-")).add((Object)new UnarySuffixOperatorConversion((SqlOperator)SqlStdOperatorTable.IS_FALSE, "<= 0")).add((Object)new UnarySuffixOperatorConversion((SqlOperator)SqlStdOperatorTable.IS_NOT_TRUE, "<= 0")).add((Object)new UnarySuffixOperatorConversion((SqlOperator)SqlStdOperatorTable.IS_TRUE, "> 0")).add((Object)new UnarySuffixOperatorConversion((SqlOperator)SqlStdOperatorTable.IS_NOT_FALSE, "> 0")).add((Object)new UnarySuffixOperatorConversion((SqlOperator)SqlStdOperatorTable.IS_NULL, "== null")).add((Object)new UnarySuffixOperatorConversion((SqlOperator)SqlStdOperatorTable.IS_NOT_NULL, "!= null")).add((Object)new FloorOperatorConversion()).add((Object)new CeilOperatorConversion()).add((Object)new SubstringOperatorConversion()).build();
    protected @Nullable QuerySpec querySpec;
    final RelOptTable table;
    final DruidTable druidTable;
    final ImmutableList<Interval> intervals;
    final ImmutableList<RelNode> rels;
    final Map<SqlOperator, DruidSqlOperatorConverter> converterOperatorMap;
    private static final Pattern VALID_SIG = Pattern.compile("sf?p?(a?|ah|ah?o)l?");
    private static final String EXTRACT_COLUMN_NAME_PREFIX = "extract";
    private static final String FLOOR_COLUMN_NAME_PREFIX = "floor";
    protected static final String DRUID_QUERY_FETCH = "druid.query.fetch";
    private static final int DAYS_IN_TEN_YEARS = 3650;

    protected DruidQuery(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, DruidTable druidTable, List<Interval> intervals, List<RelNode> rels, Map<SqlOperator, DruidSqlOperatorConverter> converterOperatorMap) {
        super(cluster, traitSet);
        this.table = table;
        this.druidTable = druidTable;
        this.intervals = ImmutableList.copyOf(intervals);
        this.rels = ImmutableList.copyOf(rels);
        this.converterOperatorMap = Objects.requireNonNull(converterOperatorMap, "Operator map cannot be null");
        assert (this.isValid(Litmus.THROW, null));
    }

    static boolean isValidSignature(String signature) {
        return VALID_SIG.matcher(signature).matches();
    }

    public static DruidQuery create(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, DruidTable druidTable, List<RelNode> rels) {
        ImmutableMap.Builder mapBuilder = ImmutableMap.builder();
        for (DruidSqlOperatorConverter converter : DEFAULT_OPERATORS_LIST) {
            mapBuilder.put((Object)converter.calciteOperator(), (Object)converter);
        }
        return DruidQuery.create(cluster, traitSet, table, druidTable, druidTable.intervals, rels, (Map<SqlOperator, DruidSqlOperatorConverter>)mapBuilder.build());
    }

    public static DruidQuery create(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, DruidTable druidTable, List<RelNode> rels, Map<SqlOperator, DruidSqlOperatorConverter> converterOperatorMap) {
        return DruidQuery.create(cluster, traitSet, table, druidTable, druidTable.intervals, rels, converterOperatorMap);
    }

    private static DruidQuery create(RelOptCluster cluster, RelTraitSet traitSet, RelOptTable table, DruidTable druidTable, List<Interval> intervals, List<RelNode> rels, Map<SqlOperator, DruidSqlOperatorConverter> converterOperatorMap) {
        return new DruidQuery(cluster, traitSet, table, druidTable, intervals, rels, converterOperatorMap);
    }

    public static DruidQuery extendQuery(DruidQuery query, RelNode r) {
        ImmutableList.Builder builder = ImmutableList.builder();
        return DruidQuery.create(query.getCluster(), r.getTraitSet().replace((RelTrait)query.getConvention()), query.getTable(), query.druidTable, query.intervals, (List<RelNode>)builder.addAll(query.rels).add((Object)r).build(), query.getOperatorConversionMap());
    }

    public static DruidQuery extendQuery(DruidQuery query, List<Interval> intervals) {
        return DruidQuery.create(query.getCluster(), query.getTraitSet(), query.getTable(), query.druidTable, intervals, query.rels, query.getOperatorConversionMap());
    }

    private static boolean needUtcTimeExtract(RexNode rexNode) {
        return rexNode.getType().getSqlTypeName() == SqlTypeName.DATE || rexNode.getType().getSqlTypeName() == SqlTypeName.TIMESTAMP || rexNode.getType().getSqlTypeName() == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE;
    }

    protected static Pair<String, ExtractionFunction> toDruidColumn(RexNode rexNode, RelDataType rowType, DruidQuery druidQuery) {
        TimeExtractionFunction extractionFunction;
        String columnName;
        switch (rexNode.getKind()) {
            case INPUT_REF: {
                columnName = DruidQuery.extractColumnName(rexNode, rowType, druidQuery);
                if (DruidQuery.needUtcTimeExtract(rexNode)) {
                    extractionFunction = TimeExtractionFunction.createDefault(DateTimeUtils.UTC_ZONE.getID());
                    break;
                }
                extractionFunction = null;
                break;
            }
            case EXTRACT: {
                Granularity granularity = DruidDateTimeUtils.extractGranularity(rexNode, druidQuery.getConnectionConfig().timeZone());
                if (granularity == null) {
                    return Pair.of(null, null);
                }
                if (!TimeExtractionFunction.isValidTimeExtract(rexNode)) {
                    return Pair.of(null, null);
                }
                RexNode extractValueNode = (RexNode)((RexCall)rexNode).getOperands().get(1);
                if (extractValueNode.getType().getSqlTypeName() == SqlTypeName.DATE || extractValueNode.getType().getSqlTypeName() == SqlTypeName.TIMESTAMP) {
                    extractionFunction = TimeExtractionFunction.createExtractFromGranularity(granularity, DateTimeUtils.UTC_ZONE.getID());
                    columnName = DruidQuery.extractColumnName(extractValueNode, rowType, druidQuery);
                    break;
                }
                if (extractValueNode.getType().getSqlTypeName() == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE) {
                    extractionFunction = TimeExtractionFunction.createExtractFromGranularity(granularity, druidQuery.getConnectionConfig().timeZone());
                    columnName = DruidQuery.extractColumnName(extractValueNode, rowType, druidQuery);
                    break;
                }
                return Pair.of(null, null);
            }
            case FLOOR: {
                Granularity granularity = DruidDateTimeUtils.extractGranularity(rexNode, druidQuery.getConnectionConfig().timeZone());
                if (granularity == null) {
                    return Pair.of(null, null);
                }
                if (!TimeExtractionFunction.isValidTimeFloor(rexNode)) {
                    return Pair.of(null, null);
                }
                RexNode floorValueNode = (RexNode)((RexCall)rexNode).getOperands().get(0);
                if (DruidQuery.needUtcTimeExtract(floorValueNode)) {
                    extractionFunction = TimeExtractionFunction.createFloorFromGranularity(granularity, DateTimeUtils.UTC_ZONE.getID());
                    columnName = DruidQuery.extractColumnName(floorValueNode, rowType, druidQuery);
                    break;
                }
                return Pair.of(null, null);
            }
            case CAST: {
                if (!DruidQuery.isValidLeafCast(rexNode)) {
                    return Pair.of(null, null);
                }
                RexNode operand0 = (RexNode)((RexCall)rexNode).getOperands().get(0);
                columnName = DruidQuery.extractColumnName(operand0, rowType, druidQuery);
                if (DruidQuery.needUtcTimeExtract(rexNode)) {
                    extractionFunction = TimeExtractionFunction.translateCastToTimeExtract(rexNode, TimeZone.getTimeZone(druidQuery.getConnectionConfig().timeZone()));
                    if (extractionFunction != null) break;
                    return Pair.of(null, null);
                }
                extractionFunction = null;
                break;
            }
            default: {
                return Pair.of(null, null);
            }
        }
        return Pair.of((Object)columnName, (Object)extractionFunction);
    }

    private static boolean isValidLeafCast(RexNode rexNode) {
        assert (rexNode.isA(SqlKind.CAST));
        RexNode input = (RexNode)((RexCall)rexNode).getOperands().get(0);
        if (!input.isA(SqlKind.INPUT_REF)) {
            return false;
        }
        SqlTypeName toTypeName = rexNode.getType().getSqlTypeName();
        if (toTypeName.getFamily() == SqlTypeFamily.CHARACTER) {
            return true;
        }
        if (toTypeName.getFamily() == SqlTypeFamily.NUMERIC) {
            return true;
        }
        if (toTypeName.getFamily() == SqlTypeFamily.TIMESTAMP || toTypeName.getFamily() == SqlTypeFamily.DATETIME) {
            return true;
        }
        return toTypeName.getFamily().contains(input.getType());
    }

    protected static @Nullable String extractColumnName(RexNode rexNode, RelDataType rowType, DruidQuery query) {
        if (rexNode.getKind() == SqlKind.INPUT_REF) {
            RexInputRef ref = (RexInputRef)rexNode;
            String columnName = (String)rowType.getFieldNames().get(ref.getIndex());
            if (columnName == null) {
                return null;
            }
            if (query.getDruidTable().timestampFieldName.equals(columnName)) {
                return "__time";
            }
            return columnName;
        }
        return null;
    }

    public static String format(String message, Object ... formatArgs) {
        return String.format(Locale.ENGLISH, message, formatArgs);
    }

    String signature() {
        StringBuilder b = new StringBuilder();
        boolean flag = false;
        for (RelNode rel : this.rels) {
            b.append((char)(rel instanceof TableScan ? 115 : (rel instanceof Project && flag ? 111 : (rel instanceof Filter && flag ? 104 : (rel instanceof Aggregate ? 97 : (rel instanceof Filter ? 102 : (rel instanceof Sort ? 108 : (rel instanceof Project ? 112 : 33))))))));
            flag = flag || rel instanceof Aggregate;
        }
        return b.toString();
    }

    public boolean isValid(Litmus litmus, RelNode.Context context) {
        if (!super.isValid(litmus, context)) {
            return false;
        }
        String signature = this.signature();
        if (!DruidQuery.isValidSignature(signature)) {
            return litmus.fail("invalid signature [{}]", new Object[]{signature});
        }
        if (this.rels.isEmpty()) {
            return litmus.fail("must have at least one rel", new Object[0]);
        }
        for (int i = 0; i < this.rels.size(); ++i) {
            Filter filter;
            DruidJsonFilter druidJsonFilter;
            Aggregate aggregate;
            RelNode r = (RelNode)this.rels.get(i);
            if (i == 0) {
                if (!(r instanceof TableScan)) {
                    return litmus.fail("first rel must be TableScan, was ", new Object[]{r});
                }
                if (r.getTable() == this.table) continue;
                return litmus.fail("first rel must be based on table table", new Object[0]);
            }
            List inputs = r.getInputs();
            if (inputs.size() != 1 || inputs.get(0) != this.rels.get(i - 1)) {
                return litmus.fail("each rel must have a single input", new Object[0]);
            }
            if (r instanceof Aggregate && (aggregate = (Aggregate)r).getGroupSets().size() != 1) {
                return litmus.fail("no grouping sets", new Object[0]);
            }
            if (r instanceof Filter && (druidJsonFilter = DruidJsonFilter.toDruidFilters((filter = (Filter)r).getCondition(), filter.getInput().getRowType(), this, this.getCluster().getRexBuilder())) == null) {
                return litmus.fail("invalid filter [{}]", new Object[]{filter.getCondition()});
            }
            if (!(r instanceof Sort)) continue;
            Sort sort = (Sort)r;
            if (sort.offset == null || RexLiteral.intValue((RexNode)sort.offset) == 0) continue;
            return litmus.fail("offset not supported", new Object[0]);
        }
        return true;
    }

    protected Map<SqlOperator, DruidSqlOperatorConverter> getOperatorConversionMap() {
        return this.converterOperatorMap;
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        assert (inputs.isEmpty());
        return this;
    }

    public RelDataType deriveRowType() {
        return this.getCluster().getTypeFactory().createStructType(Pair.right((List)((RelNode)Util.last(this.rels)).getRowType().getFieldList()), this.getQuerySpec().fieldNames);
    }

    public TableScan getTableScan() {
        return (TableScan)this.rels.get(0);
    }

    public RelNode getTopNode() {
        return (RelNode)Util.last(this.rels);
    }

    public RelOptTable getTable() {
        return this.table;
    }

    public DruidTable getDruidTable() {
        return this.druidTable;
    }

    public RelWriter explainTerms(RelWriter pw) {
        for (RelNode rel : this.rels) {
            if (rel instanceof TableScan) {
                TableScan tableScan = (TableScan)rel;
                pw.item("table", (Object)tableScan.getTable().getQualifiedName());
                pw.item("intervals", this.intervals);
                continue;
            }
            if (rel instanceof Filter) {
                pw.item("filter", (Object)((Filter)rel).getCondition());
                continue;
            }
            if (rel instanceof Project) {
                if (((Project)rel).getInput() instanceof Aggregate) {
                    pw.item("post_projects", (Object)((Project)rel).getProjects());
                    continue;
                }
                pw.item("projects", (Object)((Project)rel).getProjects());
                continue;
            }
            if (rel instanceof Aggregate) {
                Aggregate aggregate = (Aggregate)rel;
                pw.item("groups", (Object)aggregate.getGroupSet()).item("aggs", (Object)aggregate.getAggCallList());
                continue;
            }
            if (rel instanceof Sort) {
                Sort sort = (Sort)rel;
                for (Ord ord : Ord.zip((List)sort.collation.getFieldCollations())) {
                    pw.item("sort" + ord.i, (Object)((RelFieldCollation)ord.e).getFieldIndex());
                }
                for (Ord ord : Ord.zip((List)sort.collation.getFieldCollations())) {
                    if (!pw.expand()) {
                        pw.item("dir" + ord.i, (Object)((RelFieldCollation)ord.e).shortString());
                        continue;
                    }
                    pw.item("dir" + ord.i, (Object)((RelFieldCollation)ord.e).fullString());
                }
                pw.itemIf("fetch", (Object)sort.fetch, sort.fetch != null);
                continue;
            }
            throw new AssertionError((Object)("rel type not supported in Druid query " + rel));
        }
        return pw;
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost cost = Objects.requireNonNull(((RelNode)Util.last(this.rels)).computeSelfCost(planner, mq));
        return cost.multiplyBy(RelMdUtil.linear((int)this.querySpec.fieldNames.size(), (int)2, (int)100, (double)1.0, (double)2.0)).multiplyBy(this.getQueryTypeCostMultiplier()).multiplyBy(this.rels.size() > 1 && this.rels.get(1) instanceof Filter ? 0.5 : 1.0).multiplyBy(Util.last(this.rels) instanceof Sort ? 0.1 : 1.0).multiplyBy(this.getIntervalCostMultiplier());
    }

    private double getIntervalCostMultiplier() {
        long days = 0L;
        for (Interval interval : this.intervals) {
            days += interval.toDuration().getStandardDays();
        }
        return RelMdUtil.linear((int)((int)days), (int)1, (int)3650, (double)0.1, (double)1.0);
    }

    private double getQueryTypeCostMultiplier() {
        switch (this.querySpec.queryType) {
            case SELECT: {
                return 0.1;
            }
            case GROUP_BY: {
                return 0.08;
            }
            case TIMESERIES: {
                return 0.06;
            }
            case TOP_N: {
                return 0.04;
            }
        }
        return 0.2;
    }

    public void register(RelOptPlanner planner) {
        for (RelOptRule rule : DruidRules.RULES) {
            planner.addRule(rule);
        }
        for (RelOptRule rule : Bindables.RULES) {
            planner.addRule(rule);
        }
    }

    public Class<Object[]> getElementType() {
        return Object[].class;
    }

    public Enumerable<@Nullable Object[]> bind(DataContext dataContext) {
        return ((ScannableTable)this.table.unwrapOrThrow(ScannableTable.class)).scan(dataContext);
    }

    public Node implement(InterpretableRel.InterpreterImplementor implementor) {
        return new DruidQueryNode(implementor.compiler, this);
    }

    public QuerySpec getQuerySpec() {
        if (this.querySpec == null) {
            this.querySpec = (QuerySpec)Preconditions.checkNotNull((Object)this.deriveQuerySpec(), (String)"null querySpec for %s", (Object)((Object)this));
        }
        return this.querySpec;
    }

    protected QuerySpec deriveQuerySpec() {
        RelDataType rowType = this.table.getRowType();
        int i = 1;
        Filter filterRel = null;
        if (i < this.rels.size() && this.rels.get(i) instanceof Filter) {
            filterRel = (Filter)this.rels.get(i++);
        }
        Project project = null;
        if (i < this.rels.size() && this.rels.get(i) instanceof Project) {
            project = (Project)this.rels.get(i++);
        }
        ImmutableBitSet groupSet = null;
        List aggCalls = null;
        List aggNames = null;
        if (i < this.rels.size() && this.rels.get(i) instanceof Aggregate) {
            Aggregate aggregate = (Aggregate)this.rels.get(i++);
            groupSet = aggregate.getGroupSet();
            aggCalls = aggregate.getAggCallList();
            aggNames = Util.skip((List)aggregate.getRowType().getFieldNames(), (int)groupSet.cardinality());
        }
        Filter havingFilter = null;
        if (i < this.rels.size() && this.rels.get(i) instanceof Filter) {
            havingFilter = (Filter)this.rels.get(i++);
        }
        Project postProject = null;
        if (i < this.rels.size() && this.rels.get(i) instanceof Project) {
            postProject = (Project)this.rels.get(i++);
        }
        ArrayList<Integer> collationIndexes = null;
        ArrayList<RelFieldCollation.Direction> collationDirections = null;
        ImmutableBitSet.Builder numericCollationBitSetBuilder = ImmutableBitSet.builder();
        Integer fetch = null;
        if (i < this.rels.size() && this.rels.get(i) instanceof Sort) {
            Sort sort = (Sort)this.rels.get(i++);
            collationIndexes = new ArrayList<Integer>();
            collationDirections = new ArrayList<RelFieldCollation.Direction>();
            for (RelFieldCollation fCol : sort.collation.getFieldCollations()) {
                collationIndexes.add(fCol.getFieldIndex());
                collationDirections.add(fCol.getDirection());
                if (((RelDataTypeField)sort.getRowType().getFieldList().get(fCol.getFieldIndex())).getType().getFamily() != SqlTypeFamily.NUMERIC) continue;
                numericCollationBitSetBuilder.set(fCol.getFieldIndex());
            }
            Integer n = fetch = sort.fetch != null ? Integer.valueOf(RexLiteral.intValue((RexNode)sort.fetch)) : null;
        }
        if (i != this.rels.size()) {
            throw new AssertionError((Object)"could not implement all rels");
        }
        return this.getQuery(rowType, filterRel, project, groupSet, aggCalls, aggNames, collationIndexes, collationDirections, numericCollationBitSetBuilder.build(), fetch, postProject, havingFilter);
    }

    public QueryType getQueryType() {
        return this.getQuerySpec().queryType;
    }

    public String getQueryString() {
        return this.getQuerySpec().queryString;
    }

    protected CalciteConnectionConfig getConnectionConfig() {
        return (CalciteConnectionConfig)this.getCluster().getPlanner().getContext().unwrapOrThrow(CalciteConnectionConfig.class);
    }

    private @Nullable DruidJsonFilter computeFilter(@Nullable Filter filterRel) {
        if (filterRel == null) {
            return null;
        }
        RexNode filter = filterRel.getCondition();
        RelDataType inputRowType = filterRel.getInput().getRowType();
        if (filter != null) {
            return DruidJsonFilter.toDruidFilters(filter, inputRowType, this, this.getCluster().getRexBuilder());
        }
        return null;
    }

    protected static @Nullable Pair<List<String>, List<VirtualColumn>> computeProjectAsScan(@Nullable Project projectRel, RelDataType inputRowType, DruidQuery druidQuery) {
        if (projectRel == null) {
            return null;
        }
        HashSet<Object> usedFieldNames = new HashSet<Object>();
        ImmutableList.Builder virtualColumnsBuilder = ImmutableList.builder();
        ImmutableList.Builder projectedColumnsBuilder = ImmutableList.builder();
        List projects = projectRel.getProjects();
        for (RexNode project : projects) {
            boolean needExtractForOperand;
            Pair<String, ExtractionFunction> druidColumn = DruidQuery.toDruidColumn(project, inputRowType, druidQuery);
            boolean bl = needExtractForOperand = project instanceof RexCall && ((RexCall)project).getOperands().stream().anyMatch(DruidQuery::needUtcTimeExtract);
            if (druidColumn.left == null || druidColumn.right != null || needExtractForOperand) {
                String expression = DruidExpressions.toDruidExpression(project, inputRowType, druidQuery);
                if (expression == null) {
                    return null;
                }
                String virColName = SqlValidatorUtil.uniquify((String)"vc", usedFieldNames, (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER);
                virtualColumnsBuilder.add((Object)VirtualColumn.builder().withName(virColName).withExpression(expression).withType(DruidExpressions.EXPRESSION_TYPES.get(project.getType().getSqlTypeName())).build());
                usedFieldNames.add(virColName);
                projectedColumnsBuilder.add((Object)virColName);
                continue;
            }
            if (usedFieldNames.contains(druidColumn.left)) {
                String virColName = SqlValidatorUtil.uniquify((String)"vc", usedFieldNames, (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER);
                virtualColumnsBuilder.add((Object)VirtualColumn.builder().withName(virColName).withExpression(DruidExpressions.fromColumn((String)druidColumn.left)).withType(DruidExpressions.EXPRESSION_TYPES.get(project.getType().getSqlTypeName())).build());
                usedFieldNames.add(virColName);
                projectedColumnsBuilder.add((Object)virColName);
                continue;
            }
            projectedColumnsBuilder.add(druidColumn.left);
            usedFieldNames.add(druidColumn.left);
        }
        return Pair.of((Object)projectedColumnsBuilder.build(), (Object)virtualColumnsBuilder.build());
    }

    protected static @Nullable Pair<List<DimensionSpec>, List<VirtualColumn>> computeProjectGroupSet(@Nullable Project projectNode, ImmutableBitSet groupSet, RelDataType inputRowType, DruidQuery druidQuery) {
        ArrayList<DefaultDimensionSpec> dimensionSpecList = new ArrayList<DefaultDimensionSpec>();
        ArrayList<VirtualColumn> virtualColumnList = new ArrayList<VirtualColumn>();
        HashSet<Object> usedFieldNames = new HashSet<Object>();
        Iterator iterator = groupSet.iterator();
        while (iterator.hasNext()) {
            DimensionSpec dimensionSpec;
            int groupKey = (Integer)iterator.next();
            Object project = projectNode == null ? RexInputRef.of((int)groupKey, (RelDataType)inputRowType) : (RexNode)projectNode.getProjects().get(groupKey);
            Pair<String, ExtractionFunction> druidColumn = DruidQuery.toDruidColumn((RexNode)project, inputRowType, druidQuery);
            if (druidColumn.left != null && druidColumn.right == null) {
                dimensionSpec = new DefaultDimensionSpec((String)druidColumn.left, (String)druidColumn.left, DruidExpressions.EXPRESSION_TYPES.get(project.getType().getSqlTypeName()));
                usedFieldNames.add(druidColumn.left);
            } else if (druidColumn.left != null && druidColumn.right != null) {
                String columnPrefix = project.getKind() == SqlKind.EXTRACT ? "extract_" + Objects.requireNonNull(DruidDateTimeUtils.extractGranularity((RexNode)project, (String)druidQuery.getConnectionConfig().timeZone()).getType().lowerName) : (project.getKind() == SqlKind.FLOOR ? "floor_" + Objects.requireNonNull(DruidDateTimeUtils.extractGranularity((RexNode)project, (String)druidQuery.getConnectionConfig().timeZone()).getType().lowerName) : EXTRACT_COLUMN_NAME_PREFIX);
                String uniqueExtractColumnName = SqlValidatorUtil.uniquify((String)columnPrefix, usedFieldNames, (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER);
                dimensionSpec = new ExtractionDimensionSpec((String)druidColumn.left, (ExtractionFunction)druidColumn.right, uniqueExtractColumnName);
                usedFieldNames.add(uniqueExtractColumnName);
            } else {
                String expression = DruidExpressions.toDruidExpression((RexNode)project, inputRowType, druidQuery);
                if (Strings.isNullOrEmpty((String)expression)) {
                    return null;
                }
                String name = SqlValidatorUtil.uniquify((String)"vc", usedFieldNames, (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER);
                VirtualColumn vc = new VirtualColumn(name, expression, DruidExpressions.EXPRESSION_TYPES.get(project.getType().getSqlTypeName()));
                virtualColumnList.add(vc);
                dimensionSpec = new DefaultDimensionSpec(name, name, DruidExpressions.EXPRESSION_TYPES.get(project.getType().getSqlTypeName()));
                usedFieldNames.add(name);
            }
            dimensionSpecList.add((DefaultDimensionSpec)dimensionSpec);
        }
        return Pair.of(dimensionSpecList, virtualColumnList);
    }

    protected static @Nullable List<JsonAggregation> computeDruidJsonAgg(List<AggregateCall> aggCalls, List<String> aggNames, @Nullable Project project, DruidQuery druidQuery) {
        ArrayList<JsonAggregation> aggregations = new ArrayList<JsonAggregation>();
        for (Pair agg : Pair.zip(aggCalls, aggNames)) {
            String expression;
            String fieldName;
            AggregateCall aggCall = (AggregateCall)agg.left;
            RelDataType type = aggCall.getType();
            SqlTypeName sqlTypeName = type.getSqlTypeName();
            boolean isNotAcceptedType = SqlTypeFamily.APPROXIMATE_NUMERIC.getTypeNames().contains(sqlTypeName) || SqlTypeFamily.INTEGER.getTypeNames().contains(sqlTypeName) ? false : !SqlTypeFamily.EXACT_NUMERIC.getTypeNames().contains(sqlTypeName) || type.getScale() != 0 && !druidQuery.getConnectionConfig().approximateDecimal();
            if (isNotAcceptedType) {
                return null;
            }
            RexNode filterNode = project != null && aggCall.hasFilter() ? (RexNode)project.getProjects().get(aggCall.filterArg) : null;
            if (aggCall.getArgList().isEmpty()) {
                fieldName = null;
                expression = null;
            } else {
                int index = (Integer)Iterables.getOnlyElement((Iterable)aggCall.getArgList());
                if (project == null) {
                    fieldName = (String)druidQuery.table.getRowType().getFieldNames().get(index);
                    expression = null;
                } else {
                    RexNode rexNode = (RexNode)project.getProjects().get(index);
                    RelDataType inputRowType = project.getInput().getRowType();
                    if (rexNode.isA(SqlKind.INPUT_REF)) {
                        expression = null;
                        fieldName = DruidQuery.extractColumnName(rexNode, inputRowType, druidQuery);
                    } else {
                        expression = DruidExpressions.toDruidExpression(rexNode, inputRowType, druidQuery);
                        if (Strings.isNullOrEmpty((String)expression)) {
                            return null;
                        }
                        fieldName = null;
                    }
                }
                assert (expression == null ^ fieldName == null);
            }
            JsonAggregation jsonAggregation = DruidQuery.getJsonAggregation((String)agg.right, (AggregateCall)agg.left, filterNode, fieldName, expression, druidQuery);
            if (jsonAggregation == null) {
                return null;
            }
            aggregations.add(jsonAggregation);
        }
        return aggregations;
    }

    protected QuerySpec getQuery(RelDataType rowType, Filter filter, @Nullable Project project, @Nullable ImmutableBitSet groupSet, @Nullable List<AggregateCall> aggCalls, @Nullable List<String> aggNames, @Nullable List<Integer> collationIndexes, @Nullable List<// Could not load outer class - annotation placement on inner may be incorrect
    RelFieldCollation.Direction> collationDirections, ImmutableBitSet numericCollationIndexes, @Nullable Integer fetch, @Nullable Project postProject, @Nullable Filter havingFilter) {
        ArrayList<String> postAggregateStageFieldNames;
        @Nullable DruidJsonFilter jsonFilter = this.computeFilter(filter);
        if (groupSet == null) {
            List scanColumnNames;
            assert (aggCalls == null);
            assert (aggNames == null);
            assert (collationIndexes == null || collationIndexes.isEmpty());
            assert (collationDirections == null || collationDirections.isEmpty());
            ArrayList<VirtualColumn> virtualColumnList = new ArrayList<VirtualColumn>();
            if (project != null) {
                Pair<List<String>, List<VirtualColumn>> projectResult = DruidQuery.computeProjectAsScan(project, project.getInput().getRowType(), this);
                scanColumnNames = (List)projectResult.left;
                virtualColumnList.addAll((Collection)projectResult.right);
            } else {
                scanColumnNames = rowType.getFieldNames();
            }
            ScanQuery scanQuery = new ScanQuery(this.druidTable.dataSource, (List<Interval>)this.intervals, jsonFilter, (List<VirtualColumn>)virtualColumnList, scanColumnNames, fetch);
            return new QuerySpec(QueryType.SCAN, scanQuery.toQuery(), scanColumnNames);
        }
        Objects.requireNonNull(aggCalls, "aggCalls");
        Objects.requireNonNull(aggNames, "aggNames");
        Preconditions.checkArgument((aggCalls.size() == aggNames.size() ? 1 : 0) != 0);
        ArrayList<JsonExpressionPostAgg> postAggs = new ArrayList<JsonExpressionPostAgg>();
        RelDataType aggInputRowType = this.table.getRowType();
        ArrayList<String> aggregateStageFieldNames = new ArrayList<String>();
        Pair<List<DimensionSpec>, List<VirtualColumn>> projectGroupSet = DruidQuery.computeProjectGroupSet(project, groupSet, aggInputRowType, this);
        Objects.requireNonNull(projectGroupSet, "projectGroupSet");
        List groupByKeyDims = (List)projectGroupSet.left;
        List virtualColumnList = (List)projectGroupSet.right;
        for (Object dim : groupByKeyDims) {
            aggregateStageFieldNames.add(dim.getOutputName());
        }
        List<JsonAggregation> aggregations = DruidQuery.computeDruidJsonAgg(aggCalls, aggNames, project, this);
        Objects.requireNonNull(aggregations, "aggregations");
        for (JsonAggregation jsonAgg : aggregations) {
            aggregateStageFieldNames.add(jsonAgg.name);
        }
        DruidJsonFilter havingJsonFilter = havingFilter != null ? DruidJsonFilter.toDruidFilters(havingFilter.getCondition(), havingFilter.getInput().getRowType(), this, this.getCluster().getRexBuilder()) : null;
        if (postProject != null) {
            ArrayList<String> postProjectDimListBuilder = new ArrayList<String>();
            RelDataType postAggInputRowType = this.getCluster().getTypeFactory().createStructType(Pair.right((List)postProject.getInput().getRowType().getFieldList()), aggregateStageFieldNames);
            HashSet<String> existingAggFieldsNames = new HashSet<String>(aggregateStageFieldNames);
            ImmutableMap existingProjects = Maps.uniqueIndex(aggregateStageFieldNames, DruidExpressions::fromColumn);
            for (Pair pair : postProject.getNamedProjects()) {
                RexNode postProjectRexNode = (RexNode)pair.left;
                String expression = DruidExpressions.toDruidExpression(postProjectRexNode, postAggInputRowType, this);
                String existingFieldName = (String)existingProjects.get(expression);
                if (existingFieldName != null) {
                    postProjectDimListBuilder.add(existingFieldName);
                    continue;
                }
                String uniquelyProjectFieldName = SqlValidatorUtil.uniquify((String)((String)pair.right), existingAggFieldsNames, (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER);
                postAggs.add(new JsonExpressionPostAgg(uniquelyProjectFieldName, expression, null));
                postProjectDimListBuilder.add(uniquelyProjectFieldName);
                existingAggFieldsNames.add(uniquelyProjectFieldName);
            }
            postAggregateStageFieldNames = postProjectDimListBuilder;
        } else {
            postAggregateStageFieldNames = null;
        }
        ArrayList<String> queryOutputFieldNames = postAggregateStageFieldNames == null ? aggregateStageFieldNames : postAggregateStageFieldNames;
        JsonLimit limit = DruidQuery.computeSort(fetch, collationIndexes, collationDirections, numericCollationIndexes, queryOutputFieldNames);
        String timeSeriesQueryString = this.planAsTimeSeries(groupByKeyDims, jsonFilter, virtualColumnList, aggregations, postAggs, limit, havingJsonFilter);
        if (timeSeriesQueryString != null) {
            String timeExtractColumn;
            String string = timeExtractColumn = groupByKeyDims.isEmpty() ? null : ((DimensionSpec)groupByKeyDims.get(0)).getOutputName();
            if (timeExtractColumn != null) {
                List timeseriesFieldNames = Util.transform(queryOutputFieldNames, input -> {
                    if (timeExtractColumn.equals(input)) {
                        return "timestamp";
                    }
                    return input;
                });
                return new QuerySpec(QueryType.TIMESERIES, timeSeriesQueryString, timeseriesFieldNames);
            }
            return new QuerySpec(QueryType.TIMESERIES, timeSeriesQueryString, queryOutputFieldNames);
        }
        String topNQuery = this.planAsTopN(groupByKeyDims, jsonFilter, virtualColumnList, aggregations, postAggs, limit, havingJsonFilter);
        if (topNQuery != null) {
            return new QuerySpec(QueryType.TOP_N, topNQuery, queryOutputFieldNames);
        }
        String groupByQuery = this.planAsGroupBy(groupByKeyDims, jsonFilter, virtualColumnList, aggregations, postAggs, limit, havingJsonFilter);
        if (groupByQuery == null) {
            throw new IllegalStateException("Cannot plan Druid Query");
        }
        return new QuerySpec(QueryType.GROUP_BY, groupByQuery, queryOutputFieldNames);
    }

    private static JsonLimit computeSort(@Nullable Integer fetch, @Nullable List<Integer> collationIndexes, @Nullable List<// Could not load outer class - annotation placement on inner may be incorrect
    RelFieldCollation.Direction> collationDirections, ImmutableBitSet numericCollationIndexes, List<String> queryOutputFieldNames) {
        ImmutableList collations;
        if (collationIndexes != null) {
            Objects.requireNonNull(collationDirections, "collationDirections");
            ImmutableList.Builder colBuilder = ImmutableList.builder();
            for (Pair p : Pair.zip(collationIndexes, collationDirections)) {
                String dimensionOrder = numericCollationIndexes.get(((Integer)p.left).intValue()) ? "numeric" : "lexicographic";
                colBuilder.add((Object)new JsonCollation(queryOutputFieldNames.get((Integer)p.left), p.right == RelFieldCollation.Direction.DESCENDING ? "descending" : "ascending", dimensionOrder));
            }
            collations = colBuilder.build();
        } else {
            collations = null;
        }
        return new JsonLimit("default", fetch, (List)collations);
    }

    private @Nullable String planAsTimeSeries(List<DimensionSpec> groupByKeyDims, @Nullable DruidJsonFilter jsonFilter, List<VirtualColumn> virtualColumnList, List<JsonAggregation> aggregations, List<JsonExpressionPostAgg> postAggregations, JsonLimit limit, @Nullable DruidJsonFilter havingFilter) {
        Granularity timeseriesGranularity;
        String sortDirection;
        if (havingFilter != null) {
            return null;
        }
        if (groupByKeyDims.size() > 1) {
            return null;
        }
        if (limit.limit != null) {
            return null;
        }
        if (limit.collations != null && limit.collations.size() > 1) {
            return null;
        }
        if (limit.collations != null && limit.collations.size() == 1) {
            if (groupByKeyDims.isEmpty() || !limit.collations.get((int)0).dimension.equals(groupByKeyDims.get(0).getOutputName())) {
                return null;
            }
            sortDirection = limit.collations.get((int)0).direction;
        } else {
            sortDirection = null;
        }
        if (groupByKeyDims.size() == 1) {
            DimensionSpec dimensionSpec = (DimensionSpec)Iterables.getOnlyElement(groupByKeyDims);
            Granularity granularity = ExtractionDimensionSpec.toQueryGranularity(dimensionSpec);
            boolean hasExpressionOnTopOfTimeExtract = false;
            for (JsonExpressionPostAgg postAgg : postAggregations) {
                if (postAgg == null || !postAgg.expression.contains(groupByKeyDims.get(0).getOutputName())) continue;
                hasExpressionOnTopOfTimeExtract = true;
            }
            Granularity granularity2 = timeseriesGranularity = hasExpressionOnTopOfTimeExtract ? null : granularity;
            if (timeseriesGranularity == null) {
                return null;
            }
        } else {
            timeseriesGranularity = Granularities.all();
        }
        boolean skipEmptyBuckets = Granularities.all() != timeseriesGranularity;
        StringWriter sw = new StringWriter();
        JsonFactory factory = new JsonFactory();
        try {
            JsonGenerator generator = factory.createGenerator((Writer)sw);
            generator.writeStartObject();
            generator.writeStringField("queryType", "timeseries");
            generator.writeStringField("dataSource", this.druidTable.dataSource);
            generator.writeBooleanField("descending", sortDirection != null && sortDirection.equals("descending"));
            DruidQuery.writeField(generator, "granularity", timeseriesGranularity);
            DruidQuery.writeFieldIf(generator, "filter", jsonFilter);
            DruidQuery.writeField(generator, "aggregations", aggregations);
            DruidQuery.writeFieldIf(generator, "virtualColumns", virtualColumnList.isEmpty() ? null : virtualColumnList);
            DruidQuery.writeFieldIf(generator, "postAggregations", postAggregations.isEmpty() ? null : postAggregations);
            DruidQuery.writeField(generator, "intervals", this.intervals);
            generator.writeFieldName("context");
            generator.writeStartObject();
            generator.writeBooleanField("skipEmptyBuckets", skipEmptyBuckets);
            generator.writeEndObject();
            generator.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    private @Nullable String planAsTopN(List<DimensionSpec> groupByKeyDims, DruidJsonFilter jsonFilter, List<VirtualColumn> virtualColumnList, List<JsonAggregation> aggregations, List<JsonExpressionPostAgg> postAggregations, JsonLimit limit, DruidJsonFilter havingFilter) {
        if (havingFilter != null) {
            return null;
        }
        if (!this.getConnectionConfig().approximateTopN() || groupByKeyDims.size() != 1 || limit.limit == null || limit.collations == null || limit.collations.size() != 1) {
            return null;
        }
        if (limit.collations.get((int)0).dimension.equals(groupByKeyDims.get(0).getOutputName())) {
            return null;
        }
        if (limit.collations.get((int)0).direction.equals("ascending")) {
            return null;
        }
        String topNMetricColumnName = limit.collations.get((int)0).dimension;
        StringWriter sw = new StringWriter();
        JsonFactory factory = new JsonFactory();
        try {
            JsonGenerator generator = factory.createGenerator((Writer)sw);
            generator.writeStartObject();
            generator.writeStringField("queryType", "topN");
            generator.writeStringField("dataSource", this.druidTable.dataSource);
            DruidQuery.writeField(generator, "granularity", Granularities.all());
            DruidQuery.writeField(generator, "dimension", groupByKeyDims.get(0));
            DruidQuery.writeFieldIf(generator, "virtualColumns", virtualColumnList.isEmpty() ? null : virtualColumnList);
            generator.writeStringField("metric", topNMetricColumnName);
            DruidQuery.writeFieldIf(generator, "filter", jsonFilter);
            DruidQuery.writeField(generator, "aggregations", aggregations);
            DruidQuery.writeFieldIf(generator, "postAggregations", postAggregations.isEmpty() ? null : postAggregations);
            DruidQuery.writeField(generator, "intervals", this.intervals);
            generator.writeNumberField("threshold", limit.limit.intValue());
            generator.writeEndObject();
            generator.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    private @Nullable String planAsGroupBy(List<DimensionSpec> groupByKeyDims, DruidJsonFilter jsonFilter, List<VirtualColumn> virtualColumnList, List<JsonAggregation> aggregations, List<JsonExpressionPostAgg> postAggregations, JsonLimit limit, DruidJsonFilter havingFilter) {
        StringWriter sw = new StringWriter();
        JsonFactory factory = new JsonFactory();
        try {
            JsonGenerator generator = factory.createGenerator((Writer)sw);
            generator.writeStartObject();
            generator.writeStringField("queryType", "groupBy");
            generator.writeStringField("dataSource", this.druidTable.dataSource);
            DruidQuery.writeField(generator, "granularity", Granularities.all());
            DruidQuery.writeField(generator, "dimensions", groupByKeyDims);
            DruidQuery.writeFieldIf(generator, "virtualColumns", virtualColumnList.isEmpty() ? null : virtualColumnList);
            DruidQuery.writeFieldIf(generator, "limitSpec", limit);
            DruidQuery.writeFieldIf(generator, "filter", jsonFilter);
            DruidQuery.writeField(generator, "aggregations", aggregations);
            DruidQuery.writeFieldIf(generator, "postAggregations", postAggregations.isEmpty() ? null : postAggregations);
            DruidQuery.writeField(generator, "intervals", this.intervals);
            DruidQuery.writeFieldIf(generator, "having", havingFilter == null ? null : new DruidJsonFilter.JsonDimHavingFilter(havingFilter));
            generator.writeEndObject();
            generator.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    private static @Nullable JsonAggregation getJsonAggregation(String name, AggregateCall aggCall, @Nullable RexNode filterNode, @Nullable String fieldName, @Nullable String aggExpression, DruidQuery druidQuery) {
        JsonAggregation aggregation;
        boolean fractional;
        RelDataType type = aggCall.getType();
        SqlTypeName sqlTypeName = type.getSqlTypeName();
        CalciteConnectionConfig config = druidQuery.getConnectionConfig();
        if (SqlTypeFamily.APPROXIMATE_NUMERIC.getTypeNames().contains(sqlTypeName)) {
            fractional = true;
        } else if (SqlTypeFamily.INTEGER.getTypeNames().contains(sqlTypeName)) {
            fractional = false;
        } else if (SqlTypeFamily.EXACT_NUMERIC.getTypeNames().contains(sqlTypeName)) {
            assert (sqlTypeName == SqlTypeName.DECIMAL);
            fractional = type.getScale() != 0;
        } else {
            return null;
        }
        ComplexMetric complexMetric = druidQuery.druidTable.resolveComplexMetric(fieldName, aggCall);
        switch (aggCall.getAggregation().getKind()) {
            case COUNT: {
                if (aggCall.isDistinct()) {
                    if (aggCall.isApproximate() || config.approximateDistinctCount()) {
                        if (complexMetric == null) {
                            aggregation = new JsonCardinalityAggregation("cardinality", name, (List)ImmutableList.of((Object)fieldName));
                            break;
                        }
                        aggregation = new JsonAggregation(complexMetric.getMetricType(), name, complexMetric.getMetricName(), null);
                        break;
                    }
                    return null;
                }
                if (aggCall.getArgList().size() == 1 && !aggCall.isDistinct()) {
                    DruidJsonFilter matchNulls = fieldName == null ? new DruidJsonFilter.JsonExpressionFilter(aggExpression + " == null") : DruidJsonFilter.getSelectorFilter(fieldName, null, null);
                    aggregation = new JsonFilteredAggregation(DruidJsonFilter.toNotDruidFilter(matchNulls), new JsonAggregation("count", name, fieldName, aggExpression));
                    break;
                }
                if (!aggCall.isDistinct()) {
                    aggregation = new JsonAggregation("count", name, fieldName, aggExpression);
                    break;
                }
                aggregation = null;
                break;
            }
            case SUM: 
            case SUM0: {
                aggregation = new JsonAggregation(fractional ? "doubleSum" : "longSum", name, fieldName, aggExpression);
                break;
            }
            case MIN: {
                aggregation = new JsonAggregation(fractional ? "doubleMin" : "longMin", name, fieldName, aggExpression);
                break;
            }
            case MAX: {
                aggregation = new JsonAggregation(fractional ? "doubleMax" : "longMax", name, fieldName, aggExpression);
                break;
            }
            default: {
                return null;
            }
        }
        if (aggregation == null) {
            return null;
        }
        if (filterNode != null) {
            DruidJsonFilter druidFilter = DruidJsonFilter.toDruidFilters(filterNode, druidQuery.table.getRowType(), druidQuery, druidQuery.getCluster().getRexBuilder());
            if (druidFilter == null) {
                return null;
            }
            return new JsonFilteredAggregation(druidFilter, aggregation);
        }
        return aggregation;
    }

    protected static void writeField(JsonGenerator generator, String fieldName, Object o) throws IOException {
        generator.writeFieldName(fieldName);
        DruidQuery.writeObject(generator, o);
    }

    protected static void writeFieldIf(JsonGenerator generator, String fieldName, @Nullable Object o) throws IOException {
        if (o != null) {
            DruidQuery.writeField(generator, fieldName, o);
        }
    }

    protected static void writeArray(JsonGenerator generator, List<?> elements) throws IOException {
        generator.writeStartArray();
        for (Object o : elements) {
            DruidQuery.writeObject(generator, o);
        }
        generator.writeEndArray();
    }

    protected static void writeObject(JsonGenerator generator, Object o) throws IOException {
        if (o instanceof String) {
            String s = (String)o;
            generator.writeString(s);
        } else if (o instanceof Interval) {
            generator.writeString(o.toString());
        } else if (o instanceof Integer) {
            Integer i = (Integer)o;
            generator.writeNumber(i.intValue());
        } else if (o instanceof List) {
            DruidQuery.writeArray(generator, (List)o);
        } else if (o instanceof DruidJson) {
            ((DruidJson)o).write(generator);
        } else {
            throw new AssertionError((Object)("not a json object: " + o));
        }
    }

    static String metadataQuery(String dataSourceName, List<Interval> intervals) {
        StringWriter sw = new StringWriter();
        JsonFactory factory = new JsonFactory();
        try {
            JsonGenerator generator = factory.createGenerator((Writer)sw);
            generator.writeStartObject();
            generator.writeStringField("queryType", "segmentMetadata");
            generator.writeStringField("dataSource", dataSourceName);
            generator.writeBooleanField("merge", true);
            generator.writeBooleanField("lenientAggregatorMerge", true);
            generator.writeArrayFieldStart("analysisTypes");
            generator.writeString("aggregators");
            generator.writeEndArray();
            DruidQuery.writeFieldIf(generator, "intervals", intervals);
            generator.writeEndObject();
            generator.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return sw.toString();
    }

    protected int getTimestampFieldIndex() {
        return Iterables.indexOf((Iterable)this.getRowType().getFieldList(), input -> this.druidTable.timestampFieldName.equals(input.getName()));
    }

    protected static abstract class JsonPostAggregation
    implements DruidJson {
        final String type;
        String name;

        private JsonPostAggregation(String name, String type) {
            this.type = type;
            this.name = name;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type);
            generator.writeStringField("name", this.name);
        }

        public void setName(String name) {
            this.name = name;
        }
    }

    private static class JsonFilteredAggregation
    extends JsonAggregation {
        final DruidJsonFilter filter;
        final JsonAggregation aggregation;

        private JsonFilteredAggregation(DruidJsonFilter filter, JsonAggregation aggregation) {
            super("filtered", aggregation.name, aggregation.fieldName, null);
            this.filter = filter;
            this.aggregation = aggregation;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type);
            DruidQuery.writeField(generator, "filter", this.filter);
            DruidQuery.writeField(generator, "aggregator", this.aggregation);
            generator.writeEndObject();
        }
    }

    private static class JsonCardinalityAggregation
    extends JsonAggregation {
        final List<String> fieldNames;

        private JsonCardinalityAggregation(String type, String name, List<String> fieldNames) {
            super(type, name, null, null);
            this.fieldNames = fieldNames;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type);
            generator.writeStringField("name", this.name);
            DruidQuery.writeFieldIf(generator, "fieldNames", this.fieldNames);
            generator.writeEndObject();
        }
    }

    private static class JsonCollation
    implements DruidJson {
        final String dimension;
        final String direction;
        final String dimensionOrder;

        private JsonCollation(String dimension, String direction, String dimensionOrder) {
            this.dimension = dimension;
            this.direction = direction;
            this.dimensionOrder = dimensionOrder;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("dimension", this.dimension);
            DruidQuery.writeFieldIf(generator, "direction", this.direction);
            DruidQuery.writeFieldIf(generator, "dimensionOrder", this.dimensionOrder);
            generator.writeEndObject();
        }
    }

    private static class JsonLimit
    implements DruidJson {
        final String type;
        final @Nullable Integer limit;
        final @Nullable List<JsonCollation> collations;

        private JsonLimit(String type, @Nullable Integer limit, @Nullable List<JsonCollation> collations) {
            this.type = type;
            this.limit = limit;
            this.collations = collations;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type);
            DruidQuery.writeFieldIf(generator, "limit", this.limit);
            DruidQuery.writeFieldIf(generator, "columns", this.collations);
            generator.writeEndObject();
        }
    }

    private static class JsonExpressionPostAgg
    extends JsonPostAggregation {
        private final String expression;
        private final @Nullable String ordering;

        private JsonExpressionPostAgg(String name, String expression, @Nullable String ordering) {
            super(name, "expression");
            this.expression = expression;
            this.ordering = ordering;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            super.write(generator);
            DruidQuery.writeFieldIf(generator, "expression", this.expression);
            DruidQuery.writeFieldIf(generator, "ordering", this.ordering);
            generator.writeEndObject();
        }
    }

    private static class JsonAggregation
    implements DruidJson {
        final String type;
        final String name;
        final @Nullable String fieldName;
        final @Nullable String expression;

        private JsonAggregation(String type, String name, @Nullable String fieldName, @Nullable String expression) {
            this.type = type;
            this.name = name;
            this.fieldName = fieldName;
            this.expression = expression;
        }

        @Override
        public void write(JsonGenerator generator) throws IOException {
            generator.writeStartObject();
            generator.writeStringField("type", this.type);
            generator.writeStringField("name", this.name);
            DruidQuery.writeFieldIf(generator, "fieldName", this.fieldName);
            DruidQuery.writeFieldIf(generator, "expression", this.expression);
            generator.writeEndObject();
        }
    }

    private static class DruidQueryNode
    implements Node {
        private final Sink sink;
        private final DruidQuery query;
        private final QuerySpec querySpec;

        DruidQueryNode(Compiler interpreter, DruidQuery query) {
            this.query = query;
            this.sink = interpreter.sink((RelNode)query);
            this.querySpec = query.getQuerySpec();
            Hook.QUERY_PLAN.run((Object)this.querySpec);
        }

        public void run() {
            ArrayList<ColumnMetaData.Rep> fieldTypes = new ArrayList<ColumnMetaData.Rep>();
            for (RelDataTypeField field : this.query.getRowType().getFieldList()) {
                fieldTypes.add(DruidQueryNode.getPrimitive(field));
            }
            DruidConnectionImpl connection = new DruidConnectionImpl(this.query.druidTable.schema.url, this.query.druidTable.schema.coordinatorUrl);
            boolean limitQuery = DruidQueryNode.containsLimit(this.querySpec);
            DruidConnectionImpl.Page page = new DruidConnectionImpl.Page();
            do {
                String queryString = this.querySpec.getQueryString(page.pagingIdentifier, page.offset);
                connection.request(this.querySpec.queryType, queryString, this.sink, this.querySpec.fieldNames, fieldTypes, page);
            } while (!limitQuery && page.pagingIdentifier != null && page.totalRowCount > 0);
        }

        private static boolean containsLimit(QuerySpec querySpec) {
            return querySpec.queryString.contains("\"context\":{\"druid.query.fetch\":true");
        }

        private static ColumnMetaData.Rep getPrimitive(RelDataTypeField field) {
            switch (field.getType().getSqlTypeName()) {
                case TIMESTAMP_WITH_LOCAL_TIME_ZONE: 
                case TIMESTAMP: {
                    return ColumnMetaData.Rep.JAVA_SQL_TIMESTAMP;
                }
                case BIGINT: {
                    return ColumnMetaData.Rep.LONG;
                }
                case INTEGER: {
                    return ColumnMetaData.Rep.INTEGER;
                }
                case SMALLINT: {
                    return ColumnMetaData.Rep.SHORT;
                }
                case TINYINT: {
                    return ColumnMetaData.Rep.BYTE;
                }
                case REAL: {
                    return ColumnMetaData.Rep.FLOAT;
                }
                case DOUBLE: 
                case FLOAT: {
                    return ColumnMetaData.Rep.DOUBLE;
                }
            }
            return null;
        }
    }

    public static class QuerySpec {
        final QueryType queryType;
        final String queryString;
        final List<String> fieldNames;

        QuerySpec(QueryType queryType, String queryString, List<String> fieldNames) {
            this.queryType = Objects.requireNonNull(queryType, "queryType");
            this.queryString = Objects.requireNonNull(queryString, "queryString");
            this.fieldNames = ImmutableList.copyOf(fieldNames);
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.queryType, this.queryString, this.fieldNames});
        }

        public boolean equals(Object obj) {
            return obj == this || obj instanceof QuerySpec && this.queryType == ((QuerySpec)obj).queryType && this.queryString.equals(((QuerySpec)obj).queryString) && this.fieldNames.equals(((QuerySpec)obj).fieldNames);
        }

        public String toString() {
            return "{queryType: " + (Object)((Object)this.queryType) + ", queryString: " + this.queryString + ", fieldNames: " + this.fieldNames + "}";
        }

        public String getQueryString(@Nullable String pagingIdentifier, int offset) {
            if (pagingIdentifier == null) {
                return this.queryString;
            }
            return this.queryString.replace("\"threshold\":", "\"pagingIdentifiers\":{\"" + pagingIdentifier + "\":" + offset + "},\"threshold\":");
        }
    }

    private static class ScanQuery {
        private final String dataSource;
        private final List<Interval> intervals;
        private final @Nullable DruidJsonFilter jsonFilter;
        private final List<VirtualColumn> virtualColumnList;
        private final List<String> columns;
        private final @Nullable Integer fetchLimit;

        ScanQuery(String dataSource, List<Interval> intervals, @Nullable DruidJsonFilter jsonFilter, List<VirtualColumn> virtualColumnList, List<String> columns, @Nullable Integer fetchLimit) {
            this.dataSource = dataSource;
            this.intervals = intervals;
            this.jsonFilter = jsonFilter;
            this.virtualColumnList = virtualColumnList;
            this.columns = columns;
            this.fetchLimit = fetchLimit;
        }

        public String toQuery() {
            StringWriter sw = new StringWriter();
            try {
                JsonFactory factory = new JsonFactory();
                JsonGenerator generator = factory.createGenerator((Writer)sw);
                generator.writeStartObject();
                generator.writeStringField("queryType", "scan");
                generator.writeStringField("dataSource", this.dataSource);
                DruidQuery.writeField(generator, "intervals", this.intervals);
                DruidQuery.writeFieldIf(generator, "filter", this.jsonFilter);
                DruidQuery.writeFieldIf(generator, "virtualColumns", this.virtualColumnList.isEmpty() ? null : this.virtualColumnList);
                DruidQuery.writeField(generator, "columns", this.columns);
                generator.writeStringField("resultFormat", "compactedList");
                if (this.fetchLimit != null) {
                    generator.writeNumberField("limit", this.fetchLimit.intValue());
                }
                generator.writeEndObject();
                generator.close();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            return sw.toString();
        }
    }
}

