/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.druid;

import java.util.Objects;
import java.util.TimeZone;
import org.apache.calcite.adapter.druid.DruidDateTimeUtils;
import org.apache.calcite.adapter.druid.DruidExpressions;
import org.apache.calcite.adapter.druid.DruidQuery;
import org.apache.calcite.adapter.druid.DruidSqlOperatorConverter;
import org.apache.calcite.adapter.druid.Granularity;
import org.apache.calcite.avatica.util.DateTimeUtils;
import org.apache.calcite.avatica.util.TimeUnitRange;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.type.SqlTypeName;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CeilOperatorConversion
implements DruidSqlOperatorConverter {
    @Override
    public SqlOperator calciteOperator() {
        return SqlStdOperatorTable.CEIL;
    }

    @Override
    public @Nullable String toDruidExpression(RexNode rexNode, RelDataType rowType, DruidQuery query) {
        RexCall call = (RexCall)rexNode;
        RexNode arg = (RexNode)call.getOperands().get(0);
        String druidExpression = DruidExpressions.toDruidExpression(arg, rowType, query);
        if (druidExpression == null) {
            return null;
        }
        if (call.getOperands().size() == 1) {
            return DruidQuery.format("ceil(%s)", druidExpression);
        }
        if (call.getOperands().size() == 2) {
            RexLiteral flag = (RexLiteral)call.getOperands().get(1);
            TimeUnitRange timeUnit = Objects.requireNonNull((TimeUnitRange)flag.getValue());
            Granularity.Type type = DruidDateTimeUtils.toDruidGranularity(timeUnit);
            if (type == null) {
                return null;
            }
            String isoPeriodFormat = DruidDateTimeUtils.toISOPeriodFormat(type);
            if (isoPeriodFormat == null) {
                return null;
            }
            TimeZone tz = arg.getType().getSqlTypeName() == SqlTypeName.TIMESTAMP_WITH_LOCAL_TIME_ZONE ? TimeZone.getTimeZone(query.getConnectionConfig().timeZone()) : DateTimeUtils.UTC_ZONE;
            return DruidExpressions.applyTimestampCeil(druidExpression, isoPeriodFormat, "", tz);
        }
        return null;
    }
}

