/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.cassandra;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.calcite.adapter.cassandra.CassandraFilter;
import org.apache.calcite.adapter.cassandra.CassandraLimit;
import org.apache.calcite.adapter.cassandra.CassandraProject;
import org.apache.calcite.adapter.cassandra.CassandraRel;
import org.apache.calcite.adapter.cassandra.CassandraSort;
import org.apache.calcite.adapter.cassandra.CassandraTableScan;
import org.apache.calcite.adapter.cassandra.CassandraToEnumerableConverter;
import org.apache.calcite.adapter.cassandra.CassandraToEnumerableConverterRule;
import org.apache.calcite.adapter.cassandra.ImmutableCassandraFilterRuleConfig;
import org.apache.calcite.adapter.cassandra.ImmutableCassandraLimitRuleConfig;
import org.apache.calcite.adapter.cassandra.ImmutableCassandraSortRuleConfig;
import org.apache.calcite.adapter.enumerable.EnumerableLimit;
import org.apache.calcite.plan.Convention;
import org.apache.calcite.plan.RelOptRule;
import org.apache.calcite.plan.RelOptRuleCall;
import org.apache.calcite.plan.RelOptUtil;
import org.apache.calcite.plan.RelRule;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelCollation;
import org.apache.calcite.rel.RelCollations;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterRule;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rel.logical.LogicalFilter;
import org.apache.calcite.rel.logical.LogicalProject;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexInputRef;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlKind;
import org.apache.calcite.sql.validate.SqlValidatorUtil;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.immutables.value.Value;

public class CassandraRules {
    public static final CassandraFilterRule FILTER = CassandraFilterRule.Config.DEFAULT.toRule();
    public static final CassandraProjectRule PROJECT = (CassandraProjectRule)CassandraProjectRule.access$000().toRule(CassandraProjectRule.class);
    public static final CassandraSortRule SORT = CassandraSortRule.Config.DEFAULT.toRule();
    public static final CassandraLimitRule LIMIT = CassandraLimitRule.Config.DEFAULT.toRule();
    public static final CassandraToEnumerableConverterRule TO_ENUMERABLE = (CassandraToEnumerableConverterRule)CassandraToEnumerableConverterRule.DEFAULT_CONFIG.toRule(CassandraToEnumerableConverterRule.class);
    protected static final RelOptRule[] RULES = new RelOptRule[]{FILTER, PROJECT, SORT, LIMIT};

    private CassandraRules() {
    }

    static List<String> cassandraFieldNames(RelDataType rowType) {
        return SqlValidatorUtil.uniquify((List)rowType.getFieldNames(), (SqlValidatorUtil.Suggester)SqlValidatorUtil.EXPR_SUGGESTER, (boolean)true);
    }

    public static class CassandraLimitRule
    extends RelRule<CassandraLimitRuleConfig> {
        protected CassandraLimitRule(CassandraLimitRuleConfig config) {
            super((RelRule.Config)config);
        }

        public RelNode convert(EnumerableLimit limit) {
            RelTraitSet traitSet = limit.getTraitSet().replace((RelTrait)CassandraRel.CONVENTION);
            return new CassandraLimit(limit.getCluster(), traitSet, CassandraLimitRule.convert((RelNode)limit.getInput(), (RelTrait)CassandraRel.CONVENTION), limit.offset, limit.fetch);
        }

        public void onMatch(RelOptRuleCall call) {
            EnumerableLimit limit = (EnumerableLimit)call.rel(0);
            call.transformTo(this.convert(limit));
        }

        @Value.Immutable
        public static interface CassandraLimitRuleConfig
        extends RelRule.Config {
            public static final CassandraLimitRuleConfig DEFAULT = ImmutableCassandraLimitRuleConfig.builder().withOperandSupplier(b0 -> b0.operand(EnumerableLimit.class).oneInput(b1 -> b1.operand(CassandraToEnumerableConverter.class).anyInputs())).build();

            default public CassandraLimitRule toRule() {
                return new CassandraLimitRule(this);
            }
        }

        @Deprecated
        public static interface Config
        extends CassandraLimitRuleConfig {
        }
    }

    public static class CassandraSortRule
    extends RelRule<CassandraSortRuleConfig> {
        protected CassandraSortRule(CassandraSortRuleConfig config) {
            super((RelRule.Config)config);
        }

        public RelNode convert(Sort sort, CassandraFilter filter) {
            RelTraitSet traitSet = sort.getTraitSet().replace((RelTrait)CassandraRel.CONVENTION).replace((RelTrait)sort.getCollation());
            return new CassandraSort(sort.getCluster(), traitSet, CassandraSortRule.convert((RelNode)sort.getInput(), (RelTraitSet)traitSet.replace((RelTrait)RelCollations.EMPTY)), sort.getCollation());
        }

        public boolean matches(RelOptRuleCall call) {
            Sort sort = (Sort)call.rel(0);
            CassandraFilter filter = (CassandraFilter)call.rel(2);
            return CassandraSortRule.collationsCompatible(sort.getCollation(), filter.getImplicitCollation());
        }

        private static boolean collationsCompatible(RelCollation sortCollation, RelCollation implicitCollation) {
            List sortFieldCollations = sortCollation.getFieldCollations();
            List implicitFieldCollations = implicitCollation.getFieldCollations();
            if (sortFieldCollations.size() > implicitFieldCollations.size()) {
                return false;
            }
            if (sortFieldCollations.isEmpty()) {
                return true;
            }
            boolean reversed = ((RelFieldCollation)sortFieldCollations.get(0)).getDirection().reverse().lax() == ((RelFieldCollation)implicitFieldCollations.get(0)).getDirection();
            for (int i = 0; i < sortFieldCollations.size(); ++i) {
                RelFieldCollation sorted = (RelFieldCollation)sortFieldCollations.get(i);
                RelFieldCollation implied = (RelFieldCollation)implicitFieldCollations.get(i);
                if (sorted.getFieldIndex() != implied.getFieldIndex()) {
                    return false;
                }
                RelFieldCollation.Direction sortDirection = sorted.getDirection();
                RelFieldCollation.Direction implicitDirection = implied.getDirection();
                if ((reversed || sortDirection == implicitDirection) && (!reversed || sortDirection.reverse().lax() == implicitDirection)) continue;
                return false;
            }
            return true;
        }

        public void onMatch(RelOptRuleCall call) {
            Sort sort = (Sort)call.rel(0);
            CassandraFilter filter = (CassandraFilter)call.rel(2);
            call.transformTo(this.convert(sort, filter));
        }

        @Value.Immutable
        public static interface CassandraSortRuleConfig
        extends RelRule.Config {
            public static final CassandraSortRuleConfig DEFAULT = ImmutableCassandraSortRuleConfig.builder().withOperandSupplier(b0 -> b0.operand(Sort.class).predicate(sort -> sort.offset == null && sort.fetch == null).oneInput(b1 -> b1.operand(CassandraToEnumerableConverter.class).oneInput(b2 -> b2.operand(CassandraFilter.class).predicate(CassandraFilter::isSinglePartition).anyInputs()))).build();

            default public CassandraSortRule toRule() {
                return new CassandraSortRule(this);
            }
        }

        @Deprecated
        public static interface Config
        extends CassandraSortRuleConfig {
        }
    }

    public static class CassandraProjectRule
    extends CassandraConverterRule {
        private static final ConverterRule.Config DEFAULT_CONFIG = ConverterRule.Config.INSTANCE.withConversion(LogicalProject.class, (RelTrait)Convention.NONE, (RelTrait)CassandraRel.CONVENTION, "CassandraProjectRule").withRuleFactory(CassandraProjectRule::new);

        protected CassandraProjectRule(ConverterRule.Config config) {
            super(config);
        }

        public boolean matches(RelOptRuleCall call) {
            LogicalProject project = (LogicalProject)call.rel(0);
            for (RexNode e : project.getProjects()) {
                if (e instanceof RexInputRef) continue;
                return false;
            }
            return project.getVariablesSet().isEmpty();
        }

        public RelNode convert(RelNode rel) {
            LogicalProject project = (LogicalProject)rel;
            RelTraitSet traitSet = project.getTraitSet().replace((RelTrait)this.out);
            return new CassandraProject(project.getCluster(), traitSet, CassandraProjectRule.convert((RelNode)project.getInput(), (RelTrait)this.out), project.getProjects(), project.getRowType());
        }

        static /* synthetic */ ConverterRule.Config access$000() {
            return DEFAULT_CONFIG;
        }
    }

    public static class CassandraFilterRule
    extends RelRule<CassandraFilterRuleConfig> {
        protected CassandraFilterRule(CassandraFilterRuleConfig config) {
            super((RelRule.Config)config);
        }

        public boolean matches(RelOptRuleCall call) {
            LogicalFilter filter = (LogicalFilter)call.rel(0);
            RexNode condition = filter.getCondition();
            CassandraTableScan scan = (CassandraTableScan)call.rel(1);
            List<String> partitionKeys = scan.cassandraTable.getPartitionKeys();
            List<String> clusteringKeys = scan.cassandraTable.getClusteringKeys();
            HashSet<String> partitionKeysSet = new HashSet<String>(scan.cassandraTable.getPartitionKeys());
            List<String> fieldNames = CassandraRules.cassandraFieldNames(filter.getInput().getRowType());
            List disjunctions = RelOptUtil.disjunctions((RexNode)condition);
            if (disjunctions.size() != 1) {
                return false;
            }
            condition = (RexNode)disjunctions.get(0);
            for (RexNode predicate : RelOptUtil.conjunctions((RexNode)condition)) {
                if (CassandraFilterRule.isEqualityOnKey(predicate, fieldNames, partitionKeysSet, clusteringKeys)) continue;
                return false;
            }
            return partitionKeysSet.size() == partitionKeys.size() || partitionKeysSet.isEmpty();
        }

        private static boolean isEqualityOnKey(RexNode node, List<String> fieldNames, Set<String> partitionKeys, List<String> clusteringKeys) {
            RexNode right;
            if (node.getKind() != SqlKind.EQUALS) {
                return false;
            }
            RexCall call = (RexCall)node;
            RexNode left = (RexNode)call.operands.get(0);
            String key = CassandraFilterRule.compareFieldWithLiteral(left, right = (RexNode)call.operands.get(1), fieldNames);
            if (key == null) {
                key = CassandraFilterRule.compareFieldWithLiteral(left, right, fieldNames);
            }
            if (key != null) {
                return partitionKeys.remove(key) || clusteringKeys.contains(key);
            }
            return false;
        }

        private static @Nullable String compareFieldWithLiteral(RexNode left, RexNode right, List<String> fieldNames) {
            if (left.isA(SqlKind.CAST)) {
                left = (RexNode)((RexCall)left).getOperands().get(0);
            }
            if (left.isA(SqlKind.INPUT_REF) && right.isA(SqlKind.LITERAL)) {
                RexInputRef left1 = (RexInputRef)left;
                return fieldNames.get(left1.getIndex());
            }
            return null;
        }

        public void onMatch(RelOptRuleCall call) {
            RelNode converted;
            LogicalFilter filter = (LogicalFilter)call.rel(0);
            CassandraTableScan scan = (CassandraTableScan)call.rel(1);
            if (filter.getTraitSet().contains((RelTrait)Convention.NONE) && (converted = this.convert(filter, scan)) != null) {
                call.transformTo(converted);
            }
        }

        @Nullable RelNode convert(LogicalFilter filter, CassandraTableScan scan) {
            RelTraitSet traitSet = filter.getTraitSet().replace((RelTrait)CassandraRel.CONVENTION);
            List<String> partitionKeys = scan.cassandraTable.getPartitionKeys();
            List<String> clusteringKeys = scan.cassandraTable.getClusteringKeys();
            return new CassandraFilter(filter.getCluster(), traitSet, CassandraFilterRule.convert((RelNode)filter.getInput(), (RelTrait)CassandraRel.CONVENTION), filter.getCondition(), partitionKeys, clusteringKeys, scan.cassandraTable.getClusteringOrder());
        }

        @Value.Immutable
        public static interface CassandraFilterRuleConfig
        extends RelRule.Config {
            public static final CassandraFilterRuleConfig DEFAULT = ImmutableCassandraFilterRuleConfig.builder().withOperandSupplier(b0 -> b0.operand(LogicalFilter.class).oneInput(b1 -> b1.operand(CassandraTableScan.class).noInputs())).build();

            default public CassandraFilterRule toRule() {
                return new CassandraFilterRule(this);
            }
        }

        @Deprecated
        public static interface Config
        extends CassandraFilterRuleConfig {
        }
    }

    static abstract class CassandraConverterRule
    extends ConverterRule {
        CassandraConverterRule(ConverterRule.Config config) {
            super(config);
        }
    }

    static class RexToCassandraTranslator
    extends RexVisitorImpl<String> {
        private final List<String> inFields;

        protected RexToCassandraTranslator(List<String> inFields) {
            super(true);
            this.inFields = inFields;
        }

        public String visitInputRef(RexInputRef inputRef) {
            return this.inFields.get(inputRef.getIndex());
        }
    }
}

