/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.cassandra;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import org.apache.calcite.adapter.cassandra.CassandraRel;
import org.apache.calcite.adapter.cassandra.CassandraRules;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Project;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitor;
import org.apache.calcite.util.Pair;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CassandraProject
extends Project
implements CassandraRel {
    public CassandraProject(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, List<? extends RexNode> projects, RelDataType rowType) {
        super(cluster, traitSet, (List)ImmutableList.of(), input, projects, rowType, (Set)ImmutableSet.of());
        assert (this.getConvention() == CassandraRel.CONVENTION);
        assert (this.getConvention() == input.getConvention());
    }

    public Project copy(RelTraitSet traitSet, RelNode input, List<RexNode> projects, RelDataType rowType) {
        return new CassandraProject(this.getCluster(), traitSet, input, projects, rowType);
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost cost = super.computeSelfCost(planner, mq);
        return Objects.requireNonNull(cost, "cost").multiplyBy(0.1);
    }

    @Override
    public void implement(CassandraRel.Implementor implementor) {
        implementor.visitChild(0, this.getInput());
        CassandraRules.RexToCassandraTranslator translator = new CassandraRules.RexToCassandraTranslator(CassandraRules.cassandraFieldNames(this.getInput().getRowType()));
        LinkedHashMap<String, String> fields = new LinkedHashMap<String, String>();
        for (Pair pair : this.getNamedProjects()) {
            RexNode node = (RexNode)pair.left;
            String name = (String)pair.right;
            String originalName = (String)node.accept((RexVisitor)translator);
            fields.put(originalName, name);
        }
        implementor.add(fields, null);
    }
}

