/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.cassandra;

import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.data.TupleValue;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.codec.registry.CodecRegistry;
import java.nio.ByteBuffer;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.Date;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Objects;
import java.util.stream.IntStream;
import org.apache.calcite.avatica.util.ByteString;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeField;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.checkerframework.checker.nullness.qual.Nullable;

class CassandraEnumerator
implements Enumerator<Object> {
    private final Iterator<Row> iterator;
    private final List<RelDataTypeField> fieldTypes;
    private @Nullable Row current;

    CassandraEnumerator(ResultSet results, RelProtoDataType protoRowType) {
        this.iterator = results.iterator();
        this.current = null;
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        this.fieldTypes = ((RelDataType)protoRowType.apply((Object)typeFactory)).getFieldList();
    }

    public Object current() {
        if (this.fieldTypes.size() == 1) {
            return this.currentRowField(0);
        }
        Object[] row = new Object[this.fieldTypes.size()];
        for (int i = 0; i < this.fieldTypes.size(); ++i) {
            row[i] = this.currentRowField(i);
        }
        return row;
    }

    private @Nullable Object currentRowField(int index) {
        Objects.requireNonNull(this.current, "current");
        Object o = this.current.get(index, CodecRegistry.DEFAULT.codecFor(this.current.getColumnDefinitions().get(index).getType()));
        return this.convertToEnumeratorObject(o);
    }

    private @Nullable Object convertToEnumeratorObject(@Nullable Object obj) {
        if (obj instanceof ByteBuffer) {
            ByteBuffer buf = (ByteBuffer)obj;
            byte[] bytes = new byte[buf.remaining()];
            buf.get(bytes, 0, bytes.length);
            return new ByteString(bytes);
        }
        if (obj instanceof LocalDate) {
            return ((LocalDate)obj).toEpochDay();
        }
        if (obj instanceof Date) {
            long milli = ((Date)obj).toInstant().toEpochMilli();
            return milli;
        }
        if (obj instanceof Instant) {
            return ((Instant)obj).toEpochMilli();
        }
        if (obj instanceof LocalTime) {
            return ((LocalTime)obj).toNanoOfDay();
        }
        if (obj instanceof LinkedHashSet) {
            return ((LinkedHashSet)obj).toArray();
        }
        if (obj instanceof TupleValue) {
            TupleValue tupleValue = (TupleValue)obj;
            int numComponents = tupleValue.getType().getComponentTypes().size();
            return IntStream.range(0, numComponents).mapToObj(i -> tupleValue.get(i, CodecRegistry.DEFAULT.codecFor((DataType)tupleValue.getType().getComponentTypes().get(i)))).map(this::convertToEnumeratorObject).map(Objects::requireNonNull).toArray();
        }
        return obj;
    }

    public boolean moveNext() {
        if (this.iterator.hasNext()) {
            this.current = this.iterator.next();
            return true;
        }
        return false;
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }

    public void close() {
    }
}

