/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.cassandra;

import java.lang.reflect.Method;
import java.util.AbstractList;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.adapter.cassandra.CassandraMethod;
import org.apache.calcite.adapter.cassandra.CassandraRel;
import org.apache.calcite.adapter.cassandra.CassandraRules;
import org.apache.calcite.adapter.cassandra.CassandraTable;
import org.apache.calcite.adapter.enumerable.EnumerableRel;
import org.apache.calcite.adapter.enumerable.EnumerableRelImplementor;
import org.apache.calcite.adapter.enumerable.JavaRowFormat;
import org.apache.calcite.adapter.enumerable.PhysType;
import org.apache.calcite.adapter.enumerable.PhysTypeImpl;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.config.CalciteSystemProperty;
import org.apache.calcite.linq4j.tree.BlockBuilder;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.MethodCallExpression;
import org.apache.calcite.linq4j.tree.Statement;
import org.apache.calcite.plan.ConventionTraitDef;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTraitDef;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.convert.ConverterImpl;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CassandraToEnumerableConverter
extends ConverterImpl
implements EnumerableRel {
    protected CassandraToEnumerableConverter(RelOptCluster cluster, RelTraitSet traits, RelNode input) {
        super(cluster, (RelTraitDef)ConventionTraitDef.INSTANCE, traits, input);
    }

    public RelNode copy(RelTraitSet traitSet, List<RelNode> inputs) {
        return new CassandraToEnumerableConverter(this.getCluster(), traitSet, (RelNode)CassandraToEnumerableConverter.sole(inputs));
    }

    public @Nullable RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost cost = Objects.requireNonNull(super.computeSelfCost(planner, mq));
        return cost.multiplyBy(0.1);
    }

    public EnumerableRel.Result implement(EnumerableRelImplementor implementor, EnumerableRel.Prefer pref) {
        BlockBuilder list = new BlockBuilder();
        CassandraRel.Implementor cassandraImplementor = new CassandraRel.Implementor();
        cassandraImplementor.visitChild(0, this.getInput());
        final RelDataType rowType = this.getRowType();
        final PhysType physType = PhysTypeImpl.of((JavaTypeFactory)implementor.getTypeFactory(), (RelDataType)rowType, (JavaRowFormat)pref.prefer(JavaRowFormat.ARRAY));
        Expression fields = list.append("fields", (Expression)CassandraToEnumerableConverter.constantArrayList(Pair.zip(CassandraRules.cassandraFieldNames(rowType), (List)new AbstractList<Class<?>>(){

            @Override
            public Class<?> get(int index) {
                return physType.fieldClass(index);
            }

            @Override
            public int size() {
                return rowType.getFieldCount();
            }
        }), Pair.class));
        ArrayList<Map.Entry> selectList = new ArrayList<Map.Entry>();
        for (Map.Entry entry : Pair.zip(cassandraImplementor.selectFields.keySet(), cassandraImplementor.selectFields.values())) {
            selectList.add(entry);
        }
        Expression selectFields = list.append("selectFields", (Expression)CassandraToEnumerableConverter.constantArrayList(selectList, Pair.class));
        RelOptTable cassandraTable = Objects.requireNonNull(cassandraImplementor.table);
        Expression table = list.append("table", Objects.requireNonNull(cassandraTable.getExpression(CassandraTable.CassandraQueryable.class)));
        Expression predicates = list.append("predicates", (Expression)CassandraToEnumerableConverter.constantArrayList(cassandraImplementor.whereClause, String.class));
        Expression order = list.append("order", (Expression)CassandraToEnumerableConverter.constantArrayList(cassandraImplementor.order, String.class));
        Expression offset = list.append("offset", (Expression)Expressions.constant((Object)cassandraImplementor.offset));
        Expression fetch = list.append("fetch", (Expression)Expressions.constant((Object)cassandraImplementor.fetch));
        Expression enumerable = list.append("enumerable", (Expression)Expressions.call((Expression)table, (Method)CassandraMethod.CASSANDRA_QUERYABLE_QUERY.method, (Expression[])new Expression[]{fields, selectFields, predicates, order, offset, fetch}));
        if (((Boolean)CalciteSystemProperty.DEBUG.value()).booleanValue()) {
            System.out.println("Cassandra: " + predicates);
        }
        Hook.QUERY_PLAN.run((Object)predicates);
        list.add((Statement)Expressions.return_(null, (Expression)enumerable));
        return implementor.result(physType, list.toBlock());
    }

    private static <T> MethodCallExpression constantArrayList(List<T> values, Class<?> clazz) {
        return Expressions.call((Method)BuiltInMethod.ARRAYS_AS_LIST.method, (Expression[])new Expression[]{Expressions.newArrayInit(clazz, CassandraToEnumerableConverter.constantList(values))});
    }

    private static <T> List<Expression> constantList(List<T> values) {
        return Util.transform(values, Expressions::constant);
    }
}

