/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.ResultSet;
import com.google.common.collect.ImmutableList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.apache.calcite.adapter.cassandra.CassandraEnumerator;
import org.apache.calcite.adapter.cassandra.CassandraRel;
import org.apache.calcite.adapter.cassandra.CassandraSchema;
import org.apache.calcite.adapter.cassandra.CassandraTableScan;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptTable;
import org.apache.calcite.plan.RelTrait;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.schema.QueryableTable;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

public class CassandraTable
extends AbstractQueryableTable
implements TranslatableTable {
    final RelProtoDataType protoRowType;
    final List<String> partitionKeys;
    final List<String> clusteringKeys;
    final List<RelFieldCollation> clusteringOrder;
    private final Optional<String> keyspace;
    private final String columnFamily;

    @Deprecated
    public CassandraTable(CassandraSchema schema, String columnFamily, boolean isView) {
        super(Object[].class);
        this.keyspace = Optional.empty();
        this.columnFamily = columnFamily;
        this.protoRowType = schema.getRelDataType(columnFamily, isView);
        this.partitionKeys = schema.getPartitionKeys(columnFamily, isView);
        this.clusteringKeys = schema.getClusteringKeys(columnFamily, isView);
        this.clusteringOrder = schema.getClusteringOrder(columnFamily, isView);
    }

    public CassandraTable(CassandraSchema schema, String keyspace, String columnFamily, boolean isView) {
        super(Object[].class);
        this.keyspace = Optional.of(keyspace);
        this.columnFamily = columnFamily;
        this.protoRowType = schema.getRelDataType(columnFamily, isView);
        this.partitionKeys = schema.getPartitionKeys(columnFamily, isView);
        this.clusteringKeys = schema.getClusteringKeys(columnFamily, isView);
        this.clusteringOrder = schema.getClusteringOrder(columnFamily, isView);
    }

    @Deprecated
    public CassandraTable(CassandraSchema schema, String columnFamily) {
        this(schema, columnFamily, false);
    }

    public CassandraTable(CassandraSchema schema, String keyspace, String columnFamily) {
        this(schema, keyspace, columnFamily, false);
    }

    public String toString() {
        return "CassandraTable {" + this.columnFamily + "}";
    }

    public RelDataType getRowType(RelDataTypeFactory typeFactory) {
        return (RelDataType)this.protoRowType.apply((Object)typeFactory);
    }

    public List<String> getPartitionKeys() {
        return this.partitionKeys;
    }

    public List<String> getClusteringKeys() {
        return this.clusteringKeys;
    }

    public List<RelFieldCollation> getClusteringOrder() {
        return this.clusteringOrder;
    }

    public Enumerable<Object> query(CqlSession session) {
        return this.query(session, (List<Map.Entry<String, Class>>)ImmutableList.of(), (List<Map.Entry<String, String>>)ImmutableList.of(), (List<String>)ImmutableList.of(), (List<String>)ImmutableList.of(), 0, -1);
    }

    /*
     * WARNING - void declaration
     */
    public Enumerable<Object> query(final CqlSession session, List<Map.Entry<String, Class>> fields, List<Map.Entry<String, String>> selectFields, List<String> predicates, List<String> order, final Integer offset, Integer fetch) {
        void var13_18;
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataTypeFactory.FieldInfoBuilder fieldInfo = typeFactory.builder();
        RelDataType rowType = this.getRowType((RelDataTypeFactory)typeFactory);
        Function1 addField = arg_0 -> CassandraTable.lambda$query$0(rowType, (RelDataTypeFactory.Builder)fieldInfo, arg_0);
        if (selectFields.isEmpty()) {
            for (Map.Entry<String, Object> entry : fields) {
                addField.apply((Object)entry.getKey());
            }
        } else {
            for (Map.Entry<String, Object> entry : selectFields) {
                addField.apply((Object)entry.getKey());
            }
        }
        final RelProtoDataType resultRowType = RelDataTypeImpl.proto((RelDataType)fieldInfo.build());
        if (selectFields.isEmpty()) {
            String string = "*";
        } else {
            String string = Util.toString(() -> {
                final Iterator selectIterator = selectFields.iterator();
                return new Iterator<String>(){

                    @Override
                    public boolean hasNext() {
                        return selectIterator.hasNext();
                    }

                    @Override
                    public String next() {
                        Map.Entry entry = (Map.Entry)selectIterator.next();
                        return (String)entry.getKey() + " AS " + (String)entry.getValue();
                    }

                    @Override
                    public void remove() {
                        throw new UnsupportedOperationException();
                    }
                };
            }, (String)"", (String)", ", (String)"");
        }
        String whereClause = "";
        if (!predicates.isEmpty()) {
            whereClause = " WHERE ";
            whereClause = whereClause + Util.toString(predicates, (String)"", (String)" AND ", (String)"");
        }
        final StringBuilder queryBuilder = new StringBuilder("SELECT ");
        queryBuilder.append((String)var13_18).append(" FROM \"");
        this.keyspace.ifPresent(s -> queryBuilder.append((String)s).append("\".\""));
        queryBuilder.append(this.columnFamily).append("\"").append(whereClause);
        if (!order.isEmpty()) {
            queryBuilder.append(Util.toString(order, (String)" ORDER BY ", (String)", ", (String)""));
        }
        int limit = offset;
        if (fetch >= 0) {
            limit += fetch.intValue();
        }
        if (limit > 0) {
            queryBuilder.append(" LIMIT ").append(limit);
        }
        queryBuilder.append(" ALLOW FILTERING");
        return new AbstractEnumerable<Object>(){

            public Enumerator<Object> enumerator() {
                ResultSet results = session.execute(queryBuilder.toString());
                CassandraEnumerator enumerator = new CassandraEnumerator(results, resultRowType);
                for (int skip = 0; skip < offset && enumerator.moveNext(); ++skip) {
                }
                return enumerator;
            }
        };
    }

    public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
        return new CassandraQueryable(queryProvider, schema, this, tableName);
    }

    public RelNode toRel(RelOptTable.ToRelContext context, RelOptTable relOptTable) {
        RelOptCluster cluster = context.getCluster();
        return new CassandraTableScan(cluster, cluster.traitSetOf((RelTrait)CassandraRel.CONVENTION), relOptTable, this, null);
    }

    private static /* synthetic */ Void lambda$query$0(RelDataType rowType, RelDataTypeFactory.Builder fieldInfo, String fieldName) {
        RelDataType relDataType = Objects.requireNonNull(rowType.getField(fieldName, true, false)).getType();
        fieldInfo.add(fieldName, relDataType).nullable(true);
        return null;
    }

    public static class CassandraQueryable<T>
    extends AbstractTableQueryable<T> {
        public CassandraQueryable(QueryProvider queryProvider, SchemaPlus schema, CassandraTable table, String tableName) {
            super(queryProvider, schema, (QueryableTable)table, tableName);
        }

        public Enumerator<T> enumerator() {
            Enumerable<Object> enumerable = this.getTable().query(this.getSession());
            return enumerable.enumerator();
        }

        private CassandraTable getTable() {
            return (CassandraTable)this.table;
        }

        private CqlSession getSession() {
            return ((CassandraSchema)((Object)Objects.requireNonNull(this.schema.unwrap(CassandraSchema.class)))).session;
        }

        public @Nullable Enumerable<Object> query(List<Map.Entry<String, Class>> fields, List<Map.Entry<String, String>> selectFields, List<String> predicates, List<String> order, Integer offset, Integer fetch) {
            return this.getTable().query(this.getSession(), fields, selectFields, predicates, order, offset, fetch);
        }
    }
}

