/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.cassandra;

import com.datastax.oss.driver.api.core.CqlIdentifier;
import com.datastax.oss.driver.api.core.CqlSession;
import com.datastax.oss.driver.api.core.cql.Row;
import com.datastax.oss.driver.api.core.metadata.schema.ClusteringOrder;
import com.datastax.oss.driver.api.core.metadata.schema.ColumnMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.KeyspaceMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.RelationMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.TableMetadata;
import com.datastax.oss.driver.api.core.metadata.schema.ViewMetadata;
import com.datastax.oss.driver.api.core.type.DataType;
import com.datastax.oss.driver.api.core.type.ListType;
import com.datastax.oss.driver.api.core.type.MapType;
import com.datastax.oss.driver.api.core.type.SetType;
import com.datastax.oss.driver.api.core.type.TupleType;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import org.apache.calcite.adapter.cassandra.CassandraTable;
import org.apache.calcite.adapter.cassandra.CqlToSqlTypeConversionRules;
import org.apache.calcite.avatica.util.Casing;
import org.apache.calcite.jdbc.CalciteSchema;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.rel.type.RelDataTypeImpl;
import org.apache.calcite.rel.type.RelDataTypeSystem;
import org.apache.calcite.rel.type.RelProtoDataType;
import org.apache.calcite.runtime.Hook;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.MaterializedViewTable;
import org.apache.calcite.schema.lookup.LikePattern;
import org.apache.calcite.sql.SqlSelect;
import org.apache.calcite.sql.SqlWriter;
import org.apache.calcite.sql.SqlWriterConfig;
import org.apache.calcite.sql.parser.SqlParseException;
import org.apache.calcite.sql.parser.SqlParser;
import org.apache.calcite.sql.pretty.SqlPrettyWriter;
import org.apache.calcite.sql.type.SqlTypeFactoryImpl;
import org.apache.calcite.sql.type.SqlTypeName;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.trace.CalciteTrace;
import org.slf4j.Logger;

public class CassandraSchema
extends AbstractSchema {
    final CqlSession session;
    final String keyspace;
    private final SchemaPlus parentSchema;
    final String name;
    final Hook.Closeable hook;
    static final CqlToSqlTypeConversionRules CQL_TO_SQL_TYPE = CqlToSqlTypeConversionRules.instance();
    protected static final Logger LOGGER = CalciteTrace.getPlannerTracer();

    public CassandraSchema(CqlSession session, SchemaPlus parentSchema, String name) {
        this(session, parentSchema, ((CqlIdentifier)session.getKeyspace().orElseThrow(() -> new RuntimeException("No keyspace for session " + session.getName()))).asInternal(), name);
    }

    public CassandraSchema(CqlSession session, SchemaPlus parentSchema, String keyspace, String name) {
        this.session = session;
        this.keyspace = keyspace;
        this.parentSchema = parentSchema;
        this.name = name;
        this.hook = this.prepareHook();
    }

    private Hook.Closeable prepareHook() {
        return Hook.TRIMMED.add(node -> this.addMaterializedViews());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    RelProtoDataType getRelDataType(String columnFamily, boolean view) {
        Map columns;
        CqlIdentifier tableName = CqlIdentifier.fromInternal((String)columnFamily);
        if (view) {
            Optional optionalViewMetadata = this.getKeyspace().getView(tableName);
            if (!optionalViewMetadata.isPresent()) throw new IllegalStateException("Unknown view " + tableName + " in keyspace " + this.keyspace);
            columns = ((ViewMetadata)optionalViewMetadata.get()).getColumns();
        } else {
            Optional optionalTableMetadata = this.getKeyspace().getTable(tableName);
            if (!optionalTableMetadata.isPresent()) throw new IllegalStateException("Unknown table " + tableName + " in keyspace " + this.keyspace);
            columns = ((TableMetadata)optionalTableMetadata.get()).getColumns();
        }
        SqlTypeFactoryImpl typeFactory = new SqlTypeFactoryImpl(RelDataTypeSystem.DEFAULT);
        RelDataTypeFactory.FieldInfoBuilder fieldInfo = typeFactory.builder();
        for (ColumnMetadata column : columns.values()) {
            DataType dataType = column.getType();
            String columnName = column.getName().asInternal();
            if (dataType instanceof ListType) {
                SqlTypeName arrayInnerType = CQL_TO_SQL_TYPE.lookup(((ListType)dataType).getElementType());
                fieldInfo.add(columnName, typeFactory.createArrayType(typeFactory.createSqlType(arrayInnerType), -1L)).nullable(true);
                continue;
            }
            if (dataType instanceof SetType) {
                SqlTypeName multiSetInnerType = CQL_TO_SQL_TYPE.lookup(((SetType)dataType).getElementType());
                fieldInfo.add(columnName, typeFactory.createMultisetType(typeFactory.createSqlType(multiSetInnerType), -1L)).nullable(true);
                continue;
            }
            if (dataType instanceof MapType) {
                MapType columnType = (MapType)dataType;
                SqlTypeName keyType = CQL_TO_SQL_TYPE.lookup(columnType.getKeyType());
                SqlTypeName valueType = CQL_TO_SQL_TYPE.lookup(columnType.getValueType());
                fieldInfo.add(columnName, typeFactory.createMapType(typeFactory.createSqlType(keyType), typeFactory.createSqlType(valueType))).nullable(true);
                continue;
            }
            if (dataType instanceof TupleType) {
                List typeArgs = ((TupleType)dataType).getComponentTypes();
                List typesList = IntStream.range(0, typeArgs.size()).mapToObj(arg_0 -> CassandraSchema.lambda$getRelDataType$2((RelDataTypeFactory)typeFactory, typeArgs, arg_0)).collect(Collectors.toList());
                fieldInfo.add(columnName, typeFactory.createStructType(typesList)).nullable(true);
                continue;
            }
            SqlTypeName typeName = CQL_TO_SQL_TYPE.lookup(dataType);
            fieldInfo.add(columnName, typeName).nullable(true);
        }
        return RelDataTypeImpl.proto((RelDataType)fieldInfo.build());
    }

    List<String> getPartitionKeys(String columnFamily, boolean isView) {
        RelationMetadata table = this.getRelationMetadata(columnFamily, isView);
        return table.getPartitionKey().stream().map(ColumnMetadata::getName).map(CqlIdentifier::asInternal).collect(Collectors.toList());
    }

    List<String> getClusteringKeys(String columnFamily, boolean isView) {
        RelationMetadata table = this.getRelationMetadata(columnFamily, isView);
        return table.getClusteringColumns().keySet().stream().map(ColumnMetadata::getName).map(CqlIdentifier::asInternal).collect(Collectors.toList());
    }

    public List<RelFieldCollation> getClusteringOrder(String columnFamily, boolean isView) {
        RelationMetadata table = this.getRelationMetadata(columnFamily, isView);
        Collection clusteringOrder = table.getClusteringColumns().values();
        ArrayList<RelFieldCollation> keyCollations = new ArrayList<RelFieldCollation>();
        int i = 0;
        for (ClusteringOrder order : clusteringOrder) {
            RelFieldCollation.Direction direction;
            switch (order) {
                case DESC: {
                    direction = RelFieldCollation.Direction.DESCENDING;
                    break;
                }
                default: {
                    direction = RelFieldCollation.Direction.ASCENDING;
                }
            }
            keyCollations.add(new RelFieldCollation(i, direction));
            ++i;
        }
        return keyCollations;
    }

    private RelationMetadata getRelationMetadata(String columnFamily, boolean isView) {
        String tableName = CqlIdentifier.fromInternal((String)columnFamily).asCql(false);
        if (isView) {
            return (RelationMetadata)this.getKeyspace().getView(tableName).orElseThrow(() -> new RuntimeException("Unknown view " + columnFamily + " in keyspace " + this.keyspace));
        }
        return (RelationMetadata)this.getKeyspace().getTable(tableName).orElseThrow(() -> new RuntimeException("Unknown table " + columnFamily + " in keyspace " + this.keyspace));
    }

    private void addMaterializedViews() {
        this.hook.close();
        for (ViewMetadata view : this.getKeyspace().getViews().values()) {
            SqlSelect parsedQuery;
            String tableName = view.getBaseTable().asInternal();
            StringBuilder queryBuilder = new StringBuilder("SELECT ");
            String columnsList = view.getColumns().values().stream().map(c -> c.getName().asInternal()).collect(Collectors.joining(", "));
            queryBuilder.append(columnsList);
            queryBuilder.append(" FROM ").append(tableName);
            String whereQuery = "SELECT where_clause from system_schema.views WHERE keyspace_name='" + this.keyspace + "' AND view_name='" + view.getName().asInternal() + "'";
            Row whereClauseRow = (Row)Objects.requireNonNull(this.session.execute(whereQuery).one());
            queryBuilder.append(" WHERE ").append(whereClauseRow.getString(0));
            String query = queryBuilder.toString();
            SqlParser.Config parserConfig = SqlParser.config().withUnquotedCasing(Casing.UNCHANGED);
            try {
                parsedQuery = (SqlSelect)SqlParser.create((String)query, (SqlParser.Config)parserConfig).parseQuery();
            }
            catch (SqlParseException e) {
                LOGGER.warn("Could not parse query {} for CQL view {}.{}", new Object[]{query, this.keyspace, view.getName().asInternal()});
                continue;
            }
            StringBuilder buf = new StringBuilder(query.length());
            SqlWriterConfig config = SqlPrettyWriter.config().withAlwaysUseParentheses(true);
            SqlPrettyWriter writer = new SqlPrettyWriter(config, buf);
            parsedQuery.unparse((SqlWriter)writer, 0, 0);
            query = buf.toString();
            String viewName = "$" + this.tables().getNames(LikePattern.any()).size();
            SchemaPlus schema = (SchemaPlus)this.parentSchema.subSchemas().get(this.name);
            if (schema == null) {
                throw new IllegalStateException("Cannot find schema " + this.name + " in parent schema " + this.parentSchema.getName());
            }
            CalciteSchema calciteSchema = CalciteSchema.from((SchemaPlus)schema);
            List viewPath = calciteSchema.path(viewName);
            schema.add(viewName, (Function)MaterializedViewTable.create((CalciteSchema)calciteSchema, (String)query, null, (List)viewPath, (String)view.getName().asInternal(), (boolean)true));
        }
    }

    protected Map<String, Table> getTableMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (TableMetadata table : this.getKeyspace().getTables().values()) {
            String tableName = table.getName().asInternal();
            builder.put((Object)tableName, (Object)new CassandraTable(this, this.keyspace, tableName));
            for (ViewMetadata view : this.getKeyspace().getViewsOnTable(table.getName()).values()) {
                String viewName = view.getName().asInternal();
                builder.put((Object)viewName, (Object)new CassandraTable(this, this.keyspace, viewName, true));
            }
        }
        return builder.build();
    }

    private KeyspaceMetadata getKeyspace() {
        return (KeyspaceMetadata)this.session.getMetadata().getKeyspace(this.keyspace).orElseThrow(() -> new RuntimeException("Keyspace " + this.keyspace + " not found"));
    }

    private static /* synthetic */ Pair lambda$getRelDataType$2(RelDataTypeFactory typeFactory, List typeArgs, int i) {
        return new Pair((Object)Integer.toString(i + 1), (Object)typeFactory.createSqlType(CQL_TO_SQL_TYPE.lookup((DataType)typeArgs.get(i))));
    }
}

