/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.arrow;

import java.io.File;
import java.util.Map;
import org.apache.calcite.adapter.arrow.ArrowSchema;
import org.apache.calcite.model.ModelHandler;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;

public class ArrowSchemaFactory
implements SchemaFactory {
    public Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
        File baseDirectory = (File)operand.get(ModelHandler.ExtraOperand.BASE_DIRECTORY.camelName);
        String directory = (String)operand.get("directory");
        File directoryFile = null;
        if (directory != null) {
            directoryFile = new File(directory);
        }
        if (baseDirectory != null) {
            if (directoryFile == null) {
                directoryFile = baseDirectory;
            } else if (!directoryFile.isAbsolute()) {
                directoryFile = new File(baseDirectory, directoryFile.getPath());
            }
        }
        if (directoryFile == null) {
            throw new RuntimeException("no directory");
        }
        return new ArrowSchema(directoryFile);
    }
}

