/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.arrow;

import java.util.List;
import java.util.Objects;
import org.apache.calcite.adapter.arrow.ArrowRel;
import org.apache.calcite.adapter.arrow.ArrowTranslator;
import org.apache.calcite.plan.RelOptCluster;
import org.apache.calcite.plan.RelOptCost;
import org.apache.calcite.plan.RelOptPlanner;
import org.apache.calcite.plan.RelTraitSet;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rel.core.Filter;
import org.apache.calcite.rel.metadata.RelMetadataQuery;
import org.apache.calcite.rex.RexNode;

class ArrowFilter
extends Filter
implements ArrowRel {
    private final List<String> match;

    ArrowFilter(RelOptCluster cluster, RelTraitSet traitSet, RelNode input, RexNode condition) {
        super(cluster, traitSet, input, condition);
        ArrowTranslator translator = ArrowTranslator.create(cluster.getRexBuilder(), input.getRowType());
        this.match = translator.translateMatch(condition);
        assert (this.getConvention() == ArrowRel.CONVENTION);
        assert (this.getConvention() == input.getConvention());
    }

    public RelOptCost computeSelfCost(RelOptPlanner planner, RelMetadataQuery mq) {
        RelOptCost cost = super.computeSelfCost(planner, mq);
        return Objects.requireNonNull(cost, "cost").multiplyBy(0.1);
    }

    public ArrowFilter copy(RelTraitSet traitSet, RelNode input, RexNode condition) {
        return new ArrowFilter(this.getCluster(), traitSet, input, condition);
    }

    @Override
    public void implement(ArrowRel.Implementor implementor) {
        implementor.visitInput(0, this.getInput());
        implementor.addFilters(this.match);
    }
}

