/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.arrow;

import org.apache.arrow.gandiva.evaluator.Filter;
import org.apache.arrow.gandiva.evaluator.Projector;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.calcite.adapter.arrow.ArrowFilterEnumerator;
import org.apache.calcite.adapter.arrow.ArrowProjectEnumerator;
import org.apache.calcite.linq4j.AbstractEnumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

class ArrowEnumerable
extends AbstractEnumerable<Object> {
    private final ArrowFileReader arrowFileReader;
    private final ImmutableIntList fields;
    private final @Nullable Projector projector;
    private final @Nullable Filter filter;

    ArrowEnumerable(ArrowFileReader arrowFileReader, ImmutableIntList fields, @Nullable Projector projector, @Nullable Filter filter) {
        this.arrowFileReader = arrowFileReader;
        this.projector = projector;
        this.filter = filter;
        this.fields = fields;
    }

    public Enumerator<Object> enumerator() {
        try {
            if (this.projector != null) {
                return new ArrowProjectEnumerator(this.arrowFileReader, this.fields, this.projector);
            }
            if (this.filter != null) {
                return new ArrowFilterEnumerator(this.arrowFileReader, this.fields, this.filter);
            }
            throw new IllegalArgumentException("The arrow enumerator must have either a filter or a projection");
        }
        catch (Exception e) {
            throw Util.toUnchecked((Exception)e);
        }
    }
}

