/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.arrow;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.apache.arrow.vector.ValueVector;
import org.apache.arrow.vector.VectorSchemaRoot;
import org.apache.arrow.vector.VectorUnloader;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Util;

abstract class AbstractArrowEnumerator
implements Enumerator<Object> {
    protected final ArrowFileReader arrowFileReader;
    protected final List<Integer> fields;
    protected final List<ValueVector> valueVectors;
    protected int currRowIndex;
    protected int rowCount;

    AbstractArrowEnumerator(ArrowFileReader arrowFileReader, ImmutableIntList fields) {
        this.arrowFileReader = arrowFileReader;
        this.fields = fields;
        this.valueVectors = new ArrayList<ValueVector>(fields.size());
        this.currRowIndex = -1;
    }

    abstract void evaluateOperator(ArrowRecordBatch var1);

    protected void loadNextArrowBatch() {
        try {
            VectorSchemaRoot vsr = this.arrowFileReader.getVectorSchemaRoot();
            for (int i : this.fields) {
                this.valueVectors.add((ValueVector)vsr.getVector(i));
            }
            this.rowCount = vsr.getRowCount();
            VectorUnloader vectorUnloader = new VectorUnloader(vsr);
            ArrowRecordBatch arrowRecordBatch = vectorUnloader.getRecordBatch();
            this.evaluateOperator(arrowRecordBatch);
        }
        catch (IOException e) {
            throw Util.toUnchecked((Exception)e);
        }
    }

    public Object current() {
        if (this.fields.size() == 1) {
            return this.valueVectors.get(0).getObject(this.currRowIndex);
        }
        Object[] current = new Object[this.valueVectors.size()];
        for (int i = 0; i < this.valueVectors.size(); ++i) {
            ValueVector vector = this.valueVectors.get(i);
            current[i] = vector.getObject(this.currRowIndex);
        }
        return current;
    }

    public void reset() {
        throw new UnsupportedOperationException();
    }
}

