/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.arrow;

import java.io.IOException;
import java.util.Objects;
import org.apache.arrow.gandiva.evaluator.Filter;
import org.apache.arrow.gandiva.evaluator.SelectionVector;
import org.apache.arrow.gandiva.evaluator.SelectionVectorInt16;
import org.apache.arrow.gandiva.exceptions.GandivaException;
import org.apache.arrow.memory.ArrowBuf;
import org.apache.arrow.memory.BufferAllocator;
import org.apache.arrow.memory.RootAllocator;
import org.apache.arrow.vector.ipc.ArrowFileReader;
import org.apache.arrow.vector.ipc.message.ArrowRecordBatch;
import org.apache.calcite.adapter.arrow.AbstractArrowEnumerator;
import org.apache.calcite.util.ImmutableIntList;
import org.apache.calcite.util.Util;
import org.checkerframework.checker.nullness.qual.Nullable;

class ArrowFilterEnumerator
extends AbstractArrowEnumerator {
    private final BufferAllocator allocator = new RootAllocator(Long.MAX_VALUE);
    private final Filter filter;
    private @Nullable ArrowBuf buf;
    private @Nullable SelectionVector selectionVector;
    private int selectionVectorIndex;

    ArrowFilterEnumerator(ArrowFileReader arrowFileReader, ImmutableIntList fields, Filter filter) {
        super(arrowFileReader, fields);
        this.filter = filter;
    }

    @Override
    void evaluateOperator(ArrowRecordBatch arrowRecordBatch) {
        try {
            this.buf = this.allocator.buffer((long)this.rowCount * 2L);
            this.selectionVector = new SelectionVectorInt16(this.buf);
            this.filter.evaluate(arrowRecordBatch, this.selectionVector);
        }
        catch (GandivaException e) {
            throw Util.toUnchecked((Exception)((Object)e));
        }
    }

    public boolean moveNext() {
        if (this.selectionVector == null || this.selectionVectorIndex >= this.selectionVector.getRecordCount()) {
            boolean hasNextBatch;
            block4: {
                do {
                    try {
                        hasNextBatch = this.arrowFileReader.loadNextBatch();
                    }
                    catch (IOException e) {
                        throw Util.toUnchecked((Exception)e);
                    }
                    if (!hasNextBatch) break block4;
                    this.selectionVectorIndex = 0;
                    this.valueVectors.clear();
                    this.loadNextArrowBatch();
                    Objects.requireNonNull(this.selectionVector, "selectionVector");
                } while (this.selectionVectorIndex >= this.selectionVector.getRecordCount());
                this.currRowIndex = this.selectionVector.getIndex(this.selectionVectorIndex++);
            }
            return hasNextBatch;
        }
        this.currRowIndex = this.selectionVector.getIndex(this.selectionVectorIndex++);
        return true;
    }

    public void close() {
        try {
            if (this.buf != null) {
                this.buf.close();
            }
            this.filter.close();
        }
        catch (GandivaException e) {
            throw Util.toUnchecked((Exception)((Object)e));
        }
    }
}

