/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.xml;

import com.thoughtworks.xstream.annotations.XStreamImplicit;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.apache.bval.model.FeaturesCapable;
import org.apache.bval.xml.XMLMetaFeature;
import org.apache.bval.xml.XMLMetaValidatorReference;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XMLFeaturesCapable
implements Serializable {
    private static final long serialVersionUID = 1L;
    @XStreamImplicit
    private List<XMLMetaFeature> features;
    @XStreamImplicit(itemFieldName="validator")
    private List<XMLMetaValidatorReference> validators;

    public List<XMLMetaFeature> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<XMLMetaFeature> features) {
        this.features = features;
    }

    public void putFeature(String key, Object value) {
        XMLMetaFeature anno = this.findFeature(key);
        if (this.features == null) {
            this.features = new ArrayList<XMLMetaFeature>();
        }
        if (anno == null) {
            this.features.add(new XMLMetaFeature(key, value));
        } else {
            anno.setValue(value);
        }
    }

    public void removeFeature(String key) {
        XMLMetaFeature anno = this.findFeature(key);
        if (anno != null) {
            this.getFeatures().remove(anno);
        }
    }

    public Object getFeature(String key) {
        XMLMetaFeature anno = this.findFeature(key);
        return anno == null ? null : anno.getValue();
    }

    private XMLMetaFeature findFeature(String key) {
        if (this.features == null) {
            return null;
        }
        for (XMLMetaFeature anno : this.features) {
            if (!key.equals(anno.getKey())) continue;
            return anno;
        }
        return null;
    }

    public List<XMLMetaValidatorReference> getValidators() {
        return this.validators;
    }

    public void setValidators(List<XMLMetaValidatorReference> validators) {
        this.validators = validators;
    }

    public void addValidator(String validatorId) {
        if (this.validators == null) {
            this.validators = new ArrayList<XMLMetaValidatorReference>();
        }
        this.validators.add(new XMLMetaValidatorReference(validatorId));
    }

    public void mergeFeaturesInto(FeaturesCapable fc) {
        if (this.getFeatures() != null) {
            fc.optimizeRead(false);
            for (XMLMetaFeature each : this.getFeatures()) {
                fc.putFeature(each.getKey(), each.getValue());
            }
            fc.optimizeRead(true);
        }
    }
}

