/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.routines;

import java.util.Collection;
import java.util.Date;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import org.apache.bval.model.MetaProperty;
import org.apache.bval.model.Validation;
import org.apache.bval.model.ValidationContext;
import org.apache.bval.model.ValidationListener;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class StandardValidation
implements Validation {
    private static final String REG_EXP_PATTERN = "cachedRegExpPattern";

    public String getValidationId() {
        return "standard";
    }

    public <T extends ValidationListener> void validate(ValidationContext<T> context) {
        this.validateMandatory(context);
        this.validateMaxLength(context);
        this.validateMinLength(context);
        this.validateMaxValue(context);
        this.validateMinValue(context);
        this.validateRegExp(context);
        this.validateTimeLag(context);
    }

    protected <T extends ValidationListener> void validateTimeLag(ValidationContext<T> context) {
        String lag = (String)context.getMetaProperty().getFeature("timeLag");
        if (lag == null) {
            return;
        }
        if (context.getPropertyValue() == null) {
            return;
        }
        long date = ((Date)context.getPropertyValue()).getTime();
        long now = System.currentTimeMillis();
        if ("FUTURE".equals(lag)) {
            if (date < now) {
                context.getListener().addError("timeLag", context);
            }
        } else if ("PAST".equals(lag)) {
            if (date > now) {
                context.getListener().addError("timeLag", context);
            }
        } else {
            throw new IllegalArgumentException("unknown timelag " + lag + " at " + context);
        }
    }

    protected <T extends ValidationListener> void validateRegExp(ValidationContext<T> context) {
        MetaProperty meta = context.getMetaProperty();
        String regExp = (String)meta.getFeature("regExp");
        if (regExp == null) {
            return;
        }
        if (context.getPropertyValue() == null) {
            return;
        }
        String value = String.valueOf(context.getPropertyValue());
        try {
            Pattern pattern = (Pattern)meta.getFeature(REG_EXP_PATTERN);
            if (pattern == null) {
                pattern = Pattern.compile(regExp);
                meta.putFeature(REG_EXP_PATTERN, (Object)pattern);
            }
            if (!pattern.matcher(value).matches()) {
                context.getListener().addError("regExp", context);
            }
        }
        catch (PatternSyntaxException e) {
            throw new IllegalArgumentException("regular expression malformed. regexp " + regExp + " at " + context, e);
        }
    }

    protected <T extends ValidationListener> void validateMinValue(ValidationContext<T> context) {
        Comparable minValue = (Comparable)context.getMetaProperty().getFeature("minValue");
        if (minValue == null || context.getPropertyValue() == null) {
            return;
        }
        if (this.compare(context, minValue, context.getPropertyValue()) > 0) {
            context.getListener().addError("minValue", context);
        }
    }

    protected <T extends ValidationListener> void validateMaxValue(ValidationContext<T> context) {
        Comparable maxValue = (Comparable)context.getMetaProperty().getFeature("maxValue");
        if (maxValue == null || context.getPropertyValue() == null) {
            return;
        }
        if (this.compare(context, maxValue, context.getPropertyValue()) < 0) {
            context.getListener().addError("maxValue", context);
        }
    }

    private <T extends ValidationListener> int compare(ValidationContext<T> context, Comparable<Object> constraintValue, Object currentValue) {
        int r;
        if (constraintValue.getClass().isAssignableFrom(currentValue.getClass())) {
            r = constraintValue.compareTo(context.getPropertyValue());
        } else if (currentValue instanceof Number) {
            double dv = ((Number)currentValue).doubleValue();
            double mdv = ((Number)((Object)constraintValue)).doubleValue();
            r = mdv > dv ? 1 : -1;
        } else {
            r = String.valueOf(constraintValue).compareTo(String.valueOf(currentValue));
        }
        return r;
    }

    protected <T extends ValidationListener> void validateMaxLength(ValidationContext<T> context) {
        Integer maxLength = (Integer)context.getMetaProperty().getFeature("maxLen");
        if (maxLength == null) {
            return;
        }
        if (context.getPropertyValue() == null) {
            return;
        }
        Object value = context.getPropertyValue();
        int length = 0;
        if (value instanceof String) {
            length = ((String)value).length();
        } else if (value instanceof Collection) {
            length = ((Collection)value).size();
        }
        if (length > maxLength) {
            context.getListener().addError("maxLen", context);
        }
    }

    protected <T extends ValidationListener> void validateMinLength(ValidationContext<T> context) {
        Integer maxLength = (Integer)context.getMetaProperty().getFeature("minLen");
        if (maxLength == null) {
            return;
        }
        if (context.getPropertyValue() == null) {
            return;
        }
        Object value = context.getPropertyValue();
        int length = 0;
        if (value instanceof String) {
            length = ((String)value).length();
        } else if (value instanceof Collection) {
            length = ((Collection)value).size();
        }
        if (length < maxLength) {
            context.getListener().addError("minLen", context);
        }
    }

    protected <T extends ValidationListener> void validateMandatory(ValidationContext<T> context) {
        if (context.getMetaProperty().isMandatory() && context.getPropertyValue() == null) {
            context.getListener().addError("mandatory", context);
        }
    }

    public static StandardValidation getInstance() {
        return new StandardValidation();
    }
}

