/*
 * Decompiled with CFR 0.152.
 */
package org.apache.bval.extras.constraints.checkdigit;

import javax.validation.ConstraintValidator;
import javax.validation.ConstraintValidatorContext;
import org.apache.bval.extras.constraints.checkdigit.IBAN;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class IBANValidator
implements ConstraintValidator<IBAN, String> {
    private static final long MAX = 999999999L;
    private static final long MODULUS = 97L;

    public boolean isValid(String code, ConstraintValidatorContext context) {
        if (code.length() < 5) {
            return false;
        }
        String reformattedCode = code.substring(4) + code.substring(0, 4);
        long total = 0L;
        for (int i = 0; i < reformattedCode.length(); ++i) {
            int charValue = Character.getNumericValue(reformattedCode.charAt(i));
            if (charValue < 0 || charValue > 35) {
                return false;
            }
            total = (charValue > 9 ? total * 100L : total * 10L) + (long)charValue;
            if (total <= 999999999L) continue;
            total %= 97L;
        }
        return total % 97L == 1L;
    }

    public void initialize(IBAN iban) {
    }
}

