/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.xml;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.ValidationEventHandler;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.CompressedSource;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.ReadAllViaFileBasedSource;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.xml.AutoValue_XmlIO_MappingConfiguration;
import org.apache.beam.sdk.io.xml.AutoValue_XmlIO_Read;
import org.apache.beam.sdk.io.xml.AutoValue_XmlIO_ReadFiles;
import org.apache.beam.sdk.io.xml.AutoValue_XmlIO_Sink;
import org.apache.beam.sdk.io.xml.AutoValue_XmlIO_Write;
import org.apache.beam.sdk.io.xml.JAXBCoder;
import org.apache.beam.sdk.io.xml.XmlSource;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v32_1_2_jre.com.google.common.base.Preconditions;
import org.checkerframework.checker.initialization.qual.Initialized;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.checkerframework.checker.nullness.qual.UnknownKeyFor;

public class XmlIO {
    public static <T> @UnknownKeyFor @NonNull @Initialized Read<T> read() {
        return new AutoValue_XmlIO_Read.Builder().setConfiguration(new AutoValue_XmlIO_MappingConfiguration.Builder().setCharset(StandardCharsets.UTF_8.name()).build()).setMinBundleSize(1L).setCompression(Compression.AUTO).build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized ReadFiles<T> readFiles() {
        return new AutoValue_XmlIO_ReadFiles.Builder().setConfiguration(new AutoValue_XmlIO_MappingConfiguration.Builder().setCharset(StandardCharsets.UTF_8.name()).build()).build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Write<T> write() {
        return new AutoValue_XmlIO_Write.Builder().setCharset(StandardCharsets.UTF_8.name()).build();
    }

    public static <T> @UnknownKeyFor @NonNull @Initialized Sink<T> sink(@UnknownKeyFor @NonNull @Initialized Class<T> recordClass) {
        return new AutoValue_XmlIO_Sink.Builder<T>().setRecordClass(recordClass).setCharset(StandardCharsets.UTF_8.name()).build();
    }

    @AutoValue
    public static abstract class Sink<@UnknownKeyFor T>
    implements FileIO.Sink<T> {
        private transient @UnknownKeyFor @NonNull @Initialized OutputStream outputStream;
        private transient @UnknownKeyFor @NonNull @Initialized Marshaller marshaller;

        abstract @UnknownKeyFor @NonNull @Initialized Class<T> getRecordClass();

        abstract @Nullable @UnknownKeyFor @Initialized String getRootElement();

        abstract @UnknownKeyFor @NonNull @Initialized String getCharset();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Sink<T> withRootElement(@UnknownKeyFor @NonNull @Initialized String rootElement) {
            return this.toBuilder().setRootElement(rootElement).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Sink<T> withCharset(@UnknownKeyFor @NonNull @Initialized Charset charset) {
            return this.toBuilder().setCharset(charset.name()).build();
        }

        public void open(@UnknownKeyFor @NonNull @Initialized WritableByteChannel channel) throws @UnknownKeyFor @NonNull @Initialized IOException {
            Preconditions.checkArgument((this.getRootElement() != null ? 1 : 0) != 0, (Object)".withRootElement() is required");
            try {
                this.marshaller = JAXBContext.newInstance((Class[])new Class[]{this.getRecordClass()}).createMarshaller();
                this.marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
                this.marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
                this.marshaller.setProperty("jaxb.encoding", (Object)this.getCharset());
            }
            catch (JAXBException e) {
                throw new IOException(e);
            }
            this.outputStream = Channels.newOutputStream(channel);
            this.outputStream.write(("<" + this.getRootElement() + ">\n").getBytes(Charset.forName(this.getCharset())));
        }

        public void write(T element) throws @UnknownKeyFor @NonNull @Initialized IOException {
            try {
                this.marshaller.marshal(element, this.outputStream);
            }
            catch (JAXBException e) {
                throw new IOException(e);
            }
        }

        public void flush() throws @UnknownKeyFor @NonNull @Initialized IOException {
            this.outputStream.write(("\n</" + this.getRootElement() + ">").getBytes(Charset.forName(this.getCharset())));
            this.outputStream.flush();
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setRecordClass(@UnknownKeyFor @NonNull @Initialized Class<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setRootElement(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCharset(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Sink<T> build();
        }
    }

    @AutoValue
    public static abstract class Write<@UnknownKeyFor T>
    extends PTransform<PCollection<T>, PDone> {
        abstract @Nullable @UnknownKeyFor @Initialized String getFilenamePrefix();

        abstract @Nullable @UnknownKeyFor @Initialized Class<T> getRecordClass();

        abstract @Nullable @UnknownKeyFor @Initialized String getRootElement();

        abstract @Nullable @UnknownKeyFor @Initialized String getCharset();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Write<T> to(@UnknownKeyFor @NonNull @Initialized String filenamePrefix) {
            return this.toBuilder().setFilenamePrefix(filenamePrefix).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withRecordClass(@UnknownKeyFor @NonNull @Initialized Class<T> recordClass) {
            return this.toBuilder().setRecordClass(recordClass).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withRootElement(@UnknownKeyFor @NonNull @Initialized String rootElement) {
            return this.toBuilder().setRootElement(rootElement).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Write<T> withCharset(@UnknownKeyFor @NonNull @Initialized Charset charset) {
            return this.toBuilder().setCharset(charset.name()).build();
        }

        public @UnknownKeyFor @NonNull @Initialized PDone expand(@UnknownKeyFor @NonNull @Initialized PCollection<T> input) {
            Preconditions.checkArgument((this.getRecordClass() != null ? 1 : 0) != 0, (Object)"withRecordClass() is required");
            Preconditions.checkArgument((this.getRootElement() != null ? 1 : 0) != 0, (Object)"withRootElement() is required");
            Preconditions.checkArgument((this.getFilenamePrefix() != null ? 1 : 0) != 0, (Object)"to() is required");
            Preconditions.checkArgument((this.getCharset() != null ? 1 : 0) != 0, (Object)"withCharset() is required");
            try {
                JAXBContext.newInstance((Class[])new Class[]{this.getRecordClass()});
            }
            catch (JAXBException e) {
                throw new RuntimeException("Error binding classes to a JAXB Context.", e);
            }
            ResourceId prefix = FileSystems.matchNewResource((String)this.getFilenamePrefix(), (boolean)false);
            input.apply((PTransform)FileIO.write().via(XmlIO.sink(this.getRecordClass()).withCharset(Charset.forName(this.getCharset())).withRootElement(this.getRootElement())).to(prefix.getCurrentDirectory().toString()).withPrefix(prefix.getFilename()).withSuffix(".xml").withIgnoreWindowing());
            return PDone.in((Pipeline)input.getPipeline());
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            builder.addIfNotNull(DisplayData.item((String)"rootElement", (String)this.getRootElement()).withLabel("XML Root Element")).addIfNotNull(DisplayData.item((String)"recordClass", this.getRecordClass()).withLabel("XML Record Class")).addIfNotNull(DisplayData.item((String)"charset", (String)this.getCharset()).withLabel("Charset"));
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFilenamePrefix(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setRecordClass(@UnknownKeyFor @NonNull @Initialized Class<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setRootElement(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCharset(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Write<T> build();
        }
    }

    private static class CreateSourceFn<@UnknownKeyFor T>
    implements SerializableFunction<String, XmlSource<T>> {
        private final @UnknownKeyFor @NonNull @Initialized MappingConfiguration<T> configuration;

        CreateSourceFn(@UnknownKeyFor @NonNull @Initialized MappingConfiguration<T> configuration) {
            this.configuration = configuration;
        }

        public @UnknownKeyFor @NonNull @Initialized XmlSource<T> apply(@UnknownKeyFor @NonNull @Initialized String input) {
            return new XmlSource<T>((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)input), this.configuration, 1L);
        }
    }

    @AutoValue
    public static abstract class ReadFiles<@UnknownKeyFor T>
    extends PTransform<PCollection<FileIO.ReadableFile>, PCollection<T>> {
        abstract @UnknownKeyFor @NonNull @Initialized MappingConfiguration<T> getConfiguration();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        private @UnknownKeyFor @NonNull @Initialized ReadFiles<T> withConfiguration(@UnknownKeyFor @NonNull @Initialized MappingConfiguration<T> configuration) {
            return this.toBuilder().setConfiguration(configuration).build();
        }

        public @UnknownKeyFor @NonNull @Initialized ReadFiles<T> withRootElement(@UnknownKeyFor @NonNull @Initialized String rootElement) {
            return this.withConfiguration(((MappingConfiguration)this.getConfiguration()).withRootElement(rootElement));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadFiles<T> withRecordElement(@UnknownKeyFor @NonNull @Initialized String recordElement) {
            return this.withConfiguration(((MappingConfiguration)this.getConfiguration()).withRecordElement(recordElement));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadFiles<T> withRecordClass(@UnknownKeyFor @NonNull @Initialized Class<T> recordClass) {
            return this.withConfiguration(((MappingConfiguration)this.getConfiguration()).withRecordClass(recordClass));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadFiles<T> withCharset(@UnknownKeyFor @NonNull @Initialized Charset charset) {
            return this.withConfiguration(((MappingConfiguration)this.getConfiguration()).withCharset(charset));
        }

        public @UnknownKeyFor @NonNull @Initialized ReadFiles<T> withValidationEventHandler(@UnknownKeyFor @NonNull @Initialized ValidationEventHandler validationEventHandler) {
            return this.withConfiguration(((MappingConfiguration)this.getConfiguration()).withValidationEventHandler(validationEventHandler));
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PCollection<// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized FileIO.ReadableFile> input) {
            return (PCollection)input.apply((PTransform)new ReadAllViaFileBasedSource(0x4000000L, new CreateSourceFn<T>(this.getConfiguration()), JAXBCoder.of(this.getConfiguration().getRecordClass())));
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setConfiguration(@UnknownKeyFor @NonNull @Initialized MappingConfiguration<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized ReadFiles<T> build();
        }
    }

    @AutoValue
    public static abstract class Read<@UnknownKeyFor T>
    extends PTransform<PBegin, PCollection<T>> {
        abstract @UnknownKeyFor @NonNull @Initialized MappingConfiguration<T> getConfiguration();

        abstract @Nullable @UnknownKeyFor @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> getFileOrPatternSpec();

        abstract @UnknownKeyFor @NonNull @Initialized Compression getCompression();

        abstract @UnknownKeyFor @NonNull @Initialized long getMinBundleSize();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        public @UnknownKeyFor @NonNull @Initialized Read<T> from(@UnknownKeyFor @NonNull @Initialized String fileOrPatternSpec) {
            return this.from((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)fileOrPatternSpec));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> from(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> fileOrPatternSpec) {
            return this.toBuilder().setFileOrPatternSpec(fileOrPatternSpec).build();
        }

        private @UnknownKeyFor @NonNull @Initialized Read<T> withConfiguration(@UnknownKeyFor @NonNull @Initialized MappingConfiguration<T> configuration) {
            return this.toBuilder().setConfiguration(configuration).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withRootElement(@UnknownKeyFor @NonNull @Initialized String rootElement) {
            return this.withConfiguration(((MappingConfiguration)this.getConfiguration()).withRootElement(rootElement));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withRecordElement(@UnknownKeyFor @NonNull @Initialized String recordElement) {
            return this.withConfiguration(((MappingConfiguration)this.getConfiguration()).withRecordElement(recordElement));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withRecordClass(@UnknownKeyFor @NonNull @Initialized Class<T> recordClass) {
            return this.withConfiguration(((MappingConfiguration)this.getConfiguration()).withRecordClass(recordClass));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withMinBundleSize(@UnknownKeyFor @NonNull @Initialized long minBundleSize) {
            return this.toBuilder().setMinBundleSize(minBundleSize).build();
        }

        @Deprecated
        public @UnknownKeyFor @NonNull @Initialized Read<T> withCompressionType(@UnknownKeyFor @NonNull @Initialized CompressionType compressionType) {
            return this.withCompression(compressionType.canonical);
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withCompression(@UnknownKeyFor @NonNull @Initialized Compression compression) {
            return this.toBuilder().setCompression(compression).build();
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withCharset(@UnknownKeyFor @NonNull @Initialized Charset charset) {
            return this.withConfiguration(((MappingConfiguration)this.getConfiguration()).withCharset(charset));
        }

        public @UnknownKeyFor @NonNull @Initialized Read<T> withValidationEventHandler(@UnknownKeyFor @NonNull @Initialized ValidationEventHandler validationEventHandler) {
            return this.withConfiguration(((MappingConfiguration)this.getConfiguration()).withValidationEventHandler(validationEventHandler));
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            builder.addIfNotDefault(DisplayData.item((String)"minBundleSize", (Long)this.getMinBundleSize()).withLabel("Minimum Bundle Size"), (Object)1L).add(DisplayData.item((String)"filePattern", this.getFileOrPatternSpec()).withLabel("File Pattern")).include("configuration", this.getConfiguration());
        }

        @VisibleForTesting
        @UnknownKeyFor @NonNull @Initialized BoundedSource<T> createSource() {
            return CompressedSource.from(new XmlSource<T>(this.getFileOrPatternSpec(), this.getConfiguration(), 1L)).withCompression(this.getCompression());
        }

        public @UnknownKeyFor @NonNull @Initialized PCollection<T> expand(@UnknownKeyFor @NonNull @Initialized PBegin input) {
            ((MappingConfiguration)this.getConfiguration()).validate();
            return (PCollection)input.apply((PTransform)org.apache.beam.sdk.io.Read.from(this.createSource()));
        }

        @Deprecated
        public static enum CompressionType {
            AUTO(Compression.AUTO),
            UNCOMPRESSED(Compression.UNCOMPRESSED),
            GZIP(Compression.GZIP),
            BZIP2(Compression.BZIP2),
            ZIP(Compression.ZIP),
            DEFLATE(Compression.DEFLATE);

            private final @UnknownKeyFor @NonNull @Initialized Compression canonical;

            private CompressionType(Compression canonical) {
                this.canonical = canonical;
            }

            public @UnknownKeyFor @NonNull @Initialized boolean matches(@UnknownKeyFor @NonNull @Initialized String filename) {
                return this.canonical.matches(filename);
            }
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setConfiguration(@UnknownKeyFor @NonNull @Initialized MappingConfiguration<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setFileOrPatternSpec(@UnknownKeyFor @NonNull @Initialized ValueProvider<@UnknownKeyFor @NonNull @Initialized String> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCompression(@UnknownKeyFor @NonNull @Initialized Compression var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setMinBundleSize(@UnknownKeyFor @NonNull @Initialized long var1);

            abstract @UnknownKeyFor @NonNull @Initialized Read<T> build();
        }
    }

    @AutoValue
    static abstract class MappingConfiguration<@UnknownKeyFor T>
    implements HasDisplayData,
    Serializable {
        MappingConfiguration() {
        }

        abstract @Nullable @UnknownKeyFor @Initialized String getRootElement();

        abstract @Nullable @UnknownKeyFor @Initialized String getRecordElement();

        abstract @Nullable @UnknownKeyFor @Initialized Class<T> getRecordClass();

        abstract @Nullable @UnknownKeyFor @Initialized String getCharset();

        abstract @Nullable @UnknownKeyFor @Initialized ValidationEventHandler getValidationEventHandler();

        abstract @UnknownKeyFor @NonNull @Initialized Builder<T> toBuilder();

        private @UnknownKeyFor @NonNull @Initialized MappingConfiguration<T> withRootElement(@UnknownKeyFor @NonNull @Initialized String rootElement) {
            return this.toBuilder().setRootElement(rootElement).build();
        }

        private @UnknownKeyFor @NonNull @Initialized MappingConfiguration<T> withRecordElement(@UnknownKeyFor @NonNull @Initialized String recordElement) {
            return this.toBuilder().setRecordElement(recordElement).build();
        }

        private @UnknownKeyFor @NonNull @Initialized MappingConfiguration<T> withRecordClass(@UnknownKeyFor @NonNull @Initialized Class<T> recordClass) {
            return this.toBuilder().setRecordClass(recordClass).build();
        }

        private @UnknownKeyFor @NonNull @Initialized MappingConfiguration<T> withCharset(@UnknownKeyFor @NonNull @Initialized Charset charset) {
            return this.toBuilder().setCharset(charset.name()).build();
        }

        private @UnknownKeyFor @NonNull @Initialized MappingConfiguration<T> withValidationEventHandler(@UnknownKeyFor @NonNull @Initialized ValidationEventHandler validationEventHandler) {
            return this.toBuilder().setValidationEventHandler(validationEventHandler).build();
        }

        private void validate() {
            Preconditions.checkArgument((this.getRootElement() != null ? 1 : 0) != 0, (Object)"withRootElement() is required");
            Preconditions.checkArgument((this.getRecordElement() != null ? 1 : 0) != 0, (Object)"withRecordElement() is required");
            Preconditions.checkArgument((this.getRecordClass() != null ? 1 : 0) != 0, (Object)"withRecordClass() is required");
            Preconditions.checkArgument((this.getCharset() != null ? 1 : 0) != 0, (Object)"withCharset() is required");
        }

        public void populateDisplayData(// Could not load outer class - annotation placement on inner may be incorrect
        @UnknownKeyFor @NonNull @Initialized DisplayData.Builder builder) {
            builder.addIfNotNull(DisplayData.item((String)"rootElement", (String)this.getRootElement()).withLabel("XML Root Element")).addIfNotNull(DisplayData.item((String)"recordElement", (String)this.getRecordElement()).withLabel("XML Record Element")).addIfNotNull(DisplayData.item((String)"recordClass", this.getRecordClass()).withLabel("XML Record Class")).addIfNotNull(DisplayData.item((String)"charset", (String)this.getCharset()).withLabel("Charset"));
        }

        @AutoValue.Builder
        static abstract class Builder<@UnknownKeyFor T> {
            Builder() {
            }

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setRootElement(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setRecordElement(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setRecordClass(@UnknownKeyFor @NonNull @Initialized Class<T> var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setCharset(@UnknownKeyFor @NonNull @Initialized String var1);

            abstract @UnknownKeyFor @NonNull @Initialized Builder<T> setValidationEventHandler(@UnknownKeyFor @NonNull @Initialized ValidationEventHandler var1);

            abstract @UnknownKeyFor @NonNull @Initialized MappingConfiguration<T> build();
        }
    }
}

