/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.xml;

import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.Marshaller;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.DefaultFilenamePolicy;
import org.apache.beam.sdk.io.DynamicFileDestinations;
import org.apache.beam.sdk.io.FileBasedSink;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.xml.XmlIO;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.util.CoderUtils;
import org.apache.beam.sdks.java.io.xml.repackaged.com.google.common.annotations.VisibleForTesting;

class XmlSink<T>
extends FileBasedSink<T, Void, T> {
    private static final String XML_EXTENSION = ".xml";
    private final XmlIO.Write<T> spec;

    private static <T> DefaultFilenamePolicy makeFilenamePolicy(XmlIO.Write<T> spec) {
        return DefaultFilenamePolicy.fromStandardParameters(spec.getFilenamePrefix(), (String)"-SSSSS-of-NNNNN", (String)XML_EXTENSION, (boolean)false);
    }

    XmlSink(XmlIO.Write<T> spec) {
        super(spec.getFilenamePrefix(), DynamicFileDestinations.constant((FileBasedSink.FilenamePolicy)XmlSink.makeFilenamePolicy(spec)));
        this.spec = spec;
    }

    public XmlWriteOperation<T> createWriteOperation() {
        return new XmlWriteOperation(this);
    }

    public void populateDisplayData(DisplayData.Builder builder) {
        this.spec.populateDisplayData(builder);
    }

    void populateFileBasedDisplayData(DisplayData.Builder builder) {
        super.populateDisplayData(builder);
    }

    protected static final class XmlWriter<T>
    extends FileBasedSink.Writer<Void, T> {
        final Marshaller marshaller;
        private OutputStream os = null;

        public XmlWriter(XmlWriteOperation<T> writeOperation, Marshaller marshaller) {
            super(writeOperation, "text/plain");
            this.marshaller = marshaller;
        }

        protected void prepareWrite(WritableByteChannel channel) throws Exception {
            this.os = Channels.newOutputStream(channel);
        }

        protected void writeHeader() throws Exception {
            String rootElementName = ((XmlSink)this.getWriteOperation().getSink()).spec.getRootElement();
            this.os.write(CoderUtils.encodeToByteArray((Coder)StringUtf8Coder.of(), (Object)("<" + rootElementName + ">\n")));
        }

        protected void writeFooter() throws Exception {
            String rootElementName = ((XmlSink)this.getWriteOperation().getSink()).spec.getRootElement();
            this.os.write(CoderUtils.encodeToByteArray((Coder)StringUtf8Coder.of(), (Object)("\n</" + rootElementName + ">")));
        }

        public void write(T value) throws Exception {
            this.marshaller.marshal(value, this.os);
        }

        public XmlWriteOperation<T> getWriteOperation() {
            return (XmlWriteOperation)super.getWriteOperation();
        }
    }

    protected static final class XmlWriteOperation<T>
    extends FileBasedSink.WriteOperation<Void, T> {
        public XmlWriteOperation(XmlSink<T> sink) {
            super(sink);
        }

        public XmlWriter<T> createWriter() throws Exception {
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{((XmlSink)this.getSink()).spec.getRecordClass()});
            Marshaller marshaller = context.createMarshaller();
            marshaller.setProperty("jaxb.formatted.output", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.fragment", (Object)Boolean.TRUE);
            marshaller.setProperty("jaxb.encoding", (Object)((XmlSink)this.getSink()).spec.getCharset());
            return new XmlWriter(this, marshaller);
        }

        public XmlSink<T> getSink() {
            return (XmlSink)super.getSink();
        }

        @VisibleForTesting
        ResourceId getTemporaryDirectory() {
            return (ResourceId)this.tempDirectory.get();
        }
    }
}

