/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.tika;

import com.google.auto.value.AutoValue;
import java.io.InputStream;
import java.nio.channels.Channels;
import javax.annotation.Nullable;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.tika.AutoValue_TikaIO_Parse;
import org.apache.beam.sdk.io.tika.AutoValue_TikaIO_ParseFiles;
import org.apache.beam.sdk.io.tika.ParseResult;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.ToTextContentHandler;
import org.xml.sax.ContentHandler;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class TikaIO {
    public static Parse parse() {
        return new AutoValue_TikaIO_Parse.Builder().build();
    }

    public static ParseFiles parseFiles() {
        return new AutoValue_TikaIO_ParseFiles.Builder().build();
    }

    @AutoValue
    public static abstract class ParseFiles
    extends PTransform<PCollection<FileIO.ReadableFile>, PCollection<ParseResult>> {
        @Nullable
        abstract ValueProvider<String> getTikaConfigPath();

        @Nullable
        abstract String getContentTypeHint();

        @Nullable
        abstract Metadata getInputMetadata();

        abstract Builder toBuilder();

        public ParseFiles withTikaConfigPath(String tikaConfigPath) {
            Preconditions.checkArgument((tikaConfigPath != null ? 1 : 0) != 0, (Object)"tikaConfigPath can not be null.");
            return this.withTikaConfigPath((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)tikaConfigPath));
        }

        public ParseFiles withTikaConfigPath(ValueProvider<String> tikaConfigPath) {
            Preconditions.checkArgument((tikaConfigPath != null ? 1 : 0) != 0, (Object)"tikaConfigPath can not be null.");
            return this.toBuilder().setTikaConfigPath(tikaConfigPath).build();
        }

        public ParseFiles withContentTypeHint(String contentTypeHint) {
            Preconditions.checkNotNull((Object)contentTypeHint, (Object)"contentTypeHint can not be null.");
            return this.toBuilder().setContentTypeHint(contentTypeHint).build();
        }

        public ParseFiles withInputMetadata(Metadata metadata) {
            Metadata inputMetadata = this.getInputMetadata();
            if (inputMetadata != null) {
                for (String name : metadata.names()) {
                    inputMetadata.set(name, metadata.get(name));
                }
            } else {
                inputMetadata = metadata;
            }
            return this.toBuilder().setInputMetadata(inputMetadata).build();
        }

        public PCollection<ParseResult> expand(PCollection<FileIO.ReadableFile> input) {
            return (PCollection)input.apply((PTransform)ParDo.of((DoFn)new ParseToStringFn(this)));
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            Metadata metadata;
            super.populateDisplayData(builder);
            if (this.getTikaConfigPath() != null) {
                builder.add(DisplayData.item((String)"tikaConfigPath", this.getTikaConfigPath()).withLabel("TikaConfig Path"));
            }
            if ((metadata = this.getInputMetadata()) != null) {
                builder.add(DisplayData.item((String)"inputMetadata", (String)metadata.toString().trim()).withLabel("Input Metadata"));
            }
            builder.addIfNotNull(DisplayData.item((String)"contentTypeHint", (String)this.getContentTypeHint()).withLabel("Content type hint"));
        }

        private static class ParseToStringFn
        extends DoFn<FileIO.ReadableFile, ParseResult> {
            private final ParseFiles spec;
            private transient TikaConfig tikaConfig;

            ParseToStringFn(ParseFiles spec) {
                this.spec = spec;
            }

            @DoFn.Setup
            public void setup() throws Exception {
                if (this.spec.getTikaConfigPath() != null) {
                    ResourceId configResource = FileSystems.matchSingleFileSpec((String)((String)this.spec.getTikaConfigPath().get())).resourceId();
                    this.tikaConfig = new TikaConfig(Channels.newInputStream(FileSystems.open((ResourceId)configResource)));
                }
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws Exception {
                FileIO.ReadableFile file = (FileIO.ReadableFile)c.element();
                InputStream stream = Channels.newInputStream(file.open());
                try (TikaInputStream tikaStream = TikaInputStream.get((InputStream)stream);){
                    ParseResult res;
                    Metadata tikaMetadata;
                    AutoDetectParser parser = this.tikaConfig == null ? new AutoDetectParser() : new AutoDetectParser(this.tikaConfig);
                    ParseContext context = new ParseContext();
                    context.set(Parser.class, (Object)parser);
                    Metadata metadata = tikaMetadata = this.spec.getInputMetadata() != null ? this.spec.getInputMetadata() : new Metadata();
                    if (this.spec.getContentTypeHint() != null) {
                        tikaMetadata.set("Content-Type", this.spec.getContentTypeHint());
                    }
                    String location = file.getMetadata().resourceId().toString();
                    ToTextContentHandler tikaHandler = new ToTextContentHandler();
                    try {
                        parser.parse((InputStream)tikaStream, (ContentHandler)tikaHandler, tikaMetadata, context);
                        res = ParseResult.success(location, tikaHandler.toString(), tikaMetadata);
                    }
                    catch (Exception e) {
                        res = ParseResult.failure(location, tikaHandler.toString(), tikaMetadata, e);
                    }
                    c.output((Object)res);
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setTikaConfigPath(ValueProvider<String> var1);

            abstract Builder setContentTypeHint(String var1);

            abstract Builder setInputMetadata(Metadata var1);

            abstract ParseFiles build();
        }
    }

    @AutoValue
    public static abstract class Parse
    extends PTransform<PBegin, PCollection<ParseResult>> {
        @Nullable
        abstract ValueProvider<String> getFilepattern();

        abstract Builder toBuilder();

        public Parse filepattern(String filepattern) {
            return this.filepattern((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)filepattern));
        }

        public Parse filepattern(ValueProvider<String> filepattern) {
            return this.toBuilder().setFilepattern(filepattern).build();
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"filePattern", this.getFilepattern()).withLabel("File Pattern"));
        }

        public PCollection<ParseResult> expand(PBegin input) {
            return (PCollection)((PCollection)((PCollection)input.apply((PTransform)FileIO.match().filepattern(this.getFilepattern()))).apply((PTransform)FileIO.readMatches().withCompression(Compression.UNCOMPRESSED))).apply((PTransform)TikaIO.parseFiles());
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setFilepattern(ValueProvider<String> var1);

            abstract Parse build();
        }
    }
}

