/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake;

import org.apache.beam.sdk.options.Default;
import org.apache.beam.sdk.options.Description;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.options.StreamingOptions;
import org.apache.beam.sdk.options.Validation;
import org.apache.beam.sdk.options.ValueProvider;

public interface SnowflakePipelineOptions
extends PipelineOptions,
StreamingOptions {
    public static final String BASIC_CONNECTION_INFO_VALIDATION_GROUP = "BASIC_CONNECTION_INFO_GROUP";
    public static final String AUTH_VALIDATION_GROUP = "AUTH_VALIDATION_GROUP";

    @Description(value="Snowflake's JDBC-like url including account name and region without any parameters.")
    @Validation.Required(groups={"BASIC_CONNECTION_INFO_GROUP"})
    public String getUrl();

    public void setUrl(String var1);

    @Description(value="Server Name - full server name with account, zone and domain.")
    @Validation.Required(groups={"BASIC_CONNECTION_INFO_GROUP"})
    public ValueProvider<String> getServerName();

    public void setServerName(ValueProvider<String> var1);

    @Description(value="Username. Required for username/password and Private Key authentication.")
    @Validation.Required(groups={"AUTH_VALIDATION_GROUP"})
    public ValueProvider<String> getUsername();

    public void setUsername(ValueProvider<String> var1);

    @Description(value="OAuth token. Required for OAuth authentication only.")
    @Validation.Required(groups={"AUTH_VALIDATION_GROUP"})
    public String getOauthToken();

    public void setOauthToken(String var1);

    @Description(value="Password. Required for username/password authentication only.")
    @Default.String(value="")
    public ValueProvider<String> getPassword();

    public void setPassword(ValueProvider<String> var1);

    @Description(value="Path to Private Key file. Required for Private Key authentication only.")
    @Default.String(value="")
    public String getPrivateKeyPath();

    public void setPrivateKeyPath(String var1);

    @Description(value="Private key. Required for Private Key authentication only.")
    @Default.String(value="")
    public ValueProvider<String> getRawPrivateKey();

    public void setRawPrivateKey(ValueProvider<String> var1);

    @Description(value="Private Key's passphrase. Required for Private Key authentication only.")
    @Default.String(value="")
    public ValueProvider<String> getPrivateKeyPassphrase();

    public void setPrivateKeyPassphrase(ValueProvider<String> var1);

    @Description(value="Warehouse to use. Optional.")
    @Default.String(value="")
    public ValueProvider<String> getWarehouse();

    public void setWarehouse(ValueProvider<String> var1);

    @Description(value="Database name to connect to. Optional.")
    @Default.String(value="")
    @Validation.Required
    public ValueProvider<String> getDatabase();

    public void setDatabase(ValueProvider<String> var1);

    @Description(value="Schema to use. Optional.")
    @Default.String(value="")
    public ValueProvider<String> getSchema();

    public void setSchema(ValueProvider<String> var1);

    @Description(value="Table to use. Optional.")
    @Default.String(value="")
    public ValueProvider<String> getTable();

    public void setTable(ValueProvider<String> var1);

    @Description(value="Query to use. Optional.")
    @Default.String(value="")
    public ValueProvider<String> getQuery();

    public void setQuery(ValueProvider<String> var1);

    @Description(value="Role to use. Optional.")
    @Default.String(value="")
    public ValueProvider<String> getRole();

    public void setRole(ValueProvider<String> var1);

    @Description(value="Authenticator to use. Optional.")
    @Default.String(value="")
    public String getAuthenticator();

    public void setAuthenticator(String var1);

    @Description(value="Port number. Optional.")
    @Default.String(value="")
    public String getPortNumber();

    public void setPortNumber(String var1);

    @Description(value="Login timeout. Optional.")
    @Default.String(value="")
    public String getLoginTimeout();

    public void setLoginTimeout(String var1);

    @Description(value="Temporary GCS bucket name.")
    @Validation.Required
    public ValueProvider<String> getStagingBucketName();

    public void setStagingBucketName(ValueProvider<String> var1);

    @Description(value="Storage integration name")
    @Validation.Required
    public ValueProvider<String> getStorageIntegrationName();

    public void setStorageIntegrationName(ValueProvider<String> var1);

    @Description(value="SnowPipe name. Optional.")
    public ValueProvider<String> getSnowPipe();

    public void setSnowPipe(ValueProvider<String> var1);
}

