/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake;

import com.google.auto.value.AutoValue;
import com.opencsv.CSVParser;
import com.opencsv.CSVParserBuilder;
import java.io.IOException;
import java.io.Serializable;
import java.security.PrivateKey;
import java.sql.SQLException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import javax.sql.DataSource;
import net.snowflake.client.jdbc.SnowflakeBasicDataSource;
import net.snowflake.ingest.SimpleIngestManager;
import net.snowflake.ingest.connection.HistoryResponse;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.ListCoder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.Compression;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.FileSystems;
import org.apache.beam.sdk.io.TextIO;
import org.apache.beam.sdk.io.WriteFilesResult;
import org.apache.beam.sdk.io.fs.MoveOptions;
import org.apache.beam.sdk.io.snowflake.AutoValue_SnowflakeIO_DataSourceConfiguration;
import org.apache.beam.sdk.io.snowflake.AutoValue_SnowflakeIO_Read;
import org.apache.beam.sdk.io.snowflake.AutoValue_SnowflakeIO_Write;
import org.apache.beam.sdk.io.snowflake.KeyPairUtils;
import org.apache.beam.sdk.io.snowflake.data.SnowflakeTableSchema;
import org.apache.beam.sdk.io.snowflake.enums.CreateDisposition;
import org.apache.beam.sdk.io.snowflake.enums.StreamingLogLevel;
import org.apache.beam.sdk.io.snowflake.enums.WriteDisposition;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeBatchServiceConfig;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeServices;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeServicesImpl;
import org.apache.beam.sdk.io.snowflake.services.SnowflakeStreamingServiceConfig;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Combine;
import org.apache.beam.sdk.transforms.CombineFnBase;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.MapElements;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.Reify;
import org.apache.beam.sdk.transforms.Reshuffle;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.SimpleFunction;
import org.apache.beam.sdk.transforms.Values;
import org.apache.beam.sdk.transforms.View;
import org.apache.beam.sdk.transforms.Wait;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.display.HasDisplayData;
import org.apache.beam.sdk.transforms.windowing.AfterFirst;
import org.apache.beam.sdk.transforms.windowing.AfterPane;
import org.apache.beam.sdk.transforms.windowing.AfterProcessingTime;
import org.apache.beam.sdk.transforms.windowing.GlobalWindows;
import org.apache.beam.sdk.transforms.windowing.Repeatedly;
import org.apache.beam.sdk.transforms.windowing.Trigger;
import org.apache.beam.sdk.transforms.windowing.Window;
import org.apache.beam.sdk.transforms.windowing.WindowFn;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PCollectionView;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Joiner;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Splitter;
import org.joda.time.Duration;
import org.joda.time.ReadableDuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental
public class SnowflakeIO {
    private static final Logger LOG = LoggerFactory.getLogger(SnowflakeIO.class);
    private static final String CSV_QUOTE_CHAR = "'";
    static final int DEFAULT_FLUSH_ROW_LIMIT = 10000;
    static final int DEFAULT_STREAMING_SHARDS_NUMBER = 1;
    static final int DEFAULT_BATCH_SHARDS_NUMBER = 0;
    static final Duration DEFAULT_FLUSH_TIME_LIMIT = Duration.millis((long)30000L);
    static final Duration DEFAULT_STREAMING_LOGS_MAX_SLEEP = Duration.standardMinutes((long)2L);
    static final Duration DEFAULT_SLEEP_STREAMING_LOGS = Duration.standardSeconds((long)5000L);

    @VisibleForTesting
    public static <T> Read<T> read(SnowflakeServices snowflakeServices) {
        return new AutoValue_SnowflakeIO_Read.Builder().setSnowflakeServices(snowflakeServices).setQuotationMark((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)CSV_QUOTE_CHAR)).build();
    }

    public static <T> Read<T> read() {
        return SnowflakeIO.read(new SnowflakeServicesImpl());
    }

    public static <T> Write<T> write() {
        return new AutoValue_SnowflakeIO_Write.Builder().setFileNameTemplate("output").setCreateDisposition(CreateDisposition.CREATE_IF_NEEDED).setWriteDisposition(WriteDisposition.APPEND).setFlushTimeLimit(DEFAULT_FLUSH_TIME_LIMIT).setShardsNumber(0).setFlushRowLimit(10000).setQuotationMark(CSV_QUOTE_CHAR).build();
    }

    private static String getValueOrNull(ValueProvider<String> valueProvider) {
        return valueProvider != null && valueProvider.get() != null ? (String)valueProvider.get() : null;
    }

    private static boolean isNotEmpty(ValueProvider<String> valueProvider) {
        return valueProvider != null && valueProvider.get() != null && !((String)valueProvider.get()).isEmpty();
    }

    public static class DataSourceProviderFromDataSourceConfiguration
    implements SerializableFunction<Void, DataSource>,
    HasDisplayData {
        private static final ConcurrentHashMap<DataSourceConfiguration, DataSource> instances = new ConcurrentHashMap();
        private final DataSourceConfiguration config;

        private DataSourceProviderFromDataSourceConfiguration(DataSourceConfiguration config) {
            this.config = config;
        }

        public static SerializableFunction<Void, DataSource> of(DataSourceConfiguration config) {
            return new DataSourceProviderFromDataSourceConfiguration(config);
        }

        public DataSource apply(Void input) {
            return instances.computeIfAbsent(this.config, config -> config.buildDatasource());
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            this.config.populateDisplayData(builder);
        }

        public DataSourceConfiguration getConfig() {
            return this.config;
        }
    }

    @AutoValue
    @AutoValue.CopyAnnotations
    public static abstract class DataSourceConfiguration
    implements Serializable {
        @Nullable
        public abstract String getUrl();

        @Nullable
        public abstract ValueProvider<String> getUsername();

        @Nullable
        public abstract ValueProvider<String> getPassword();

        @Nullable
        public abstract PrivateKey getPrivateKey();

        @Nullable
        public abstract ValueProvider<String> getRawPrivateKey();

        @Nullable
        public abstract ValueProvider<String> getPrivateKeyPassphrase();

        @Nullable
        public abstract ValueProvider<String> getOauthToken();

        @Nullable
        public abstract ValueProvider<String> getDatabase();

        @Nullable
        public abstract ValueProvider<String> getWarehouse();

        @Nullable
        public abstract ValueProvider<String> getSchema();

        @Nullable
        public abstract ValueProvider<String> getServerName();

        @Nullable
        public abstract Integer getPortNumber();

        @Nullable
        public abstract ValueProvider<String> getRole();

        @Nullable
        public abstract String getAuthenticator();

        @Nullable
        public abstract Integer getLoginTimeout();

        @Nullable
        public abstract Boolean getSsl();

        @Nullable
        public abstract DataSource getDataSource();

        abstract Builder builder();

        public static DataSourceConfiguration create() {
            return new AutoValue_SnowflakeIO_DataSourceConfiguration.Builder().build();
        }

        public static DataSourceConfiguration create(DataSource dataSource) {
            Preconditions.checkArgument((boolean)(dataSource instanceof Serializable), (Object)"dataSource must be Serializable");
            return new AutoValue_SnowflakeIO_DataSourceConfiguration.Builder().setDataSource(dataSource).build();
        }

        public DataSourceConfiguration withUsernamePasswordAuth(String username, String password) {
            return this.builder().setUsername((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)username)).setPassword((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)password)).build();
        }

        public DataSourceConfiguration withUsernamePasswordAuth(ValueProvider<String> username, ValueProvider<String> password) {
            return this.builder().setUsername(username).setPassword(password).build();
        }

        public DataSourceConfiguration withOAuth(String token) {
            return this.builder().setOauthToken((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)token)).build();
        }

        public DataSourceConfiguration withOAuth(ValueProvider<String> token) {
            return this.builder().setOauthToken(token).build();
        }

        public DataSourceConfiguration withKeyPairAuth(String username, PrivateKey privateKey) {
            return this.builder().setUsername((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)username)).setPrivateKey(privateKey).build();
        }

        public DataSourceConfiguration withKeyPairPathAuth(ValueProvider<String> username, String privateKeyPath, ValueProvider<String> privateKeyPassphrase) {
            String privateKey = KeyPairUtils.readPrivateKeyFile(privateKeyPath);
            return this.builder().setUsername(username).setRawPrivateKey((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)privateKey)).setPrivateKeyPassphrase(privateKeyPassphrase).build();
        }

        public DataSourceConfiguration withKeyPairPathAuth(ValueProvider<String> username, String privateKeyPath) {
            String privateKey = KeyPairUtils.readPrivateKeyFile(privateKeyPath);
            return this.builder().setUsername(username).setRawPrivateKey((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)privateKey)).build();
        }

        public DataSourceConfiguration withKeyPairPathAuth(String username, String privateKeyPath, String privateKeyPassphrase) {
            String privateKey = KeyPairUtils.readPrivateKeyFile(privateKeyPath);
            return this.builder().setUsername((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)username)).setRawPrivateKey((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)privateKey)).setPrivateKeyPassphrase((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)privateKeyPassphrase)).build();
        }

        public DataSourceConfiguration withKeyPairPathAuth(String username, String privateKeyPath) {
            String privateKey = KeyPairUtils.readPrivateKeyFile(privateKeyPath);
            return this.builder().setUsername((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)username)).setRawPrivateKey((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)privateKey)).build();
        }

        public DataSourceConfiguration withKeyPairRawAuth(ValueProvider<String> username, ValueProvider<String> rawPrivateKey, ValueProvider<String> privateKeyPassphrase) {
            return this.builder().setUsername(username).setRawPrivateKey(rawPrivateKey).setPrivateKeyPassphrase(privateKeyPassphrase).build();
        }

        public DataSourceConfiguration withKeyPairRawAuth(ValueProvider<String> username, ValueProvider<String> rawPrivateKey) {
            return this.builder().setUsername(username).setRawPrivateKey(rawPrivateKey).build();
        }

        public DataSourceConfiguration withKeyPairRawAuth(String username, String rawPrivateKey, String privateKeyPassphrase) {
            return this.builder().setUsername((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)username)).setRawPrivateKey((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)rawPrivateKey)).setPrivateKeyPassphrase((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)privateKeyPassphrase)).build();
        }

        public DataSourceConfiguration withKeyPairRawAuth(String username, String rawPrivateKey) {
            return this.builder().setUsername((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)username)).setRawPrivateKey((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)rawPrivateKey)).build();
        }

        public DataSourceConfiguration withUrl(String url) {
            Preconditions.checkArgument((boolean)url.startsWith("jdbc:snowflake://"), (Object)"url must have format: jdbc:snowflake://<account_name>.snowflakecomputing.com");
            Preconditions.checkArgument((boolean)url.endsWith("snowflakecomputing.com"), (Object)"url must have format: jdbc:snowflake://<account_name>.snowflakecomputing.com");
            return this.builder().setUrl(url).build();
        }

        public DataSourceConfiguration withDatabase(String database) {
            return this.builder().setDatabase((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)database)).build();
        }

        public DataSourceConfiguration withDatabase(ValueProvider<String> database) {
            return this.builder().setDatabase(database).build();
        }

        public DataSourceConfiguration withWarehouse(ValueProvider<String> warehouse) {
            return this.builder().setWarehouse(warehouse).build();
        }

        public DataSourceConfiguration withWarehouse(String warehouse) {
            return this.withWarehouse((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)warehouse));
        }

        public DataSourceConfiguration withSchema(String schema) {
            return this.builder().setSchema((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)schema)).build();
        }

        public DataSourceConfiguration withSchema(ValueProvider<String> schema) {
            return this.builder().setSchema(schema).build();
        }

        public DataSourceConfiguration withServerName(String serverName) {
            Preconditions.checkArgument((boolean)serverName.endsWith("snowflakecomputing.com"), (Object)"serverName must be in format <account_name>.snowflakecomputing.com");
            return this.withServerName((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)serverName));
        }

        public DataSourceConfiguration withServerName(ValueProvider<String> serverName) {
            return this.builder().setServerName(serverName).build();
        }

        public DataSourceConfiguration withPortNumber(Integer portNumber) {
            return this.builder().setPortNumber(portNumber).build();
        }

        public DataSourceConfiguration withRole(ValueProvider<String> role) {
            return this.builder().setRole(role).build();
        }

        public DataSourceConfiguration withRole(String role) {
            return this.withRole((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)role));
        }

        public DataSourceConfiguration withAuthenticator(String authenticator) {
            return this.builder().setAuthenticator(authenticator).build();
        }

        public DataSourceConfiguration withLoginTimeout(Integer loginTimeout) {
            return this.builder().setLoginTimeout(loginTimeout).build();
        }

        void populateDisplayData(DisplayData.Builder builder) {
            if (this.getDataSource() != null) {
                builder.addIfNotNull(DisplayData.item((String)"dataSource", (String)this.getDataSource().getClass().getName()));
            } else {
                builder.addIfNotNull(DisplayData.item((String)"jdbcUrl", (String)this.getUrl()));
                builder.addIfNotNull(DisplayData.item((String)"username", this.getUsername()));
            }
        }

        public DataSource buildDatasource() {
            if (this.getDataSource() == null) {
                SnowflakeBasicDataSource basicDataSource = new SnowflakeBasicDataSource();
                basicDataSource.setUrl(this.buildUrl());
                if (SnowflakeIO.isNotEmpty((ValueProvider<String>)this.getOauthToken())) {
                    basicDataSource.setOauthToken((String)this.getOauthToken().get());
                } else if (SnowflakeIO.isNotEmpty((ValueProvider<String>)this.getUsername()) && this.getPrivateKey() != null) {
                    basicDataSource.setUser((String)this.getUsername().get());
                    basicDataSource.setPrivateKey(this.getPrivateKey());
                } else if (SnowflakeIO.isNotEmpty((ValueProvider<String>)this.getUsername()) && SnowflakeIO.isNotEmpty((ValueProvider<String>)this.getRawPrivateKey())) {
                    PrivateKey privateKey = KeyPairUtils.preparePrivateKey((String)this.getRawPrivateKey().get(), SnowflakeIO.getValueOrNull((ValueProvider<String>)this.getPrivateKeyPassphrase()));
                    basicDataSource.setPrivateKey(privateKey);
                    basicDataSource.setUser((String)this.getUsername().get());
                } else if (SnowflakeIO.isNotEmpty((ValueProvider<String>)this.getUsername()) && SnowflakeIO.isNotEmpty((ValueProvider<String>)this.getPassword())) {
                    basicDataSource.setUser((String)this.getUsername().get());
                    basicDataSource.setPassword((String)this.getPassword().get());
                } else {
                    throw new RuntimeException("Missing credentials values. Please check your credentials");
                }
                if (SnowflakeIO.isNotEmpty((ValueProvider<String>)this.getDatabase())) {
                    basicDataSource.setDatabaseName((String)this.getDatabase().get());
                }
                if (SnowflakeIO.isNotEmpty((ValueProvider<String>)this.getWarehouse())) {
                    basicDataSource.setWarehouse((String)this.getWarehouse().get());
                }
                if (SnowflakeIO.isNotEmpty((ValueProvider<String>)this.getSchema())) {
                    basicDataSource.setSchema((String)this.getSchema().get());
                }
                if (SnowflakeIO.isNotEmpty((ValueProvider<String>)this.getServerName())) {
                    basicDataSource.setServerName((String)this.getServerName().get());
                }
                if (this.getPortNumber() != null) {
                    basicDataSource.setPortNumber(this.getPortNumber().intValue());
                }
                if (SnowflakeIO.isNotEmpty((ValueProvider<String>)this.getRole())) {
                    basicDataSource.setRole((String)this.getRole().get());
                }
                if (this.getAuthenticator() != null) {
                    basicDataSource.setAuthenticator(this.getAuthenticator());
                }
                if (this.getLoginTimeout() != null) {
                    try {
                        basicDataSource.setLoginTimeout(this.getLoginTimeout().intValue());
                    }
                    catch (SQLException e) {
                        throw new RuntimeException("Failed to setLoginTimeout");
                    }
                }
                return basicDataSource;
            }
            return this.getDataSource();
        }

        private String buildUrl() {
            StringBuilder url = new StringBuilder();
            if (this.getUrl() != null) {
                url.append(this.getUrl());
            } else {
                url.append("jdbc:snowflake://");
                url.append((String)this.getServerName().get());
            }
            if (this.getPortNumber() != null) {
                url.append(":").append(this.getPortNumber());
            }
            url.append("?application=beam");
            return url.toString();
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setUrl(String var1);

            abstract Builder setUsername(ValueProvider<String> var1);

            abstract Builder setPassword(ValueProvider<String> var1);

            abstract Builder setPrivateKey(PrivateKey var1);

            abstract Builder setRawPrivateKey(ValueProvider<String> var1);

            abstract Builder setPrivateKeyPassphrase(ValueProvider<String> var1);

            abstract Builder setOauthToken(ValueProvider<String> var1);

            abstract Builder setDatabase(ValueProvider<String> var1);

            abstract Builder setWarehouse(ValueProvider<String> var1);

            abstract Builder setSchema(ValueProvider<String> var1);

            abstract Builder setServerName(ValueProvider<String> var1);

            abstract Builder setPortNumber(Integer var1);

            abstract Builder setRole(ValueProvider<String> var1);

            abstract Builder setAuthenticator(String var1);

            abstract Builder setLoginTimeout(Integer var1);

            abstract Builder setSsl(Boolean var1);

            abstract Builder setDataSource(DataSource var1);

            abstract DataSourceConfiguration build();
        }
    }

    private static class StreamToTableFn
    extends DoFn<List<String>, Void> {
        private final SerializableFunction<Void, DataSource> dataSourceProviderFn;
        private final ValueProvider<String> stagingBucketDir;
        private final ValueProvider<String> snowPipe;
        private final StreamingLogLevel debugMode;
        private final SnowflakeServices snowflakeServices;
        private transient SimpleIngestManager ingestManager;
        ArrayList<String> trackedFilesNames;

        StreamToTableFn(SerializableFunction<Void, DataSource> dataSourceProviderFn, ValueProvider<String> snowPipe, ValueProvider<String> stagingBucketDir, StreamingLogLevel debugMode, SnowflakeServices snowflakeServices) {
            this.dataSourceProviderFn = dataSourceProviderFn;
            this.stagingBucketDir = stagingBucketDir;
            this.snowPipe = snowPipe;
            this.debugMode = debugMode;
            this.snowflakeServices = snowflakeServices;
            this.trackedFilesNames = new ArrayList();
        }

        @DoFn.Setup
        public void setup() throws Exception {
            this.dataSourceProviderFn.apply(null);
            DataSourceProviderFromDataSourceConfiguration dataSourceProviderFromDataSourceConfiguration = (DataSourceProviderFromDataSourceConfiguration)this.dataSourceProviderFn;
            DataSourceConfiguration config = dataSourceProviderFromDataSourceConfiguration.getConfig();
            PrivateKey privateKey = null;
            if (config.getPrivateKey() != null) {
                privateKey = config.getPrivateKey();
            } else if (SnowflakeIO.isNotEmpty((ValueProvider<String>)config.getPrivateKeyPassphrase()) && SnowflakeIO.isNotEmpty((ValueProvider<String>)config.getRawPrivateKey())) {
                privateKey = KeyPairUtils.preparePrivateKey((String)config.getRawPrivateKey().get(), (String)config.getPrivateKeyPassphrase().get());
            }
            Preconditions.checkArgument((privateKey != null ? 1 : 0) != 0, (Object)"KeyPair is required for authentication");
            String hostName = (String)config.getServerName().get();
            List path = Splitter.on((char)'.').splitToList((CharSequence)hostName);
            String account = (String)path.get(0);
            String username = (String)config.getUsername().get();
            String schema = (String)config.getSchema().get();
            String database = (String)config.getDatabase().get();
            String snowPipeName = String.format("%s.%s.%s", database, schema, this.snowPipe.get());
            this.ingestManager = new SimpleIngestManager(account, username, snowPipeName, privateKey, "https", hostName, 443);
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) throws Exception {
            List filesList = (List)context.element();
            if (this.debugMode != null) {
                this.trackedFilesNames.addAll(filesList);
            }
            SnowflakeStreamingServiceConfig config = new SnowflakeStreamingServiceConfig(filesList, (String)this.stagingBucketDir.get(), this.ingestManager);
            this.snowflakeServices.getStreamingService().write(config);
        }

        @DoFn.FinishBundle
        public void finishBundle() throws Exception {
            if (this.debugMode != null) {
                String beginMark = null;
                Duration currentSleep = Duration.ZERO;
                while (currentSleep.isShorterThan((ReadableDuration)DEFAULT_STREAMING_LOGS_MAX_SLEEP) && this.trackedFilesNames.size() > 0) {
                    Thread.sleep(DEFAULT_SLEEP_STREAMING_LOGS.getMillis());
                    currentSleep = currentSleep.plus((ReadableDuration)DEFAULT_SLEEP_STREAMING_LOGS);
                    HistoryResponse response = this.ingestManager.getHistory(null, null, beginMark);
                    if (response != null && response.getNextBeginMark() != null) {
                        beginMark = response.getNextBeginMark();
                    }
                    if (response == null || response.files == null) continue;
                    response.files.forEach(entry -> {
                        String responseFileName;
                        if (entry.getPath() != null && entry.isComplete().booleanValue() && this.trackedFilesNames.contains(responseFileName = String.format("'%s%s'", entry.getStageLocation(), entry.getPath()).toLowerCase().replace("gcs://", "gs://"))) {
                            this.trackedFilesNames.remove(responseFileName);
                            if (entry.getErrorsSeen() > 0L) {
                                LOG.error(String.format("Snowflake SnowPipe ERROR: %s", entry.toString()));
                            } else if (entry.getErrorsSeen() == 0L && this.debugMode.equals((Object)StreamingLogLevel.INFO)) {
                                LOG.info(String.format("Snowflake SnowPipe INFO: %s", entry.toString()));
                            }
                        }
                    });
                }
                this.trackedFilesNames.forEach(file -> LOG.info(String.format("File %s was not found in ingest history", file)));
            }
        }
    }

    private static class CopyToTableFn
    extends DoFn<List<String>, Void> {
        private final SerializableFunction<Void, DataSource> dataSourceProviderFn;
        private final ValueProvider<String> table;
        private final ValueProvider<String> database;
        private final ValueProvider<String> schema;
        private final ValueProvider<String> query;
        private final SnowflakeTableSchema tableSchema;
        private final String quotationMark;
        private final ValueProvider<String> stagingBucketDir;
        private final ValueProvider<String> storageIntegrationName;
        private final WriteDisposition writeDisposition;
        private final CreateDisposition createDisposition;
        private final SnowflakeServices snowflakeServices;

        CopyToTableFn(SerializableFunction<Void, DataSource> dataSourceProviderFn, ValueProvider<String> table, ValueProvider<String> query, ValueProvider<String> stagingBucketDir, ValueProvider<String> storageIntegrationName, CreateDisposition createDisposition, WriteDisposition writeDisposition, SnowflakeTableSchema tableSchema, SnowflakeServices snowflakeServices, String quotationMark) {
            this.dataSourceProviderFn = dataSourceProviderFn;
            this.query = query;
            this.table = table;
            this.tableSchema = tableSchema;
            this.stagingBucketDir = stagingBucketDir;
            this.storageIntegrationName = storageIntegrationName;
            this.writeDisposition = writeDisposition;
            this.createDisposition = createDisposition;
            this.snowflakeServices = snowflakeServices;
            this.quotationMark = quotationMark;
            DataSourceProviderFromDataSourceConfiguration dataSourceProviderFromDataSourceConfiguration = (DataSourceProviderFromDataSourceConfiguration)this.dataSourceProviderFn;
            DataSourceConfiguration config = dataSourceProviderFromDataSourceConfiguration.getConfig();
            this.database = config.getDatabase();
            this.schema = config.getSchema();
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) throws Exception {
            String databaseValue = SnowflakeIO.getValueOrNull((ValueProvider<String>)this.database);
            String schemaValue = SnowflakeIO.getValueOrNull((ValueProvider<String>)this.schema);
            String tableValue = SnowflakeIO.getValueOrNull((ValueProvider<String>)this.table);
            String queryValue = SnowflakeIO.getValueOrNull((ValueProvider<String>)this.query);
            SnowflakeBatchServiceConfig config = new SnowflakeBatchServiceConfig(this.dataSourceProviderFn, (List)context.element(), this.tableSchema, databaseValue, schemaValue, tableValue, queryValue, this.createDisposition, this.writeDisposition, (String)this.storageIntegrationName.get(), (String)this.stagingBucketDir.get(), this.quotationMark);
            this.snowflakeServices.getBatchService().write(config);
        }
    }

    private static class MapObjectsArrayToCsvFn
    extends DoFn<Object[], String> {
        private String quotationMark;

        public MapObjectsArrayToCsvFn(String quotationMark) {
            this.quotationMark = quotationMark;
        }

        @DoFn.ProcessElement
        public void processElement(DoFn.ProcessContext context) {
            ArrayList<Object> csvItems = new ArrayList<Object>();
            for (Object o : (Object[])context.element()) {
                if (o instanceof String) {
                    String field = (String)o;
                    field = field.replace(SnowflakeIO.CSV_QUOTE_CHAR, "''");
                    field = this.quoteField(field);
                    csvItems.add(field);
                    continue;
                }
                csvItems.add(o);
            }
            context.output((Object)Joiner.on((String)",").useForNull("").join(csvItems));
        }

        private String quoteField(String field) {
            return this.quoteField(field, this.quotationMark);
        }

        private String quoteField(String field, String quotation) {
            return String.format("%s%s%s", quotation, field, quotation);
        }
    }

    public static class Concatenate
    extends Combine.CombineFn<String, List<String>, List<String>> {
        public List<String> createAccumulator() {
            return new ArrayList<String>();
        }

        public List<String> addInput(List<String> mutableAccumulator, String input) {
            mutableAccumulator.add(String.format("'%s'", input));
            return mutableAccumulator;
        }

        public List<String> mergeAccumulators(Iterable<List<String>> accumulators) {
            Object result = this.createAccumulator();
            for (List<String> accumulator : accumulators) {
                result.addAll(accumulator);
            }
            return result;
        }

        public List<String> extractOutput(List<String> accumulator) {
            return accumulator;
        }
    }

    @AutoValue
    @AutoValue.CopyAnnotations
    public static abstract class Write<T>
    extends PTransform<PCollection<T>, PDone> {
        @Nullable
        abstract SerializableFunction<Void, DataSource> getDataSourceProviderFn();

        @Nullable
        abstract ValueProvider<String> getTable();

        @Nullable
        abstract ValueProvider<String> getStorageIntegrationName();

        @Nullable
        abstract ValueProvider<String> getStagingBucketName();

        @Nullable
        abstract ValueProvider<String> getQuery();

        @Nullable
        abstract ValueProvider<String> getSnowPipe();

        @Nullable
        abstract Integer getFlushRowLimit();

        @Nullable
        abstract Integer getShardsNumber();

        @Nullable
        abstract Duration getFlushTimeLimit();

        @Nullable
        abstract String getFileNameTemplate();

        @Nullable
        abstract WriteDisposition getWriteDisposition();

        @Nullable
        abstract CreateDisposition getCreateDisposition();

        @Nullable
        abstract UserDataMapper<T> getUserDataMapper();

        @Nullable
        abstract SnowflakeTableSchema getTableSchema();

        @Nullable
        abstract SnowflakeServices getSnowflakeServices();

        @Nullable
        abstract String getQuotationMark();

        @Nullable
        abstract StreamingLogLevel getDebugMode();

        abstract Builder<T> toBuilder();

        public Write<T> withDataSourceConfiguration(DataSourceConfiguration config) {
            return this.withDataSourceProviderFn(DataSourceProviderFromDataSourceConfiguration.of(config));
        }

        public Write<T> withDataSourceProviderFn(SerializableFunction<Void, DataSource> dataSourceProviderFn) {
            return this.toBuilder().setDataSourceProviderFn(dataSourceProviderFn).build();
        }

        public Write<T> to(String table) {
            return this.toBuilder().setTable((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)table)).build();
        }

        public Write<T> to(ValueProvider<String> table) {
            return this.toBuilder().setTable(table).build();
        }

        public Write<T> withStagingBucketName(String stagingBucketName) {
            Preconditions.checkArgument((boolean)stagingBucketName.endsWith("/"), (Object)"stagingBucketName must be a cloud storage path ending with /");
            return this.toBuilder().setStagingBucketName((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)stagingBucketName)).build();
        }

        public Write<T> withStagingBucketName(ValueProvider<String> stagingBucketName) {
            return this.toBuilder().setStagingBucketName(stagingBucketName).build();
        }

        public Write<T> withStorageIntegrationName(String integrationName) {
            return this.toBuilder().setStorageIntegrationName((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)integrationName)).build();
        }

        public Write<T> withStorageIntegrationName(ValueProvider<String> integrationName) {
            return this.toBuilder().setStorageIntegrationName(integrationName).build();
        }

        public Write<T> withQueryTransformation(String query) {
            return this.toBuilder().setQuery((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)query)).build();
        }

        public Write<T> withQueryTransformation(ValueProvider<String> query) {
            return this.toBuilder().setQuery(query).build();
        }

        public Write<T> withFileNameTemplate(String fileNameTemplate) {
            return this.toBuilder().setFileNameTemplate(fileNameTemplate).build();
        }

        public Write<T> withUserDataMapper(UserDataMapper<T> userDataMapper) {
            return this.toBuilder().setUserDataMapper(userDataMapper).build();
        }

        public Write<T> withFlushTimeLimit(Duration triggeringFrequency) {
            return this.toBuilder().setFlushTimeLimit(triggeringFrequency).build();
        }

        public Write<T> withSnowPipe(String snowPipe) {
            return this.toBuilder().setSnowPipe((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)snowPipe)).build();
        }

        public Write<T> withSnowPipe(ValueProvider<String> snowPipe) {
            return this.toBuilder().setSnowPipe(snowPipe).build();
        }

        public Write<T> withShardsNumber(Integer shardsNumber) {
            return this.toBuilder().setShardsNumber(shardsNumber).build();
        }

        public Write<T> withFlushRowLimit(Integer rowsCount) {
            return this.toBuilder().setFlushRowLimit(rowsCount).build();
        }

        public Write<T> withWriteDisposition(WriteDisposition writeDisposition) {
            return this.toBuilder().setWriteDisposition(writeDisposition).build();
        }

        public Write<T> withCreateDisposition(CreateDisposition createDisposition) {
            return this.toBuilder().setCreateDisposition(createDisposition).build();
        }

        public Write<T> withTableSchema(SnowflakeTableSchema tableSchema) {
            return this.toBuilder().setTableSchema(tableSchema).build();
        }

        @VisibleForTesting
        public Write<T> withSnowflakeServices(SnowflakeServices snowflakeServices) {
            return this.toBuilder().setSnowflakeServices(snowflakeServices).build();
        }

        public Write<T> withQuotationMark(String quotationMark) {
            return this.toBuilder().setQuotationMark(quotationMark).build();
        }

        public Write<T> withDebugMode(StreamingLogLevel debugLevel) {
            return this.toBuilder().setDebugMode(debugLevel).build();
        }

        public PDone expand(PCollection<T> input) {
            this.checkArguments(input);
            PCollection<Void> out = this.getSnowPipe() != null ? this.writeStream(input, this.getStagingBucketName()) : this.writeBatch(input, this.getStagingBucketName());
            return PDone.in((Pipeline)out.getPipeline());
        }

        private void checkArguments(PCollection<T> input) {
            Preconditions.checkArgument((this.getStagingBucketName() != null ? 1 : 0) != 0, (Object)"withStagingBucketName is required");
            Preconditions.checkArgument((this.getUserDataMapper() != null ? 1 : 0) != 0, (Object)"withUserDataMapper() is required");
            Preconditions.checkArgument((this.getDataSourceProviderFn() != null ? 1 : 0) != 0, (Object)"withDataSourceConfiguration() or withDataSourceProviderFn() is required");
            if (input.isBounded() == PCollection.IsBounded.UNBOUNDED) {
                Preconditions.checkArgument((this.getSnowPipe() != null ? 1 : 0) != 0, (Object)"in streaming (unbounded) write it is required to specify SnowPipe name via withSnowPipe() method.");
            } else {
                Preconditions.checkArgument((this.getTable() != null ? 1 : 0) != 0, (Object)"in batch writing it is required to specify destination table name via to() method.");
            }
        }

        private PCollection<Void> writeStream(PCollection<T> input, ValueProvider<String> stagingBucketDir) {
            SnowflakeServices snowflakeServices = this.getSnowflakeServices() != null ? this.getSnowflakeServices() : new SnowflakeServicesImpl();
            PCollection inputInGlobalWindow = (PCollection)input.apply("Rewindow Into Global", (PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)Repeatedly.forever((Trigger)AfterFirst.of((Trigger.OnceTrigger[])new Trigger.OnceTrigger[]{AfterProcessingTime.pastFirstElementInPane().plusDelayOf(this.getFlushTimeLimit()), AfterPane.elementCountAtLeast((int)this.getFlushRowLimit())}))).discardingFiredPanes());
            int shards = this.getShardsNumber() > 0 ? this.getShardsNumber() : 1;
            PCollection files = this.writeFiles(inputInGlobalWindow, stagingBucketDir, shards);
            files = (PCollection)files.apply("Apply User Trigger", (PTransform)Window.into((WindowFn)new GlobalWindows()).triggering((Trigger)Repeatedly.forever((Trigger)AfterProcessingTime.pastFirstElementInPane().plusDelayOf(this.getFlushTimeLimit()))).discardingFiredPanes());
            PCollection filesConcatenated = (PCollection)files.apply("Create list of files for loading via SnowPipe", (PTransform)Combine.globally((CombineFnBase.GlobalCombineFn)new Concatenate()).withoutDefaults());
            return (PCollection)filesConcatenated.apply("Stream files to table", this.streamToTable(snowflakeServices, stagingBucketDir));
        }

        private PCollection<Void> writeBatch(PCollection<T> input, ValueProvider<String> stagingBucketDir) {
            SnowflakeServices snowflakeServices = this.getSnowflakeServices() != null ? this.getSnowflakeServices() : new SnowflakeServicesImpl();
            PCollection<String> files = this.writeBatchFiles(input, stagingBucketDir);
            ListCoder coder = ListCoder.of((Coder)StringUtf8Coder.of());
            PCollection reifiedFiles = (PCollection)files.getPipeline().apply(Reify.viewInGlobalWindow((PCollectionView)((PCollectionView)files.apply((PTransform)View.asList())), (Coder)coder));
            return (PCollection)reifiedFiles.apply("Copy files to table", this.copyToTable(snowflakeServices, stagingBucketDir));
        }

        private PCollection<String> writeBatchFiles(PCollection<T> input, ValueProvider<String> outputDirectory) {
            int shards = this.getShardsNumber() > 0 ? this.getShardsNumber() : 0;
            return this.writeFiles(input, outputDirectory, shards);
        }

        private PCollection<String> writeFiles(PCollection<T> input, ValueProvider<String> stagingBucketDir, int numShards) {
            PCollection mappedUserData = ((PCollection)((PCollection)input.apply((PTransform)MapElements.via((SimpleFunction)new SimpleFunction<T, Object[]>(){

                public Object[] apply(T element) {
                    return this.getUserDataMapper().mapRow(element);
                }
            }))).apply("Map Objects array to CSV lines", (PTransform)ParDo.of((DoFn)new MapObjectsArrayToCsvFn(this.getQuotationMark())))).setCoder((Coder)StringUtf8Coder.of());
            WriteFilesResult filesResult = (WriteFilesResult)mappedUserData.apply("Write files to specified location", (PTransform)FileIO.write().via((FileIO.Sink)TextIO.sink()).to(stagingBucketDir).withPrefix(UUID.randomUUID().toString().subSequence(0, 8).toString()).withSuffix(".csv").withNumShards(numShards).withCompression(Compression.GZIP));
            return (PCollection)filesResult.getPerDestinationOutputFilenames().apply("Parse KV filenames to Strings", (PTransform)Values.create());
        }

        private ParDo.SingleOutput<List<String>, Void> copyToTable(SnowflakeServices snowflakeServices, ValueProvider<String> stagingBucketDir) {
            return ParDo.of((DoFn)new CopyToTableFn(this.getDataSourceProviderFn(), this.getTable(), this.getQuery(), stagingBucketDir, this.getStorageIntegrationName(), this.getCreateDisposition(), this.getWriteDisposition(), this.getTableSchema(), snowflakeServices, this.getQuotationMark()));
        }

        protected ParDo.SingleOutput<List<String>, Void> streamToTable(SnowflakeServices snowflakeServices, ValueProvider<String> stagingBucketDir) {
            return ParDo.of((DoFn)new StreamToTableFn(this.getDataSourceProviderFn(), this.getSnowPipe(), stagingBucketDir, this.getDebugMode(), snowflakeServices));
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setDataSourceProviderFn(SerializableFunction<Void, DataSource> var1);

            abstract Builder<T> setTable(ValueProvider<String> var1);

            abstract Builder<T> setQuery(ValueProvider<String> var1);

            abstract Builder<T> setStorageIntegrationName(ValueProvider<String> var1);

            abstract Builder<T> setStagingBucketName(ValueProvider<String> var1);

            abstract Builder<T> setSnowPipe(ValueProvider<String> var1);

            abstract Builder<T> setFlushRowLimit(Integer var1);

            abstract Builder<T> setShardsNumber(Integer var1);

            abstract Builder<T> setFlushTimeLimit(Duration var1);

            abstract Builder<T> setFileNameTemplate(String var1);

            abstract Builder<T> setUserDataMapper(UserDataMapper<T> var1);

            abstract Builder<T> setWriteDisposition(WriteDisposition var1);

            abstract Builder<T> setCreateDisposition(CreateDisposition var1);

            abstract Builder<T> setTableSchema(SnowflakeTableSchema var1);

            abstract Builder<T> setSnowflakeServices(SnowflakeServices var1);

            abstract Builder<T> setQuotationMark(String var1);

            abstract Builder<T> setDebugMode(StreamingLogLevel var1);

            abstract Write<T> build();
        }
    }

    @AutoValue
    @AutoValue.CopyAnnotations
    public static abstract class Read<T>
    extends PTransform<PBegin, PCollection<T>> {
        @Nullable
        abstract SerializableFunction<Void, DataSource> getDataSourceProviderFn();

        @Nullable
        abstract ValueProvider<String> getQuery();

        @Nullable
        abstract ValueProvider<String> getTable();

        @Nullable
        abstract ValueProvider<String> getStorageIntegrationName();

        @Nullable
        abstract ValueProvider<String> getStagingBucketName();

        @Nullable
        abstract CsvMapper<T> getCsvMapper();

        @Nullable
        abstract Coder<T> getCoder();

        @Nullable
        abstract SnowflakeServices getSnowflakeServices();

        @Nullable
        abstract ValueProvider<String> getQuotationMark();

        abstract Builder<T> toBuilder();

        public Read<T> withDataSourceConfiguration(DataSourceConfiguration config) {
            return this.withDataSourceProviderFn(DataSourceProviderFromDataSourceConfiguration.of(config));
        }

        public Read<T> withDataSourceProviderFn(SerializableFunction<Void, DataSource> dataSourceProviderFn) {
            return this.toBuilder().setDataSourceProviderFn(dataSourceProviderFn).build();
        }

        public Read<T> fromQuery(String query) {
            return this.toBuilder().setQuery((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)query)).build();
        }

        public Read<T> fromQuery(ValueProvider<String> query) {
            return this.toBuilder().setQuery(query).build();
        }

        public Read<T> fromTable(String table) {
            return this.toBuilder().setTable((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)table)).build();
        }

        public Read<T> fromTable(ValueProvider<String> table) {
            return this.toBuilder().setTable(table).build();
        }

        public Read<T> withStagingBucketName(String stagingBucketName) {
            Preconditions.checkArgument((boolean)stagingBucketName.endsWith("/"), (Object)"stagingBucketName must be a cloud storage path ending with /");
            return this.toBuilder().setStagingBucketName((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)stagingBucketName)).build();
        }

        public Read<T> withStagingBucketName(ValueProvider<String> stagingBucketName) {
            return this.toBuilder().setStagingBucketName(stagingBucketName).build();
        }

        public Read<T> withStorageIntegrationName(String integrationName) {
            return this.toBuilder().setStorageIntegrationName((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)integrationName)).build();
        }

        public Read<T> withStorageIntegrationName(ValueProvider<String> integrationName) {
            return this.toBuilder().setStorageIntegrationName(integrationName).build();
        }

        public Read<T> withCsvMapper(CsvMapper<T> csvMapper) {
            return this.toBuilder().setCsvMapper(csvMapper).build();
        }

        public Read<T> withCoder(Coder<T> coder) {
            return this.toBuilder().setCoder(coder).build();
        }

        public Read<T> withQuotationMark(String quotationMark) {
            return this.toBuilder().setQuotationMark((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)quotationMark)).build();
        }

        public Read<T> withQuotationMark(ValueProvider<String> quotationMark) {
            return this.toBuilder().setQuotationMark(quotationMark).build();
        }

        public PCollection<T> expand(PBegin input) {
            this.checkArguments();
            PCollection emptyCollection = (PCollection)input.apply((PTransform)Create.of((Object)null, (Object[])new Void[0]));
            String tmpDirName = this.makeTmpDirName();
            PCollection output = (PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)((PCollection)emptyCollection.apply((PTransform)ParDo.of((DoFn)new CopyIntoStageFn(this.getDataSourceProviderFn(), this.getQuery(), this.getTable(), this.getStorageIntegrationName(), this.getStagingBucketName(), tmpDirName, this.getSnowflakeServices(), this.getQuotationMark())))).apply((PTransform)Reshuffle.viaRandomKey())).apply((PTransform)FileIO.matchAll())).apply((PTransform)FileIO.readMatches())).apply((PTransform)TextIO.readFiles())).apply((PTransform)ParDo.of((DoFn)new MapCsvToStringArrayFn(this.getQuotationMark())))).apply((PTransform)ParDo.of(new MapStringArrayToUserDataFn<T>(this.getCsvMapper())));
            output.setCoder(this.getCoder());
            ((PCollection)emptyCollection.apply((PTransform)Wait.on((PCollection[])new PCollection[]{output}))).apply((PTransform)ParDo.of((DoFn)new CleanTmpFilesFromGcsFn(this.getStagingBucketName(), tmpDirName)));
            return output;
        }

        private void checkArguments() {
            Preconditions.checkArgument((this.getStorageIntegrationName() != null ? 1 : 0) != 0, (Object)"withStorageIntegrationName() is required");
            Preconditions.checkArgument((this.getStagingBucketName() != null ? 1 : 0) != 0, (Object)"withStagingBucketName() is required");
            Preconditions.checkArgument((this.getQuery() != null || this.getTable() != null ? 1 : 0) != 0, (Object)"fromTable() or fromQuery() is required");
            Preconditions.checkArgument((this.getQuery() == null || this.getTable() == null ? 1 : 0) != 0, (Object)"fromTable() and fromQuery() are not allowed together");
            Preconditions.checkArgument((this.getCsvMapper() != null ? 1 : 0) != 0, (Object)"withCsvMapper() is required");
            Preconditions.checkArgument((this.getCoder() != null ? 1 : 0) != 0, (Object)"withCoder() is required");
            Preconditions.checkArgument((this.getDataSourceProviderFn() != null ? 1 : 0) != 0, (Object)"withDataSourceConfiguration() or withDataSourceProviderFn() is required");
        }

        private String makeTmpDirName() {
            return String.format("sf_copy_csv_%s_%s", new SimpleDateFormat("yyyyMMdd_HHmmss").format(new Date()), UUID.randomUUID().toString().subSequence(0, 8));
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            if (this.getQuery() != null) {
                builder.add(DisplayData.item((String)"query", this.getQuery()));
            }
            if (this.getTable() != null) {
                builder.add(DisplayData.item((String)"table", this.getTable()));
            }
            builder.add(DisplayData.item((String)"storageIntegrationName", this.getStagingBucketName()));
            builder.add(DisplayData.item((String)"stagingBucketName", this.getStagingBucketName()));
            builder.add(DisplayData.item((String)"csvMapper", (String)this.getCsvMapper().getClass().getName()));
            builder.add(DisplayData.item((String)"coder", (String)this.getCoder().getClass().getName()));
            if (this.getDataSourceProviderFn() instanceof HasDisplayData) {
                ((HasDisplayData)this.getDataSourceProviderFn()).populateDisplayData(builder);
            }
        }

        public static class CleanTmpFilesFromGcsFn
        extends DoFn<Object, Object> {
            private final ValueProvider<String> stagingBucketDir;
            private final String tmpDirName;

            public CleanTmpFilesFromGcsFn(ValueProvider<String> stagingBucketDir, String tmpDirName) {
                this.stagingBucketDir = stagingBucketDir;
                this.tmpDirName = tmpDirName;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws IOException {
                String combinedPath = String.format("%s/%s/**", this.stagingBucketDir.get(), this.tmpDirName);
                List paths = FileSystems.match((String)combinedPath).metadata().stream().map(metadata -> metadata.resourceId()).collect(Collectors.toList());
                FileSystems.delete(paths, (MoveOptions[])new MoveOptions[]{MoveOptions.StandardMoveOptions.IGNORE_MISSING_FILES});
            }
        }

        private static class MapStringArrayToUserDataFn<T>
        extends DoFn<String[], T> {
            private final CsvMapper<T> csvMapper;

            public MapStringArrayToUserDataFn(CsvMapper<T> csvMapper) {
                this.csvMapper = csvMapper;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context) throws Exception {
                context.output(this.csvMapper.mapRow((String[])context.element()));
            }
        }

        public static class MapCsvToStringArrayFn
        extends DoFn<String, String[]> {
            private ValueProvider<String> quoteChar;

            public MapCsvToStringArrayFn(ValueProvider<String> quoteChar) {
                this.quoteChar = quoteChar;
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext c) throws IOException {
                String csvLine = (String)c.element();
                CSVParser parser = new CSVParserBuilder().withQuoteChar(((String)this.quoteChar.get()).charAt(0)).build();
                String[] parts = parser.parseLine(csvLine);
                c.output((Object)parts);
            }
        }

        private static class CopyIntoStageFn
        extends DoFn<Object, String> {
            private final SerializableFunction<Void, DataSource> dataSourceProviderFn;
            private final ValueProvider<String> query;
            private final ValueProvider<String> database;
            private final ValueProvider<String> schema;
            private final ValueProvider<String> table;
            private final ValueProvider<String> storageIntegrationName;
            private final ValueProvider<String> stagingBucketDir;
            private final String tmpDirName;
            private final SnowflakeServices snowflakeServices;
            private final ValueProvider<String> quotationMark;

            private CopyIntoStageFn(SerializableFunction<Void, DataSource> dataSourceProviderFn, ValueProvider<String> query, ValueProvider<String> table, ValueProvider<String> storageIntegrationName, ValueProvider<String> stagingBucketDir, String tmpDirName, SnowflakeServices snowflakeServices, ValueProvider<String> quotationMark) {
                this.dataSourceProviderFn = dataSourceProviderFn;
                this.query = query;
                this.table = table;
                this.storageIntegrationName = storageIntegrationName;
                this.snowflakeServices = snowflakeServices;
                this.quotationMark = quotationMark;
                this.stagingBucketDir = stagingBucketDir;
                this.tmpDirName = tmpDirName;
                DataSourceProviderFromDataSourceConfiguration dataSourceProviderFromDataSourceConfiguration = (DataSourceProviderFromDataSourceConfiguration)this.dataSourceProviderFn;
                DataSourceConfiguration config = dataSourceProviderFromDataSourceConfiguration.getConfig();
                this.database = config.getDatabase();
                this.schema = config.getSchema();
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext context) throws Exception {
                String databaseValue = SnowflakeIO.getValueOrNull((ValueProvider<String>)this.database);
                String schemaValue = SnowflakeIO.getValueOrNull((ValueProvider<String>)this.schema);
                String tableValue = SnowflakeIO.getValueOrNull((ValueProvider<String>)this.table);
                String queryValue = SnowflakeIO.getValueOrNull((ValueProvider<String>)this.query);
                String stagingBucketRunDir = String.format("%s/%s/run_%s/", this.stagingBucketDir.get(), this.tmpDirName, UUID.randomUUID().toString().subSequence(0, 8));
                SnowflakeBatchServiceConfig config = new SnowflakeBatchServiceConfig(this.dataSourceProviderFn, databaseValue, schemaValue, tableValue, queryValue, (String)this.storageIntegrationName.get(), stagingBucketRunDir, (String)this.quotationMark.get());
                String output = this.snowflakeServices.getBatchService().read(config);
                context.output((Object)output);
            }
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setDataSourceProviderFn(SerializableFunction<Void, DataSource> var1);

            abstract Builder<T> setQuery(ValueProvider<String> var1);

            abstract Builder<T> setTable(ValueProvider<String> var1);

            abstract Builder<T> setStorageIntegrationName(ValueProvider<String> var1);

            abstract Builder<T> setStagingBucketName(ValueProvider<String> var1);

            abstract Builder<T> setCsvMapper(CsvMapper<T> var1);

            abstract Builder<T> setCoder(Coder<T> var1);

            abstract Builder<T> setSnowflakeServices(SnowflakeServices var1);

            abstract Builder<T> setQuotationMark(ValueProvider<String> var1);

            abstract Read<T> build();
        }
    }

    @FunctionalInterface
    public static interface UserDataMapper<T>
    extends Serializable {
        public Object[] mapRow(T var1);
    }

    @FunctionalInterface
    public static interface CsvMapper<T>
    extends Serializable {
        public T mapRow(String[] var1) throws Exception;
    }
}

