/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.data;

import java.io.Serializable;
import org.apache.beam.sdk.io.snowflake.data.SnowflakeDataType;

public class SnowflakeColumn
implements Serializable {
    private SnowflakeDataType dataType;
    private String name;
    private boolean isNullable;

    public static SnowflakeColumn of(String name, SnowflakeDataType dataType) {
        return new SnowflakeColumn(name, dataType);
    }

    public static SnowflakeColumn of(String name, SnowflakeDataType dataType, boolean isNull) {
        return new SnowflakeColumn(name, dataType, isNull);
    }

    public SnowflakeColumn() {
    }

    public SnowflakeColumn(String name, SnowflakeDataType dataType) {
        this.name = name;
        this.dataType = dataType;
    }

    public SnowflakeColumn(String name, SnowflakeDataType dataType, boolean isNullable) {
        this.dataType = dataType;
        this.name = name;
        this.isNullable = isNullable;
    }

    public String sql() {
        String sql = String.format("%s %s", this.name, this.dataType.sql());
        if (this.isNullable) {
            sql = sql + " NULL";
        }
        return sql;
    }

    public SnowflakeDataType getDataType() {
        return this.dataType;
    }

    public void setDataType(SnowflakeDataType dataType) {
        this.dataType = dataType;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isNullable() {
        return this.isNullable;
    }

    public void setNullable(boolean nullable) {
        this.isNullable = nullable;
    }
}

