/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.snowflake.crosslanguage;

import java.io.Serializable;
import java.nio.charset.Charset;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.ByteArrayCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.io.snowflake.SnowflakeIO;
import org.apache.beam.sdk.io.snowflake.crosslanguage.CrossLanguageConfiguration;
import org.apache.beam.sdk.transforms.ExternalTransformBuilder;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;

@Experimental(value=Experimental.Kind.PORTABILITY)
public class ReadBuilder
implements ExternalTransformBuilder<Configuration, PBegin, PCollection<byte[]>> {
    public PTransform<PBegin, PCollection<byte[]>> buildExternal(Configuration c) {
        SnowflakeIO.Read<byte[]> readTransform = SnowflakeIO.read().withDataSourceConfiguration(c.getDataSourceConfiguration()).withStorageIntegrationName(c.getStorageIntegrationName()).withStagingBucketName(c.getStagingBucketName()).withCsvMapper(CsvMapper.getCsvMapper()).withCoder((Coder<byte[]>)ByteArrayCoder.of());
        if (c.getTable() != null) {
            readTransform = readTransform.fromTable(c.getTable());
        }
        if (c.getQuery() != null) {
            readTransform = readTransform.fromQuery(c.getQuery());
        }
        return readTransform;
    }

    private static class CsvMapper
    implements Serializable {
        private CsvMapper() {
        }

        public static SnowflakeIO.CsvMapper<byte[]> getCsvMapper() {
            return parts -> {
                String partsCSV = String.join((CharSequence)",", parts);
                return partsCSV.getBytes(Charset.defaultCharset());
            };
        }
    }

    public static class Configuration
    extends CrossLanguageConfiguration {
    }
}

