/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.parquet;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericRecord;
import org.apache.beam.repackaged.beam_sdks_java_io_parquet.com.google.common.base.Preconditions;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.parquet.AutoValue_ParquetIO_Read;
import org.apache.beam.sdk.io.parquet.AutoValue_ParquetIO_ReadFiles;
import org.apache.beam.sdk.io.parquet.AutoValue_ParquetIO_Sink;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.io.DelegatingSeekableInputStream;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.PositionOutputStream;
import org.apache.parquet.io.SeekableInputStream;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class ParquetIO {
    public static Read read(Schema schema) {
        return new AutoValue_ParquetIO_Read.Builder().setSchema(schema).build();
    }

    public static ReadFiles readFiles(Schema schema) {
        return new AutoValue_ParquetIO_ReadFiles.Builder().setSchema(schema).build();
    }

    public static Sink sink(Schema schema) {
        return new AutoValue_ParquetIO_Sink.Builder().setJsonSchema(schema.toString()).build();
    }

    private ParquetIO() {
    }

    @AutoValue
    public static abstract class Sink
    implements FileIO.Sink<GenericRecord> {
        @Nullable
        private transient ParquetWriter<GenericRecord> writer;

        @Nullable
        abstract String getJsonSchema();

        public void open(WritableByteChannel channel) throws IOException {
            Preconditions.checkNotNull(this.getJsonSchema(), "Schema cannot be null");
            Schema schema = new Schema.Parser().parse(this.getJsonSchema());
            BeamParquetOutputFile beamParquetOutputFile = new BeamParquetOutputFile(Channels.newOutputStream(channel));
            this.writer = ((AvroParquetWriter.Builder)AvroParquetWriter.builder((OutputFile)beamParquetOutputFile).withSchema(schema).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).build();
        }

        public void write(GenericRecord element) throws IOException {
            Preconditions.checkNotNull(this.writer, "Writer cannot be null");
            this.writer.write((Object)element);
        }

        public void flush() throws IOException {
            this.writer.close();
        }

        private static class BeamOutputStream
        extends PositionOutputStream {
            private long position = 0L;
            private OutputStream outputStream;

            private BeamOutputStream(OutputStream outputStream) {
                this.outputStream = outputStream;
            }

            public long getPos() throws IOException {
                return this.position;
            }

            public void write(int b) throws IOException {
                ++this.position;
                this.outputStream.write(b);
            }

            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                this.outputStream.write(b, off, len);
                this.position += (long)len;
            }

            public void flush() throws IOException {
                this.outputStream.flush();
            }

            public void close() throws IOException {
                this.outputStream.close();
            }
        }

        private static class BeamParquetOutputFile
        implements OutputFile {
            private OutputStream outputStream;

            BeamParquetOutputFile(OutputStream outputStream) {
                this.outputStream = outputStream;
            }

            public PositionOutputStream create(long blockSizeHint) {
                return new BeamOutputStream(this.outputStream);
            }

            public PositionOutputStream createOrOverwrite(long blockSizeHint) {
                return new BeamOutputStream(this.outputStream);
            }

            public boolean supportsBlockSize() {
                return false;
            }

            public long defaultBlockSize() {
                return 0L;
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setJsonSchema(String var1);

            abstract Sink build();
        }
    }

    @AutoValue
    public static abstract class ReadFiles
    extends PTransform<PCollection<FileIO.ReadableFile>, PCollection<GenericRecord>> {
        @Nullable
        abstract Schema getSchema();

        public PCollection<GenericRecord> expand(PCollection<FileIO.ReadableFile> input) {
            Preconditions.checkNotNull(this.getSchema(), "Schema can not be null");
            return ((PCollection)input.apply((PTransform)ParDo.of((DoFn)new ReadFn()))).setCoder((Coder)AvroCoder.of((Schema)this.getSchema()));
        }

        private static class BeamParquetInputFile
        implements InputFile {
            private SeekableByteChannel seekableByteChannel;

            BeamParquetInputFile(SeekableByteChannel seekableByteChannel) {
                this.seekableByteChannel = seekableByteChannel;
            }

            public long getLength() throws IOException {
                return this.seekableByteChannel.size();
            }

            public SeekableInputStream newStream() {
                return new DelegatingSeekableInputStream(Channels.newInputStream(this.seekableByteChannel)){

                    public long getPos() throws IOException {
                        return seekableByteChannel.position();
                    }

                    public void seek(long newPos) throws IOException {
                        seekableByteChannel.position(newPos);
                    }
                };
            }
        }

        static class ReadFn
        extends DoFn<FileIO.ReadableFile, GenericRecord> {
            ReadFn() {
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext processContext) throws Exception {
                FileIO.ReadableFile file = (FileIO.ReadableFile)processContext.element();
                if (!file.getMetadata().isReadSeekEfficient()) {
                    ResourceId filename = file.getMetadata().resourceId();
                    throw new RuntimeException(String.format("File has to be seekable: %s", filename));
                }
                SeekableByteChannel seekableByteChannel = file.openSeekable();
                try (ParquetReader reader = AvroParquetReader.builder((InputFile)new BeamParquetInputFile(seekableByteChannel)).build();){
                    GenericRecord read;
                    while ((read = (GenericRecord)reader.read()) != null) {
                        processContext.output((Object)read);
                    }
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setSchema(Schema var1);

            abstract ReadFiles build();
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<GenericRecord>> {
        @Nullable
        abstract ValueProvider<String> getFilepattern();

        @Nullable
        abstract Schema getSchema();

        abstract Builder builder();

        public Read from(ValueProvider<String> filepattern) {
            return this.builder().setFilepattern(filepattern).build();
        }

        public Read from(String filepattern) {
            return this.from((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)filepattern));
        }

        public PCollection<GenericRecord> expand(PBegin input) {
            Preconditions.checkNotNull(this.getFilepattern(), "Filepattern cannot be null.");
            return (PCollection)((PCollection)((PCollection)((PCollection)input.apply("Create filepattern", (PTransform)Create.ofProvider(this.getFilepattern(), (Coder)StringUtf8Coder.of()))).apply((PTransform)FileIO.matchAll())).apply((PTransform)FileIO.readMatches())).apply((PTransform)ParquetIO.readFiles(this.getSchema()));
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"filePattern", this.getFilepattern()).withLabel("Input File Pattern"));
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setFilepattern(ValueProvider<String> var1);

            abstract Builder setSchema(Schema var1);

            abstract Read build();
        }
    }
}

