/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.parquet;

import com.google.auto.value.AutoValue;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.channels.Channels;
import java.nio.channels.SeekableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.generic.GenericRecord;
import org.apache.avro.specific.SpecificData;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.AvroCoder;
import org.apache.beam.sdk.coders.CannotProvideCoderException;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.CoderRegistry;
import org.apache.beam.sdk.coders.StringUtf8Coder;
import org.apache.beam.sdk.io.FileIO;
import org.apache.beam.sdk.io.fs.ResourceId;
import org.apache.beam.sdk.io.hadoop.SerializableConfiguration;
import org.apache.beam.sdk.io.parquet.AutoValue_ParquetIO_Parse;
import org.apache.beam.sdk.io.parquet.AutoValue_ParquetIO_ParseFiles;
import org.apache.beam.sdk.io.parquet.AutoValue_ParquetIO_Read;
import org.apache.beam.sdk.io.parquet.AutoValue_ParquetIO_ReadFiles;
import org.apache.beam.sdk.io.parquet.AutoValue_ParquetIO_ReadFiles_SplitReadFn_CountAndSize;
import org.apache.beam.sdk.io.parquet.AutoValue_ParquetIO_Sink;
import org.apache.beam.sdk.io.range.OffsetRange;
import org.apache.beam.sdk.options.ValueProvider;
import org.apache.beam.sdk.schemas.utils.AvroUtils;
import org.apache.beam.sdk.transforms.Create;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.transforms.splittabledofn.OffsetRangeTracker;
import org.apache.beam.sdk.transforms.splittabledofn.RestrictionTracker;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.TypeDescriptors;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.ImmutableSet;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.collect.Maps;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.Preconditions;
import org.apache.parquet.avro.AvroParquetReader;
import org.apache.parquet.avro.AvroParquetWriter;
import org.apache.parquet.avro.AvroReadSupport;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.InitContext;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.DelegatingSeekableInputStream;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.PositionOutputStream;
import org.apache.parquet.io.RecordReader;
import org.apache.parquet.io.SeekableInputStream;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.MessageType;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class ParquetIO {
    private static final Logger LOG = LoggerFactory.getLogger(ParquetIO.class);

    public static Read read(Schema schema) {
        return new AutoValue_ParquetIO_Read.Builder().setSchema(schema).setInferBeamSchema(false).setSplittable(false).build();
    }

    public static ReadFiles readFiles(Schema schema) {
        return new AutoValue_ParquetIO_ReadFiles.Builder().setSplittable(false).setInferBeamSchema(false).setSchema(schema).build();
    }

    public static <T> Parse<T> parseGenericRecords(SerializableFunction<GenericRecord, T> parseFn) {
        return new AutoValue_ParquetIO_Parse.Builder<T>().setParseFn(parseFn).setSplittable(false).build();
    }

    public static <T> ParseFiles<T> parseFilesGenericRecords(SerializableFunction<GenericRecord, T> parseFn) {
        return new AutoValue_ParquetIO_ParseFiles.Builder<T>().setParseFn(parseFn).setSplittable(false).build();
    }

    public static Sink sink(Schema schema) {
        return new AutoValue_ParquetIO_Sink.Builder().setJsonSchema(schema.toString()).setCompressionCodec(CompressionCodecName.SNAPPY).setRowGroupSize(0x8000000).build();
    }

    private static GenericData buildModelObject(@Nullable Class<? extends GenericData> modelClass) throws ReflectiveOperationException {
        return modelClass == null ? null : (GenericData)modelClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
    }

    private ParquetIO() {
    }

    @VisibleForTesting
    static final class GenericRecordPassthroughFn
    implements SerializableFunction<GenericRecord, GenericRecord> {
        private static final GenericRecordPassthroughFn singleton = new GenericRecordPassthroughFn();

        static GenericRecordPassthroughFn create() {
            return singleton;
        }

        public GenericRecord apply(GenericRecord input) {
            return input;
        }

        private GenericRecordPassthroughFn() {
        }
    }

    @AutoValue
    public static abstract class Sink
    implements FileIO.Sink<GenericRecord> {
        @Nullable
        private transient ParquetWriter<GenericRecord> writer;

        @Nullable
        abstract String getJsonSchema();

        abstract CompressionCodecName getCompressionCodec();

        @Nullable
        abstract SerializableConfiguration getConfiguration();

        abstract int getRowGroupSize();

        @Nullable
        abstract Class<? extends GenericData> getAvroDataModelClass();

        abstract Builder toBuilder();

        public Sink withCompressionCodec(CompressionCodecName compressionCodecName) {
            return this.toBuilder().setCompressionCodec(compressionCodecName).build();
        }

        public Sink withConfiguration(Map<String, String> configuration) {
            Preconditions.checkArgument((configuration != null ? 1 : 0) != 0, (String)"configuration can not be null");
            return this.toBuilder().setConfiguration(SerializableConfiguration.fromMap(configuration)).build();
        }

        public Sink withConfiguration(Configuration configuration) {
            Preconditions.checkArgument((configuration != null ? 1 : 0) != 0, (String)"configuration can not be null");
            return this.toBuilder().setConfiguration(new SerializableConfiguration(configuration)).build();
        }

        public Sink withRowGroupSize(int rowGroupSize) {
            Preconditions.checkArgument((rowGroupSize > 0 ? 1 : 0) != 0, (String)"rowGroupSize must be positive");
            return this.toBuilder().setRowGroupSize(rowGroupSize).build();
        }

        public Sink withAvroDataModel(GenericData model) {
            return this.toBuilder().setAvroDataModelClass(model.getClass()).build();
        }

        public void open(WritableByteChannel channel) throws IOException {
            Preconditions.checkNotNull((Object)this.getJsonSchema(), (String)"Schema cannot be null");
            Schema schema = new Schema.Parser().parse(this.getJsonSchema());
            Class<? extends GenericData> modelClass = this.getAvroDataModelClass();
            BeamParquetOutputFile beamParquetOutputFile = new BeamParquetOutputFile(Channels.newOutputStream(channel));
            AvroParquetWriter.Builder builder = (AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)((AvroParquetWriter.Builder)AvroParquetWriter.builder((OutputFile)beamParquetOutputFile).withSchema(schema).withCompressionCodec(this.getCompressionCodec())).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withConf(SerializableConfiguration.newConfiguration((SerializableConfiguration)this.getConfiguration()))).withRowGroupSize(this.getRowGroupSize());
            if (modelClass != null) {
                try {
                    builder.withDataModel(ParquetIO.buildModelObject(modelClass));
                }
                catch (ReflectiveOperationException e) {
                    throw new IOException("Couldn't set the specified Avro data model " + modelClass.getName(), e);
                }
            }
            this.writer = builder.build();
        }

        public void write(GenericRecord element) throws IOException {
            Preconditions.checkNotNull(this.writer, (String)"Writer cannot be null");
            this.writer.write((Object)element);
        }

        public void flush() throws IOException {
            this.writer.close();
        }

        private static class BeamOutputStream
        extends PositionOutputStream {
            private long position = 0L;
            private final OutputStream outputStream;

            private BeamOutputStream(OutputStream outputStream) {
                this.outputStream = outputStream;
            }

            public long getPos() {
                return this.position;
            }

            public void write(int b) throws IOException {
                ++this.position;
                this.outputStream.write(b);
            }

            public void write(byte[] b) throws IOException {
                this.write(b, 0, b.length);
            }

            public void write(byte[] b, int off, int len) throws IOException {
                this.outputStream.write(b, off, len);
                this.position += (long)len;
            }

            public void flush() throws IOException {
                this.outputStream.flush();
            }

            public void close() throws IOException {
                this.outputStream.close();
            }
        }

        private static class BeamParquetOutputFile
        implements OutputFile {
            private final OutputStream outputStream;

            BeamParquetOutputFile(OutputStream outputStream) {
                this.outputStream = outputStream;
            }

            public PositionOutputStream create(long blockSizeHint) {
                return new BeamOutputStream(this.outputStream);
            }

            public PositionOutputStream createOrOverwrite(long blockSizeHint) {
                return new BeamOutputStream(this.outputStream);
            }

            public boolean supportsBlockSize() {
                return false;
            }

            public long defaultBlockSize() {
                return 0L;
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setJsonSchema(String var1);

            abstract Builder setCompressionCodec(CompressionCodecName var1);

            abstract Builder setConfiguration(SerializableConfiguration var1);

            abstract Builder setRowGroupSize(int var1);

            abstract Builder setAvroDataModelClass(Class<? extends GenericData> var1);

            abstract Sink build();
        }
    }

    @AutoValue
    public static abstract class ReadFiles
    extends PTransform<PCollection<FileIO.ReadableFile>, PCollection<GenericRecord>> {
        @Nullable
        abstract Schema getSchema();

        @Nullable
        abstract GenericData getAvroDataModel();

        @Nullable
        abstract Schema getEncoderSchema();

        @Nullable
        abstract Schema getProjectionSchema();

        @Nullable
        abstract SerializableConfiguration getConfiguration();

        abstract boolean getInferBeamSchema();

        abstract boolean isSplittable();

        abstract Builder toBuilder();

        public ReadFiles withAvroDataModel(GenericData model) {
            return this.toBuilder().setAvroDataModel(model).build();
        }

        public ReadFiles withProjection(Schema projectionSchema, Schema encoderSchema) {
            return this.toBuilder().setProjectionSchema(projectionSchema).setEncoderSchema(encoderSchema).setSplittable(true).build();
        }

        public ReadFiles withConfiguration(Map<String, String> configuration) {
            Preconditions.checkArgument((configuration != null ? 1 : 0) != 0, (String)"configuration can not be null");
            return this.toBuilder().setConfiguration(SerializableConfiguration.fromMap(configuration)).build();
        }

        public ReadFiles withConfiguration(Configuration configuration) {
            Preconditions.checkArgument((configuration != null ? 1 : 0) != 0, (String)"configuration can not be null");
            return this.toBuilder().setConfiguration(new SerializableConfiguration(configuration)).build();
        }

        @Experimental(value=Experimental.Kind.SCHEMAS)
        public ReadFiles withBeamSchemas(boolean inferBeamSchema) {
            return this.toBuilder().setInferBeamSchema(inferBeamSchema).build();
        }

        public ReadFiles withSplit() {
            return this.toBuilder().setSplittable(true).build();
        }

        public PCollection<GenericRecord> expand(PCollection<FileIO.ReadableFile> input) {
            Preconditions.checkNotNull((Object)this.getSchema(), (String)"Schema can not be null");
            return ((PCollection)input.apply((PTransform)ParDo.of(this.getReaderFn()))).setCoder(this.getCollectionCoder());
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"schema", (String)String.valueOf(this.getSchema()))).add(DisplayData.item((String)"inferBeamSchema", (Boolean)this.getInferBeamSchema()).withLabel("Infer Beam Schema")).add(DisplayData.item((String)"splittable", (Boolean)this.isSplittable())).addIfNotNull(DisplayData.item((String)"projectionSchema", (String)String.valueOf(this.getProjectionSchema()))).addIfNotNull(DisplayData.item((String)"avroDataModel", (String)String.valueOf(this.getAvroDataModel())));
            if (this.getConfiguration() != null) {
                Configuration configuration = this.getConfiguration().get();
                for (Map.Entry entry : configuration) {
                    if (!((String)entry.getKey()).startsWith("parquet")) continue;
                    builder.addIfNotNull(DisplayData.item((String)((String)entry.getKey()), (String)((String)entry.getValue())));
                }
            }
        }

        private DoFn<FileIO.ReadableFile, GenericRecord> getReaderFn() {
            return this.isSplittable() ? new SplitReadFn<GenericRecord>(this.getAvroDataModel(), this.getProjectionSchema(), GenericRecordPassthroughFn.create(), this.getConfiguration()) : new ReadFn<GenericRecord>(this.getAvroDataModel(), GenericRecordPassthroughFn.create(), this.getConfiguration());
        }

        @Experimental(value=Experimental.Kind.SCHEMAS)
        private Coder<GenericRecord> getCollectionCoder() {
            Schema coderSchema = this.getProjectionSchema() != null && this.isSplittable() ? this.getEncoderSchema() : this.getSchema();
            return this.getInferBeamSchema() ? AvroUtils.schemaCoder((Schema)coderSchema) : AvroCoder.of((Schema)coderSchema);
        }

        private static class BeamParquetInputFile
        implements InputFile {
            private final SeekableByteChannel seekableByteChannel;

            BeamParquetInputFile(SeekableByteChannel seekableByteChannel) {
                this.seekableByteChannel = seekableByteChannel;
            }

            public long getLength() throws IOException {
                return this.seekableByteChannel.size();
            }

            public SeekableInputStream newStream() {
                return new DelegatingSeekableInputStream(Channels.newInputStream(this.seekableByteChannel)){

                    public long getPos() throws IOException {
                        return seekableByteChannel.position();
                    }

                    public void seek(long newPos) throws IOException {
                        seekableByteChannel.position(newPos);
                    }
                };
            }
        }

        static class ReadFn<T>
        extends DoFn<FileIO.ReadableFile, T> {
            private final Class<? extends GenericData> modelClass;
            private final SerializableFunction<GenericRecord, T> parseFn;
            private final SerializableConfiguration configuration;

            ReadFn(GenericData model, SerializableFunction<GenericRecord, T> parseFn, SerializableConfiguration configuration) {
                this.modelClass = model != null ? model.getClass() : null;
                this.parseFn = (SerializableFunction)Preconditions.checkNotNull(parseFn, (String)"GenericRecord parse function is null");
                this.configuration = configuration;
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element FileIO.ReadableFile file, DoFn.OutputReceiver<T> receiver) throws Exception {
                if (!file.getMetadata().isReadSeekEfficient()) {
                    ResourceId filename = file.getMetadata().resourceId();
                    throw new RuntimeException(String.format("File has to be seekable: %s", filename));
                }
                SeekableByteChannel seekableByteChannel = file.openSeekable();
                AvroParquetReader.Builder builder = (AvroParquetReader.Builder)AvroParquetReader.builder((InputFile)new BeamParquetInputFile(seekableByteChannel)).withConf(SerializableConfiguration.newConfiguration((SerializableConfiguration)this.configuration));
                if (this.modelClass != null) {
                    builder = builder.withDataModel(ParquetIO.buildModelObject(this.modelClass));
                }
                try (ParquetReader reader = builder.build();){
                    GenericRecord read;
                    while ((read = (GenericRecord)reader.read()) != null) {
                        receiver.output(this.parseFn.apply((Object)read));
                    }
                }
                seekableByteChannel.close();
            }
        }

        public static class BlockTracker
        extends OffsetRangeTracker {
            private long totalWork;
            private long progress;
            private long approximateRecordSize;

            public BlockTracker(OffsetRange range, long totalByteSize, long recordCount) {
                super(range);
                if (recordCount != 0L) {
                    this.approximateRecordSize = totalByteSize / recordCount;
                    this.totalWork = this.approximateRecordSize * recordCount;
                    this.progress = 0L;
                }
            }

            public void makeProgress() throws IOException {
                this.progress += this.approximateRecordSize;
                if (this.progress > this.totalWork) {
                    throw new IOException("Making progress out of range");
                }
            }

            public RestrictionTracker.Progress getProgress() {
                return super.getProgress();
            }
        }

        @DoFn.BoundedPerElement
        static class SplitReadFn<T>
        extends DoFn<FileIO.ReadableFile, T> {
            private final Class<? extends GenericData> modelClass;
            private final String requestSchemaString;
            private static final long SPLIT_LIMIT = 64000000L;
            @Nullable
            private final SerializableConfiguration configuration;
            private final SerializableFunction<GenericRecord, T> parseFn;

            SplitReadFn(GenericData model, Schema requestSchema, SerializableFunction<GenericRecord, T> parseFn, @Nullable SerializableConfiguration configuration) {
                this.modelClass = model != null ? model.getClass() : null;
                this.requestSchemaString = requestSchema != null ? requestSchema.toString() : null;
                this.parseFn = (SerializableFunction)Preconditions.checkNotNull(parseFn, (String)"GenericRecord parse function can't be null");
                this.configuration = configuration;
            }

            private ParquetFileReader getParquetFileReader(FileIO.ReadableFile file) throws Exception {
                ParquetReadOptions options = HadoopReadOptions.builder((Configuration)this.getConfWithModelClass()).build();
                return ParquetFileReader.open((InputFile)new BeamParquetInputFile(file.openSeekable()), (ParquetReadOptions)options);
            }

            @DoFn.ProcessElement
            public void processElement(@DoFn.Element FileIO.ReadableFile file, RestrictionTracker<OffsetRange, Long> tracker, DoFn.OutputReceiver<T> outputReceiver) throws Exception {
                LOG.debug("start " + ((OffsetRange)tracker.currentRestriction()).getFrom() + " to " + ((OffsetRange)tracker.currentRestriction()).getTo());
                Configuration conf = this.getConfWithModelClass();
                GenericData model = null;
                if (this.modelClass != null) {
                    model = (GenericData)this.modelClass.getMethod("get", new Class[0]).invoke(null, new Object[0]);
                }
                AvroReadSupport readSupport = new AvroReadSupport(model);
                if (this.requestSchemaString != null) {
                    AvroReadSupport.setRequestedProjection((Configuration)conf, (Schema)new Schema.Parser().parse(this.requestSchemaString));
                }
                ParquetReadOptions options = HadoopReadOptions.builder((Configuration)conf).build();
                try (ParquetFileReader reader = ParquetFileReader.open((InputFile)new BeamParquetInputFile(file.openSeekable()), (ParquetReadOptions)options);){
                    FilterCompat.Filter filter = (FilterCompat.Filter)Preconditions.checkNotNull((Object)options.getRecordFilter(), (String)"filter");
                    Configuration hadoopConf = ((HadoopReadOptions)options).getConf();
                    FileMetaData parquetFileMetadata = reader.getFooter().getFileMetaData();
                    MessageType fileSchema = parquetFileMetadata.getSchema();
                    Map fileMetadata = parquetFileMetadata.getKeyValueMetaData();
                    ReadSupport.ReadContext readContext = readSupport.init(new InitContext(hadoopConf, Maps.transformValues((Map)fileMetadata, ImmutableSet::of), fileSchema));
                    ColumnIOFactory columnIOFactory = new ColumnIOFactory(parquetFileMetadata.getCreatedBy());
                    RecordMaterializer recordConverter = readSupport.prepareForRead(hadoopConf, fileMetadata, fileSchema, readContext);
                    reader.setRequestedSchema(readContext.getRequestedSchema());
                    MessageColumnIO columnIO = columnIOFactory.getColumnIO(readContext.getRequestedSchema(), fileSchema, true);
                    long currentBlock = ((OffsetRange)tracker.currentRestriction()).getFrom();
                    int i = 0;
                    while ((long)i < currentBlock) {
                        reader.skipNextRowGroup();
                        ++i;
                    }
                    while (tracker.tryClaim((Object)currentBlock)) {
                        long currentRow;
                        PageReadStore pages = reader.readNextRowGroup();
                        LOG.debug("block {} read in memory. row count = {}", (Object)currentBlock, (Object)pages.getRowCount());
                        ++currentBlock;
                        RecordReader recordReader = columnIO.getRecordReader(pages, recordConverter, options.useRecordFilter() ? filter : FilterCompat.NOOP);
                        long totalRows = pages.getRowCount();
                        for (currentRow = 0L; currentRow < totalRows; ++currentRow) {
                            try {
                                GenericRecord record;
                                try {
                                    record = (GenericRecord)recordReader.read();
                                }
                                catch (RecordMaterializer.RecordMaterializationException e) {
                                    LOG.warn("skipping a corrupt record at {} in block {} in file {}", new Object[]{currentRow, currentBlock, file.toString()});
                                    continue;
                                }
                                if (record == null) {
                                    LOG.debug("filtered record reader reached end of block in block {} in file {}", (Object)currentBlock, (Object)file.toString());
                                    break;
                                }
                                if (recordReader.shouldSkipCurrentRecord()) {
                                    LOG.debug("skipping record at {} in block {} in file {}", new Object[]{currentRow, currentBlock, file.toString()});
                                    continue;
                                }
                                outputReceiver.output(this.parseFn.apply((Object)record));
                                continue;
                            }
                            catch (RuntimeException e) {
                                throw new ParquetDecodingException(String.format("Can not read value at %d in block %d in file %s", currentRow, currentBlock, file.toString()), (Throwable)e);
                            }
                        }
                        LOG.debug("Finish processing {} rows from block {} in file {}", new Object[]{currentRow, currentBlock - 1L, file.toString()});
                    }
                }
            }

            public Configuration getConfWithModelClass() throws ReflectiveOperationException {
                Configuration conf = SerializableConfiguration.newConfiguration((SerializableConfiguration)this.configuration);
                GenericData model = ParquetIO.buildModelObject(this.modelClass);
                if (model != null && (model.getClass() == GenericData.class || model.getClass() == SpecificData.class)) {
                    conf.setBoolean("parquet.avro.compatible", true);
                } else {
                    conf.setBoolean("parquet.avro.compatible", false);
                }
                return conf;
            }

            @DoFn.GetInitialRestriction
            public OffsetRange getInitialRestriction(@DoFn.Element FileIO.ReadableFile file) throws Exception {
                try (ParquetFileReader reader = this.getParquetFileReader(file);){
                    OffsetRange offsetRange = new OffsetRange(0L, (long)reader.getRowGroups().size());
                    return offsetRange;
                }
            }

            @DoFn.SplitRestriction
            public void split(@DoFn.Restriction OffsetRange restriction, DoFn.OutputReceiver<OffsetRange> out, @DoFn.Element FileIO.ReadableFile file) throws Exception {
                try (ParquetFileReader reader = this.getParquetFileReader(file);){
                    List rowGroups = reader.getRowGroups();
                    for (OffsetRange offsetRange : this.splitBlockWithLimit(restriction.getFrom(), restriction.getTo(), rowGroups, 64000000L)) {
                        out.output((Object)offsetRange);
                    }
                }
            }

            public ArrayList<OffsetRange> splitBlockWithLimit(long start, long end, List<BlockMetaData> blockList, long limit) {
                ArrayList<OffsetRange> offsetList = new ArrayList<OffsetRange>();
                long totalSize = 0L;
                long rangeStart = start;
                for (long rangeEnd = start; rangeEnd < end; ++rangeEnd) {
                    if ((totalSize += blockList.get((int)rangeEnd).getTotalByteSize()) < limit) continue;
                    offsetList.add(new OffsetRange(rangeStart, rangeEnd + 1L));
                    rangeStart = rangeEnd + 1L;
                    totalSize = 0L;
                }
                if (totalSize != 0L) {
                    offsetList.add(new OffsetRange(rangeStart, end));
                }
                return offsetList;
            }

            @DoFn.NewTracker
            public RestrictionTracker<OffsetRange, Long> newTracker(@DoFn.Restriction OffsetRange restriction, @DoFn.Element FileIO.ReadableFile file) throws Exception {
                CountAndSize recordCountAndSize = this.getRecordCountAndSize(file, restriction);
                return new BlockTracker(restriction, Math.round(recordCountAndSize.getSize()), Math.round(recordCountAndSize.getCount()));
            }

            @DoFn.GetRestrictionCoder
            public OffsetRange.Coder getRestrictionCoder() {
                return new OffsetRange.Coder();
            }

            @DoFn.GetSize
            public double getSize(@DoFn.Element FileIO.ReadableFile file, @DoFn.Restriction OffsetRange restriction) throws Exception {
                return this.getRecordCountAndSize(file, restriction).getSize();
            }

            private CountAndSize getRecordCountAndSize(FileIO.ReadableFile file, OffsetRange restriction) throws Exception {
                try (ParquetFileReader reader = this.getParquetFileReader(file);){
                    double size = 0.0;
                    double recordCount = 0.0;
                    for (long i = restriction.getFrom(); i < restriction.getTo(); ++i) {
                        BlockMetaData block = (BlockMetaData)reader.getRowGroups().get((int)i);
                        recordCount += (double)block.getRowCount();
                        size += (double)block.getTotalByteSize();
                    }
                    CountAndSize countAndSize = CountAndSize.create(recordCount, size);
                    return countAndSize;
                }
            }

            @AutoValue
            static abstract class CountAndSize {
                CountAndSize() {
                }

                static CountAndSize create(double count, double size) {
                    return new AutoValue_ParquetIO_ReadFiles_SplitReadFn_CountAndSize(count, size);
                }

                abstract double getCount();

                abstract double getSize();
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setSchema(Schema var1);

            abstract Builder setAvroDataModel(GenericData var1);

            abstract Builder setEncoderSchema(Schema var1);

            abstract Builder setProjectionSchema(Schema var1);

            abstract Builder setConfiguration(SerializableConfiguration var1);

            abstract Builder setInferBeamSchema(boolean var1);

            abstract Builder setSplittable(boolean var1);

            abstract ReadFiles build();
        }
    }

    @AutoValue
    public static abstract class ParseFiles<T>
    extends PTransform<PCollection<FileIO.ReadableFile>, PCollection<T>> {
        abstract SerializableFunction<GenericRecord, T> getParseFn();

        @Nullable
        abstract Coder<T> getCoder();

        @Nullable
        abstract SerializableConfiguration getConfiguration();

        abstract boolean isSplittable();

        abstract Builder<T> toBuilder();

        public ParseFiles<T> withCoder(Coder<T> coder) {
            return coder == null ? this : this.toBuilder().setCoder(coder).build();
        }

        public ParseFiles<T> withConfiguration(Map<String, String> configuration) {
            Preconditions.checkArgument((configuration != null ? 1 : 0) != 0, (String)"configuration can not be null");
            return this.toBuilder().setConfiguration(SerializableConfiguration.fromMap(configuration)).build();
        }

        public ParseFiles<T> withConfiguration(Configuration configuration) {
            Preconditions.checkArgument((configuration != null ? 1 : 0) != 0, (String)"configuration can not be null");
            return this.toBuilder().setConfiguration(new SerializableConfiguration(configuration)).build();
        }

        public ParseFiles<T> withSplit() {
            return this.toBuilder().setSplittable(true).build();
        }

        public PCollection<T> expand(PCollection<FileIO.ReadableFile> input) {
            Preconditions.checkArgument((!this.isGenericRecordOutput() ? 1 : 0) != 0, (String)"Parse can't be used for reading as GenericRecord.");
            return ((PCollection)input.apply((PTransform)ParDo.of(this.buildFileReadingFn()))).setCoder(this.inferCoder(input.getPipeline().getCoderRegistry()));
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"splittable", (Boolean)this.isSplittable())).add(DisplayData.item((String)"parseFn", this.getParseFn().getClass()).withLabel("Parse function"));
            if (this.getCoder() != null) {
                builder.add(DisplayData.item((String)"coder", this.getCoder().getClass()));
            }
            if (this.getConfiguration() != null) {
                Configuration configuration = this.getConfiguration().get();
                for (Map.Entry entry : configuration) {
                    if (!((String)entry.getKey()).startsWith("parquet")) continue;
                    builder.addIfNotNull(DisplayData.item((String)((String)entry.getKey()), (String)((String)entry.getValue())));
                }
            }
        }

        private DoFn<FileIO.ReadableFile, T> buildFileReadingFn() {
            return this.isSplittable() ? new ReadFiles.SplitReadFn<T>(null, null, this.getParseFn(), this.getConfiguration()) : new ReadFiles.ReadFn<T>(null, this.getParseFn(), this.getConfiguration());
        }

        private boolean isGenericRecordOutput() {
            String outputType = TypeDescriptors.outputOf(this.getParseFn()).getType().getTypeName();
            return outputType.equals(GenericRecord.class.getTypeName());
        }

        private Coder<T> inferCoder(CoderRegistry coderRegistry) {
            if (this.isGenericRecordOutput()) {
                throw new IllegalArgumentException("Parse can't be used for reading as GenericRecord.");
            }
            if (this.getCoder() != null) {
                return this.getCoder();
            }
            try {
                return coderRegistry.getCoder(TypeDescriptors.outputOf(this.getParseFn()));
            }
            catch (CannotProvideCoderException e) {
                throw new IllegalArgumentException("Unable to infer coder for output of parseFn. Specify it explicitly using .withCoder().", e);
            }
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setParseFn(SerializableFunction<GenericRecord, T> var1);

            abstract Builder<T> setCoder(Coder<T> var1);

            abstract Builder<T> setConfiguration(SerializableConfiguration var1);

            abstract Builder<T> setSplittable(boolean var1);

            abstract ParseFiles<T> build();
        }
    }

    @AutoValue
    public static abstract class Parse<T>
    extends PTransform<PBegin, PCollection<T>> {
        @Nullable
        abstract ValueProvider<String> getFilepattern();

        abstract SerializableFunction<GenericRecord, T> getParseFn();

        @Nullable
        abstract Coder<T> getCoder();

        @Nullable
        abstract SerializableConfiguration getConfiguration();

        abstract boolean isSplittable();

        abstract Builder<T> toBuilder();

        public Parse<T> from(ValueProvider<String> filepattern) {
            return this.toBuilder().setFilepattern(filepattern).build();
        }

        public Parse<T> from(String filepattern) {
            return this.from((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)filepattern));
        }

        public Parse<T> withCoder(Coder<T> coder) {
            return coder == null ? this : this.toBuilder().setCoder(coder).build();
        }

        public Parse<T> withConfiguration(Map<String, String> configuration) {
            Preconditions.checkArgument((configuration != null ? 1 : 0) != 0, (String)"configuration can not be null");
            return this.toBuilder().setConfiguration(SerializableConfiguration.fromMap(configuration)).build();
        }

        public Parse<T> withConfiguration(Configuration configuration) {
            Preconditions.checkArgument((configuration != null ? 1 : 0) != 0, (String)"configuration can not be null");
            return this.toBuilder().setConfiguration(new SerializableConfiguration(configuration)).build();
        }

        public Parse<T> withSplit() {
            return this.toBuilder().setSplittable(true).build();
        }

        public PCollection<T> expand(PBegin input) {
            Preconditions.checkNotNull(this.getFilepattern(), (String)"Filepattern cannot be null.");
            return (PCollection)((PCollection)((PCollection)((PCollection)input.apply("Create filepattern", (PTransform)Create.ofProvider(this.getFilepattern(), (Coder)StringUtf8Coder.of()))).apply((PTransform)FileIO.matchAll())).apply((PTransform)FileIO.readMatches())).apply(ParquetIO.parseFilesGenericRecords(this.getParseFn()).toBuilder().setCoder(this.getCoder()).setSplittable(this.isSplittable()).build());
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"filePattern", this.getFilepattern()).withLabel("Input File Pattern")).add(DisplayData.item((String)"splittable", (Boolean)this.isSplittable())).add(DisplayData.item((String)"parseFn", this.getParseFn().getClass()).withLabel("Parse function"));
            if (this.getCoder() != null) {
                builder.add(DisplayData.item((String)"coder", this.getCoder().getClass()));
            }
            if (this.getConfiguration() != null) {
                Configuration configuration = this.getConfiguration().get();
                for (Map.Entry entry : configuration) {
                    if (!((String)entry.getKey()).startsWith("parquet")) continue;
                    builder.addIfNotNull(DisplayData.item((String)((String)entry.getKey()), (String)((String)entry.getValue())));
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder<T> {
            Builder() {
            }

            abstract Builder<T> setFilepattern(ValueProvider<String> var1);

            abstract Builder<T> setParseFn(SerializableFunction<GenericRecord, T> var1);

            abstract Builder<T> setCoder(Coder<T> var1);

            abstract Builder<T> setConfiguration(SerializableConfiguration var1);

            abstract Builder<T> setSplittable(boolean var1);

            abstract Parse<T> build();
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<GenericRecord>> {
        @Nullable
        abstract ValueProvider<String> getFilepattern();

        @Nullable
        abstract Schema getSchema();

        @Nullable
        abstract Schema getProjectionSchema();

        @Nullable
        abstract Schema getEncoderSchema();

        @Nullable
        abstract GenericData getAvroDataModel();

        @Nullable
        abstract SerializableConfiguration getConfiguration();

        abstract boolean getInferBeamSchema();

        abstract boolean isSplittable();

        abstract Builder toBuilder();

        public Read from(ValueProvider<String> filepattern) {
            return this.toBuilder().setFilepattern(filepattern).build();
        }

        public Read from(String filepattern) {
            return this.from((ValueProvider<String>)ValueProvider.StaticValueProvider.of((Object)filepattern));
        }

        public Read withProjection(Schema projectionSchema, Schema encoderSchema) {
            return this.toBuilder().setProjectionSchema(projectionSchema).setSplittable(true).setEncoderSchema(encoderSchema).build();
        }

        public Read withConfiguration(Map<String, String> configuration) {
            Preconditions.checkArgument((configuration != null ? 1 : 0) != 0, (String)"configuration can not be null");
            return this.toBuilder().setConfiguration(SerializableConfiguration.fromMap(configuration)).build();
        }

        public Read withConfiguration(Configuration configuration) {
            Preconditions.checkArgument((configuration != null ? 1 : 0) != 0, (String)"configuration can not be null");
            return this.toBuilder().setConfiguration(new SerializableConfiguration(configuration)).build();
        }

        @Experimental(value=Experimental.Kind.SCHEMAS)
        public Read withBeamSchemas(boolean inferBeamSchema) {
            return this.toBuilder().setInferBeamSchema(inferBeamSchema).build();
        }

        public Read withSplit() {
            return this.toBuilder().setSplittable(true).build();
        }

        public Read withAvroDataModel(GenericData model) {
            return this.toBuilder().setAvroDataModel(model).build();
        }

        public PCollection<GenericRecord> expand(PBegin input) {
            Preconditions.checkNotNull(this.getFilepattern(), (String)"Filepattern cannot be null.");
            PCollection inputFiles = (PCollection)((PCollection)((PCollection)input.apply("Create filepattern", (PTransform)Create.ofProvider(this.getFilepattern(), (Coder)StringUtf8Coder.of()))).apply((PTransform)FileIO.matchAll())).apply((PTransform)FileIO.readMatches());
            ReadFiles readFiles = ParquetIO.readFiles(this.getSchema()).withBeamSchemas(this.getInferBeamSchema()).withAvroDataModel(this.getAvroDataModel());
            if (this.isSplittable()) {
                readFiles = readFiles.withSplit().withProjection(this.getProjectionSchema(), this.getEncoderSchema());
            }
            if (this.getConfiguration() != null) {
                readFiles = readFiles.withConfiguration(this.getConfiguration().get());
            }
            return (PCollection)inputFiles.apply((PTransform)readFiles);
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.addIfNotNull(DisplayData.item((String)"filePattern", this.getFilepattern()).withLabel("Input File Pattern")).addIfNotNull(DisplayData.item((String)"schema", (String)String.valueOf(this.getSchema()))).add(DisplayData.item((String)"inferBeamSchema", (Boolean)this.getInferBeamSchema()).withLabel("Infer Beam Schema")).add(DisplayData.item((String)"splittable", (Boolean)this.isSplittable())).addIfNotNull(DisplayData.item((String)"projectionSchema", (String)String.valueOf(this.getProjectionSchema()))).addIfNotNull(DisplayData.item((String)"avroDataModel", (String)String.valueOf(this.getAvroDataModel())));
            if (this.getConfiguration() != null) {
                Configuration configuration = this.getConfiguration().get();
                for (Map.Entry entry : configuration) {
                    if (!((String)entry.getKey()).startsWith("parquet")) continue;
                    builder.addIfNotNull(DisplayData.item((String)((String)entry.getKey()), (String)((String)entry.getValue())));
                }
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setInferBeamSchema(boolean var1);

            abstract Builder setSplittable(boolean var1);

            abstract Builder setFilepattern(ValueProvider<String> var1);

            abstract Builder setSchema(Schema var1);

            abstract Builder setEncoderSchema(Schema var1);

            abstract Builder setProjectionSchema(Schema var1);

            abstract Builder setAvroDataModel(GenericData var1);

            abstract Builder setConfiguration(SerializableConfiguration var1);

            abstract Read build();
        }
    }
}

