/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.mongodb;

import com.google.auto.value.AutoValue;
import com.mongodb.BasicDBObject;
import com.mongodb.MongoBulkWriteException;
import com.mongodb.MongoClient;
import com.mongodb.MongoClientOptions;
import com.mongodb.MongoClientURI;
import com.mongodb.client.AggregateIterable;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.client.MongoDatabase;
import com.mongodb.client.model.Aggregates;
import com.mongodb.client.model.Filters;
import com.mongodb.client.model.InsertManyOptions;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.net.SocketFactory;
import javax.net.ssl.SSLContext;
import org.apache.beam.sdk.Pipeline;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.coders.Coder;
import org.apache.beam.sdk.coders.SerializableCoder;
import org.apache.beam.sdk.io.BoundedSource;
import org.apache.beam.sdk.io.mongodb.AggregationQuery;
import org.apache.beam.sdk.io.mongodb.AutoValue_FindQuery;
import org.apache.beam.sdk.io.mongodb.AutoValue_MongoDbIO_Read;
import org.apache.beam.sdk.io.mongodb.AutoValue_MongoDbIO_Write;
import org.apache.beam.sdk.io.mongodb.FindQuery;
import org.apache.beam.sdk.io.mongodb.SSLUtils;
import org.apache.beam.sdk.options.PipelineOptions;
import org.apache.beam.sdk.transforms.DoFn;
import org.apache.beam.sdk.transforms.PTransform;
import org.apache.beam.sdk.transforms.ParDo;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.apache.beam.sdk.transforms.display.DisplayData;
import org.apache.beam.sdk.values.PBegin;
import org.apache.beam.sdk.values.PCollection;
import org.apache.beam.sdk.values.PDone;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.annotations.VisibleForTesting;
import org.apache.beam.vendor.guava.v26_0_jre.com.google.common.base.Preconditions;
import org.bson.BsonDocument;
import org.bson.BsonInt32;
import org.bson.BsonString;
import org.bson.BsonValue;
import org.bson.Document;
import org.bson.conversions.Bson;
import org.bson.types.ObjectId;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
public class MongoDbIO {
    private static final Logger LOG = LoggerFactory.getLogger(MongoDbIO.class);

    public static Read read() {
        return new AutoValue_MongoDbIO_Read.Builder().setMaxConnectionIdleTime(60000).setNumSplits(0).setBucketAuto(false).setSslEnabled(false).setIgnoreSSLCertificate(false).setSslInvalidHostNameAllowed(false).setQueryFn(FindQuery.create()).build();
    }

    public static Write write() {
        return new AutoValue_MongoDbIO_Write.Builder().setMaxConnectionIdleTime(60000).setBatchSize(1024L).setSslEnabled(false).setIgnoreSSLCertificate(false).setSslInvalidHostNameAllowed(false).setOrdered(true).build();
    }

    private MongoDbIO() {
    }

    private static MongoClientOptions.Builder getOptions(int maxConnectionIdleTime, boolean sslEnabled, boolean sslInvalidHostNameAllowed, boolean ignoreSSLCertificate) {
        MongoClientOptions.Builder optionsBuilder = new MongoClientOptions.Builder();
        optionsBuilder.maxConnectionIdleTime(maxConnectionIdleTime);
        if (sslEnabled) {
            optionsBuilder.sslEnabled(sslEnabled).sslInvalidHostNameAllowed(sslInvalidHostNameAllowed);
            if (ignoreSSLCertificate) {
                SSLContext sslContext = SSLUtils.ignoreSSLCertificate();
                optionsBuilder.sslContext(sslContext);
                optionsBuilder.socketFactory((SocketFactory)sslContext.getSocketFactory());
            }
        }
        return optionsBuilder;
    }

    @AutoValue
    public static abstract class Write
    extends PTransform<PCollection<Document>, PDone> {
        abstract @Nullable String uri();

        abstract int maxConnectionIdleTime();

        abstract boolean sslEnabled();

        abstract boolean sslInvalidHostNameAllowed();

        abstract boolean ignoreSSLCertificate();

        abstract boolean ordered();

        abstract @Nullable String database();

        abstract @Nullable String collection();

        abstract long batchSize();

        abstract Builder builder();

        public Write withUri(String uri) {
            Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"uri can not be null");
            return this.builder().setUri(uri).build();
        }

        public Write withMaxConnectionIdleTime(int maxConnectionIdleTime) {
            return this.builder().setMaxConnectionIdleTime(maxConnectionIdleTime).build();
        }

        public Write withSSLEnabled(boolean sslEnabled) {
            return this.builder().setSslEnabled(sslEnabled).build();
        }

        public Write withSSLInvalidHostNameAllowed(boolean invalidHostNameAllowed) {
            return this.builder().setSslInvalidHostNameAllowed(invalidHostNameAllowed).build();
        }

        public Write withOrdered(boolean ordered) {
            return this.builder().setOrdered(ordered).build();
        }

        public Write withIgnoreSSLCertificate(boolean ignoreSSLCertificate) {
            return this.builder().setIgnoreSSLCertificate(ignoreSSLCertificate).build();
        }

        public Write withDatabase(String database) {
            Preconditions.checkArgument((database != null ? 1 : 0) != 0, (Object)"database can not be null");
            return this.builder().setDatabase(database).build();
        }

        public Write withCollection(String collection) {
            Preconditions.checkArgument((collection != null ? 1 : 0) != 0, (Object)"collection can not be null");
            return this.builder().setCollection(collection).build();
        }

        public Write withBatchSize(long batchSize) {
            Preconditions.checkArgument((batchSize >= 0L ? 1 : 0) != 0, (String)"Batch size must be >= 0, but was %s", (long)batchSize);
            return this.builder().setBatchSize(batchSize).build();
        }

        public PDone expand(PCollection<Document> input) {
            Preconditions.checkArgument((this.uri() != null ? 1 : 0) != 0, (Object)"withUri() is required");
            Preconditions.checkArgument((this.database() != null ? 1 : 0) != 0, (Object)"withDatabase() is required");
            Preconditions.checkArgument((this.collection() != null ? 1 : 0) != 0, (Object)"withCollection() is required");
            input.apply((PTransform)ParDo.of((DoFn)new WriteFn(this)));
            return PDone.in((Pipeline)input.getPipeline());
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            builder.add(DisplayData.item((String)"uri", (String)this.uri()));
            builder.add(DisplayData.item((String)"maxConnectionIdleTime", (Integer)this.maxConnectionIdleTime()));
            builder.add(DisplayData.item((String)"sslEnable", (Boolean)this.sslEnabled()));
            builder.add(DisplayData.item((String)"sslInvalidHostNameAllowed", (Boolean)this.sslInvalidHostNameAllowed()));
            builder.add(DisplayData.item((String)"ignoreSSLCertificate", (Boolean)this.ignoreSSLCertificate()));
            builder.add(DisplayData.item((String)"ordered", (Boolean)this.ordered()));
            builder.add(DisplayData.item((String)"database", (String)this.database()));
            builder.add(DisplayData.item((String)"collection", (String)this.collection()));
            builder.add(DisplayData.item((String)"batchSize", (Long)this.batchSize()));
        }

        static class WriteFn
        extends DoFn<Document, Void> {
            private final Write spec;
            private transient MongoClient client;
            private List<Document> batch;

            WriteFn(Write spec) {
                this.spec = spec;
            }

            @DoFn.Setup
            public void createMongoClient() {
                this.client = new MongoClient(new MongoClientURI(this.spec.uri(), MongoDbIO.getOptions(this.spec.maxConnectionIdleTime(), this.spec.sslEnabled(), this.spec.sslInvalidHostNameAllowed(), this.spec.ignoreSSLCertificate())));
            }

            @DoFn.StartBundle
            public void startBundle() {
                this.batch = new ArrayList<Document>();
            }

            @DoFn.ProcessElement
            public void processElement(DoFn.ProcessContext ctx) {
                this.batch.add(new Document((Map)ctx.element()));
                if ((long)this.batch.size() >= this.spec.batchSize()) {
                    this.flush();
                }
            }

            @DoFn.FinishBundle
            public void finishBundle() {
                this.flush();
            }

            private void flush() {
                block3: {
                    if (this.batch.isEmpty()) {
                        return;
                    }
                    MongoDatabase mongoDatabase = this.client.getDatabase(this.spec.database());
                    MongoCollection mongoCollection = mongoDatabase.getCollection(this.spec.collection());
                    try {
                        mongoCollection.insertMany(this.batch, new InsertManyOptions().ordered(this.spec.ordered()));
                    }
                    catch (MongoBulkWriteException e) {
                        if (!this.spec.ordered()) break block3;
                        throw e;
                    }
                }
                this.batch.clear();
            }

            @DoFn.Teardown
            public void closeMongoClient() {
                this.client.close();
                this.client = null;
            }
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setUri(String var1);

            abstract Builder setMaxConnectionIdleTime(int var1);

            abstract Builder setSslEnabled(boolean var1);

            abstract Builder setSslInvalidHostNameAllowed(boolean var1);

            abstract Builder setIgnoreSSLCertificate(boolean var1);

            abstract Builder setOrdered(boolean var1);

            abstract Builder setDatabase(String var1);

            abstract Builder setCollection(String var1);

            abstract Builder setBatchSize(long var1);

            abstract Write build();
        }
    }

    private static class BoundedMongoDbReader
    extends BoundedSource.BoundedReader<Document> {
        private final BoundedMongoDbSource source;
        private MongoClient client;
        private MongoCursor<Document> cursor;
        private Document current;

        BoundedMongoDbReader(BoundedMongoDbSource source) {
            this.source = source;
        }

        public boolean start() {
            Read spec = this.source.spec;
            this.client = this.createClient(spec);
            MongoDatabase mongoDatabase = this.client.getDatabase(spec.database());
            MongoCollection mongoCollection = mongoDatabase.getCollection(spec.collection());
            this.cursor = (MongoCursor)spec.queryFn().apply((Object)mongoCollection);
            return this.advance();
        }

        public boolean advance() {
            if (this.cursor.hasNext()) {
                this.current = (Document)this.cursor.next();
                return true;
            }
            return false;
        }

        public BoundedMongoDbSource getCurrentSource() {
            return this.source;
        }

        public Document getCurrent() {
            return this.current;
        }

        public void close() {
            try {
                if (this.cursor != null) {
                    this.cursor.close();
                }
            }
            catch (Exception e) {
                LOG.warn("Error closing MongoDB cursor", (Throwable)e);
            }
            try {
                this.client.close();
            }
            catch (Exception e) {
                LOG.warn("Error closing MongoDB client", (Throwable)e);
            }
        }

        private MongoClient createClient(Read spec) {
            return new MongoClient(new MongoClientURI(spec.uri(), MongoDbIO.getOptions(spec.maxConnectionIdleTime(), spec.sslEnabled(), spec.sslInvalidHostNameAllowed(), spec.ignoreSSLCertificate())));
        }
    }

    @VisibleForTesting
    static class BoundedMongoDbSource
    extends BoundedSource<Document> {
        private final Read spec;

        private BoundedMongoDbSource(Read spec) {
            this.spec = spec;
        }

        public Coder<Document> getOutputCoder() {
            return SerializableCoder.of(Document.class);
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            this.spec.populateDisplayData(builder);
        }

        public BoundedSource.BoundedReader<Document> createReader(PipelineOptions options) {
            return new BoundedMongoDbReader(this);
        }

        long getDocumentCount() {
            long l;
            MongoClient mongoClient = new MongoClient(new MongoClientURI(this.spec.uri(), MongoDbIO.getOptions(this.spec.maxConnectionIdleTime(), this.spec.sslEnabled(), this.spec.sslInvalidHostNameAllowed(), this.spec.ignoreSSLCertificate())));
            Throwable throwable = null;
            try {
                l = this.getDocumentCount(mongoClient, this.spec.database(), this.spec.collection());
            }
            catch (Throwable throwable2) {
                try {
                    try {
                        throwable = throwable2;
                        throw throwable2;
                    }
                    catch (Throwable throwable3) {
                        BoundedMongoDbSource.$closeResource(throwable, (AutoCloseable)mongoClient);
                        throw throwable3;
                    }
                }
                catch (Exception e) {
                    return -1L;
                }
            }
            BoundedMongoDbSource.$closeResource(throwable, (AutoCloseable)mongoClient);
            return l;
        }

        private long getDocumentCount(MongoClient mongoClient, String database, String collection) {
            MongoDatabase mongoDatabase = mongoClient.getDatabase(database);
            BasicDBObject stat = new BasicDBObject();
            stat.append("collStats", (Object)collection);
            Document stats = mongoDatabase.runCommand((Bson)stat);
            return ((Number)stats.get((Object)"count", Number.class)).longValue();
        }

        public long getEstimatedSizeBytes(PipelineOptions pipelineOptions) {
            try (MongoClient mongoClient = new MongoClient(new MongoClientURI(this.spec.uri(), MongoDbIO.getOptions(this.spec.maxConnectionIdleTime(), this.spec.sslEnabled(), this.spec.sslInvalidHostNameAllowed(), this.spec.ignoreSSLCertificate())));){
                long l = this.getEstimatedSizeBytes(mongoClient, this.spec.database(), this.spec.collection());
                return l;
            }
        }

        private long getEstimatedSizeBytes(MongoClient mongoClient, String database, String collection) {
            MongoDatabase mongoDatabase = mongoClient.getDatabase(database);
            BasicDBObject stat = new BasicDBObject();
            stat.append("collStats", (Object)collection);
            Document stats = mongoDatabase.runCommand((Bson)stat);
            return ((Number)stats.get((Object)"size", Number.class)).longValue();
        }

        public List<BoundedSource<Document>> split(long desiredBundleSizeBytes, PipelineOptions options) {
            try (MongoClient mongoClient = new MongoClient(new MongoClientURI(this.spec.uri(), MongoDbIO.getOptions(this.spec.maxConnectionIdleTime(), this.spec.sslEnabled(), this.spec.sslInvalidHostNameAllowed(), this.spec.ignoreSSLCertificate())));){
                MongoDatabase mongoDatabase = mongoClient.getDatabase(this.spec.database());
                ArrayList<BoundedSource<Document>> sources = new ArrayList<BoundedSource<Document>>();
                if (this.spec.queryFn().getClass() == AutoValue_FindQuery.class) {
                    Object splitVectorCommand;
                    List splitKeys;
                    if (this.spec.bucketAuto()) {
                        splitKeys = BoundedMongoDbSource.buildAutoBuckets(mongoDatabase, this.spec);
                    } else {
                        if (this.spec.numSplits() > 0) {
                            long estimatedSizeBytes = this.getEstimatedSizeBytes(mongoClient, this.spec.database(), this.spec.collection());
                            desiredBundleSizeBytes = estimatedSizeBytes / (long)this.spec.numSplits();
                        }
                        if (desiredBundleSizeBytes < 0x100000L) {
                            desiredBundleSizeBytes = 0x100000L;
                        }
                        splitVectorCommand = new BasicDBObject();
                        splitVectorCommand.append("splitVector", (Object)(this.spec.database() + "." + this.spec.collection()));
                        splitVectorCommand.append("keyPattern", (Object)new BasicDBObject().append("_id", (Object)1));
                        splitVectorCommand.append("force", (Object)false);
                        LOG.debug("Splitting in chunk of {} MB", (Object)(desiredBundleSizeBytes / 1024L / 1024L));
                        splitVectorCommand.append("maxChunkSize", (Object)(desiredBundleSizeBytes / 1024L / 1024L));
                        Document splitVectorCommandResult = mongoDatabase.runCommand((Bson)splitVectorCommand);
                        splitKeys = (List)splitVectorCommandResult.get((Object)"splitKeys");
                    }
                    if (splitKeys.size() < 1) {
                        LOG.debug("Split keys is low, using a unique source");
                        splitVectorCommand = Collections.singletonList(this);
                        return splitVectorCommand;
                    }
                    for (String shardFilter : BoundedMongoDbSource.splitKeysToFilters(splitKeys)) {
                        SerializableFunction<MongoCollection<Document>, MongoCursor<Document>> queryFn = this.spec.queryFn();
                        BsonDocument filters = FindQuery.bson2BsonDocument((Bson)Document.parse((String)shardFilter));
                        FindQuery findQuery = (FindQuery)queryFn;
                        BsonDocument allFilters = FindQuery.bson2BsonDocument((Bson)(findQuery.filters() != null ? Filters.and((Bson[])new Bson[]{findQuery.filters(), filters}) : filters));
                        FindQuery queryWithFilter = findQuery.toBuilder().setFilters(allFilters).build();
                        LOG.debug("using filters: " + allFilters.toJson());
                        sources.add(new BoundedMongoDbSource(this.spec.withQueryFn(queryWithFilter)));
                    }
                } else {
                    SerializableFunction<MongoCollection<Document>, MongoCursor<Document>> queryFn = this.spec.queryFn();
                    AggregationQuery aggregationQuery = (AggregationQuery)queryFn;
                    if (aggregationQuery.mongoDbPipeline().stream().anyMatch(s -> s.keySet().contains("$limit"))) {
                        List<BoundedSource<Document>> list = Collections.singletonList(this);
                        return list;
                    }
                    List<Document> splitKeys = BoundedMongoDbSource.buildAutoBuckets(mongoDatabase, this.spec);
                    for (BsonDocument shardFilter : BoundedMongoDbSource.splitKeysToMatch(splitKeys)) {
                        AggregationQuery queryWithBucket = aggregationQuery.toBuilder().setBucket(shardFilter).build();
                        sources.add(new BoundedMongoDbSource(this.spec.withQueryFn(queryWithBucket)));
                    }
                }
                ArrayList<BoundedSource<Document>> arrayList = sources;
                return arrayList;
            }
        }

        @VisibleForTesting
        static List<String> splitKeysToFilters(List<Document> splitKeys) {
            ArrayList<String> filters = new ArrayList<String>();
            String lowestBound = null;
            for (int i = 0; i < splitKeys.size(); ++i) {
                String rangeFilter;
                String splitKey = splitKeys.get(i).get((Object)"_id").toString();
                if (i == 0) {
                    rangeFilter = String.format("{ $and: [ {\"_id\":{$lte:ObjectId(\"%s\")}}", splitKey);
                    filters.add(String.format("%s ]}", rangeFilter));
                    if (splitKeys.size() == 1) {
                        rangeFilter = String.format("{ $and: [ {\"_id\":{$gt:ObjectId(\"%s\")}}", splitKey);
                        filters.add(String.format("%s ]}", rangeFilter));
                    }
                } else if (i == splitKeys.size() - 1) {
                    rangeFilter = String.format("{ $and: [ {\"_id\":{$gt:ObjectId(\"%s\"),$lte:ObjectId(\"%s\")}}", lowestBound, splitKey);
                    filters.add(String.format("%s ]}", rangeFilter));
                    rangeFilter = String.format("{ $and: [ {\"_id\":{$gt:ObjectId(\"%s\")}}", splitKey);
                    filters.add(String.format("%s ]}", rangeFilter));
                } else {
                    rangeFilter = String.format("{ $and: [ {\"_id\":{$gt:ObjectId(\"%s\"),$lte:ObjectId(\"%s\")}}", lowestBound, splitKey);
                    filters.add(String.format("%s ]}", rangeFilter));
                }
                lowestBound = splitKey;
            }
            return filters;
        }

        @VisibleForTesting
        static List<BsonDocument> splitKeysToMatch(List<Document> splitKeys) {
            ArrayList<Bson> aggregates = new ArrayList<Bson>();
            ObjectId lowestBound = null;
            for (int i = 0; i < splitKeys.size(); ++i) {
                ObjectId splitKey = splitKeys.get(i).getObjectId((Object)"_id");
                if (i == 0) {
                    aggregates.add(Aggregates.match((Bson)Filters.lte((String)"_id", (Object)splitKey)));
                    if (splitKeys.size() == 1) {
                        aggregates.add(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.gt((String)"_id", (Object)splitKey)})));
                    }
                } else if (i == splitKeys.size() - 1) {
                    aggregates.add(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.gt((String)"_id", (Object)lowestBound), Filters.lte((String)"_id", (Object)splitKey)})));
                    aggregates.add(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.gt((String)"_id", (Object)splitKey)})));
                } else {
                    aggregates.add(Aggregates.match((Bson)Filters.and((Bson[])new Bson[]{Filters.gt((String)"_id", (Object)lowestBound), Filters.lte((String)"_id", (Object)splitKey)})));
                }
                lowestBound = splitKey;
            }
            return aggregates.stream().map(s -> s.toBsonDocument(BasicDBObject.class, MongoClient.getDefaultCodecRegistry())).collect(Collectors.toList());
        }

        @VisibleForTesting
        static List<Document> buildAutoBuckets(MongoDatabase mongoDatabase, Read spec) {
            ArrayList<Document> splitKeys = new ArrayList<Document>();
            MongoCollection mongoCollection = mongoDatabase.getCollection(spec.collection());
            BsonDocument bucketAutoConfig = new BsonDocument();
            bucketAutoConfig.put("groupBy", (BsonValue)new BsonString("$_id"));
            bucketAutoConfig.put("buckets", (BsonValue)new BsonInt32(spec.numSplits() > 0 ? spec.numSplits() : 10));
            BsonDocument bucketAuto = new BsonDocument("$bucketAuto", (BsonValue)bucketAutoConfig);
            ArrayList<BsonDocument> aggregates = new ArrayList<BsonDocument>();
            aggregates.add(bucketAuto);
            AggregateIterable buckets = mongoCollection.aggregate(aggregates);
            for (Document bucket : buckets) {
                Document filter = new Document();
                filter.put("_id", ((Document)bucket.get((Object)"_id")).get((Object)"min"));
                splitKeys.add(filter);
            }
            return splitKeys;
        }
    }

    @AutoValue
    public static abstract class Read
    extends PTransform<PBegin, PCollection<Document>> {
        abstract @Nullable String uri();

        abstract int maxConnectionIdleTime();

        abstract boolean sslEnabled();

        abstract boolean sslInvalidHostNameAllowed();

        abstract boolean ignoreSSLCertificate();

        abstract @Nullable String database();

        abstract @Nullable String collection();

        abstract int numSplits();

        abstract boolean bucketAuto();

        abstract SerializableFunction<MongoCollection<Document>, MongoCursor<Document>> queryFn();

        abstract Builder builder();

        public Read withUri(String uri) {
            Preconditions.checkArgument((uri != null ? 1 : 0) != 0, (Object)"MongoDbIO.read().withUri(uri) called with null uri");
            return this.builder().setUri(uri).build();
        }

        public Read withMaxConnectionIdleTime(int maxConnectionIdleTime) {
            return this.builder().setMaxConnectionIdleTime(maxConnectionIdleTime).build();
        }

        public Read withSSLEnabled(boolean sslEnabled) {
            return this.builder().setSslEnabled(sslEnabled).build();
        }

        public Read withSSLInvalidHostNameAllowed(boolean invalidHostNameAllowed) {
            return this.builder().setSslInvalidHostNameAllowed(invalidHostNameAllowed).build();
        }

        public Read withIgnoreSSLCertificate(boolean ignoreSSLCertificate) {
            return this.builder().setIgnoreSSLCertificate(ignoreSSLCertificate).build();
        }

        public Read withDatabase(String database) {
            Preconditions.checkArgument((database != null ? 1 : 0) != 0, (Object)"database can not be null");
            return this.builder().setDatabase(database).build();
        }

        public Read withCollection(String collection) {
            Preconditions.checkArgument((collection != null ? 1 : 0) != 0, (Object)"collection can not be null");
            return this.builder().setCollection(collection).build();
        }

        @Deprecated
        public Read withFilter(String filter) {
            Preconditions.checkArgument((filter != null ? 1 : 0) != 0, (Object)"filter can not be null");
            Preconditions.checkArgument((this.queryFn().getClass() != FindQuery.class ? 1 : 0) != 0, (Object)"withFilter is only supported for FindQuery API");
            FindQuery findQuery = (FindQuery)this.queryFn();
            FindQuery queryWithFilter = findQuery.toBuilder().setFilters(FindQuery.bson2BsonDocument((Bson)Document.parse((String)filter))).build();
            return this.builder().setQueryFn(queryWithFilter).build();
        }

        @Deprecated
        public Read withProjection(String ... fieldNames) {
            Preconditions.checkArgument((fieldNames.length > 0 ? 1 : 0) != 0, (Object)"projection can not be null");
            Preconditions.checkArgument((this.queryFn().getClass() != FindQuery.class ? 1 : 0) != 0, (Object)"withFilter is only supported for FindQuery API");
            FindQuery findQuery = (FindQuery)this.queryFn();
            FindQuery queryWithProjection = findQuery.toBuilder().setProjection(Arrays.asList(fieldNames)).build();
            return this.builder().setQueryFn(queryWithProjection).build();
        }

        public Read withNumSplits(int numSplits) {
            Preconditions.checkArgument((numSplits >= 0 ? 1 : 0) != 0, (String)"invalid num_splits: must be >= 0, but was %s", (int)numSplits);
            return this.builder().setNumSplits(numSplits).build();
        }

        public Read withBucketAuto(boolean bucketAuto) {
            return this.builder().setBucketAuto(bucketAuto).build();
        }

        public Read withQueryFn(SerializableFunction<MongoCollection<Document>, MongoCursor<Document>> queryBuilderFn) {
            return this.builder().setQueryFn(queryBuilderFn).build();
        }

        public PCollection<Document> expand(PBegin input) {
            Preconditions.checkArgument((this.uri() != null ? 1 : 0) != 0, (Object)"withUri() is required");
            Preconditions.checkArgument((this.database() != null ? 1 : 0) != 0, (Object)"withDatabase() is required");
            Preconditions.checkArgument((this.collection() != null ? 1 : 0) != 0, (Object)"withCollection() is required");
            return (PCollection)input.apply((PTransform)org.apache.beam.sdk.io.Read.from((BoundedSource)new BoundedMongoDbSource(this)));
        }

        public long getDocumentCount() {
            Preconditions.checkArgument((this.uri() != null ? 1 : 0) != 0, (Object)"withUri() is required");
            Preconditions.checkArgument((this.database() != null ? 1 : 0) != 0, (Object)"withDatabase() is required");
            Preconditions.checkArgument((this.collection() != null ? 1 : 0) != 0, (Object)"withCollection() is required");
            return new BoundedMongoDbSource(this).getDocumentCount();
        }

        public void populateDisplayData(DisplayData.Builder builder) {
            super.populateDisplayData(builder);
            builder.add(DisplayData.item((String)"uri", (String)this.uri()));
            builder.add(DisplayData.item((String)"maxConnectionIdleTime", (Integer)this.maxConnectionIdleTime()));
            builder.add(DisplayData.item((String)"sslEnabled", (Boolean)this.sslEnabled()));
            builder.add(DisplayData.item((String)"sslInvalidHostNameAllowed", (Boolean)this.sslInvalidHostNameAllowed()));
            builder.add(DisplayData.item((String)"ignoreSSLCertificate", (Boolean)this.ignoreSSLCertificate()));
            builder.add(DisplayData.item((String)"database", (String)this.database()));
            builder.add(DisplayData.item((String)"collection", (String)this.collection()));
            builder.add(DisplayData.item((String)"numSplit", (Integer)this.numSplits()));
            builder.add(DisplayData.item((String)"bucketAuto", (Boolean)this.bucketAuto()));
            builder.add(DisplayData.item((String)"queryFn", (String)this.queryFn().toString()));
        }

        @AutoValue.Builder
        static abstract class Builder {
            Builder() {
            }

            abstract Builder setUri(String var1);

            abstract Builder setMaxConnectionIdleTime(int var1);

            abstract Builder setSslEnabled(boolean var1);

            abstract Builder setSslInvalidHostNameAllowed(boolean var1);

            abstract Builder setIgnoreSSLCertificate(boolean var1);

            abstract Builder setDatabase(String var1);

            abstract Builder setCollection(String var1);

            abstract Builder setNumSplits(int var1);

            abstract Builder setBucketAuto(boolean var1);

            abstract Builder setQueryFn(SerializableFunction<MongoCollection<Document>, MongoCursor<Document>> var1);

            abstract Read build();
        }
    }
}

