/*
 * Decompiled with CFR 0.152.
 */
package org.apache.beam.sdk.io.mongodb;

import com.google.auto.value.AutoValue;
import com.mongodb.client.MongoCollection;
import com.mongodb.client.MongoCursor;
import com.mongodb.lang.Nullable;
import java.util.ArrayList;
import java.util.List;
import org.apache.beam.sdk.annotations.Experimental;
import org.apache.beam.sdk.io.mongodb.AutoValue_AggregationQuery;
import org.apache.beam.sdk.transforms.SerializableFunction;
import org.bson.BsonDocument;
import org.bson.Document;

@Experimental(value=Experimental.Kind.SOURCE_SINK)
@AutoValue
public abstract class AggregationQuery
implements SerializableFunction<MongoCollection<Document>, MongoCursor<Document>> {
    abstract List<BsonDocument> mongoDbPipeline();

    @Nullable
    abstract BsonDocument bucket();

    private static Builder builder() {
        return new AutoValue_AggregationQuery.Builder().setMongoDbPipeline(new ArrayList<BsonDocument>());
    }

    abstract Builder toBuilder();

    public static AggregationQuery create() {
        return AggregationQuery.builder().build();
    }

    public AggregationQuery withMongoDbPipeline(List<BsonDocument> mongoDbPipeline) {
        return this.toBuilder().setMongoDbPipeline(mongoDbPipeline).build();
    }

    public MongoCursor<Document> apply(MongoCollection<Document> collection) {
        if (this.bucket() != null) {
            if (this.mongoDbPipeline().size() == 1) {
                this.mongoDbPipeline().add(this.bucket());
            } else {
                this.mongoDbPipeline().set(this.mongoDbPipeline().size() - 1, this.bucket());
            }
        }
        return collection.aggregate(this.mongoDbPipeline()).iterator();
    }

    @AutoValue.Builder
    static abstract class Builder {
        Builder() {
        }

        abstract Builder setMongoDbPipeline(List<BsonDocument> var1);

        abstract Builder setBucket(BsonDocument var1);

        abstract AggregationQuery build();
    }
}

